[comment {-*- tcl -*- nx::current manpage}]

[include version.inc]
[manpage_begin nx::current 3 [vset VERSION]]

[copyright {2014-16 Stefan Sobernig <stefan.sobernig@wu.ac.at>, Gustaf Neumann <gustaf.neumann@wu.ac.at>; available under the Creative Commons Attribution 3.0 Austria license (CC BY 3.0 AT).}]

[titledesc {Return information about the method callstack}]
[moddesc {NX API}]

[description]

[list_begin definitions]

[call [cmd "current"] [opt [arg option]]]

This introspection command provides information about various details,
to be identified using [arg option], on the callstack. The command is
invoked from a method body. If [arg option] is not provided, [cmd nx::current] will
default to option [option "object"] (see
below). [cmd nx::current] operates on the Tcl callstack and is aware
of NX-specific callstack and stackframe details. Except for the
options [option callinglevel] and [option level], calling [cmd "nx::current"] outside
an NX object or method will result in an error. [arg option] can be
any of the following:

[list_begin itemized]

[item] [option "activelevel"] returns the actual callstack level which
calls into the currently executing method directly. This [option "activelevel"] might
correspond the [option "callinglevel"], but this is not necessarily
the case. The [option "activelevel"] also includes
intermediate calls, such as [cmd nx::next] invocations. The level is
reported as an absolute level number (# followed by a digit) to be
directly used as the first argument to [cmd uplevel] or [cmd upvar].

[comment {[item] [option "activemixin"] ...}]

[item] [option "args"] returns the list of argument values passed into the currently executing method implementation.

[item] [option "calledclass"] returns the name of the class that provides
the method implementation to which the intercepted method call is to be redirected (only available from within filter methods).

[item] [option "calledmethod"] returns the original method name
requested by intercepted method call (only available from within
filter methods).

[item] [option "callingclass"] returns the name of the class which
provides the method implementation calling into the currently
executing method. See also [option "callingobject"].

[item] [option "callinglevel"] resolves the callstack level of the
originating invocation of the currently executing method
implementation. Callstack levels introduced by method interception
(e.g., filters) and by method combination ([cmd nx::next]) are
ignored. The level is reported as an absolute level number ([const #] followed
by a digit) to be directly used as the first argument to [cmd uplevel]
or [cmd upvar]. See also [option "activelevel"]. If called outside NX,
[const 1] is returned (which is the default for [cmd upvar] and [cmd uplevel]).

[item] [option "callingobject"] returns the name of the object which is
calling into the currently executing method. See also [option "callingclass"].

[item] [option "class"] returns the name of the class providing the
 currently executing method implementation. The returned
 method-providing class may be different to the class of the current
 object. If called from within a method implementation provided by the
 current object itself, an empty string is returned.

[item] [option "filterreg"] returns the object (class) on which the
currently executing method was registered as a filter method (only
available from within filter methods).

[item] [option "isnextcall"] will return 1, if the currently executing
method implementation was invoked via [cmd nx::next]; 0 otherwise.

[item] [option "level"] will return a number indicating the stack
level of the currently executed method or script, or an empty string when
executed outside an NX context (e.g., in a Tcl proc or a namespace
script). The resulting value can be directly passed as [arg "level"] to
[cmd "info level"].

[item] [option method] returns the name of the currently executing
method. If an ensemble-method call, the name of the bottom-most
("leaf") method is returned.

[item] [option "methodpath"] returns the combined name of the
currently executing method (including all ensemble levels) in an
ensemble-method call. Otherwise, for a regular method call, the result
corresponds to the result of option [option "method"].

[item] [option "nextmethod"] returns the name of the next most
specific method implementation to be called when invoking [cmd nx::next].

[item] [option "object"] gives the name of the object on which the
currently executing method implementation is evaluated.

[list_end]

[list_end]

[manpage_end]
