/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

var wpl = Ci.nsIWebProgressListener;

var reporterListener = {
  _isBusy: false,
  get securityButton() {
    delete this.securityButton;
    return this.securityButton = document.getElementById("security-button");
  },

  QueryInterface: ChromeUtils.generateQI(["nsIWebProgressListener",
                                          "nsISupportsWeakReference"]),

  onStateChange(/* in nsIWebProgress*/ aWebProgress,
                /* in nsIRequest*/ aRequest,
                /* in unsigned long*/ aStateFlags,
                /* in nsresult*/ aStatus) {
  },

  onProgressChange(/* in nsIWebProgress*/ aWebProgress,
                   /* in nsIRequest*/ aRequest,
                   /* in long*/ aCurSelfProgress,
                   /* in long */aMaxSelfProgress,
                   /* in long */aCurTotalProgress,
                   /* in long */aMaxTotalProgress) {
  },

  onLocationChange(/* in nsIWebProgress*/ aWebProgress,
                   /* in nsIRequest*/ aRequest,
                   /* in nsIURI*/ aLocation) {
    document.getElementById("headerMessage").textContent = aLocation.spec;
  },

  onStatusChange(/* in nsIWebProgress*/ aWebProgress,
                 /* in nsIRequest*/ aRequest,
                 /* in nsresult*/ aStatus,
                 /* in wstring*/ aMessage) {
  },

  onSecurityChange(/* in nsIWebProgress*/ aWebProgress,
                   /* in nsIRequest*/ aRequest,
                   /* in unsigned long*/ aState) {
    const wpl_security_bits = wpl.STATE_IS_SECURE |
                              wpl.STATE_IS_BROKEN |
                              wpl.STATE_IS_INSECURE |
                              wpl.STATE_SECURE_HIGH |
                              wpl.STATE_SECURE_MED |
                              wpl.STATE_SECURE_LOW;
    var browser = document.getElementById("requestFrame");
    var level;

    switch (aState & wpl_security_bits) {
      case wpl.STATE_IS_SECURE | wpl.STATE_SECURE_HIGH:
        level = "high";
        break;
      case wpl.STATE_IS_SECURE | wpl.STATE_SECURE_MED:
      case wpl.STATE_IS_SECURE | wpl.STATE_SECURE_LOW:
        level = "low";
        break;
      case wpl.STATE_IS_BROKEN:
        level = "broken";
        break;
    }
    if (level) {
      this.securityButton.setAttribute("level", level);
      this.securityButton.hidden = false;
    } else {
      this.securityButton.hidden = true;
      this.securityButton.removeAttribute("level");
    }
    this.securityButton.setAttribute("tooltiptext",
                                     browser.securityUI.tooltipText);
  },

  onContentBlockingEvent(/* in nsIWebProgress*/ aWebProgress,
                         /* in nsIRequest*/ aRequest,
                         /* in unsigned long*/ aEvent) {
  },
};

function cancelRequest() {
  reportUserClosed();
  window.close();
}

function reportUserClosed() {
  let request = window.arguments[0].wrappedJSObject;
  request.cancelled();
}

function loadRequestedUrl() {
  let request = window.arguments[0].wrappedJSObject;
  document.getElementById("headerMessage").textContent = request.promptText;
  if (request.iconURI != "")
    document.getElementById("headerImage").src = request.iconURI;

  var browser = document.getElementById("requestFrame");
  browser.addProgressListener(reporterListener,
                              Ci.nsIWebProgress.NOTIFY_ALL);
  var url = request.url;
  if (url != "") {
    browser.setAttribute("src", url);
    document.getElementById("headerMessage").textContent = url;
  }
  request.loaded(window, browser.webProgress);
}
