/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const actionTypes = {
  ADB_ADDON_INSTALL_START: "ADB_ADDON_INSTALL_START",
  ADB_ADDON_INSTALL_SUCCESS: "ADB_ADDON_INSTALL_SUCCESS",
  ADB_ADDON_INSTALL_FAILURE: "ADB_ADDON_INSTALL_FAILURE",
  ADB_ADDON_UNINSTALL_START: "ADB_ADDON_UNINSTALL_START",
  ADB_ADDON_UNINSTALL_SUCCESS: "ADB_ADDON_UNINSTALL_SUCCESS",
  ADB_ADDON_UNINSTALL_FAILURE: "ADB_ADDON_UNINSTALL_FAILURE",
  ADB_ADDON_STATUS_UPDATED: "ADB_ADDON_STATUS_UPDATED",
  CONNECT_RUNTIME_FAILURE: "CONNECT_RUNTIME_FAILURE",
  CONNECT_RUNTIME_START: "CONNECT_RUNTIME_START",
  CONNECT_RUNTIME_SUCCESS: "CONNECT_RUNTIME_SUCCESS",
  DEBUG_TARGET_COLLAPSIBILITY_UPDATED: "DEBUG_TARGET_COLLAPSIBILITY_UPDATED",
  DISCONNECT_RUNTIME_FAILURE: "DISCONNECT_RUNTIME_FAILURE",
  DISCONNECT_RUNTIME_START: "DISCONNECT_RUNTIME_START",
  DISCONNECT_RUNTIME_SUCCESS: "DISCONNECT_RUNTIME_SUCCESS",
  NETWORK_LOCATIONS_UPDATED: "NETWORK_LOCATIONS_UPDATED",
  REMOTE_RUNTIMES_UPDATED: "REMOTE_RUNTIMES_UPDATED",
  REQUEST_EXTENSIONS_FAILURE: "REQUEST_EXTENSIONS_FAILURE",
  REQUEST_EXTENSIONS_START: "REQUEST_EXTENSIONS_START",
  REQUEST_EXTENSIONS_SUCCESS: "REQUEST_EXTENSIONS_SUCCESS",
  REQUEST_TABS_FAILURE: "REQUEST_TABS_FAILURE",
  REQUEST_TABS_START: "REQUEST_TABS_START",
  REQUEST_TABS_SUCCESS: "REQUEST_TABS_SUCCESS",
  REQUEST_WORKERS_FAILURE: "REQUEST_WORKERS_FAILURE",
  REQUEST_WORKERS_START: "REQUEST_WORKERS_START",
  REQUEST_WORKERS_SUCCESS: "REQUEST_WORKERS_SUCCESS",
  SELECT_PAGE_FAILURE: "SELECT_PAGE_FAILURE",
  SELECT_PAGE_START: "SELECT_PAGE_START",
  SELECT_PAGE_SUCCESS: "SELECT_PAGE_SUCCESS",
  SELECTED_RUNTIME_ID_UPDATED: "SELECTED_RUNTIME_ID_UPDATED",
  TEMPORARY_EXTENSION_INSTALL_FAILURE: "TEMPORARY_EXTENSION_INSTALL_FAILURE",
  TEMPORARY_EXTENSION_INSTALL_START: "TEMPORARY_EXTENSION_INSTALL_START",
  TEMPORARY_EXTENSION_INSTALL_SUCCESS: "TEMPORARY_EXTENSION_INSTALL_SUCCESS",
  THIS_FIREFOX_RUNTIME_CREATED: "THIS_FIREFOX_RUNTIME_CREATED",
  UNWATCH_RUNTIME_FAILURE: "UNWATCH_RUNTIME_FAILURE",
  UNWATCH_RUNTIME_START: "UNWATCH_RUNTIME_START",
  UNWATCH_RUNTIME_SUCCESS: "UNWATCH_RUNTIME_SUCCESS",
  UPDATE_CONNECTION_PROMPT_SETTING_FAILURE: "UPDATE_CONNECTION_PROMPT_SETTING_FAILURE",
  UPDATE_CONNECTION_PROMPT_SETTING_START: "UPDATE_CONNECTION_PROMPT_SETTING_START",
  UPDATE_CONNECTION_PROMPT_SETTING_SUCCESS: "UPDATE_CONNECTION_PROMPT_SETTING_SUCCESS",
  UPDATE_RUNTIME_MULTIE10S_FAILURE: "UPDATE_RUNTIME_MULTIE10S_FAILURE",
  UPDATE_RUNTIME_MULTIE10S_START: "UPDATE_RUNTIME_MULTIE10S_START",
  UPDATE_RUNTIME_MULTIE10S_SUCCESS: "UPDATE_RUNTIME_MULTIE10S_SUCCESS",
  USB_RUNTIMES_SCAN_START: "USB_RUNTIMES_SCAN_START",
  USB_RUNTIMES_SCAN_SUCCESS: "USB_RUNTIMES_SCAN_SUCCESS",
  WATCH_RUNTIME_FAILURE: "WATCH_RUNTIME_FAILURE",
  WATCH_RUNTIME_START: "WATCH_RUNTIME_START",
  WATCH_RUNTIME_SUCCESS: "WATCH_RUNTIME_SUCCESS",
};

const DEBUG_TARGETS = {
  EXTENSION: "EXTENSION",
  TAB: "TAB",
  WORKER: "WORKER",
};

const DEBUG_TARGET_PANE = {
  INSTALLED_EXTENSION: "installedExtension",
  OTHER_WORKER: "otherWorker",
  SERVICE_WORKER: "serviceWorker",
  SHARED_WORKER: "sharedWorker",
  TAB: "tab",
  TEMPORARY_EXTENSION: "temporaryExtension",
};

const MESSAGE_LEVEL = {
  ERROR: "error",
  WARNING: "warning",
};

const PAGE_TYPES = {
  RUNTIME: "runtime",
  CONNECT: "connect",
};

const PREFERENCES = {
  // Temporary preference without any default value until network locations are enabled.
  NETWORK_ENABLED: "devtools.aboutdebugging.network",
  // Preference that drives the display of system addons in about:debugging.
  SHOW_SYSTEM_ADDONS: "devtools.aboutdebugging.showSystemAddons",
  // Temporary preference without any default value until wifi is enabled.
  WIFI_ENABLED: "devtools.aboutdebugging.wifi",
};

const RUNTIME_PREFERENCE = {
  CONNECTION_PROMPT: "devtools.debugger.prompt-connection",
};

const RUNTIMES = {
  NETWORK: "network",
  THIS_FIREFOX: "this-firefox",
  USB: "usb",
};

const SERVICE_WORKER_FETCH_STATES = {
  LISTENING: "LISTENING",
  NOT_LISTENING: "NOT_LISTENING",
};

const SERVICE_WORKER_STATUSES = {
  RUNNING: "RUNNING",
  REGISTERING: "REGISTERING",
  STOPPED: "STOPPED",
};

const USB_STATES = {
  DISABLED_USB: "DISABLED_USB",
  ENABLED_USB: "ENABLED_USB",
  UPDATING_USB: "UPDATING_USB",
};

// flatten constants
module.exports = Object.assign({}, {
  DEBUG_TARGETS,
  DEBUG_TARGET_PANE,
  MESSAGE_LEVEL,
  PAGE_TYPES,
  PREFERENCES,
  RUNTIME_PREFERENCE,
  RUNTIMES,
  SERVICE_WORKER_FETCH_STATES,
  SERVICE_WORKER_STATUSES,
  USB_STATES,
}, actionTypes);
