   X                                   
admin.default              8    m                        `H=H=H=              #ident	"@(#)default	1.4	92/12/23 SMI"	/* SVr4.0  1.5.2.1	*/ 
mail=
instance=unique
partial=ask
runlevel=ask
idepend=ask
rdepend=ask
space=ask
setuid=ask
conflict=nocheck
action=nocheck
basedir=default
                  X                                   response.LGTOclnt              8    m              ;          \H=H=H=          ?    NSR_HOME=/var/nsr
NSR_SERVERS=""
RESTART_DAEMONS=no
exit 0
                X                                   response.LGTOnode              8    m                        ]H=H=H=              RESTART_DAEMONS=no
exit 0
                 X                                   response.SUNWebsc              8    m              ;          ^H=H=H=          ?    NSR_HOME=/var/nsr
NSR_SERVERS=""
RESTART_DAEMONS=no
exit 0
                X                                   response.SUNWebsn              8    m                        _H=H=H=              RESTART_DAEMONS=no
exit 0
                 X                                   nw_client_install              8                           UH=H=H=             #!/bin/sh
# $Id: nw_client_install.sh,v 1.3 2006/07/20 20:43:58 bspadafo Exp $ Copyright (c) 2008 EMC Corporation
#

#
# Copyright (c) 2006-2008 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#

# This is the main client install script
# It will perform the following tasks in order
# 1. Shut down networker daemons
# 2. Remove packages in order
# 3. Apply any patches in order
# 4. Install packages in order
# 5. Start networker daemons
# 6. Clean up

# CONSTANT

nw_command="nw_command_list"

# common function script

nw_common_script="nw_common"

# install common function script

install_common_script="nw_install_common"

# install platform specific script

install_specific_script="nw_install_platform"

# networker base directory /nsr

nw_base_dir="/nsr"

# install lock file, be sure sync with lock_file in script get_lock and do_check

lock_file="/tmp/.nw_install_lock"

# VARIABLES

# return status

_nw_status=0

# networker temp directory for install, default to /tmp

nw_tmp_dir="/tmp"

# the following variables will get their value assigned in parse_args

# old networker installation directory,

nw_old_dir=""

# log level, debug, verbose or normal

nw_log_level=""

# silent install flag, no output to stdout, default to false

silent_install=0


# MAIN start from here

# import platform specific command list with full path
if [ ! -f $nw_command ] || [ ! -r $nw_command ]
then
    echo \
    "File \"$nw_command\" is missing or can not be read." 1>&2
    exit 1
else . ./$nw_command

fi

# import common functions and platform specific functions
# note, install_log and install_exit is defined in common script

if [ ! -f $nw_common_script ] || [ ! -r $nw_common_script ]
then 
    echo "File \"$nw_common_script\" is missing or can not be read \n" 1>&2
    exit 1
else
    . ./$nw_common_script
fi

if [ ! -f $install_common_script ] || [ ! -r $install_common_script ]
then
    nw_log "$ScriptName: File \"$install_common_script\" is missing or can not be read \n"
    nw_exit 1
else
    . ./$install_common_script
fi

if [ ! -f $install_specific_script ] || [ ! -r $install_specific_script ]
then
    nw_log "$ScriptName: File \"$install_specific_script\" is missing or can not be read \n"
    nw_exit 1
else
    . ./$install_specific_script
fi

# set up env and create log file

install_init "$@"

_nw_status=$?

if [ $_nw_status -ne 0 ]
then 
    nw_log "$ScriptName: Function install_init failed."
    nw_exit $_nw_status;
fi

# if it is not fresh install, shutdown daemons first

#1. Shut down nw daemons 

if [ $fresh_install -ne 1 ]
then

    # Do we want to check is there any backup running?

    nw_verbose_log "$ScriptName: Shutting down networker daemons..."

    # shutdown daemons if not down already
    shutdown_daemons
    _nw_status=$?

    if [ $_nw_status -ne 0 ]
    then
        nw_log "$ScriptName: Function shutdown_daemons failed."
        nw_exit $_nw_status      
    fi

    nw_debug_log "$ScriptName: networker daemons shut down."
fi

#2. Remove packages in order

# do remove package if it is not fresh_install

if [ $fresh_install -ne 1 ] 

then
    nw_verbose_log "$ScriptName: Removing networker packages..."
    eval remove_packages $remove_list
    _nw_status=$?
    # How the remove package goes?
    if [ $_nw_status -ne 0 ]
    then
        nw_log "$ScriptName: Function remove_packages failed."
        nw_exit $_nw_status
    fi

    nw_debug_log "$ScriptName: Selected networker packages removed"
fi

#3. Apply patches in order
# apply patches if there are any

if [ "$patch_list" != "" ]

then
    nw_verbose_log "$ScriptName: Apply patches: $patch_list ..."
    eval apply_patches $patch_list
    _nw_status=$?

    if [ $_nw_status -ne 0 ]
    then
        nw_log "$ScriptName: Function apply_packages failed."
        nw_exit $_nw_status
    fi

    nw_debug_log "$ScriptName: Selected patches applied."

fi

#4. Install new packages in order
# install package if it is not remove_only

if [ $remove_only -ne 1 ]

then
    nw_verbose_log "$ScriptName: Install networker packages $add_list ..."
    eval add_packages $add_list
    _nw_status=$?

    if [ $_nw_status -ne 0 ]
    then
        nw_log "$ScriptName: Function add_packages failed."
        nw_exit $_nw_status
    fi

    nw_debug_log "$ScriptName: Selected packages installed."

fi

#5. Start nw daemons

# start daemon if we are told to do so

if [ $start_daemon_before_exit -ne 0 ]

then

    nw_verbose_log "$ScriptName: Starting up daemons."

    start_daemons
    _nw_status=$?

    if [ $_nw_status -ne 0 ]
    then
        nw_log "$ScriptName: Function start_daemons failed."
        nw_exit $_nw_status
    fi

    nw_debug_log "$ScriptName: Networker daemons started up."
fi

#6. Clean up.

nw_verbose_log "$ScriptName: Removing temp files..."

install_cleanup
_nw_status=$?

if [ $_nw_status -ne 0 ]
then
    nw_log "$ScriptName: Function install_cleanup failed."
    nw_exit $_nw_status
fi

# Finally we are ready to exit

nw_verbose_log "$ScriptName: Networker client software update on Client \"$ClientName\" is successful."

# Exit, will remove lock file too

nw_exit $_nw_status
                X                                   nw_command_list            8    m                       aH=H=H=             #! /bin/sh
#
# $Id: nw_command_list.sun.sh,v 1.2.116.2 2008/09/29 17:05:46 mmanasaw Exp $ Copyright (c) 2006 EMC Corporation.
#

#
# Copyright (c) 2006 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#

# This file list all the command with full path install/inventory may use
# The command is platform dependent
RM='/bin/rm'
CAT='/bin/cat'
TEE='/bin/tee'
MV='/bin/mv'
BASENAME='/bin/basename'
UNAME='/bin/uname'
CKSUM='/bin/cksum'
AWK='/bin/awk'
PS='/bin/ps'
GREP='/bin/grep'
                  X                                   	nw_common              8    m                    
   WH=H=H=             #!/bin/sh
#
# $Id: nw_common.sh,v 1.3 2006/07/20 21:24:51 bspadafo Exp $ Copyright (c) 2006 EMC Corporation.
#

#
# Copyright (c) 2006 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#

# This file contains all the common functions crossing all Unix client platform
# Its function will be called by  the main installation script 
# nw_client_install
#

# CONSTANT

# set max client log file size to 1M

dir_prefix="cp_"
log_size_limit=1048576

# install lock file
lock_file="/tmp/.nw_install_lock"

# VARIABLES

server_name="localhost"

# log file

log_file="/tmp/nw_install.$server_name.log"

# back up log file

backup_log="/tmp/nw_install.$server_name.log.1"

# The following variables are expected to be used by 
# both pre-install check and install phases

# log level flag
log_level=""

# silent install flag
silent_install=0

ScriptName=`$BASENAME $0`

ClientName=`$UNAME -n`

# default base directory for nw, and tell people this is a default
# i.e. We didn't really check anything yet.
NwBaseDir="/var"
Base_check=0

# temp directory
TmpDir="/tmp"

# current directory

CurrentDir=`pwd`

# overwrite lock(1) or not (0)

over_write=0

# FUNCTIONS

# this function will create client install log file if there is not
# any yet or rename it if it reaches certain size. We keep at most
# one old copy

create_client_log()
{
    # log file is there but overweight, back it up before creating new one
    if [ -f $log_file ] && [ `$CKSUM $log_file |$AWK '{print $2}'` -ge $log_size_limit ]
    then 
        eval $MV $log_file $backup_log
    fi

    if [ ! -f $log_file ]
    # log file not found, either never created or re-named
    then 
        eval touch $log_file
        eval chmod 644 $log_file
    fi

    return 0
}


# the following function will set up the log mechanism for installation, which
# is able to handle -verbose, -debug (development phase test) and normal
# log mode

nw_debug_log()
{
    if [ "$log_level" = "d" ]
    then
        # the most complete log, for developement log
        nw_log "$1"        
    fi
    return 0
}

# debug log is higher than verbose

nw_verbose_log()
{

    if [ "$log_level" = "v" ] || [ "$log_level" = "d" ]
    then
        # verbose log for production detail log
        nw_log "$1"
    fi
    return 0
}

nw_log()
{
    if [ $silent_install -eq 0 ]
    # if not silent_install, show the log information in stdout and also log
    # to log file. Otherwise, only log to file
    then 
        echo "`date '+%m/%d/%y %H:%M:%S'`:$@" |$TEE -a $log_file
    else    
        echo "`date '+%m/%d/%y %H:%M:%S'`:$@" >> $log_file
    fi
    return 0
}           

# Remove lock file and exit with status

nw_exit()
{
    # remove lock file if it is locked by us and still there
    if [ -f $lock_file ] &&  [ "$server_name" = "`$CAT $lock_file`" ]
    then
        eval $RM $lock_file
    fi

    if [ $# -eq 0 ]
    then 
        exit 0
    else
        exit $1
    fi
}

# function to get lock

get_lock()
{

    #  this client is already locked
    if [ -f $lock_file ]
    then
        lock_by=`$CAT $lock_file`

        # locked by myself, that's all right.
        if [ "$lock_by" = "$server_name" ]
        then  
            return 0

        # locked by others, and I am not allowed to overwrite it
        elif [ $over_write -ne 1 ]
        then
            echo "This client is locked by \"$lock_by\"."
            return 1
        # I am told to overwrite it.
        # note: always put overwrite case as the last one to minimize
        # impact of the race condition.i.e.Create a new lock immediately
        # after removing the old one.
        else
            eval $RM $lock_file
        fi
    fi
    
    # set lock file to lock out other networker servers
    touch $lock_file
    echo $server_name >$lock_file
    status=$?
    return $status 
}

remove_lock()
{
# remove lock file if it is locked by us and still there
    if [ -f $lock_file ]  &&  [ "$server_name" = "`$CAT $lock_file`" ]
    then
        eval $RM $lock_file
    fi
    return $?
}
                X                                   nw_install_common              8                 +"          XH=H=H=         +&    #!/bin/sh
#
# $Id: nw_install_common.sh,v 1.3.110.1 2008/09/15 17:54:25 mmanasaw Exp $ Copyright (c) 2008 EMC Corporation.
#

#
# Copyright (c) 2006-2008 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#

# This file contains all the common functions crossing all Unix client platform
# Its function will be called by  the main installation script 
# nw_client_install
#

# CONSTANT
# error output of nsr_shutdown if no processes running.
no_process="no running NetWorker processes"

#VARIABLES

_exit_status=0

remove_list=""
add_list=""
patch_list=""
remove_only=1
fresh_install=1
start_daemon_before_exit=0
daemon_started=""

# The following files will contain the information sent to jobs
tmp_install_log="/tmp/install.$server_name.log"
tmp_install_log_old="/tmp/install.$server_name.1"
return_status=""

# tmp file to hold stderr output
tmp_err="/tmp/err.$server_name"

install_display_usage()
{
    echo "Usage:"
    echo "nw_client_install [-d/-v] [-s] [-r] -h <server_name> [-rl <list1>] [-t <path> -il <list2>]"
    echo "where \n -d: Optional for debug log, the most complete log."
    echo " -v: Optional for verbose log."
    echo " -s: Optional for silent install. No status message will be displayed."
    echo " -r: Optional, if given, networker daemons will be started after \
installation is done."
    echo " -h <server_name>: Required, networker server."
    echo " -rl <list1>: Optional, the list of packages to be removed, in reverse \n \
order of depedency."
    echo " -p <list2>: Optional, the list of patches to be applied, in order.\n"
    echo " -t: Optional, specify the target path to install package."
    echo " -il <list3>: Optional, the list of packages to be added, in the order \n \
of dependency."
    return 0
}

# this function will parse the input argument and call install_display_usage
# in error case

install_parse_arg()
{
    # Flag to indicate the parsing is good or not, default is success
    _exit_status=0

    # flags to indicate the required parameters passed in

    host_flag=0
    remove_flag=0
    install_flag=0

    #just make sure everything is clean

    # we at least require "-h <server_name> plus either 
    # "rl <remove_list" or "-il <install_list>"

    if [ $# -lt 4 ]
    then 
        install_display_usage
        return 1
    fi

    while [ $# -gt 0 ]
    do
        case "$1" in

        -r)
            start_daemon_before_exit=1
            shift
            ;;

        -d)
        # debug log
            log_level="d"
            shift
            ;;
        -v) 
        # verbose log
            log_level="v"
            shift
            ;;
        -s) 
        # silent log
            silent_install=1
            shift
            ;;
        -h)
            shift
            server_name=$1
	    # All our stuff is in the same directory but some
	    # install program on some platform only takes full path
	    # the dir is $TmpDir/$dir_prefix_$server_name
	    # /tmp/cp_<server_name>
            SourceDir=`pwd`           

            # set the flag, this is a required parameter
            host_flag=1

            # redefine the file names
            log_file="/tmp/nw_install.$server_name.log"
            backup_log="/tmp/nw_install.$server_name.log.1"

            tmp_install_log="/tmp/install.$server_name.log"
            tmp_install_log_old="/tmp/install.$server_name.log.1"

            tmp_err="/tmp/err.$server_name"

	    return_status_log="/tmp/cp_$server_name/return_status.log"

            shift
            ;;

        -rl)

            # there is package to remove, so, it is no longer fresh install
            fresh_install=0

            shift
            # as long as we don't reach the end of parameters and 
            # it is not install or patch list yet, it is a package to remove

            while [ $# -gt 0 ] && [ ! $1 = "-il" ] && [ ! $1 = "-t" ] && [ ! $1 = "-p" ]
            do
                remove_list="$remove_list $1"
                shift
            done

            nw_debug_log "The list of packages to remove is: \"$remove_list\"."
            ;;

        -p)

            # there's a patch to apply, so it's not fresh install or remove only
            fresh_install=0
            remove_only=0

            shift
            # as long as we don't reach the end of parameters and 
            # it is not install list yet, it is a patch to apply

            while [ $# -gt 0 ] && [ ! $1 = "-il" ] && [ ! $1 = "-t" ]
            do
                patch_list="$patch_list $1"
                shift
            done

            nw_debug_log "The list of patches to apply is: \"$patch_list\"."
            ;;

        # -t option specify the target directory to install package
        -t)
            shift
            nw_base_dir=$1
            shift
            ;;

        # we require -il is the last flag,
        -il)
            # there is package to install, so it is not remove only
            remove_only=0

           # pointer to list of packages to be installed
            shift
            if [ $host_flag -eq 0 ]
            then
		install_display_usage
                return 1
            fi
            add_list="$@"
            break
                
            ;;      
        *)
        # all other case, it is incorrect parameter passed in
            install_display_usage
            _exit_status=1
            break
            ;;     
        esac
    done

    return $_exit_status

}

# this function will set up env for install and call create_client_log.

install_init()
{
    # clean up in case we crashed in the middle last time
    install_cleanup

    install_parse_arg "$@"
    _exit_status=$?

    if [ $_exit_status -ne 0 ]
    then
        if [ $silent_install -ne 1 ]
        then
            echo "$ScriptName: Function pre_install_parse_arg failed"
        fi
        return $_exit_status
    fi

    # remove any return status file if there is any 
    if [ -f $return_status_log ]
    then
	$RM $return_status_log
    fi

    # Try to check/grab lock. In a perfect world, we don't need do this because
    # user should only do install after running nw_pre_install_check without "-i"
    get_lock
    _exit_status=$?

    # this should not happen, but never say never
    if [ $_exit_status -ne 0 ]
    then
        if [ $silent_install -ne 1 ]
        then
            echo "$ScriptName: Function get_lock failed"
        fi
        return $_exit_status
    fi

    # we don't need this in perfect world either as the client file should
    # have already been set up before coming here

    # create client side log file
    create_client_log
    _exit_status=$?

    if [ $_exit_status -ne 0 ]
    then 
        if [ $silent_install -ne 1 ]
        then
            # log file creation failed, have to use stdout
            echo "$ScriptName: Function create_client_log failed"
        fi
        return $_exit_status
    fi
    return $_exit_status 
}

# this function will remove everything in /tmp/cp_$server_name and remove
# the lock file

install_cleanup()
{
    # rename the install output file to jobs
    # note: Now, we decide to issue a third command to get status infomation
    # so we should not rename file here.
    recycle_tmp_install_log

    # remove lock file 
    remove_lock
    return $?
}

# this function will shut down networker daemons on client machine
shutdown_daemons()
{   
    $daemon_shutdown_command 1>>$log_file 2>$tmp_err

    # failed, is it because no process running?

    if [ $? -ne 0 ]
    then
        grep "$no_process" $tmp_err 1>/dev/null
        if [ $? -ne 0 ]
        then
            return 1
        fi
    fi
    return 0
}

# this function will start networker daemons on client machine

start_daemons()
{
    count=3
    while [ $count -gt 0 ] && [ "$daemon_started" != "1" ]
    do
    	eval $daemon_startup_command
        count=`expr $count - 1`
        daemon_started="`$PS -e |  $GREP nsrexecd | $AWK '{ if ($4 == "nsrexecd")
                                                             print "1"}'`"
	if [ "$daemon_started" != "1" ]
	then
	    sleep 30
	    nw_log "Retrying daemon startup command."
	fi
    done

    return $?
}

# This function will remove specified packages

remove_packages()
{

    count=$#

    while [ $count -gt 0 ]
    do
        count=`expr $count - 1`

        nw_verbose_log "Removing package \"$1\"..."
        
        eval remove_package $1

        if [ $? -ne 0 ]
        then
            nw_log "$ScriptName, function remove_package failed for package \"$1\"."
            return 1
        fi

        nw_debug_log "Package \"$1\" removed."
        shift
    done

    nw_debug_log "All specified packages have been removed."

    return 0
}

# This function will apply specified patches

apply_patches()
{

    count=$#

    while [ $count -gt 0 ]
    do
        count=`expr $count - 1`

        nw_verbose_log "Applying patch \"$1\"..."
        
        eval apply_patch $1

        if [ $? -ne 0 ]
        then
            nw_log "$ScriptName, function apply_patch failed for patch \"$1\"."
            return 1
        fi

        nw_debug_log "Patch \"$1\" applied."
        shift
    done

    nw_debug_log "All specified patches have been applied."

    return 0
}

# This function will add specified packages

add_packages()
{

    # if no package names passed in, we are done

    count=$#

    while [ $count -gt 0 ]
    do
        count=`expr $count - 2`

	if [ $2 = "NA" ]
	then
	    iloc="default"
	else
	    iloc=$2
	fi

        nw_verbose_log "Adding package \"$1\" at location \"$iloc\"..."
        
        eval add_package $1 $2

        if [ $? -ne 0 ]
        then
            nw_log "$ScriptName, function add_package failed for package \"$1\" at location \"$iloc\"..."
            return 1
        fi

        nw_debug_log "Package \"$1\" added at location \"$iloc\"..."
        shift
	shift
    done

    nw_debug_log "All specified packages have been added."

    return 0
}

# this function will recycle the file which contains the info sent to jobs

recycle_tmp_install_log()
{
    if [ -f $tmp_install_log ]
    then
        eval $MV $tmp_install_log $tmp_install_log_old
    fi
    if [ -f $tmp_err ]
    then
        $RM $tmp_err
    fi
}

construct_return_status()
{
 	if [ $# -lt 3 ]
	then
		nw_log "Insufficient parameters passed in for construct_return_status."
		return 1
	fi

	echo "PACKAGE_NAME = $1" >> $return_status_log
	echo "OPERATION = $2" >> $return_status_log
	echo "STATUS = $3" >> $return_status_log

	return 0
}
                 X                                   nw_install_platform            8                           ZH=H=H=             #! /bin/sh
#
# $Id: nw_install_platform.sun.sh,v 1.5 2006/09/25 14:04:11 bspadafo Exp $ Copyright (c) 2008 EMC Corporation.
#

#
# Copyright (c) 2006-2008 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#
# This script contains sun Platform specific functions for client install
# 

# CONSTANT:
# daemon_shutdown_command="/usr/sbin/nsr_shutdown"
daemon_shutdown_command="/etc/init.d/networker stop"
daemon_startup_command="/etc/init.d/networker start"

# for removal
remove_package_command="/usr/sbin/pkgrm -n"
# use our admin file instead of /var/sadm/install/admin
# this value will be overwritten to reflect server name
# /tmp/cp_$server_name/admin.defailt
admin_file="/tmp/admin.default"
admin_option="-a $admin_file"

# for patches 
apply_patch_command="/usr/sbin/patchadd"

# for install 
add_package_command="/usr/sbin/pkgadd"
# this value will be overwritten to reflect server name
# /tmp/cp_$server_name/response
response_default="/tmp/response"
response_option="-r $response_file"
basedir=""

NID=""

# This function will remove a single package, using native sun package command
remove_package()
{
    # set up its admin file for remove, NOTE: if all the package could
    # use the same admin file, we could just set up this file just once
    # in remove_packages call

    admin_file="/tmp/cp_$server_name/admin.default"
    admin_option="-a $admin_file"

    nw_log "Removing package $1"

    if [ "$1" = "LGTOnode" ] || [ "$1" = "SUNWebsn" ]
    then

        nw_log "Found Storage Node...checking for Solaris 10 or greater"

	# If the package is LGTOnode and we are Solaris 10 or greater,
        # we unload the sgen driver so that the pkgrm step will not
        # ask for user input.

	if [ `uname -r | cut -f 2 -d '.'` -ge 10 ]
        then

	    nw_log "Found Solaris 10+..."

	    NID=`/usr/sbin/modinfo | grep sgen | $AWK '{print $1}'`
	    if [ -n "$NID" ]
	    then
                /usr/sbin/modunload -i ${NID}
	    fi
	fi
    fi

    # we send the output to a file to be sent to jobs once install is done.
    # while we re-direct stderr to log file. jobs doesn't care what's wrong.

    eval $remove_package_command $admin_option $1 >>$tmp_install_log 2>&1

    if [ $? -ne 0 ]
    then
	nw_log "$ScriptName: command \"$remove_package_command $admin_option $1\" failed with: \n \
`$CAT $tmp_install_log`"

        construct_return_status $1 REMOVE FAIL

        return 1
    fi

    construct_return_status $1 REMOVE SUCCESS

    return 0
}

# This function will add a single package, using native sun package command
add_package()
{

    # construct response file for this package

    response_default="/tmp/cp_$server_name/response"
    response_file="$response_default.$1"
    response_option=""

    if [ "$1" = "LGTOnode" ] || [ "$1" = "SUNWebsn" ]
    then

        nw_log "Found Storage Node...checking for Solaris 10 or greater"

	# If the package is LGTOnode and we are Solaris 10 or greater,
        # we unload the sgen driver so that the pkgrm step will not
        # ask for user input.

	if [ `uname -r | cut -f 2 -d '.'` -ge 10 ]
        then

	    nw_log "Found Solaris 10+..."

	    NID=`/usr/sbin/modinfo | grep sgen | $AWK '{print $1}'`
	    if [ -n "$NID" ]
	    then
                /usr/sbin/modunload -i ${NID}
	    fi
	fi
    fi

    if [ -f $response_file ]
    then 
        response_option="-r $response_file"
    fi

    admin_file="/tmp/cp_$server_name/admin.default"
    admin_file_new="/tmp/cp_$server_name/admin.default.$1"
    admin_option="-a $admin_file_new"

    # If a basedir install option was specified i.e. not "NA", then
    # we use a SED command to edit the admin.default file.
    #
    # NOTE:  The following logic assumes that there are no ',' characters
    #        in the basedir path name where the products were installed.

    if [ ! $2 = "NA" ]
    then
	sed s,"basedir=.*","basedir=$2", $admin_file > $admin_file_new
    else
	sed s/"basedir=.*"/"basedir=default"/ $admin_file > $admin_file_new
    fi

    # we send the output to a file to be sent to jobs once install is done.
    # while we re-direct stderr to log file. jobs doesn't care what's wrong.

    # set up source directory
    source_option="-d $SourceDir"

    nw_debug_log "$ScriptName: command  \"$add_package_command $admin_option $source_option $response_option $1 >>$tmp_install_log 2>&1\" is issued"

    eval $add_package_command $admin_option $source_option $response_option $1 >>$tmp_install_log 2>&1
    if [ $? -ne 0 ]
    then
        nw_log "$ScriptName: command \"$add_package_command $source_option \
$response_option $1\" failed with: \n \
`$CAT $tmp_install_log`"

        construct_return_status $1 ADD FAIL

        return 1
    fi

    construct_return_status $1 ADD SUCCESS

    return 0
}

# This function will apply a single patch, using native sun package command
apply_patch()
{
    nw_log "Applying patch $1"

    # we send the output to a file to be sent to jobs once patch is done.
    # while we re-direct stderr to log file. jobs doesn't care what's wrong.

    eval $apply_patch_command /tmp/cp_$server_name/$1 >>$tmp_install_log 2>&1

    if [ $? -ne 0 ]
    then
	nw_log "$ScriptName: command \"$apply_patch_command \
	/tmp/cp_$server_name/$1\" failed with: \n `$CAT $tmp_install_log`"

        construct_return_status $1 PATCH FAIL

        return 1
    fi

    construct_return_status $1 PATCH SUCCESS

    return 0
}

               X                                   nw_pre_install_check           8    m                        VH=H=H=             #!/bin/sh
#
# $Id: nw_pre_install_check.sh,v 1.5 2006/09/07 15:51:22 bspadafo Exp $ Copyright (c) 2006 EMC Corporation.
#

#
# Copyright (c) 2006 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#

# This is a pre-install script.
# It will do the following
# 1. calculate the free space in /tmp, where nw packages and install scripts 
#    will reside
# 2: Check existing nw packages and the space it uses
# 3. Check free space on the partition existing nw software resides for upgrade
# Return value: 
# 1, error with message in stdout
# 0, Success with stdout output in the format of 
# 

# log file, this value should be sync'ed with that in nw_client_install
# note: since it is update only for now, we could put the log in current 
# nw directory

#command script, this is the file need be imported first
nw_command="nw_command_list"

# common function script
nw_common_script="nw_common"

# common pre_install function script
pre_install_common_script="nw_pre_install_common"

# platform specific function script
pre_install_specific_script="nw_pre_install_platform"

# VARIABLES

# return value
_check_status=0

# error message generated by this script in case of error
err_message=""

# flag to indicate inventory only, default to "no"
inventory_only=0

#package list to check
package_list=""

# MAIN start from here

# import platform specific command list with full path
if [ ! -f $nw_command ] || [ ! -r $nw_command ]
then 
    echo \
    " File \"$nw_command\" is missing or can not be read." 
    exit 1
else . ./$nw_command

fi


# import common functions and platform specific functions
# note, nw_log and nw_exit is defined in $nw_common_script

if [ ! -f $nw_common_script ] || [ ! -r $nw_common_script ]
then 
    echo \
    " File \"$nw_common_script\" is missing or can not be read."

# if we failed to import $nw_common_script, we need use local function to
# exit. No log is possible at client side.
    exit 1
else . ./$nw_common_script

fi

if  [ ! -f $pre_install_common_script ] || \
    [ ! -r $pre_install_common_script ]
then
    echo "$ScriptName: File \"$pre_install_common_script\" is \
                missing or can not be read."
    exit 1
else . ./$pre_install_common_script
fi

if  [ ! -f $pre_install_specific_script ] || \
    [ ! -r $pre_install_specific_script ]
then
    echo "$ScriptName: File \"$pre_install_specific_script\" is \
                missing or can not be read."

    exit 1
else . ./$pre_install_specific_script
fi

# All functions have been loaded, start to work
# First of all, parsing input, setting up log etc.

kicker_directory=$1
shift

pre_install_init "$@"

_check_status=$?

if [ $_check_status -ne 0 ]
then
    err_message="$ScriptName: Function pre_install_init failed. Can not continue"
    nw_log "$err_message"
    nw_exit $_check_status
fi

if [ -f $Tmp_packout ]
then
    $RM $Tmp_packout
fi

#1. Check if this client is a cluster member.

nw_verbose_log "$ScriptName: Checking for a cluster..."

eval check_cluster

_check_status=$?

if [ $_check_status -ne 0 ]
then
    err_message="check for cluster failed on client $ClientName"
    # log error
    nw_log $err_message
    nw_exit $_check_status
fi

#2. Check networker packages

nw_verbose_log "$ScriptName: Checking packages..."

eval check_packages "$package_list"

_check_status=$?

if [ $_check_status -ne 0 ]
then
    err_message="check previous installed networker packages failed on client $ClientName"
    # log error
    nw_log $err_message
    nw_exit $_check_status
fi

nw_debug_log "$ScriptName: Packages checking done"

# 3. Check client time zone

nw_verbose_log "$ScriptName: Checking timezone..."

eval check_timezone

_check_status=$?

if [ $_check_status -ne 0 ]
then
    err_message="Check client timezone failed on client $ClientName"
    # log error
    nw_log $err_message
    nw_exit $_check_status
fi

nw_debug_log "$ScriptName: Timezone check done"

#4. Check free space on the FS nw is installed

# check whether nw is installed in default locations

nw_verbose_log "$ScriptName: Checking free space on \"$NwBaseDir\"..."

check_nw_free_space

_check_status=$?

nw_debug_log "$ScriptName: Checking free space on \"$NwBaseDir\" done"

if [ $_check_status -ne 0 ]
then
    err_message="check free space on the partition where old version networker is installed failed on client $ClientName"
    # log error
    nw_log "$err_message"
    nw_exit $_check_status
fi

# log where we are when verbose
nw_verbose_log "Finished inventory operation for client \"$ClientName\""

# send output message to stdout for server, $Tmp_packout is defined in
# nw_pre_install_common

$CAT $Tmp_packout

# do we need remove the lock?
if [ $inventory_only -ne 0 ]
then
    nw_debug_log "Remove lock file for inventory only operation."
    remove_lock
fi

# clean up before exit
nw_debug_log "$ScriptName: Clean up."

pre_install_cleanup

nw_exit 0
               X                                   nw_pre_install_common              8    m             #6          YH=H=H=         #:    #!/bin/sh
#
# $Id: nw_pre_install_common.sh,v 1.4 2006/09/07 15:51:32 bspadafo Exp $ Copyright (c) 2006 EMC Corporation.
#

#
# Copyright (c) 2006 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#

# This is a pre-install script.
# This file defines the common functions crossing all client platform
#

# CONSTANT

space_check="./mntpts"
cluster_config="lcmap"
free_space_flag="-free_kb"
used_space_flag="-used_kb"
total_space_flag="-total_kb"

Tmp_err="/tmp/$server_name.err"
Old_err="/tmp/$server_name.err.1"
Tmp_packout="/tmp/$server_name.inv"
Old_packout="/tmp/$server_name.inv.1"
Tmp_packinfo="/tmp/$server_name.tmp"
Tmp_packinfo1="/tmp/$server_name.tmp.1"

# Content in this block of constant need be sync'ed with that from windows 
# platform, file nw_pre_install_check.vbs
ClusterMember="ClusterMember ="
NormalizeName="UName = "
PackageName="PlatformName = "
Status="Status = "
BaseDirFreeSpace="InstallLocationFreeSpace = "
Size="Size = "
TimeZone="TimeZone = "

# the content from this block is consistent with property name of windows 
# package
Version="VersionString = "
BaseDir="InstallLocation = "
InstallDate="InstallDate = "
#TotalSize="Size = "

TimeZone_key="TZ="

# VARIABLES

_exit_status=0

package_list=""

# FUNCTIONS

# this function will be called by pre_install_parse_arg to display script usage
# this function may only be used in debug or install by hand

pre_install_display_usage()
{
# display nw_pre_install usage
    echo "Usage:"
    echo "nw_pre_install_check [-d/-v] [-s] [-o] [-i] [-h <server_name>] -l <package_list>"
    echo " where \n -d: optional for debug log, the most complete log"
    echo " -v: optional for verbose log"
    echo " -s: optional for silent install, status message will be logged\n \
but not be displayed in stdout."
    echo " -o: optional for overwrite lock, in case other networker server\n \
failed upgrading this server before and left a lock file behind.\n USE \
WITH EXTREME CAUTION."
    echo " -i: optional for inventory only. nw_pre_install_check will remove\n \
lock file before it exits with -i option."
    echo " -h <server_name>: optional, specify which server is doing \n \
pre-install check. If not specified, \"localhost\" will be used."
    echo " -l <package_list>: required, it contains the list of networker \n \
packages to check. And -l must be the last option in your command"
    return 0
}

# this function will parse the input argument and call 
# pre_install_display_usage in error case

pre_install_parse_arg()
{
# no parameter passed in, that's not right. We at least require a pointer
# to list of networker packages.

    # Flag to indicate the parsing is good or not, default to fail
    _exit_status=1

    if [ $# -eq 0 ]
    then 
        pre_install_display_usage
        return $_exit_status
    fi

    while [ $# -gt 0 ]
    do
        case "$1" in
        # for inventory only, lock file will be removed before exiting
        -i) inventory_only=1
            shift
            ;;

        -o)
        # User wants to overwrite the lock
            over_write=1
            shift
            ;;

        -d)
        # debug log
            log_level="d"
            shift
            ;;
        -v) 
        # verbose log
            log_level="v"
            shift
            ;;
        -s) 
        # silent log
            silent_install=1
            shift
            ;;
        -h)
            shift
            server_name=$1
            # redefine the file names
            log_file="/tmp/nw_install.$server_name.log"
            backup_log="/tmp/nw_install.$server_name.log.1"

            Tmp_err="/tmp/$server_name.err"
            Old_err="/tmp/$server_name.err.1"
            Tmp_packout="/tmp/$server_name.inv"
            Old_packout="/tmp/$server_name.inv.1"
            Tmp_packinfo="/tmp/$server_name.tmp"
            Tmp_packinfo1="/tmp/$server_name.tmp.1"


            shift
            ;;
        # we require -l is the last flag,
        -l)
        # pointer to list of packages
            shift
            # there is package name(s) passed in
            if [ $# -gt 0 ]
            then
                package_list="$@"
                # The only success case is we get some package to check
                _exit_status=0
                nw_debug_log "package_list is $package_list"
            else
                nw_debug_log "No packages name(s) follow \"-l\" option"
            fi                           
            break;
            ;;      
        *)
        # all other case, it is incorrect parameter passed in
            break
            ;;     
        esac
    done

    if [ $_exit_status -ne 0 ]
    then
        nw_debug_log "$ScriptName: Function pre_install_check \
\"-l <package_list>\" is required"
        pre_install_display_usage
    fi

    return $_exit_status
}

# this function will set up env for install and call create_client_log.
# this could end of in specific script

pre_install_init()
{
    # Just in case we crashed in the middle last time
    pre_install_cleanup

    # parse args

    pre_install_parse_arg "$@"
    _exit_status=$?

    if [ $_exit_status -ne 0 ]
    then
        if [ $silent_install -ne 1 ]
        then
            echo "$ScriptName: Function pre_install_parse_arg failed"
        fi
        return $_exit_status
    fi

    # grab lock now.
    get_lock
    _exit_status=$?

    if [ $_exit_status -ne 0 ]
    then
        if [ $silent_install -ne 1 ]
        then
            echo "$ScriptName: Function get_lock failed"
        fi
        return $_exit_status
    fi

    # create client side log file
    create_client_log
    _exit_status=$?

    if [ $_exit_status -ne 0 ]
    then 
        if [ $silent_install -ne 1 ]
        then
            # log file creation failed, have to use stdout
            echo "$ScriptName: Function create_client_log failed"
        fi
        return $_exit_status
    fi

    return 0
}

# this function will remove temp output files

pre_install_cleanup()
{
    # delete temp files we no longer need.
    if [ -f $Tmp_packout ]
    then
        eval $MV $Tmp_packout $Old_packout
    fi

    if [ -f $Tmp_err ]
    then
        eval $MV $Tmp_err $Old_err
    fi

    return 0
}

# This function will check how much free space is available in the partition where
# networker client software is installed

check_nw_free_space()
{
# we could end up calling C program mntpts to do just that

    if [ ! -f $space_check ]
    then
        return 0
    fi

    echo "$BaseDirFreeSpace `$space_check $free_space_flag $NwBaseDir` KB" \
    >>$Tmp_packout
    return 0
}


# This function will check what package(s) have been installed on this client
check_packages()
{

    # At this point, we expect server pass a list of packages to do
    # inventory, so if nothing passed in, we will complain. This may 
    # change though, if server decide not do that.

    if [ $# -le 0 ]
    then
        eval nw_log "Error, $ScriptName: No package name is passed in to check"
    return 1
    fi

    # recycle any $Tmp_pack in case script failed last time 
    # nw_debug_log "Recycle package information output file if there is any"
    
    # if [ -f $Tmp_packout ]
    # then 
    #     $RM $Tmp_packout
    # fi

    count=$#

    #for each package, we will run platform specific package query command
    #and get its information 
    while [ $count -gt 0 ]
    do
        count=`expr $count - 1`

        # function check_package is platform dependent, defined in
        # nw_pre_install_platform.sun

        nw_verbose_log "Checking package \"$1\"..."

        eval check_package $1

        if [ $? -ne 0 ]
        then
            nw_log "$ScriptName, funtion check_package failed for package \"$1\"."
            return 1
        fi
        nw_debug_log "Done checking package \"$1\"."
        shift        
    done

    return 0    
}
# This function will check the client machine time zone.

check_timezone()
{
  #add time zone information, we could only need timezone once.

    eval env |grep $TimeZone_key | sed "s/$TimeZone_key/$TimeZone/" \
    >>$Tmp_packout
    return $?
}


# This function will check to see if this client is part of a cluster.
# We can't upgrade clusters, so we need to determine this during 
# inventory and store that information away.

check_cluster()
{
    if [ -f $kicker_directory/$cluster_config ]
    then
        echo "$ClusterMember Yes">>$Tmp_packout
    else
        echo "$ClusterMember No">>$Tmp_packout
    fi

    return 0
}    

                 X                                   nw_pre_install_platform            8                 >       
   [H=H=H=         B    #!/bin/sh
#
# $Id: nw_pre_install_platform.sun.sh,v 1.3 2006/08/22 17:52:52 mmanasaw Exp $ Copyright (c) 2008 EMC Corporation.
#

#
# Copyright (c) 2006-2008 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#

# This is a pre-install script.
# This file defines the platform specific functions
#

# command to check package info on Solaris

Check_command="/bin/pkginfo -l"

# command to get installed patches info on Solaris
Get_patch_command="/bin/showrev -a"

# this command will be used to check how many bytes one package uses 
Space_check_command="/usr/sbin/pkgchk -l"

#const and variables



# The following const are from output pkginfo -l, it will be used as a key
# to parse the output. The normalized name, which will be sent back to server,
# will be defined in  nw_pre_install_common. For example, in output to server,
# we will have "version=6.6.1.5800" for all platform. But on solaris, we
# search "VERSION" keyword

Version_key="   VERSION:  "
BaseDir_key="   BASEDIR:  "
PackageName_key="   PKGINST:  "
NormalizeName_key="      NAME:  "
Status_key="    STATUS:  "
InstallDate_key="  INSTDATE:  "
TmpDirFreeSpace="TmpFreeSpace = "
Size_key="Expected file size"
TimeZone_key="TZ"
NotExist_key="was not found"
Patch_key="Patch = "

pkgname=""

pack_size_in_byte=0

DF='/bin/df'

#FUNCTIONS

# This function will check whether a particular packages has been installed
check_package()
{
    
    # recycle tmp file, this tmp files are only used by this function.
    # and should be recycled for each package

    nw_verbose_log "Recycle temp files from if there is any."

    if [ -f $Tmp_packinfo ]
    then
        eval $RM $Tmp_packinfo
    fi

    if [ -f $Tmp_packinfo1 ]
    then
        eval $RM $Tmp_packinfo1
    fi

    pack_size_in_byte=0

    # check pkginfo and direct it to file for parsing later

    pkgname=$1

    nw_verbose_log "Checking pkginfo for $pkgname..."

    $Check_command $pkgname 1>"$Tmp_packinfo" 2>"$Tmp_err"

    if [ $? -ne 0 ]
    then
        # failed running the command, is it because no such package installed?
        grep "$NotExist_key" $Tmp_err >/dev/null

        if [ $? -eq 0 ]
        then
            # this package was not found, return success
            return 0
        else            
            eval nw_log "$ScriptName: \"$Check_command $pkgname\" failed"
        return 1        
        fi
    fi

    # Now it is time to filter out the information we need

    # we might need uncomment the following line out in order to give server
    # a delimeter to parse the output

    # echo "#Package $pkgname"

    # parsing the pkginfo output to filter out the information we 
    # are interested

    nw_verbose_log "Parsing pkginfo output..."

    eval grep $NormalizeName_key $Tmp_packinfo | sed \
    "s/$NormalizeName_key/$NormalizeName/" >>$Tmp_packout

    eval grep $Version_key $Tmp_packinfo | sed "s/$Version_key/$Version/" \
    >>$Tmp_packout

    # if package name begins "SUN", issue showrev command to see if it has any patches

    if [ "SUN" -eq "'$CAT $1 | cut -c 1-3'" ]
    then
	$Get_patch_command | grep $pkgname |  awk '{print "x" $2}' \
	| sed "s/x/$Patch_key/" >> $Tmp_packout
    fi

    eval grep $BaseDir_key $Tmp_packinfo | sed "s/$BaseDir_key/$BaseDir/" \
    >>$Tmp_packout

    if [ $Base_check -ne 1 ]
    then
        nw_debug_log "Checking networker base directory..."
        Base_check=1
        NwBaseDir=`grep $BaseDir_key $Tmp_packinfo | awk '{print $2}'`
    fi

    eval grep $PackageName_key $Tmp_packinfo | sed \
    "s/$PackageName_key/$PackageName/" >>$Tmp_packout    

    eval grep $Status_key $Tmp_packinfo | sed "s/$Status_key/$Status/" \
    >>$Tmp_packout

    eval grep $InstallDate_key $Tmp_packinfo | sed \
    "s/$InstallDate_key/$InstallDate/" >>$Tmp_packout

    nw_verbose_log "calculating disk space used by package: $pkgname..."

    # now check for the space used
    eval $Space_check_command $pkgname |grep "$Size_key" |awk '{print $5}' \
    >$Tmp_packinfo1

    if [ $? -ne 0 ]
    then
        nw_log "$ScriptName: \"$Space_check_command $pkgname\" failed"
        return 1
    fi

    for i in `$CAT $Tmp_packinfo1`

    do
        pack_size_in_byte=`expr $pack_size_in_byte + $i`
    done

    echo "$Size $pack_size_in_byte" >>$Tmp_packout

    return 0
}   

check_tmp_free_space()
{
_space=`$DF -k /tmp | awk '{ if ($1 != "Filesystem") print $4 }'`
echo "$TmpDirFreeSpace $_space KB"
}

                  