   X                                   nsr_cp_install             8    m            
      8xoF;}uF;}uF;}u         
!    #!/bin/sh
#
# $Id: nw_cp_install.sh,v 1.7 2007/02/26 22:26:33 bspadafo Exp $ Copyright (c) 2007 EMC Corporation.
#

#
# Copyright (c) 2007 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#

# This is the main client push script.
#
# This script is called by the install service indicating the operation to
# perform and the set of parameters necessary for that operation.
# This script only calls the correct script based on the operation.  The
# operational scripts are copied over to the /tmp/server_name directory
# such that we can detect if more than one server is attempting to perform
# client push operations with this client.
#
# This script simply returns the result of the operational script. 

#CONST

# Make sure the locale is "C" so that the output generated by our 
# scripts can be parsed properly.

LANG=C
export LANG

dir_prefix="cp_"

set_path=`dirname $0`

nw_command="nw_command_list"

# pre install platform specific script
pre_install_script="nw_pre_install_platform"

# inventory script
nw_inventory_script="nw_pre_install_check"

# upgrade/install script
nw_install_script="nw_client_install"

if [ $# -eq 0 ]
then
	echo "No parameter passed in for nw_cp_install. Exit..." 1>&2
	return 1
fi


if [ "$1" = "inventory" ]
then
	op="INVENTORY"
    	if [ -f $set_path/nsrrcopy2 ]
    	then
		cp $set_path/nsrrcopy2 $set_path/nsrrcopy
    	fi

	# in the future, we will have remove, install and upgrade, all of them
	# will call the same script so all of them are treated as INSTALL.

elif [ "$1" = "upgrade" ]
then
	op="INSTALL"

elif [ "$1" = "status" ]
then
	op="STATUS"

elif [ "$1" = "cleanup" ]
then
	op="CLEANUP"

elif [ "$1" = "pre_install_check" ]
then
	op="PRE_INSTALL_CHECK"

else
	echo "Invalid operation \"$1\" passed in. Exit..." 1>&2
        return 1
fi

server_defined=0

#save all the parameters after operation parameter
shift
params="$@"

while [ $# -gt 0 ]
do
	case "$1" in
	-h) shift
	server_name=$1
	server_defined=1
	break
	;;
	*)
	shift
	;;
	esac
done

if [ $server_defined -eq 0 ]
then
	echo "No server name passed in for nw_cp_install. Exit..." 1>&2
	return 1
else
	dir="/tmp/$dir_prefix$server_name"
fi

# go to directory the scripts are
cd $dir

if [ $op = "INVENTORY" ]
then
    ./$nw_inventory_script $set_path $params
    _check_status=$?
    exit $_check_status
fi

if [ $op = "PRE_INSTALL_CHECK" ]
then
    . ./$pre_install_script
    eval check_tmp_free_space
    _check_status=$?
    exit $_check_status
fi

if [ $op = "INSTALL" ]
then
    ./$nw_install_script $params
    _check_status=$?
    exit $_check_status
fi

if [ $op = "STATUS" ]
then
    # get CAT command  
    . ./$nw_command
    $CAT return_status.log
    _check_status=$?
    exit $_check_status
fi

if [ $op = "CLEANUP" ]
then
    #get RM command
    . ./$nw_command
    cd /
    $RM -rf $dir
    _check_status=$?
    exit $_check_status
fi
                  X                                   	nsrrcopy2              8         e          F;|OF;xF;}d             #!/bin/ksh
#
# $Id: nsrrcopy2,v 1.3.6.1 2007/05/03 20:28:38 gsachar Exp $ Copyright (c) 2005-2007 EMC Corporation
#

#
# Copyright (c) 2005-2007 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/ucb:/usr/etc:/usr/opt/networker/bin:/opt/networker/bin; export PATH

# get the path of this script, so we can run uasm from there

set_path=`dirname $0`

# If the savestream passed to this script on the standard input stream was
# created relative to a directory i.e. (uasm -s -u -v .), the user may want
# to recover the savestream relative to a different base directory.  This
# is done via the -t option.
#
# If the savestream passed to this script on the standard input stream was
# created with an absolute path i.e. (uasm -s -u -v c:\tmp), then the -t
# option will have no impact.
#

if [ "$1" = "-t" ]
then
    if [ ! -d "$2" ] || [ ! -w "$2" ]
    then
        mkdir $2
    fi
    cd $2
    shift
    shift
else
    cd $set_path
fi

# Check if the path mapping option (-m) was specified by the caller. If so,
# the uasm command is adjusted to perform the substitution specified by the
# following two arguments.
#

if [ "$1" = "-m" ]
then
    $set_path/uasm -r -iY -m $2=$3 $4 1>&2 2>>/tmp/uasm.log
else
    $set_path/uasm -r -iY $1 1>&2 2>>/tmp/uasm.log
fi

exit $?
                