#! /bin/sh
#
# $Id: setup-homebase.sh,v 1.1.2.4 2008/11/07 07:07:39 babur1 Exp $ Copyright (c) 2007-2008, EMC Corporation.

# Copyright (c) 2008 EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.

#------------------------------------------------#
# EMC Homebase installation on silent mode	 #
#------------------------------------------------#

set PATH=/usr/bin:/bin:/usr/sbin:/sbin:$PATH
export PATH

installhomebase()
{
	HOMEBASE_DIR=/opt/homebase-agent/
	HOMEBASE_UNINSTALL=/opt/homebase-agent/_uninstall/Uninstall_HomeBase_Agent
	BMR_ANSWER_FILE=`ls ${HOMEBASE_DIR} | grep "Agent.properties"`
	HOMEBASE_BIN=`ls ${HOMEBASE_DIR} | grep "emc-homebase-agent"`

	if [ -f ${HOMEBASE_UNINSTALL} ]; then
		echo "EMC HomeBase agent is already installed. Please uninstall the HomeBase agent before reinstalling."
		echo "To uninstall EMC HomeBase agent run: /opt/homebase-agent/_uninstall/Uninstall_HomeBase_Agent -i silent"
		exit 1
	fi
	
	if [ X${HOMEBASE_BIN} = X"" ]; then
		echo "EMC HomeBase agent install binary is not found. Contact NetWorker Administrator for any assistance."
		exit 1
	fi
 
	if [ X${BMR_ANSWER_FILE} = X"" ]; then
		echo "EMC HomeBase agent response file is not found. Contact NetWorker Administrator for any assistance."
		exit 1
	fi

	echo "Starting EMC HomeBase Agent installation"
	echo "Installing EMC HomeBase Agent would take few minutes.... Please wait"
	echo "Installing EMC HomeBase Agent in silent mode ..... "
	${HOMEBASE_DIR}/${HOMEBASE_BIN} -f ${BMR_ANSWER_FILE} -i silent
	echo "Please check the log file /opt/homebase-agent/HomeBase_Agent_InstallLog.log for installation result."
}

#--------------------------------------------------#
# Solaris version limitation for installing homebase
#--------------------------------------------------#
if [ -f /usr/bin/uname ]; then
	PLATFORM=`/usr/bin/uname -p` 
	if [ X${PLATFORM} = X"sparc" ]; then
		OS_VERS=`/usr/bin/uname -r` 
		if [ X${OS_VERS} = X"5.8" ] || [ X${OS_VERS} = X"5.9" ] || [ X${OS_VERS} = X"5.10" ]; then
			installhomebase
			exit 0 
		else 
			echo "EMC HomeBase Agent is not supported on Solaris Version ${OS_VERS}."
		fi
	fi
fi

#--------------------------------------------------#
# Liunx version limitation for installing homebase
#--------------------------------------------------#
if [ -f /etc/redhat-release ] ; then
	PLATFORM=`uname -s` 
	if [ X${PLATFORM} = X"Linux" ]; then
		OS_VERS=`cat /etc/redhat-release | tr -s ' '| cut -d' ' -f7`
		if [ X${OS_VERS} = X4 ] || [ X${OS_VERS} = X5 ] ; then
			installhomebase
			exit 0
		else
			echo "EMC HomeBase Agent is not supported on the Red Hat version ${OS_VERS}."
		fi
	fi
fi

#--------------------------------------------------#
# HP-UX version limitation for installing homebase
#--------------------------------------------------#
if [ -f /usr/bin/uname ]; then
	PLATFORM=`/usr/bin/uname`
	if [ X$PLATFORM = XHP-UX ]; then
        	VERS=`/usr/bin/uname -r`
		if [ X$VERS = XB.11.11 -o X$VERS = XB.11.23 ]; then
			installhomebase
			exit 0
		else
			echo "EMC HomeBase Agent is only supported on HP-UX 11iv1 and HP-UX 11iv2."
		fi
	fi
fi

#--------------------------------------------------#
# Aix version limitation for installing homebase
#--------------------------------------------------#
if [ -f /usr/bin/uname ]; then
        PLATFORM=`/usr/bin/uname`
        if [ X$PLATFORM = XAIX ]; then
		REL=`/usr/bin/uname -r`
                VER=`/usr/bin/uname -v`
                if [ X$VER = X5 -a $REL -ge 2 -a $REL -le 3 ]; then
                        installhomebase
                        exit 0
                else
                        echo "EMC HomeBase Agent is only supported on AIX version 5.2 and 5.3."
                fi
        fi
fi

echo "EMC HomeBase Agent is supported only on following platforms."
echo "1) Red Hat Linux Version 4 or 5 on x86 and amd64"
echo "2) Solaris Version 8 or 9 on SPARC."
echo "3) Aix 5.2 or 5.3 on PPC."

exit 0
