#!/bin/sh
#
# $Id: savepsm.sh.src,v 1.4.116.1.24.1 2010/09/15 19:33:08 grands1 Exp $ Copyright (c) 2010, EMC Corporation.
#
# All rights reserved.  This is an UNPUBLISHED work, and
# comprises proprietary and confidential information of EMC.
# Unauthorized use, disclosure, and distribution are strictly
# prohibited.  Use, duplication, or disclosure of the software
# and documentation by the U.S. Government is subject to
# restrictions set forth in a license agreement between the
# Government and EMC or other written agreement specifying
# the Government's rights to use the software and any applicable
# FAR provisions, such as FAR 52.227-19.
#
#
# All rights reserved.
#
# savepsm.sh
#
# This script is part of the Networker Management Console
# Modification of this script should be done with care and only after reading
# the administration manual included with this product.
#
#
#
#
# ====================================================================
#

#
# Handle cancel signals sent by savegrp when user stops the group.
#
handle_signal()
{
	if [ $Pid != 0 ]; then
		kill -2 $Pid
	fi
	exit 1
}

#
# The main portion of this shell.
ARCH=`uname`

# Initialize Pid
Pid=0
GST_HOME="XGST_INSTALL_DESTDIRX"

# Set the LD_LIBRARY_PATH. Since Console is relocatable on Solaris, add bin path
# as well. On other platforms, rpath built into savepsm should suffice.
case "$ARCH" in
    SunOS )
            LD_LIBRARY_PATH="$GST_HOME/sybasa/lib64:$GST_HOME/bin:$LD_LIBRARY_PATH"
            export LD_LIBRARY_PATH
            ;;
    Linux )
            LD_LIBRARY_PATH="$GST_HOME/sybasa/lib:$LD_LIBRARY_PATH"
            export LD_LIBRARY_PATH
            ;;
    AIX )
            LIBPATH="$GST_HOME/sybasa/lib64:$LIBPATH"
            export LIBPATH
            ;;
    HP-UX )
            SHLIB_PATH="$GST_HOME/sybasa/lib64:$SHLIB_PATH"
            export SHLIB_PATH
            ;;
esac

#
# Make sure we respond to savegrp cancellations.
#
trap handle_signal 2 15

# Call savepsm
"XNSR_BIN_PATHX/savepsm" -I "$GST_HOME" "$@" &
Pid=$!

# Wait till the savepsm completes
wait $Pid
ret_status=$?

exit $ret_status
