/*
 * $Id: browser.js,v 1.10.8.2.8.6 2011/10/27 17:17:55 wuy3 Exp $ Copyright (c) 2011 EMC Corporation
 */

/*
 * Copyright (c) 2011 EMC Corporation.
 *
 * All rights reserved.  This is an UNPUBLISHED work, and
 * comprises proprietary and confidential information of EMC.
 * Unauthorized use, disclosure, and distribution are strictly
 * prohibited.  Use, duplication, or disclosure of the software
 * and documentation by the U.S. Government is subject to
 * restrictions set forth in a license agreement between the
 * Government and EMC or other written agreement specifying
 * the Government's rights to use the software and any applicable
 * FAR provisions, such as FAR 52.227-19.
 */

    function checkPluginVersion() {
	var version = "application/x-java-applet;jpi-version=1.6";
	var version2 = "application/x-java-applet;version=1.6";
	for (var i = 0; i < navigator.plugins.length; i++) {
	    for (var j = 0; j < navigator.plugins[i].length; j++) {
		if (navigator.plugins[i][j].type.indexOf(version) != -1) {
		    return (true);
		} else if (navigator.plugins[i][j].type.indexOf(version2) != -1) {
		    return (true);
		}
	    }
	}
	return (false);
    }

    /*
     * Function to detect the browser we are running on, the version and 
     * whether WebStart is installed.
     */
    function xbDetectBrowser() {
	var oldOnError = window.onerror;
	var element = null;

	window.onerror = null;

	window.saveNavigator = window.navigator;

	navigator.OS    = '';
	navigator.version  = parseFloat(navigator.appVersion);
	navigator.org    = '';
	navigator.family  = '';

	var platform;
	var i = 0;
	var ua = window.navigator.userAgent.toLowerCase();

	if (typeof(window.navigator.platform) != 'undefined') {
	    platform = window.navigator.platform.toLowerCase();
	    osplat = window.navigator.platform
	    if (platform.indexOf('win') != -1) {
		navigator.OS = 'win';
		osplat = 'Windows';
	    } else if (platform.indexOf('mac') != -1) {
		navigator.OS = 'mac';
	    } else if( platform.indexOf('sun') != -1 ) {
		navigator.OS = 'nix';
	    } else if( platform.indexOf('unix') != -1 ) {
		navigator.OS = 'nix';
	    } else if( platform.indexOf('linux') != -1 ) {
		navigator.OS = 'linux';
		osplat = 'Linux';
	    } else if( platform.indexOf('hp-ux') != -1 ) {
		navigator.OS = 'HP-UX';
	    } else if( platform.indexOf('aix') != -1 ) {
		navigator.OS = 'AIX';
	    }
	}

	if (ua.indexOf('opera') != -1) {
	    i = ua.indexOf('opera');
	    navigator.family = 'opera';
	    navigator.org = 'opera';
	    navigator.version = parseFloat('0' + ua.substr(i+6), 10);
	} else if ((i = ua.indexOf('msie')) != -1) {
	    navigator.org = 'microsoft';
	    navigator.version = parseFloat('0' + ua.substr(i+5), 10);

	    if (navigator.version < 6) {
		navigator.family = 'ie4';
	    } else {
		navigator.family = 'ie6'
	    }
	} else if (ua.indexOf('gecko/') != -1) {
	    navigator.family = 'gecko';
	    var rvStart = ua.indexOf('rv:');
	    var rvEnd = ua.indexOf(')', rvStart);
	    var rv = ua.substring(rvStart+3, rvEnd);
	    var rvParts = rv.split('.');
	    var rvValue = 0;
	    var exp = 1;

	    for (var i = 0; i < rvParts.length; i++) {
		var val = parseInt(rvParts[i]);
		rvValue += val / exp;
		exp *= 100;
	    }

	    navigator.version = rvValue;

	    if (ua.indexOf('netscape') != -1) {
		navigator.org = 'netscape';
	    } else if (ua.indexOf('compuserve') != -1) {
		navigator.org = 'compuserve';
	    } else if (ua.indexOf('mozilla') != -1) {
		navigator.org = 'mozilla';
	    }
	} else if( (ua.indexOf('mozilla') !=-1) &&
		(ua.indexOf('spoofer')==-1) &&
		(ua.indexOf('compatible') == -1) &&
		(ua.indexOf('opera')==-1)&& (ua.indexOf('webtv')==-1) &&
		(ua.indexOf('hotjava')==-1)) {
	    var is_major = parseFloat(navigator.appVersion);

	    if (is_major < 4) {
		navigator.version = is_major;
	    } else {
		i = ua.lastIndexOf('/')
		navigator.version = parseFloat('0' + ua.substr(i+1), 10);
	    }

	    navigator.org = 'netscape';
	    navigator.family = 'nn' + parseInt(navigator.appVersion);
	} else if ((i = ua.indexOf('aol')) != -1 ) {
	    navigator.family  = 'aol';
	    navigator.org    = 'aol';
	    navigator.version  = parseFloat('0' + ua.substr(i+4), 10);
	} else if ((i = ua.indexOf('hotjava')) != -1 ) {
	    navigator.family  = 'hotjava';
	    navigator.org    = 'sun';
	    navigator.version  = parseFloat(navigator.appVersion);
	}
	window.onerror = oldOnError;
    }

    function isUnsupportedBrowser() {
	if (navigator.org == 'netscape' && navigator.version > 3 && navigator.version < 7) {
	    return true;
	}
	return false;
    }

    function openBrowserReqs(win) {
	showBrowserReqs(showPopup("", "browserReqs"));
    }

    function showPopup(url, windowName) {
	new_win = window.open(url, windowName, 'scrollbars=yes,toolbar=no, width=900, height=580');
	new_win.focus();
	return (new_win);
    }

    function showNetscapeMime() {
	var new_win = showPopup("", "netscapeMime");
	new_win.document.open();
	new_win.document.writeln("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">");
	new_win.document.writeln("<html>");
	new_win.document.writeln("<head>");
	new_win.document.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
	new_win.document.writeln("<META HTTP-EQUIV=\"CACHE-CONTROL\" CONTENT=\"NO-CACHE\">");
	new_win.document.writeln("<META HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\">");
	new_win.document.writeln("<body bgcolor=\"#ffffff\">");
	new_win.document.writeln("<h1>" + JI18N(39649, "Update Mime Types for the current user") + "</h1>");
	new_win.document.write(JI18N(62144, "This page has detected that the browser you are currently using is configured to use the correct Java JRE from 1.6 family."));
	new_win.document.write(" " + JI18N(39651, "This JRE was either bundled with the browser, or was installed as part of the previous JRE installation instructions."));
	new_win.document.write(" " + JI18N(70040, "If you are getting a Save As... dialog box when you try to launch the application, then there is a missing mime type association."));
	new_win.document.write(" " + JI18N(70041, "This association tells the browser which helper application to use in order to run the product."));
	new_win.document.write(" " + JI18N(39654, "Each user that wishes to use this browser will need to edit their .mime.types and .mailcap files in their home directories. The lines to add are listed below."));
	new_win.document.writeln("<br><p>" + JI18N(29859, "Add this line to the .mime.types file."));
	new_win.document.writeln("<br><p><tt>type=application/x-java-jnlp-file desc=\"Java Web Start\" exts=\"jnlp\"</tt>");
	new_win.document.writeln("<br><p>" + JI18N(29860, "Add this line to the .mailcap file."));
	new_win.document.write(" " + JI18N(39655, "This line assumes the correct JRE was installed in /usr/local."));
	new_win.document.write(" " + JI18N(39656, "Adjust this line if your JRE location is different."));
	new_win.document.write(" " + JI18N(39657, "If the JRE was bundled with your browser, you should find a link to it under your browsers installation directory."));
	new_win.document.writeln("<br><p><tt>application/x-java-jnlp-file; /usr/local/jre1.6.0_03/bin/javaws %s</tt>");
	new_win.document.writeln("<p>" + JI18N(39658, "Now restart your browser and see if the problem is fixed."));
	new_win.document.writeln("<p>");
	new_win.document.writeln("<h1>" + JI18N(39659, "Update Java Web Start Proxy Settings") + "</h1>");
	new_win.document.writeln(JI18N(39660, "If the above steps do not fix the problem then Java Web Start may be having problems picking up the correct proxy settings."));
	new_win.document.write(" " + JI18N(39661, "Java Web Start tries to determine the proxy settings from the current browser the first time it starts."));
	new_win.document.write(" " + JI18N(39662, "This process may fail, or there may be old or bad proxy settings left from a previous Java installation for this user."));
	new_win.document.write(" " + JI18N(39663, "Follow these steps to fix the problem."));

	new_win.document.writeln("<p>" + JI18N(39664, "If there is a .java directory in the current users home directory remove it as it may have old or bad proxy information in it."));
	new_win.document.write(" " + JI18N(39665, "Then invoke the Java Web Start Application Manager from the currrent shell."));
	new_win.document.write(" " + JI18N(39666, "The path to the executable is the second element of the line added to the .mailcap file above."));
	new_win.document.writeln("<br><p><tt>/usr/local/jre1.6.0_03/bin/javaws -viewer</tt>");
	new_win.document.writeln("<p>" + JI18N(39667, "Java Web Start will try to configure your current proxy settings."));
	new_win.document.write(" " + JI18N(39668, "If it cannot it will pop up a dialog box and allow you to set them."));
	new_win.document.write(" " + JI18N(39669, "If you do not have any proxy settings then choose None. If you do, then choose Manual and enter in your Manual Proxy information."));
	new_win.document.write(" " + JI18N(39670, "Close the Java Web Start Application Manager."));
	new_win.document.writeln("<p>" + JI18N(39671, "Now restart your browser and see if the problem is fixed") + ".<p>");
	new_win.document.writeln("<p align=center><a href=javascript:window.close();>" + JI18N(38143, "Close Window") + "</a> </p>");
	new_win.document.writeln("</body>");
	new_win.document.writeln("</html>");
	new_win.document.close();
    }

    function showBrowserReqs(win) {
	var JI18N = parent.JI18N;
	var new_win = win;
	new_win.document.open();
	new_win.document.writeln("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
	new_win.document.writeln("<html>");
	new_win.document.writeln("<head>");
	new_win.document.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
	new_win.document.writeln("<META HTTP-EQUIV=\"CACHE-CONTROL\" CONTENT=\"NO-CACHE\">");
	new_win.document.writeln("<META HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\">");
	if (top.isBrowserSupported) {
	    new_win.document.writeln("<title>" + JI18N(38140, "Browser, OS and JRE Requirements") + "</title>");
	} else {
	    // Note the following line left non-localized by intention
	    new_win.document.writeln("<title>" + "Browser, OS and JRE Requirements" + "</title>");
	}
	new_win.document.writeln("<style type=text/css>");
	new_win.document.writeln("<!--");
	new_win.document.writeln("body,td,th {");
	new_win.document.writeln("font-family: Trebuchet MS;");
	new_win.document.writeln("}");
	new_win.document.writeln("-->");
	new_win.document.writeln("</style></head>");
	new_win.document.writeln("<body>");
	new_win.document.writeln("<table width=100%  border=0 cellpadding=5 cellspacing=1 bgcolor=#000000>");
	new_win.document.writeln("<tr>");
	if (top.isBrowserSupported) {
	    new_win.document.writeln("<td bgcolor=#FFFFFF><strong>" + JI18N(67315, "Operating System") + "</strong> </td>");
	    new_win.document.writeln("<td bgcolor=#FFFFFF><strong>" + JI18N(70037, "Browsers") + "</strong> </td>");
	    new_win.document.writeln("<td bgcolor=#FFFFFF><strong>" + JI18N(70039, "JRE") + "</strong> </td>");
	    new_win.document.writeln("<td bgcolor=#FFFFFF><strong>" + JI18N(70038, "JRE Downloads") + "</strong> </td>");
	} else {
	    // Note the following line left non-localized by intention
	    new_win.document.writeln("<td bgcolor=#FFFFFF><strong>" + "Operating System" + "</strong> </td>");
	    new_win.document.writeln("<td bgcolor=#FFFFFF><strong>" + "Browsers" + "</strong> </td>");
	    new_win.document.writeln("<td bgcolor=#FFFFFF><strong>" + "JRE" + "</strong> </td>");
	    new_win.document.writeln("<td bgcolor=#FFFFFF><strong>" + "JRE Downloads" + "</strong> </td>");
	}
	new_win.document.writeln("</tr>");
	new_win.document.writeln("<tr>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> AIX 5L 5.2, 5.3, 6.1, 7.1 </td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Mozilla 1.7</td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> 1.6, 1.7 </td>");
	new_win.document.write("<td bgcolor=#FFFFFF> <a href=\"" + aix_url + "\" target=\"_blank\">");
	new_win.document.writeln(aix_url + " </td>");
	new_win.document.writeln("</tr>");
	new_win.document.writeln("<tr>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> HP-UX 11i ver2, ver3 </td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Mozilla 1.7 </td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> 1.6, 1.7 </td>");
	new_win.document.write("<td bgcolor=#FFFFFF> <a href=\"" + hp_url + "\" target=\"_blank\">");
	new_win.document.writeln(hp_url + " </td>");
	new_win.document.writeln("</tr>");
	new_win.document.writeln("<tr>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Red Hat Enterprise Linux Server 4, 5 <br>");
	new_win.document.writeln("SuSE Linux Enterprise Server 9, 10, 11 <br>");
	new_win.document.writeln("Redflag Asianux Server 3</td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Mozilla 1.7</td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> 1.6, 1.7 </td>");
	new_win.document.write("<td bgcolor=#FFFFFF> <a href=\"" + linux_url + "\" target=\"_blank\">");
	new_win.document.writeln(linux_url + " </td>");
	new_win.document.writeln("</tr>");
	new_win.document.writeln("<tr>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Solaris 9, 10 </td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Mozilla 1.7</td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> 1.6, 1.7 </td>");
	new_win.document.write("<td bgcolor=#FFFFFF> <a href=\"" + solaris_url + "\" target=\"_blank\">");
	new_win.document.writeln(solaris_url + " </td>");
	new_win.document.writeln("</tr>");
	new_win.document.writeln("<tr>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Windows 2000</td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Microsoft Internet Explorer 6, 7 </td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> 1.6, 1.7 </td>");
	new_win.document.write("<td bgcolor=#FFFFFF> <a href=\"" + win_url + "\" target=\"_blank\">");
	new_win.document.writeln(win_url + " </td>");
	new_win.document.writeln("</tr>");
	new_win.document.writeln("<tr>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Windows XP<br>");
	new_win.document.writeln("Windows 2003</td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Microsoft Internet Explorer 6, 7, 8 </td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> 1.6, 1.7 </td>");
	new_win.document.write("<td bgcolor=#FFFFFF> <a href=\"" + win_url + "\" target=\"_blank\">");
	new_win.document.writeln(win_url + " </td>");
	new_win.document.writeln("</tr>");
	new_win.document.writeln("<tr>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Windows 7<br>");
	new_win.document.writeln("Windows Vista<br>");
	new_win.document.writeln("Windows 2008<br>");
	new_win.document.writeln("Windows 2008 R2</td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> Microsoft Internet Explorer 8 </td>");
	new_win.document.writeln("<td bgcolor=#FFFFFF> 1.6, 1.7 </td>");
	new_win.document.write("<td bgcolor=#FFFFFF> <a href=\"" + win_url + "\" target=\"_blank\">");
	new_win.document.writeln(win_url + " </td>");
	new_win.document.writeln("</tr>");
	new_win.document.writeln("</table>");
	new_win.document.writeln("<p></p>");
	if (top.isBrowserSupported) {
	    new_win.document.writeln("<p align=center><a href=javascript:window.close();>" + JI18N(38143, "Close Window") + "</a> </p>");
	} else {
	    // Note the following line left non-localized by intention
	    new_win.document.writeln("<p align=center><a href=javascript:window.close();>" + "Close Window" + "</a> </p>");
	}
	new_win.document.writeln("</body>");
	new_win.document.writeln("</html>");
	new_win.document.close();
    }
