/*
 * $Id: locale.js,v 1.4.62.1 2010/10/08 23:06:54 protal Exp $ Copyright (c) 2010 EMC Corporation
 */

/*
 * Copyright (c) 2008 EMC Corporation.
 *
 * All rights reserved.  This is an UNPUBLISHED work, and
 * comprises proprietary and confidential information of EMC.
 * Unauthorized use, disclosure, and distribution are strictly
 * prohibited.  Use, duplication, or disclosure of the software
 * and documentation by the U.S. Government is subject to
 * restrictions set forth in a license agreement between the
 * Government and EMC or other written agreement specifying
 * the Government's rights to use the software and any applicable
 * FAR provisions, such as FAR 52.227-19.
 */

<!-- gstconfig bEgIn DO NOT ALTER THIS LINE -->
    var brand = "NetWorker";
<!-- gstconfig  eNd  DO NOT ALTER THIS LINE -->

    function getBrand() {
        if (brand == "NetWorker") {
            return ("NetWorker");
        }
        return ("Sun StorEdge EBS");
    }

    var xmlHttpReq = false;
    var self = this;
    var msgs = new Array();
    if (window.XMLHttpRequest) {
        self.xmlHttpReq = new XMLHttpRequest();
    }
    // IE
    else if (window.ActiveXObject) {
        self.xmlHttpReq = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var self = this;
    
    /**
     * This function loads the js file from the locale 
     */
    function loadJs () {
    	var jsfile = getLocaleJs(getLocale());
	var script = document.createElement('script');
	script.type = 'text/javascript';
	if(document.uniqueID) script.src = jsfile;
	else script.src = jsfile;
	document.getElementsByTagName('head')[0].appendChild(script);	
    }
    
    /**
     * This function gets the locale  
     */
    function getLocale() {
    	var lang = false;
	if (window.ActiveXObject) {
		lang = top.navigator.userLanguage
	} else {
		lang = top.navigator.language
	}
	lang = replaceAll(lang,"-","_");
    	return lang.toLowerCase();
    }
    
    /**
     * This function checks if Chinese the current locale 
     */
    function isChinese() {
      var lang = getLocale();

      if (lang.indexOf('zh') > -1) {

            return true;

      }
      return false;
    }

    /**
     * This function replaces all chars  
     */
    function replaceAll(str, oldChar, newChar) {
    	// if equal, no need to replace
    	if (oldChar == newChar) {
		return str;
	}
	// loop and replace strings
    	while (str.indexOf(oldChar) > -1) {
		str = str.replace(oldChar, newChar);
	}
	return str;
    }
    
    /**
     * This function gets the js file name given 
     * the locale
     */
    function getLocaleJs(locale) {
	locale = getBroaderLocale(locale);
  	if (locale == 'en'){
		return '/msgs.js';
	}
  	var js = '/msgs_' + locale + '.js';
	self.xmlHttpReq.open('GET', js, false);
    	self.xmlHttpReq.send('');
	var res = self.xmlHttpReq.responseText;
	// check to see if the file is present
	if (self.xmlHttpReq.status == 200) {
		return js;
	} 
	// When nothing else matches
	var newlocale = getBroaderLocale(locale);
	return getLocaleJs(newlocale);
    }
    
    /**
     * This function strips the last underscore to get a 
     * broader match locale
     */
    function getBroaderLocale(locale) {
    
    	if (locale.lastIndexOf("_") > -1) {
		locale = locale.substring(0,locale.lastIndexOf("_"));
		return locale;
	}
	// no more broader match. return english
	return "en";
    }
    
    /**
     * This function delays execution of a method my 100 ms
     */
    function delay(method) {
    	setTimeout(method, 100);
    }
    
    /**
     * This function formats the msg, by replacing the braced number
     * with the arguments
     */
    function formatMsg() {
    	if (arguments.length == 0) {
		return "";
	}
	var pattern = arguments[0];
	try {		
    		for (i=1;i<arguments.length;i++) {
			var argregexp = new RegExp("[{][" + (i-1) + "][}]");
			pattern = pattern.replace(argregexp, arguments[i]);
		}
	} catch (e) {
		alert(" Error formatting msg on :" + pattern);
	}
	return pattern;
    }
    
    /**
     * This function replaces the NetWorker txt with the brand specified
     */
    function rebrand(text, brand) {
    	if (text) {		
    		text = text.replace("NetWorker", brand);
	}
	return text;
    }
    
    function setMsgs(m) {
    	msgs = m;
    }
    
    function JI18N(msgId, str) {
    	if (msgId == null || msgId == -1) {
		return str;
	}
	try {
		if (msgs[msgId]) {
			return msgs[msgId];
		}
	} catch (e) {
	}
	return str;
    }

