   X                                   nsr_client_install.bat               uasm               8      A    N@    Np    N                             ?a Vj	*r                           $       @                       w|bD   d                                                              !         A               A::REM Copyright (c) 2007-2009 EMC Corporation
::REM
::REM All rights reserved.  This is an UNPUBLISHED work, and
::REM comprises proprietary and confidential information of EMC.
::REM Unauthorized use, disclosure, and distribution are strictly
::REM prohibited.  Use, duplication, or disclosure of the software
::REM and documentation by the U.S. Government is subject to
::REM restrictions set forth in a license agreement between the
::REM Government and EMC or other written agreement specifying
::REM the Government's rights to use the software and any applicable
::REM FAR provisions, such as FAR 52.227-19.
::REM

:: This script is called by kicker script to perform INSTALL operation
:: server will pass in the parameter list as:
::
::  <temp working dir> -r <product Name 1> -r <product name 2> ... -i <setup file 1>...
:: -r <product name 1> [ parameters for silent install ] -i <setup file 2>...
:: -r <product name 2> [ parameters for silent install ]
::
:: Note 1:  All items in < > are required and item in [ ] are optional.  There must be a 
:: space before and after "[" "]".
::
:: Note 2:  The parameter list is expected to contain INSTALLDIR as the last switch.  All
::          switches substitute "*" for "=" and "+" for ",".  Each of these characters must
::          be surrounded by a space.
::
::    e.g.  [ ADDLOCAL * All REMOVE * NwSnode + NwLLM + ... INSTALLDIR * C:\temp\dir ]
::

@ECHO OFF
IF %~1=="" (
    :: Can't set log file yet. Simply exit with error
    EXIT /B 1
)

SET install_target=
SET remove_target=
SET product=
SET ipar=
SET nw_installed=0

SET dir=%1
IF NOT EXIST %dir% (EXIT /B 2)
SET nw_install_log=%dir%\nw_install.log
SET nw_install_detail_log=%dir%\nw_install_detail.log
SET nw_status=%dir%\nw_status_temp.log
SET nw_final_status=%dir%\nw_status.log
SET nw_nsrpm_temp=%dir%\nw_nsrpm_temp.log
SHIFT

:next

IF "%~1" == "" GOTO end
IF "%~1" == "-r" GOTO remove
IF "%~1" == "-i" GOTO install

SHIFT
GOTO next


:remove

net stop nsrexecd

SHIFT
IF "%~1" =="" (
    ECHO %Date% %Time%:"Error, no product specified to remove" >>%nw_install_log%
    GOTO error
)

:: Can't just do SET product=%1, as there may be space in product name,
:: i.e. Networker Management Console

SET product=
GOTO get_product

:get_product_return

ECHO %Date% %Time%:Product = %product%>>%nw_install_log%

CALL %dir%\nsr_get_msi.vbs "%product%" "%dir%"
IF ERRORLEVEL 1 (
    ECHO %Date% %Time%:"Error determining msi files for deinstall for %product%"  >>%nw_install_log%
    GOTO ERROR
)

FOR /F "delims=;" %%i in (%dir%\product_loc.txt) do SET remove_target=%%i

ECHO %Date% %Time%:Remove Target = %remove_target%>>%nw_install_log%

CALL %dir%\nsr_check_target.bat %remove_target%
IF ERRORLEVEL 1 (	
    ECHO %Date% %Time%:Could not find %remove_target%>>%nw_install_log%
    ECHO PACKAGE_NAME = %product%>>%nw_status%
    ECHO OPERATION = REMOVE>>%nw_status%
    ECHO STATUS = FAIL>>%nw_status%
    GOTO ERROR
)



GOTO next

:: ****************************************************************************
::
:: This block is responsible for parsing the parameters necessary to install
:: the next product, determining if the correct files are available for the
:: install, and then performing the install.
::
:: ****************************************************************************

:install

SHIFT
IF "%~1" =="" (
    ECHO %Date% %Time%:"Error, no msi file or setup file specified to install" >>%nw_install_log%
    GOTO error
)

:: Retrieve the .msi file needed for the install.
SET msifile=
GOTO get_msifile

:get_msifile_return

ECHO HIT MSIFILE_RETURN>>%nw_install_log%

::===========================================================================
::
:: Now, we get the product name.  The files necessary for the install should
:: have been copied into a directory named after the product.  This allows us
:: to upgrade multiple products at the same time without having conflicts in
:: file names.
::
::===========================================================================

SET curr_product=

:: Jump past the expected -r flag, and then parse out the product.

SHIFT
GOTO get_iproduct

:get_iproduct_return

SET install_target="%dir%\%curr_product%\%msifile%"
ECHO %Date% %Time%: INSTALL TARGET = %install_target%>>%nw_install_log%

::reset ipar
SET ipar=
SET idir=
SET hbadir=
:: Get parameter list if there is any, otherwise call setup.exe and install 
:: it silently with default values

IF "%~1"=="[" (
    GOTO loop_par
)

:install_action

ECHO About to call %dir%\nsr_check_target.bat %install_target%>>%nw_install_log%

CALL %dir%\nsr_check_target.bat %install_target%
IF ERRORLEVEL 1 (	
    ECHO %Date% %Time%:"%install_target% not found. Software package has not been pushed over or path is incorrect.">>%nw_install_log%
    ECHO PACKAGE_NAME = %curr_product%>>%nw_status%
    ECHO OPERATION = ADD>>%nw_status%
    ECHO STATUS = FAIL>>%nw_status%
    GOTO ERROR
)

ECHO %Date% %Time%:"msi file for remove is %remove_target%" >>%nw_install_log%
ECHO %Date% %Time%:"Removing product using 'msiexec /qn /x %remove_target%'..." >>%nw_install_log%
CALL msiexec /qn /x %remove_target%
IF ERRORLEVEL 1 (	
    ECHO %Date% %Time%:Remove %remove_target% failed>>%nw_install_log%
    ECHO PACKAGE_NAME = %product%>>%nw_status%
    ECHO OPERATION = REMOVE>>%nw_status%
    ECHO STATUS = FAIL>>%nw_status%
    GOTO ERROR
)	

ECHO %Date% %Time%:"%product% is removed successfully." >>%nw_install_log%
ECHO PACKAGE_NAME = %product%>>%nw_status%
ECHO OPERATION = REMOVE>>%nw_status%
ECHO STATUS = SUCCESS>>%nw_status%

::=============================================================================
::
:: If this is the NetWorker product, then we need to modify the .msi to prevent
:: the installer from starting up the nsrexecd daemons.  We set the service
:: StartType to "disabled".  After the installer runs, the nsrexecd service
:: won't be started and we can then enable and restart it after ALL products
:: have been installed.
::
::=============================================================================

IF "%curr_product%"=="NetWorker" (
    SET nw_installed=1
)

::    ECHO "Setting the nsrexecd service startup mode to 'disabled'...">>%nw_install_log%
::    CALL %dir%\nsr_modify_service_startup.vbs %dir% %install_target% nsrexecd 4
:: )

:: IF ERRORLEVEL 1 (
::    ECHO %Date% %Time%:"Could not modify the nsrexecd service startup.">>%nw_install_log%
::    ECHO PACKAGE_NAME = %curr_product%>>%nw_status%
::    ECHO OPERATION = ADD>>%nw_status%
::    ECHO STATUS = FAIL>>%nw_status%
::    SET nw_installed=0
::    GOTO ERROR
:: )

ECHO "About to perform the install of %curr_product%">>%nw_install_log%

::=============================================================================
::
:: Now, we perform the silent install using the setup.exe.
::
::=============================================================================

ECHO %Date% %Time%:"Install %install_target% from location %dir% with parameters %ipar%" >>%nw_install_log%

SET curr_log=\"%dir%\%curr_product%_nw_install_detail.log\"

:: We need to check the REMOVE parameters to make sure that
:: the features we are removing are allowed to be removed.

SET new_ipar=%ipar%
SET addlocal_token=
SET addlocal_key=
SET remove_token=
SET remove_key=
SET remainder_token=
SET remove_output=
SET startsvc_token=

FOR /F "tokens=1,2,3" %%i in ("%ipar%") do (
    SET addlocal_token=%%i
    SET remove_token=%%j
    SET startsvc_token=%%k
)

FOR /F "tokens=1 delims==" %%m in ("%addlocal_token%") do SET addlocal_key=%%m
FOR /F "tokens=1 delims==" %%m in ("%remove_token%") do SET remove_key=%%m

IF NOT "%addlocal_key%"=="ADDLOCAL" (
    ECHO %Date% %Time%:"No ADDLOCAL could be using INSTALLLEVEL..." >>%nw_install_log%
    GOTO RUN_SETUP
)

IF NOT "%remove_key%"=="REMOVE" (
    ECHO %Date% %Time%:"No REMOVE switch in command line..." >>%nw_install_log%
    GOTO RUN_SETUP
)
    
ECHO %Date% %Time%:%dir%\nsr_remove_check.vbs "%dir%" %install_target% "%remove_token%">>%nw_install_log%

CALL %dir%\nsr_remove_check.vbs "%dir%" %install_target% "%remove_token%"

IF NOT EXIST %dir%\msi_switches.txt (
    echo "Information: No output file from nsr_remove_check.vbs...">>%nw_install_log%
    IF ERRORLEVEL 1 (
        ECHO %Date% %Time%:"nsr_remove_check failed" >>%nw_install_log%
        GOTO RUN_SETUP
    )
    SET new_ipar=%addlocal_token% %startsvc_token%
    GOTO RUN_SETUP
)

FOR /F "delims=;" %%i in (%dir%\msi_switches.txt) do SET remove_output=%%i
ECHO REMOVE OUTPUT = %remove_output%>>%nw_install_log%
SET new_ipar=%addlocal_token% %remove_output% %startsvc_token%

COPY /Y "%dir%\msi_switches.txt" "%dir%\%curr_product%_msi_switches.txt" 1>NUL
DEL /q "%dir%\msi_switches.txt" 1>NUL

:: For setup.exe 

:RUN_SETUP

ECHO %Date% %Time%:%install_target% /s /v"/qn /L*v %curr_log% %new_ipar% INSTALLHBADIR=\"%hbadir%\" INSTALLDIR=\"%idir%\"">>%nw_install_log%

CALL %install_target% /s /v"/qn /L*v %curr_log% %new_ipar% INSTALLHBADIR=\"%hbadir%\" INSTALLDIR=\"%idir%\""

:: For .msi
:: ECHO %Date% %Time%:"msiexec /i %install_target% /qn /L*v %nw_install_detail_log% %new_ipar%" >>%nw_install_log%
:: Call msiexec /i %install_target% /qn /L*v %nw_install_detail_log% %new_ipar%

IF ERRORLEVEL 1 (
ECHO %Date% %Time%:"Install %install_target% failed" >>%nw_install_log%
    ECHO PACKAGE_NAME = %curr_product%>>%nw_status%
    ECHO OPERATION = ADD>>%nw_status%
    ECHO STATUS = FAIL>>%nw_status%
    GOTO ERROR
)

IF "%curr_product%"=="NetWorker" (
    ECHO "Setting nw_installed to 2...">>%nw_install_log%
    SET nw_installed=2
)

ECHO %Date% %Time%:"%install_target% is installed successfully." >>%nw_install_log%
ECHO PACKAGE_NAME = %curr_product%>>%nw_status%
ECHO OPERATION = ADD>>%nw_status%
ECHO STATUS = SUCCESS>>%nw_status%
GOTO next


:: *****************************************************************
::
::  This loop will parse the commandline for the product that needs
::  to be removed.
::
:: *****************************************************************

:get_product

:: No parameter left, go back
IF "%~1"=="" (
GOTO get_product_return
)

:: This is the next operating flag, go back
IF "%~1"=="-r" ( 
GOTO get_product_return)

:: This is the next operating flag, go back
IF "%~1"=="-i" ( 
GOTO get_product_return)

:: this is the optional parameters, go back
IF "%~1"=="[" (
GOTO get_product_return)

IF "%product%"=="" GOTO first_product
SET product=%product% %~1%
SHIFT
 
GOTO get_product

:first_product
SET product=%~1%
SHIFT

GOTO get_product

:: *****************************************************************
::
::  This loop will retrieve the msifile from the command line 
::  arguments.
::
:: *****************************************************************

:get_msifile

:: No parameter left, go back
IF "%~1"=="" (
GOTO get_msifile_return
)

:: This is the next operating flag, go back
IF "%~1"=="-r" ( 
GOTO get_msifile_return)

:: This is the next operating flag, go back
IF "%~1"=="-i" ( 
GOTO get_msifile_return)

:: this is the optional parameters, go back
IF "%~1"=="[" (
GOTO get_msifile_return)


IF NOT "%msifile%"=="" (
SET msifile=%msifile% %~1%
)

IF "%msifile%"=="" (
SET msifile=%~1%
)

ECHO FOUND MSIFILE = %msifile%>>%nw_install_log%

SHIFT
GOTO get_msifile

:: *****************************************************************
::
::  This loop will grab the current product being worked on.
::
:: *****************************************************************

:get_iproduct

:: No parameter left, go back
IF "%~1"=="" (
GOTO get_iproduct_return
)

:: This is the next operating flag, go back
IF "%~1"=="-i" ( 
GOTO get_iproduct_return)

:: this is the optional parameters, go back
IF "%~1"=="[" (
GOTO get_iproduct_return)

IF "%curr_product%"=="" GOTO first_iproduct
SET curr_product=%curr_product% %~1%
SHIFT
 
GOTO get_iproduct

:first_iproduct
SET curr_product=%~1%
SHIFT

GOTO get_iproduct

:: *****************************************************************
::
::  This loop will retrieve the optional parameters.  This loop 
::  assumes that the INSTALLDIR parameter is always at the end of
::  the set of parameters.  The output variable "ipar" contains all
::  the switches except for the INSTALLDIR switch which is copied to
::  "idir".  The "idir" switch is dealt with separately because we
::  need to add quotes around the path and if we expand the ipar 
::  variable with quotes in it, they are lost.  We need to build
::  those quotes into the command at the time we run the setup.exe.
::
:: *****************************************************************

:loop_par

SET output=
SET prev_par=
SET ctoken=

:loop_par2

ECHO IPAR : %ipar%>>%nw_install_log%
ECHO PREV_PAR : %prev_par%>>%nw_install_log%
ECHO IDIR : %idir%>>%nw_install_log%
ECHO HBADIR :%hbadir%>>%nw_install_log%

SHIFT

ECHO CTOKEN %1>>%nw_install_log%

IF "%~1"=="]" (
ECHO FOUND BRACKET>>%nw_install_log%
GOTO install_action
)

IF "%~1"=="*" (
ECHO FOUND STAR>>%nw_install_log%
IF "%prev_par%"=="INSTALLDIR" (
ECHO PROCESSING INSTALLDIR PARM>>%nw_install_log%
ECHO '%1' '%2' '%3'>>%nw_install_log%
SET idir=%idir%%~2
SHIFT
GOTO loop_par2
)
IF "%prev_par%"=="INSTALLHBADIR" (
ECHO PROCESSING INSTALLHBADIR PARM>>%nw_install_log%
ECHO '%1' '%2'>>%nw_install_log%
SET hbadir=%hbadir%%~2
SHIFT
GOTO loop_par2
)

SET ipar=%ipar%=%~2%
SHIFT
GOTO loop_par2
)

IF "%~1"=="+" (
ECHO FOUND PLUS>>%nw_install_log%
SET ipar=%ipar%,%~2%
SHIFT
GOTO loop_par2
)

ECHO FOUND VALUE>>%nw_install_log%
IF "%~1"=="INSTALLDIR" (
SET prev_par=%1
GOTO loop_par2
)
IF "%prev_par%"=="INSTALLDIR" (
SET idir=%idir% %1
GOTO loop_par2
)
IF "%prev_par%"=="INSTALLHBADIR" (
SET hbadir=%hbadir% %1
GOTO loop_par2
)
SET ipar=%ipar% %1
SET prev_par=%1
GOTO loop_par2


:end

::======================================================================
::
::  If the NetWorker product was upgraded, then we need to enable the
::  nsrexecd service and then restart it.
::
::======================================================================

copy /V %nw_status% %nw_final_status% >NUL

ECHO "%Date% %Time%: 1: Copied the final status...">>%nw_install_log%

:: Fix the .msi so that if the install operation failed, the customer
:: can manually install and the service will start up properly.

:: IF NOT "%nw_installed%"=="2" IF NOT "%nw_installed%"=="0" (
::    ECHO "Modifying the nsrexecd service startup mode to 'automatic'...">>%nw_install_log%
::    CALL %dir%\nsr_modify_service_startup.vbs %dir% %install_target% nsrexecd 2
:: )

:: Enable and startup the nsrexecd service.

:: IF "%nw_installed%"=="2" (
::    ECHO "Configuring the nsrexecd service to enable it...">>%nw_install_log%
::    sc config nsrexecd start= enabled
:: )


ECHO "About to start the nsrexecd service...">>%nw_install_log%
net start nsrexecd

ECHO "Checking the nsrpm service.....">>%nw_install_log%
reg  query HKLM\SYSTEM\CurrentControlSet\Services\nsrpm /v Start

IF ERRORLEVEL 0 (	
    FOR /F "tokens=3" %%A IN ('reg  query HKLM\SYSTEM\CurrentControlSet\Services\nsrpm /v Start ^|find "Start"') do  echo %%A >%nw_nsrpm_temp%
)

if exist %nw_nsrpm_temp% ( 
   FOR /F "tokens=1 delims= " %%i IN (%nw_nsrpm_temp%) do (
   
   if [%%i] == [0x4] (sc config nsrpm start= auto)
      
   IF ERRORLEVEL 1 (
       ECHO "Unable to update startup type entry of nsrpm service in the registry" >>%nw_install_log%
   )
)
ECHO "About to start the nsrpm service...">>%nw_install_log%
net start nsrpm
)
EXIT /B 0


:error

copy /V %nw_status% %nw_final_status% >NUL

ECHO "%Date% %Time%: 2: About to copy the final status...">>%nw_install_log%

:: Fix the .msi so that if the install operation failed, the customer
:: can manually install and the service will start up properly.

:: IF NOT "%nw_installed%"=="2" IF NOT "%nw_installed%"=="0" (
::    ECHO "Modifying the nsrexecd service startup mode to 'automatic'...">>%nw_install_log%
::    CALL %dir%\nsr_modify_service_startup.vbs %dir% %install_target% nsrexecd 2
:: )

:: Enable and startup the nsrexecd service.

:: IF "%nw_installed%"=="2" (
::    ECHO "Configuring the nsrexecd service to enable it...">>%nw_install_log%
::     sc config nsrexecd start= enabled
:: )

ECHO "About to start the nsrexecd service...">>%nw_install_log%
net start nsrexecd

EXIT /B 1

         *                       	 .UNIXATTR                    X                                   nsr_pre_install_check.vbs                uasm               8      C    Nxx    Nqk    N                             B_awn6s                           $       @                       w|bD   d                                                              !         C               C' $Id: nw_pre_install_check.vbs,v 1.5 2007/01/10 20:46:56 bspadafo Exp $ Copyright (c) 2007 EMC Corporation
'
' Copyright (c) 2006 EMC Corporation.
'
' All rights reserved.  This is an UNPUBLISHED work, and
' comprises proprietary and confidential information of EMC.
' Unauthorized use, disclosure, and distribution are strictly
' prohibited.  Use, duplication, or disclosure of the software
' and documentation by the U.S. Government is subject to
' restrictions set forth in a license agreement between the
' Government and EMC or other written agreement specifying
' the Government's rights to use the software and any applicable
' FAR provisions, such as FAR 52.227-19.
'

' This script will be called by kicker script to perform INVENTORY operation
' input: Product name "xxxxx" or product code "{xxxxxxx}"
' output: product information.
' Usage:
' cscript //nologo nw_pre_install_check.vbs networker

Option Explicit

Const msiInstallStateNotUsed      = -7
Const msiInstallStateBadConfig    = -6
Const msiInstallStateIncomplete   = -5
Const msiInstallStateSourceAbsent = -4
Const msiInstallStateInvalidArg   = -2
Const msiInstallStateUnknown      = -1
Const msiInstallStateBroken       =  0
Const msiInstallStateAdvertised   =  1
Const msiInstallStateRemoved      =  1
Const msiInstallStateAbsent       =  2
Const msiInstallStateLocal        =  3
Const msiInstallStateSource       =  4
Const msiInstallStateDefault      =  5

' Joe Mitchell need fix nw73 install shield
Const NwBadNMC_name = "NMC"

' the following block need be sync'ed with that from nw_pre_install_common on Unix side
Const Uname_prefix = "UName = "
Const Name_prefix = "PlatformName = "
Const State_prefix = "Status = "
Const TmpFreeSpace_prefix = "TmpFreeSpace = "
Const InstallLocationFreeSpace_prefix = "InstallLocationFreeSpace = "
Const Size_prefix = "TotalSize = "
Const TimeZone_prefix = "TimeZone = "

' Connect to Windows Installer object
On Error Resume Next
Dim installer : Set installer = Nothing
Set installer = Wscript.CreateObject("WindowsInstaller.Installer") : CheckError

' If no argument is given, give usage.
Dim argCount:argCount = Wscript.Arguments.Count
If (argCount = 0) Then

    ' We will display usage and return error
    Wscript.Echo "Usage:" &_
    vbNewLine & " cscript //nologo nw_pre_install_check <product_name or product_ID>" &_
    vbNewLine & " Lists attributes for installed and advertised product <product_name: " &_
    "case in-sensitive or product_ID: GUID>" &_
    vbNewLine & " Example: cscript //nologo nw_pre_install_check networker" &_
    vbNewLine &_
    vbNewLine & "Copyright (C) EMC Corporation, 2005, All rights reserved."
    Wscript.Quit 1
End If

Dim inventoryData:inventoryData=""
Dim productName
Dim index:index=0
Dim currentMsiFile
Dim selectableFeatureCnt:selectableFeatureCnt = 0
Dim sFeaturesArray(50)
Dim productFileName
Dim cpFileVersion
Dim objFSO

productFilename = Trim(Wscript.Arguments(index))

index = index + 1

Set objFSO = CreateObject("Scripting.FileSystemObject")
cpFileVersion = objFSO.GetFileVersion(productFilename)

Do 

    If (argCount = index)  Then Exit Do

    productName = Trim(Wscript.Arguments(index))
    index=index + 1

    ' Wscript.echo "Current Product : " & productName

    ' If Product name supplied, need to search for product code

    Dim productCode, property, value
    If Left(productName, 1) = "{" And Right(productName, 1) = "}" Then
        If installer.ProductState(productName) <> msiInstallStateUnknown Then _
	    productCode = UCase(productName)
    Else
        For Each productCode In installer.Products : CheckError
            If LCase(installer.ProductInfo(productCode, "ProductName")) = _
	       LCase(productName) Then Exit For
        Next
    End If

    If Not IsEmpty(productCode) Then

        Dim feature, features, parent, state, location, locationSpace
        Dim locationFreeSpace, freeTempSpace, timeZone

        ' Retrieve the list of features that we care about for this product.  We
        ' only care about top-level features (no-parent) and selectable 
        ' sub-features.  We run a query on the .msi to determine the list of
        ' features that we care about.

	Dim skip:skip=0

        currentMsiFile = GetMsi(productName) : CheckError
        selectableFeatureCnt = GetMsiSelectableFeatures(currentMsiFile)

        Set features = installer.Features(productCode)

        For Each feature In features

            ' We only care about top-level features (no-parent) and
	    ' sub-features that are selectable.  

            parent = installer.FeatureParent(productCode, feature) : CheckError

	    If isFeatureSelectable(feature, selectableFeatureCnt) Then

		' Wscript.echo "Current Feature : '" & feature & "'"

	        state = installer.FeatureState(productCode, feature)

	        Select Case(state)

		    ' We only care about the packages installed locally
		    ' set up normalize_name, platform_name field and state

		    Case msiInstallStateBadConfig:    state = "Corrupt"
		    Case msiInstallStateIncomplete:   state = "InProgress"
		    Case msiInstallStateSourceAbsent: state = "SourceAbsent"
		    Case msiInstallStateBroken:       state = "Broken"
		    Case msiInstallStateAdvertised:   state = "Advertised"
		    Case msiInstallStateAbsent:       state = "Uninstalled"
		    Case msiInstallStateLocal:        state = "Local"
		    Case msiInstallStateSource:       state = "Source"
		    Case msiInstallStateDefault:      state = "Default"
		    Case Else:                        state = "Unknown"
	        End Select

		skip = 0

		' Wscript.echo "State = " & state

	        ' If stats field indicate Uninstalled, don't report, go for next feature.

	        If state <> "Uninstalled" Then

	            If state <> "Source" Then	

		        ' This can be removed once Joe fix nw73 install shield

		        If (InStr(1,feature,NwBadNMC_name,vbTextCompare)) Then
			    skip = 1
			End If

		        ' It seems odd we attach the following property information
		        ' again and again for each feature. We do this only to make
		        ' it consistent with some unix platform, such as solaris,
		        ' which each package may have different information

		        If (skip = 0) Then

			    ' For all others, we report empty uname because we
			    ' don't know its universal name.

			    inventoryData = inventoryData & vbNewLine & Uname_prefix &_
					vbNewLine & Name_prefix & feature & vbNewLine &_
 					State_prefix & state

			    For Each property In Array(_
					    "Language",_
					    "PackageName",_			
					    "VersionString",_
					    "InstallLocation",_
					    "InstallDate",_
					    "LocalPackage")
			        value = installer.ProductInfo(productCode, property)
			        If Err <> 0 Then
				    Err.Clear
				    value = Empty
			        End If
			        If (property = "InstallLocation") Then
				    location = value
			        End If

			        If (property = "VersionString") Then
				    value = cpFileVersion
			        End If
					
			        If (value <> Empty) Then

 				    inventoryData = inventoryData & vbNewLine &_
						    property & " = " & value
			        End If
			    Next
		        End If
		    End If
	        End If
	    End If

            'add InstallLocationSpace information. i.e. How much space used
            'locationSpace = GetLocationSpace(location) 
            'inventoryData = inventoryData & vbNewLine &locationSpace

            ' add InstallLocationFreeSpace information
            'locationFreeSpace = GetInstallLocationFreeSpace(location)
            'inventoryData = inventoryData & vbNewLine & locationFreeSpace

            ' check temp directory free space
            'freeTempSpace = GetFreeTempSpace()
            'inventoryData = inventoryData & vbNewLine & freeTempSpace

            'interrogate the operating system for current time zone info

	Next
 
	timeZone = GetCurrentTimeZone()
        inventoryData = inventoryData & vbNewLine & timeZone

    End If

    ' do loop
Loop

Wscript.Echo inventoryData



' ############################################################################
'
' This function determines if the specified feature is part of the .msi for
' the currently installed product that we are working on upgrading.
'

' ############################################################################

Function isFeatureSelectable(featureName, featureCount)

    ' for

    Dim selectable:selectable = 0
    Dim x:x=0

    ' Wscript.echo "Looking for feature " & "'" & featureName & "'"

    For x = 1 to featureCount

	' Wscript.echo "'" & sFeaturesArray(x) & "'"
        If sFeaturesArray(x) = featureName Then
	    selectable = 1
	    Exit For
        End If
    Next

    isFeatureSelectable = selectable

End Function

' ############################################################################
'
' This function creates an array of selectable feature names that are
' contained within the specified .msi file.  
'
' ############################################################################

Function GetMsiSelectableFeatures(databasePath)

    Const msiOpenDatabaseModeReadOnly = 0
    Const msiOpenDatabaseModeTransact = 1

    ' Open the database

    Dim openMode : openMode = msiOpenDatabaseModeReadOnly
    Dim database : Set database = installer.OpenDatabase(databasePath, openMode) : CheckError

    ' Execute an SQL statement to retrieve all top-level features (no-parent) and any
    ' user-selectable sub-features.

    Dim query, view, record, rowData, columnCount, delim, column

    query = "SELECT `Feature` FROM `Feature` WHERE `Feature_Parent`='' OR `Display`<>0"

    Set view = database.OpenView(query) : CheckError
    view.Execute : CheckError

    ' Now, loop through the results of the query and build up an array that can
    ' be used by the main routine to filter out features that we care about.

    Dim x:x=0

    Do
        Set record = view.Fetch
        If record Is Nothing Then Exit Do
        columnCount = record.FieldCount
        rowData = Empty
        delim = "  "
        For column = 1 To columnCount
	    If column = columnCount Then delim = vbLf
	    rowData = rowData & record.StringData(column) & delim
        Next
        x = x + 1
        sFeaturesArray(x) = Left(rowData, len(rowData) - 1)
    Loop

    ' Wscript.echo "Total of " & x & " elements in the array"

    ' Dim def

    ' For def = 1 To x
    '     Wscript.echo sFeaturesArray(def)
    ' Next

    ' database.close()

    GetMsiSelectableFeatures=x

End Function


Sub CheckError
	Dim message, errRec
	If Err = 0 Then Exit Sub
	message = Err.Source & " " & Hex(Err) & ": " & Err.Description
	If Not installer Is Nothing Then
		Set errRec = installer.LastErrorRecord
		If Not errRec Is Nothing Then message = message & vbLf & errRec.FormatText
	End If
	Fail message
End Sub

Sub Fail(message)
	Wscript.Echo message
	Wscript.Quit 2
End Sub



' ############################################################################
'
' This function will return the path of the .msi that was used to install the 
' specified product.  
'
' ############################################################################

Function GetMsi(productName)

    Const msiInstallStateNotUsed      = -7
    Const msiInstallStateBadConfig    = -6
    Const msiInstallStateIncomplete   = -5
    Const msiInstallStateSourceAbsent = -4
    Const msiInstallStateInvalidArg   = -2
    Const msiInstallStateUnknown      = -1
    Const msiInstallStateBroken       =  0
    Const msiInstallStateAdvertised   =  1
    Const msiInstallStateRemoved      =  1
    Const msiInstallStateAbsent       =  2
    Const msiInstallStateLocal        =  3
    Const msiInstallStateSource       =  4
    Const msiInstallStateDefault      =  5

    ' On Error Resume Next

    Dim msiFile

    ' If Product name supplied, need to search for product code

    Dim productCode, property, value, message

    If Left(productName, 1) = "{" And Right(productName, 1) = "}" Then
	If installer.ProductState(productName) <> _
	    msiInstallStateUnknown Then productCode = UCase(productName)
    Else
	For Each productCode In installer.Products : CheckError2
	    If LCase(installer.ProductInfo(productCode, "ProductName")) = _
		LCase(productName) Then Exit For
	Next
    End If

    If IsEmpty(productCode) Then
	GetMsi = "Product is not registered: " & productName
        Wscript.Quit 2
    End If

    Dim feature, features, parent, state
    Set features = installer.Features(productCode)

    For Each feature In features

        parent = installer.FeatureParent(productCode, feature) : CheckError2

	' If the feature has a parent, then we look to see if it has a .msi associated
	' with it.

	If Len(parent) = 0 Then

	    state = installer.FeatureState(productCode, feature)
	    Select Case(state)
	        ' We only care about the packages installed locally
		' set up normalize_name, platform_name field and state
		Case msiInstallStateBadConfig:    state = "Corrupt"
		Case msiInstallStateIncomplete:   state = "InProgress"
		Case msiInstallStateSourceAbsent: state = "SourceAbsent"
		Case msiInstallStateBroken:       state = "Broken"
		Case msiInstallStateAdvertised:   state = "Advertised"
		Case msiInstallStateAbsent:       state = "Uninstalled"
		Case msiInstallStateLocal:        state = "Local"
		Case msiInstallStateSource:       state = "Source"
		Case msiInstallStateDefault:      state = "Default"
		Case Else:                        state = "Unknown"
	    End Select	   
		
	    ' If stats field indicate Uninstalled, don't report, check next feature.

	    If state <> "Uninstalled" Then
		If state <> "Source" Then	
		    For Each property In Array("LocalPackage") : CheckError2
			value = installer.ProductInfo(productCode, property) ': CheckError2
			If Err <> 0 Then
			    Err.Clear
			    value = Empty
			End If
		        If value <> Empty Then
			    message = value &";"
			    msiFile = value
		        End If
		    Next
	        End If
	    End If
        End If
    Next

    ' clean up

    set message = nothing
    set productName = nothing

    GetMsi = msiFile

End Function


' Subroutine to check errors
Sub CheckError2
	Dim message, errRec
	If Err = 0 Then Exit Sub
	message = Err.Source & " " & Hex(Err) & ": " & Err.Description
	If Not installer Is Nothing Then
		Set errRec = installer.LastErrorRecord
		If Not errRec Is Nothing Then message = message & vbNewLine & errRec.FormatText
	End If
	Wscript.Echo message
	Wscript.Quit 2
End Sub




' ###########################################################################
'
' Utility Functions
'
' ###########################################################################

' Function to get free space on the drive current networker is intalled
Function GetInstallLocationFreeSpace(location)
	Dim FSObj, DriveObj	
	Set	FSObj = CreateObject("Scripting.FileSystemObject")	
	Set DriveObj = FSObj.GetDrive(FSObj.GetDriveName(location))
	GetInstallLocationFreeSpace = InstallLocationFreeSpace_prefix & DriveObj.AvailableSpace
	Set FSObj = Nothing
	Set DriveObj = Nothing
End Function

' Function to get how much space used by current version of networker
Function GetLocationSpace(location)
	Dim FSObj
	set FSObj = CreateObject("Scripting.FileSystemObject")		
	GetLocationSpace = Size_prefix & FSObj.GetFolder(FSObj.GetDriveName(location)).Size
	set FSObj = Nothing
End Function

' Function to get free temp directory
Function GetFreeTempSpace()
	Dim FSObj, WshShell, WshSysEnv, TempDir, DriveObj
	set FSObj = CreateObject("Scripting.FileSystemObject")
	set WshShell = Wscript.CreateObject("WScript.Shell")	
	set WshSysEnv = WshShell.Environment("PROCESS")
	TempDir = WshSysEnv("TEMP")	
	'if Temp doesn't exist, try "Tmp"
	If Not FSObj.FolderExists(TempDir) Then TempDir = WshSysEnv("TMP")
	'if none of them exist, create one? Or maybe return error?
	If Not FSObj.FolderExists(TempDir) Then FSObj.CreateFolder(TempDir)	
	set DriveObj = FSObj.GetDrive(FSObj.GetDriveName(TempDir))
	GetFreeTempSpace = TmpFreeSpace_prefix & DriveObj.AvailableSpace
	set FSObj = Nothing
	set Ws = Nothing
	set WsEnv = Nothing
	set DriveObj = Nothing
End Function

' Function to get time zone information. 
' Return value is the time difference with GMT in minutes,
' For example, ETS is 5 hours behind GMT, so it shows as -300 (min)
Function GetCurrentTimeZone()
	Dim Computer, WMIServiceObj, OScol, OSobj
	' set to local machine, which is ."
	Computer = "."
	set WMIServiceObj = GetObject("Winmgmts:\\" & Computer)
	set OScol = WMIServiceObj.InstancesOf("win32_OperatingSystem")
	' We usually have only one OSobj as long as no mutil-OS is installed
	For each OSobj in OScol
		GetCurrentTimeZone=TimeZone_Prefix & OSobj.CurrentTimeZone
	Next
	set WMIServiceObj = Nothing
	set OScol = Nothing
End Function
               X                                   nsr_check_target.bat             uasm               8          Dr    Np    N                             B_aD` }	5r                           $       @                       w|bD   d                                                              !                        ::REM Copyright (c) 2006 EMC Corporation
::REM
::REM All rights reserved.  This is an UNPUBLISHED work, and
::REM comprises proprietary and confidential information of EMC.
::REM Unauthorized use, disclosure, and distribution are strictly
::REM prohibited.  Use, duplication, or disclosure of the software
::REM and documentation by the U.S. Government is subject to
::REM restrictions set forth in a license agreement between the
::REM Government and EMC or other written agreement specifying
::REM the Government's rights to use the software and any applicable
::REM FAR provisions, such as FAR 52.227-19.
::REM

@ECHO OFF
SET msi_file=%1
dir %msi_file% 1>NUL 2>NUL
IF ERRORLEVEL 1 (	
	EXIT /B 1
)
EXIT /B 0
        *                       	 .UNIXATTR                    X                                   nsr_check_tmp_free_space.vbs             uasm               8          N    Np    N                             DVa pO	:4r                           $       @                       w|bD   d                                                              !                        'Copyright (c) 2006 EMC Corporation.
'
' All rights reserved.  This is an UNPUBLISHED work, and
' comprises proprietary and confidential information of EMC.
' Unauthorized use, disclosure, and distribution are strictly
' prohibited.  Use, duplication, or disclosure of the software
' and documentation by the U.S. Government is subject to
' restrictions set forth in a license agreement between the
' Government and EMC or other written agreement specifying
' the Government's rights to use the software and any applicable
' FAR provisions, such as FAR 52.227-19.
'

' This script will be called by kicker script to check available temp space
' input: None
' output: Available Tmp Space
' Usage:
' cscript //nologo nw_check_free_tmp_space.vbs

Option Explicit

Const TmpFreeSpace_prefix = "TmpFreeSpace = "

Dim FSObj, WshShell, WshSysEnv, TempDir, DriveObj, FreeTempSpace

        set FSObj = CreateObject("Scripting.FileSystemObject")
        set WshShell = Wscript.CreateObject("WScript.Shell")
        set WshSysEnv = WshShell.Environment("PROCESS")
        TempDir = WshSysEnv("TEMP")
        'if Temp doesn't exist, try "Tmp"
        If Not FSObj.FolderExists(TempDir) Then TempDir = WshSysEnv("TMP")
        'if none of them exist, create one? Or maybe return error?
        If Not FSObj.FolderExists(TempDir) Then FSObj.CreateFolder(TempDir)
        set DriveObj = FSObj.GetDrive(FSObj.GetDriveName(TempDir))
        FreeTempSpace = TmpFreeSpace_prefix & DriveObj.AvailableSpace/1024
	wscript.echo FreeTempSpace
        set FSObj = Nothing
        set WshShell = Nothing
        set WshSysEnv = Nothing
        set DriveObj = Nothing
        *                       	 .UNIXATTR                    X                                   nsr_get_msi.vbs              uasm               8          N    Np    N                             DVaO	ABr                           $       @                       w|bD   d                                                              !                        '
' Copyright (c) 2005-2006 EMC Corporation.
'
' All rights reserved.  This is an UNPUBLISHED work, and
' comprises proprietary and confidential information of EMC.
' Unauthorized use, disclosure, and distribution are strictly
' prohibited.  Use, duplication, or disclosure of the software
' and documentation by the U.S. Government is subject to
' restrictions set forth in a license agreement between the
' Government and EMC or other written agreement specifying
' the Government's rights to use the software and any applicable
' FAR provisions, such as FAR 52.227-19.
'

' This script will determine the .msi file for a given product
' input: Product name "xxxxxx" or product code "{xxxxxxx}"
' output: full path name for .msi file

Option Explicit

Const msiInstallStateNotUsed      = -7
Const msiInstallStateBadConfig    = -6
Const msiInstallStateIncomplete   = -5
Const msiInstallStateSourceAbsent = -4
Const msiInstallStateInvalidArg   = -2
Const msiInstallStateUnknown      = -1
Const msiInstallStateBroken       =  0
Const msiInstallStateAdvertised   =  1
Const msiInstallStateRemoved      =  1
Const msiInstallStateAbsent       =  2
Const msiInstallStateLocal        =  3
Const msiInstallStateSource       =  4
Const msiInstallStateDefault      =  5

' Connect to Windows Installer object
On Error Resume Next
Dim installer : Set installer = Nothing
Set installer = Wscript.CreateObject("WindowsInstaller.Installer") : CheckError

' If no argument is given, give usage.
Dim argCount:argCount = Wscript.Arguments.Count
If (argCount = 0) Then	
	Wscript.Echo "No product passed in"
	Wscript.Quit 1
End If

Dim productName:productName = Wscript.Arguments(0)
Dim directoryName:directoryName = Wscript.Arguments(1)

Dim logFile:logFile = directoryName & "\" & "product_loc.txt"
Dim objFso, objFile
Set objFso = CreateObject("Scripting.FileSystemObject")
Set objFile = objFso.CreateTextFile(logFile, True)

' If Product name supplied, need to search for product code
Dim productCode, property, value, message
If Left(productName, 1) = "{" And Right(productName, 1) = "}" Then
	If installer.ProductState(productName) <> msiInstallStateUnknown Then productCode = UCase(productName)
Else
	For Each productCode In installer.Products : CheckError
		If LCase(installer.ProductInfo(productCode, "ProductName")) = LCase(productName) Then Exit For
	Next
End If
If IsEmpty(productCode) Then objFile.WriteLine("Product is not registered: " & productName) : Wscript.Quit 2

Dim feature, features, parent, state
Set features = installer.Features(productCode)
For Each feature In features
	parent = installer.FeatureParent(productCode, feature) : CheckError
	' If the feature has parent, the way windows networker install works indicates it is
	' part of NwClient, NwSnode or NwServer. There is no value to list each of those "sub_feature"
	' for install/de-install/upgrade because we can't single out those sub_features to operate.
	' They have to go in a bunlde of NwClient, NwSnode or NwServer
	If Len(parent) = 0 Then
		state = installer.FeatureState(productCode, feature)
		Select Case(state)
			' We only care about the packages installed locally
			' set up normalize_name, platform_name field and state
			Case msiInstallStateBadConfig:    state = "Corrupt"
			Case msiInstallStateIncomplete:   state = "InProgress"
			Case msiInstallStateSourceAbsent: state = "SourceAbsent"
			Case msiInstallStateBroken:       state = "Broken"
			Case msiInstallStateAdvertised:   state = "Advertised"
			Case msiInstallStateAbsent:       state = "Uninstalled"
			Case msiInstallStateLocal:        state = "Local"
			Case msiInstallStateSource:       state = "Source"
			Case msiInstallStateDefault:      state = "Default"
			Case Else:                        state = "Unknown"
		End Select	   
		
		' If stats field indicate Uninstalled, don't report, go for next feature.
		If state <> "Uninstalled" Then 	
		If state <> "Source" Then	
		For Each property In Array("LocalPackage") : CheckError
			value = installer.ProductInfo(productCode, property) ': CheckError
			If Err <> 0 Then Err.Clear : value = Empty
			If value <> Empty Then message = value &";" 
			objFile.WriteLine(message)
		Next
		End If
		End If
	End If
Next
' clean up
objFile.Close

set objFso = nothing
set objFile = nothing
set message = nothing
set logFile = nothing
set productName = nothing

Wscripts.Quit 0



' Subroutine to check errors
Sub CheckError
	Dim message, errRec
	If Err = 0 Then Exit Sub
	message = Err.Source & " " & Hex(Err) & ": " & Err.Description
	If Not installer Is Nothing Then
		Set errRec = installer.LastErrorRecord
		If Not errRec Is Nothing Then message = message & vbNewLine & errRec.FormatText
	End If
	Wscript.Echo message
	Wscript.Quit 2
End Sub
         *                       	 .UNIXATTR                    X                                   nsr_remove_check.vbs             uasm               8      "    Ebs    Np    N                             I
avY	P,^r                           $       @                       w|bD   d                                                              !         "               "'
' Copyright (c) 2007 EMC Corporation.
'
' All rights reserved.  This is an UNPUBLISHED work, and
' comprises proprietary and confidential information of EMC.
' Unauthorized use, disclosure, and distribution are strictly
' prohibited.  Use, duplication, or disclosure of the software
' and documentation by the U.S. Government is subject to
' restrictions set forth in a license agreement between the
' Government and EMC or other written agreement specifying
' the Government's rights to use the software and any applicable
' FAR provisions, such as FAR 52.227-19.
'

' This script will be called by the kicker script before the
' INSTALL operation to massage the REMOVE switch that is 
' passed to the Windows Installer along with ADDLOCAL=ALL to 
' make sure that default features are not removed.
'
' input: <.msi path> and REMOVE=x,y,z
' output: product information.
' Usage:
' cscript //nologo <.msi> REMOVE=x,y,z

Option Explicit
On Error Resume Next

' Connect to Windows Installer object
Dim installer : Set installer = Nothing
Set installer = Wscript.CreateObject("WindowsInstaller.Installer") : CheckError

' If no argument is given, give usage.
Dim argCount:argCount = Wscript.Arguments.Count
If (argCount = 0) Then

    ' We will display usage and return error
    Wscript.Echo "Usage:" &_
    vbNewLine & " cscript //nologo nw_pre_remove_check <.msi path> REMOVE=x,y,z" &_
    vbNewLine &_
    vbNewLine & " Returns a modified REMOVE list that omits any features that " &_
    "are not allowed to be removed." &_
    vbNewLine & " Example: cscript //nologo nw_pre_remove_check c:\tmp\networker.msi REMOVE=en_Feature,NwLangPacks,NwServer" &_
    vbNewLine &_
    vbNewLine & "Copyright (C) EMC Corporation, 2007, All rights reserved."
    Wscript.Quit 1
End If

Dim directoryName
Dim currentSetupFile
Dim currentSetupDirectory
Dim msiFileName
Dim currentMsiFile
Dim defaultFeatureCnt:defaultFeatureCnt = 0
Dim dFeatureArray(50)
Dim dParentArray(50)
Dim dAttributeArray(50)
Dim dRemoveParms
Dim remove
Dim logFile
Dim objFso, objFile
Dim saveArgs

If (argCount < 3)  Then Wscript.Quit 1

Set objFso = CreateObject("Scripting.FileSystemObject")

directoryName = Trim(Wscript.Arguments(0))

' Wscript.echo "Directory Name : " & directoryName
currentSetupFile = Trim(Wscript.Arguments(1))
' Wscript.echo "Setup File : " & currentSetupFile
currentSetupDirectory = Left(currentSetupFile, inStrRev(currentSetupFile, "\"))
' Wscript.echo "Current Setup Directory : " & currentSetupDirectory

Dim Folder: Set Folder = objFso.GetFolder(currentSetupDirectory)
Dim Files: Set Files = Folder.Files
Dim File

For Each File In Files
      If instr(File, ".msi") Then
	 msiFileName = File.name
	 ' Wscript.echo "Matching file : " & File.name
      End If
Next

currentMsiFile = currentSetupDirectory&msiFileName

' Wscript.echo "Current MSI File : " & currentMsiFile

remove = Trim(Wscript.Arguments(2))
' Wscript.echo "Remove = " & remove

logFile = directoryName & "\" & "msi_switches.txt"

Set objFile = objFso.CreateTextFile(logFile, True)

' Wscript.echo directoryName
' Wscript.echo "MSI : " & currentMsiFile
' Wscript.echo "REMOVE : " & remove

Dim removeToken:removeToken="REMOVE="
Dim removeParms
Dim removeIndex:removeIndex=0
Dim parmCnt:parmCnt=0
Dim preRemove

removeParms = right(remove, len(remove) - len(removeToken))

' Wscript.echo "Remove parameters : " & removeParms

dRemoveParms = Split(removeParms, ",")

Dim i:i=0
Dim removeList:removeList="REMOVE="
Dim removeDelim:removeDelim=""
Dim isRemovable:isRemovable=0
Dim firstWritten:firstWritten=0

parmCnt = UBound(dRemoveParms)
defaultFeatureCnt = GetDefaultFeatures(currentMsiFile)

For i = 0 to parmCnt
    If firstWritten = 1 Then
        removeDelim = ","
    End If
    isRemovable = canFeatureBeRemoved(dRemoveParms(i), defaultFeatureCnt)
    if isRemovable = 1 Then
        removeList = removeList & removeDelim & dRemoveParms(i)
	firstWritten=1
    End If
Next

Dim newLine

If Len(removeList) <> Len("REMOVE=") then
   newLine = removeList & ";"
   objFile.WriteLine(newLine)
   objFile.Close
Else
   objFile.Close
   objFso.DeleteFile(logFile)
End If

Wscript.Quit 0


' ############################################################################
'
' This function creates an array of selectable feature names that are
' contained within the specified .msi file.  
'
' ############################################################################

Function GetDefaultFeatures(databasePath)

    Const msiOpenDatabaseModeReadOnly = 0
    Const msiOpenDatabaseModeTransact = 1

    ' Open the database

    Dim openMode : openMode = msiOpenDatabaseModeReadOnly
    Dim database : Set database = installer.OpenDatabase(databasePath, openMode) : CheckError

    ' Execute an SQL statement to retrieve all top-level features (no-parent) and any
    ' user-selectable sub-features.

    Dim query, view, record, rowData, columnCount, delim, column

    query = "SELECT `Feature`, `Feature_Parent`, `Attributes` FROM `Feature` WHERE `Display`<>0 AND `Attributes`<>0"
    Set view = database.OpenView(query) : CheckError
    view.Execute : CheckError

    ' Now, loop through the results of the query and build up an array that can
    ' be used by the main routine to filter out features that we care about.

    Dim x:x=0
    Dim skipRow:skipRow=0
    Dim attribute:attribute=0

    Do
        Set record = view.Fetch
        If record Is Nothing Then Exit Do
        columnCount = record.FieldCount
        rowData = Empty
        delim = "  "
	  skipRow = 0
	  
	  attribute = CInt(record.StringData(3))

   	  ' Only process this record if the second column (attribute)
	  ' does not have the msiCannotBeAbsent bit 0x10 set.

	  If ((attribute And 16) = 0) Then
		skipRow = 1
	  Else
	      x = x + 1
	      dFeatureArray(x) = record.StringData(1)
		dParentArray(x) = record.StringData(2)
		dAttributeArray(x) = record.StringData(3)
	  End If
    Loop

    ' database.close()

    GetDefaultFeatures=x

End Function


Sub CheckError
	Dim message, errRec
	If Err = 0 Then Exit Sub
	message = Err.Source & " " & Hex(Err) & ": " & Err.Description
	If Not installer Is Nothing Then
		Set errRec = installer.LastErrorRecord
		If Not errRec Is Nothing Then message = message & vbLf & errRec.FormatText
	End If
	Fail message
End Sub

Sub Fail(message)
	Wscript.Echo message
	Wscript.Quit 2
End Sub



' ############################################################################
'
' This function determines if the specified feature is a default feature
' that cannot be removed.
'
' ############################################################################

Function isFeatureDefault(featureName, featureCount)

    Dim i:i=0
    Dim defaultFeature:defaultFeature=0

    For i = 1 to featureCount

        If dFeatureArray(i) = featureName Then
 	      defaultFeature = 1
	  End If
    Next

    isFeatureDefault = defaultFeature

End Function


' ############################################################################
'
' This function retrieves the feature parent of a default feature.
'
' ############################################################################

Function getFeatureParent(featureName, featureCount)

    Dim i:i=0
    Dim featureParent

    For i = 1 to featureCount

        If dFeatureArray(i) = featureName Then
 	      featureParent = dParentArray(i)
	  End If
    Next

    getFeatureParent = featureParent

End Function



' ############################################################################
'
' This function determines if the specified feature is part of the .msi for
' the currently installed product that we are working on upgrading.
'
' ############################################################################

Function canFeatureBeRemoved(featureName, featureCount)

    Dim removable:removable=0
    Dim featureParent
    Dim x:x=0

    ' Any features that are not default can be removed.

    If isFeatureDefault(featureName, featureCount) = 0 Then
	  removable = 1
    Else
	  ' If the feature is default, then we need to determine
	  ' if the parent feature is in the remove list.

    	  featureParent = getFeatureParent(featureName, featureCount)
    	  if isEmpty(featureParent) or featureParent = "" Then
	  	removable = 0
    	  Else
	      ' Now, we need to check if the parent is in the
	      ' list of features to remove.

	      For x = 0 to parmCnt
	          If dRemoveParms(x) = featureParent Then
		        removable = canFeatureBeRemoved(featureParent, featureCount)
	          End If
            Next
	  End If
    End If

    canFeatureBeRemoved = removable

End Function
               X                                   nsr_modify_service_startup.vbs               uasm               8          N    Np    N                             G$aNO	Kgr                           $       @                       w|bD   d                                                              !                        '

' Copyright (c) 2007 EMC Corporation.

'

' All rights reserved.  This is an UNPUBLISHED work, and

' comprises proprietary and confidential information of EMC.

' Unauthorized use, disclosure, and distribution are strictly

' prohibited.  Use, duplication, or disclosure of the software

' and documentation by the U.S. Government is subject to

' restrictions set forth in a license agreement between the

' Government and EMC or other written agreement specifying

' the Government's rights to use the software and any applicable

' FAR provisions, such as FAR 52.227-19.

'



' This script is called by the install script nsr_client_install.bat

' in order to disable the NetWorker service in the installer.  This

' will prevent the service from starting immediately after being 

' installed.  Upon a successful install of ALL products, we will

' then enable and restart the service.

'

' input: <temp working directory> <.msi path> <service name> <startup type>

'



Option Explicit

On Error Resume Next



' Connect to Windows Installer object

Dim installer : Set installer = Nothing

Set installer = Wscript.CreateObject("WindowsInstaller.Installer") : CheckError



' If no argument is given, give usage.

Dim argCount:argCount = Wscript.Arguments.Count

If (argCount = 0) Then



    ' Display the usage and return an error



    Wscript.Echo "Usage:" &_

    vbNewLine & " cscript //nologo modify_service_startup_type <temp directory> <.msi path> <service name> <startup type>" &_

    vbNewLine &_

    vbNewLine & " Disables the nsrexecd service in the .msi" &_

    vbNewLine &_

    vbNewLine & "Copyright (C) EMC Corporation, 2007, All rights reserved."

    Wscript.Quit 1

End If



Dim directoryName

Dim currentSetupFile

Dim currentSetupDirectory

Dim msiFileName

Dim currentMsiFile

Dim serviceName

Dim startupValue



Dim objFso



If (argCount < 4)  Then Wscript.Quit 1



Set objFso = CreateObject("Scripting.FileSystemObject")



directoryName = Trim(Wscript.Arguments(0))



currentSetupFile = Trim(Wscript.Arguments(1))

serviceName = Trim(Wscript.Arguments(2))

startupValue = Trim(Wscript.Arguments(3))

currentSetupDirectory = Left(currentSetupFile, inStrRev(currentSetupFile, "\"))



Dim Folder: Set Folder = objFso.GetFolder(currentSetupDirectory)

Dim Files: Set Files = Folder.Files

Dim File



For Each File In Files

      If instr(File, ".msi") Then

	 msiFileName = File.name

      End If

Next



currentMsiFile = currentSetupDirectory&msiFileName



Dim success:success=0

success = ModifyServiceStartupType(currentMsiFile, serviceName, startupValue)



If success = 1 Then

   Wscript.Quit 0

End If



Wscript.Quit 1





' ############################################################################

'

' This function disables the nsrexed service in the specified .msi file.

'

' ############################################################################



Function ModifyServiceStartupType(databasePath, svcName, suValue)



    Const msiOpenDatabaseModeTransact = 1

    Const msiViewModifyUpdate = 2



    ' Open the database



    Dim openMode : openMode = msiOpenDatabaseModeTransact

    Dim database : Set database = installer.OpenDatabase(databasePath, openMode) : CheckError



    ' Execute an SQL statement to retrieve the startType column from the 

    ' ServiceInstall table.



    Dim query, db_view, record



    query = "SELECT `Name`, `StartType` FROM `ServiceInstall` WHERE `Name`='" & svcName & "'"



    Set db_view = database.OpenView(query) : CheckError

    db_view.Execute : CheckError



    ' Now, fetch the results of the query and modify the startType.



    Dim modified:modified=0



    Do

        Set record = db_view.Fetch

        If record Is Nothing Then Exit Do

	record.StringData(2) = suValue

        db_view.Modify msiViewModifyUpdate, record

	modified=1

    Loop



    database.Commit()



    database.close()



    DisableNsrexecdService=modified



End Function





Sub CheckError

	Dim message, errRec

	If Err = 0 Then Exit Sub

	message = Err.Source & " " & Hex(Err) & ": " & Err.Description

	If Not installer Is Nothing Then

		Set errRec = installer.LastErrorRecord

		If Not errRec Is Nothing Then message = message & vbLf & errRec.FormatText

	End If

	Fail message

End Sub



Sub Fail(message)

	Wscript.Echo message

	Wscript.Quit 2

End Sub





        *                       	 .UNIXATTR                     