#
# Copyright 2006 VMware, Inc.  All rights reserved.
#

use 5.006001;
use strict;
use warnings;

use XML::LibXML;
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Headers;
use HTTP::Response;
use HTTP::Cookies;
use Data::Dumper;



##################################################################################
package AboutInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['fullName', undef, undef, 1],
   ['vendor', undef, undef, 1],
   ['version', undef, undef, 1],
   ['build', undef, undef, 1],
   ['localeVersion', undef, undef, 0],
   ['localeBuild', undef, undef, 0],
   ['osType', undef, undef, 1],
   ['productLineId', undef, undef, 1],
   ['apiType', undef, undef, 1],
   ['apiVersion', undef, undef, 1],
   ['instanceUuid', undef, undef, 0],
   ['licenseProductName', undef, undef, 0],
   ['licenseProductVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('AboutInfo', 'name', 'fullName', 'vendor', 'version', 'build', 'localeVersion', 'localeBuild', 'osType', 'productLineId', 'apiType', 'apiVersion', 'instanceUuid', 'licenseProductName', 'licenseProductVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AuthorizationDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['privilege', 'ElementDescription', 1, 1],
   ['privilegeGroup', 'ElementDescription', 1, 1],
);


VIMRuntime::make_get_set('AuthorizationDescription', 'privilege', 'privilegeGroup');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Permission;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 0],
   ['principal', undef, undef, 1],
   ['group', 'boolean', undef, 1],
   ['roleId', undef, undef, 1],
   ['propagate', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('Permission', 'entity', 'principal', 'group', 'roleId', 'propagate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPermission;
our @ISA = qw(ComplexType);

our @property_list = (
   ['Permission', 'Permission', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPermission', 'Permission');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AuthorizationRole;
our @ISA = qw(DynamicData);

our @property_list = (
   ['roleId', undef, undef, 1],
   ['system', 'boolean', undef, 1],
   ['name', undef, undef, 1],
   ['info', 'Description', undef, 1],
   ['privilege', undef, 1, 0],
);


VIMRuntime::make_get_set('AuthorizationRole', 'roleId', 'system', 'name', 'info', 'privilege');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAuthorizationRole;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AuthorizationRole', 'AuthorizationRole', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAuthorizationRole', 'AuthorizationRole');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AuthorizationPrivilege;
our @ISA = qw(DynamicData);

our @property_list = (
   ['privId', undef, undef, 1],
   ['onParent', 'boolean', undef, 1],
   ['name', undef, undef, 1],
   ['privGroupName', undef, undef, 1],
);


VIMRuntime::make_get_set('AuthorizationPrivilege', 'privId', 'onParent', 'name', 'privGroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAuthorizationPrivilege;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AuthorizationPrivilege', 'AuthorizationPrivilege', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAuthorizationPrivilege', 'AuthorizationPrivilege');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PrivilegeAvailability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['privId', undef, undef, 1],
   ['isGranted', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('PrivilegeAvailability', 'privId', 'isGranted');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPrivilegeAvailability;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PrivilegeAvailability', 'PrivilegeAvailability', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPrivilegeAvailability', 'PrivilegeAvailability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EntityPrivilege;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['privAvailability', 'PrivilegeAvailability', 1, 1],
);


VIMRuntime::make_get_set('EntityPrivilege', 'entity', 'privAvailability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEntityPrivilege;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EntityPrivilege', 'EntityPrivilege', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEntityPrivilege', 'EntityPrivilege');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package BoolPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['value', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('BoolPolicy', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Capability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['provisioningSupported', 'boolean', undef, 1],
   ['multiHostSupported', 'boolean', undef, 1],
   ['userShellAccessSupported', 'boolean', undef, 1],
   ['supportedEVCMode', 'EVCMode', 1, 0],
   ['networkBackupAndRestoreSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('Capability', 'provisioningSupported', 'multiHostSupported', 'userShellAccessSupported', 'supportedEVCMode', 'networkBackupAndRestoreSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComputeResourceSummary;
our @ISA = qw(ComputeResourceSummary);

our @property_list = (
   ['currentFailoverLevel', undef, undef, 1],
   ['admissionControlInfo', 'ClusterDasAdmissionControlInfo', undef, 0],
   ['numVmotions', undef, undef, 1],
   ['targetBalance', undef, undef, 0],
   ['currentBalance', undef, undef, 0],
   ['currentEVCModeKey', undef, undef, 0],
   ['dasData', 'ClusterDasData', undef, 0],
);


VIMRuntime::make_get_set('ClusterComputeResourceSummary', 'currentFailoverLevel', 'admissionControlInfo', 'numVmotions', 'targetBalance', 'currentBalance', 'currentEVCModeKey', 'dasData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['totalCpu', undef, undef, 1],
   ['totalMemory', undef, undef, 1],
   ['numCpuCores', undef, undef, 1],
   ['numCpuThreads', undef, undef, 1],
   ['effectiveCpu', undef, undef, 1],
   ['effectiveMemory', undef, undef, 1],
   ['numHosts', undef, undef, 1],
   ['numEffectiveHosts', undef, undef, 1],
   ['overallStatus', 'ManagedEntityStatus', undef, 1],
);


VIMRuntime::make_get_set('ComputeResourceSummary', 'totalCpu', 'totalMemory', 'numCpuCores', 'numCpuThreads', 'effectiveCpu', 'effectiveMemory', 'numHosts', 'numEffectiveHosts', 'overallStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vmSwapPlacement', undef, undef, 1],
   ['spbmEnabled', 'boolean', undef, 0],
   ['defaultHardwareVersionKey', undef, undef, 0],
);


VIMRuntime::make_get_set('ComputeResourceConfigInfo', 'vmSwapPlacement', 'spbmEnabled', 'defaultHardwareVersionKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceHostSPBMLicenseInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['licenseState', 'ComputeResourceHostSPBMLicenseInfoHostSPBMLicenseState', undef, 1],
);


VIMRuntime::make_get_set('ComputeResourceHostSPBMLicenseInfo', 'host', 'licenseState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfComputeResourceHostSPBMLicenseInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ComputeResourceHostSPBMLicenseInfo', 'ComputeResourceHostSPBMLicenseInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfComputeResourceHostSPBMLicenseInfo', 'ComputeResourceHostSPBMLicenseInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vmSwapPlacement', undef, undef, 0],
   ['spbmEnabled', 'boolean', undef, 0],
   ['defaultHardwareVersionKey', undef, undef, 0],
);


VIMRuntime::make_get_set('ComputeResourceConfigSpec', 'vmSwapPlacement', 'spbmEnabled', 'defaultHardwareVersionKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldDef;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['name', undef, undef, 1],
   ['type', undef, undef, 1],
   ['managedObjectType', undef, undef, 0],
   ['fieldDefPrivileges', 'PrivilegePolicyDef', undef, 0],
   ['fieldInstancePrivileges', 'PrivilegePolicyDef', undef, 0],
);


VIMRuntime::make_get_set('CustomFieldDef', 'key', 'name', 'type', 'managedObjectType', 'fieldDefPrivileges', 'fieldInstancePrivileges');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCustomFieldDef;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CustomFieldDef', 'CustomFieldDef', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCustomFieldDef', 'CustomFieldDef');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldValue;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('CustomFieldValue', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCustomFieldValue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CustomFieldValue', 'CustomFieldValue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCustomFieldValue', 'CustomFieldValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldStringValue;
our @ISA = qw(CustomFieldValue);

our @property_list = (
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('CustomFieldStringValue', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationSpecInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['description', undef, undef, 1],
   ['type', undef, undef, 1],
   ['changeVersion', undef, undef, 0],
   ['lastUpdateTime', undef, undef, 0],
);


VIMRuntime::make_get_set('CustomizationSpecInfo', 'name', 'description', 'type', 'changeVersion', 'lastUpdateTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfCustomizationSpecInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['CustomizationSpecInfo', 'CustomizationSpecInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfCustomizationSpecInfo', 'CustomizationSpecInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationSpecItem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['info', 'CustomizationSpecInfo', undef, 1],
   ['spec', 'CustomizationSpec', undef, 1],
);


VIMRuntime::make_get_set('CustomizationSpecItem', 'info', 'spec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['defaultHardwareVersionKey', undef, undef, 0],
);


VIMRuntime::make_get_set('DatacenterConfigInfo', 'defaultHardwareVersionKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['defaultHardwareVersionKey', undef, undef, 0],
);


VIMRuntime::make_get_set('DatacenterConfigSpec', 'defaultHardwareVersionKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 0],
   ['name', undef, undef, 1],
   ['url', undef, undef, 1],
   ['capacity', undef, undef, 1],
   ['freeSpace', undef, undef, 1],
   ['uncommitted', undef, undef, 0],
   ['accessible', 'boolean', undef, 1],
   ['multipleHostAccess', 'boolean', undef, 0],
   ['type', undef, undef, 1],
   ['maintenanceMode', undef, undef, 0],
);


VIMRuntime::make_get_set('DatastoreSummary', 'datastore', 'name', 'url', 'capacity', 'freeSpace', 'uncommitted', 'accessible', 'multipleHostAccess', 'type', 'maintenanceMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['url', undef, undef, 1],
   ['freeSpace', undef, undef, 1],
   ['maxFileSize', undef, undef, 1],
   ['maxVirtualDiskCapacity', undef, undef, 0],
   ['timestamp', undef, undef, 0],
   ['containerId', undef, undef, 0],
);


VIMRuntime::make_get_set('DatastoreInfo', 'name', 'url', 'freeSpace', 'maxFileSize', 'maxVirtualDiskCapacity', 'timestamp', 'containerId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['directoryHierarchySupported', 'boolean', undef, 1],
   ['rawDiskMappingsSupported', 'boolean', undef, 1],
   ['perFileThinProvisioningSupported', 'boolean', undef, 1],
   ['storageIORMSupported', 'boolean', undef, 0],
   ['nativeSnapshotSupported', 'boolean', undef, 0],
   ['topLevelDirectoryCreateSupported', 'boolean', undef, 0],
   ['seSparseSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DatastoreCapability', 'directoryHierarchySupported', 'rawDiskMappingsSupported', 'perFileThinProvisioningSupported', 'storageIORMSupported', 'nativeSnapshotSupported', 'topLevelDirectoryCreateSupported', 'seSparseSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreHostMount;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['mountInfo', 'HostMountInfo', undef, 1],
);


VIMRuntime::make_get_set('DatastoreHostMount', 'key', 'mountInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDatastoreHostMount;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DatastoreHostMount', 'DatastoreHostMount', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDatastoreHostMount', 'DatastoreHostMount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreMountPathDatastorePair;
our @ISA = qw(DynamicData);

our @property_list = (
   ['oldMountPath', undef, undef, 1],
   ['datastore', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DatastoreMountPathDatastorePair', 'oldMountPath', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDatastoreMountPathDatastorePair;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DatastoreMountPathDatastorePair', 'DatastoreMountPathDatastorePair', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDatastoreMountPathDatastorePair', 'DatastoreMountPathDatastorePair');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Description;
our @ISA = qw(DynamicData);

our @property_list = (
   ['label', undef, undef, 1],
   ['summary', undef, undef, 1],
);


VIMRuntime::make_get_set('Description', 'label', 'summary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiagnosticManagerLogDescriptor;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['fileName', undef, undef, 1],
   ['creator', undef, undef, 1],
   ['format', undef, undef, 1],
   ['mimeType', undef, undef, 1],
   ['info', 'Description', undef, 1],
);


VIMRuntime::make_get_set('DiagnosticManagerLogDescriptor', 'key', 'fileName', 'creator', 'format', 'mimeType', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDiagnosticManagerLogDescriptor;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DiagnosticManagerLogDescriptor', 'DiagnosticManagerLogDescriptor', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDiagnosticManagerLogDescriptor', 'DiagnosticManagerLogDescriptor');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiagnosticManagerLogHeader;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lineStart', undef, undef, 1],
   ['lineEnd', undef, undef, 1],
   ['lineText', undef, 1, 0],
);


VIMRuntime::make_get_set('DiagnosticManagerLogHeader', 'lineStart', 'lineEnd', 'lineText');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiagnosticManagerBundleInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['system', 'ManagedObjectReference', undef, 0],
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('DiagnosticManagerBundleInfo', 'system', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDiagnosticManagerBundleInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DiagnosticManagerBundleInfo', 'DiagnosticManagerBundleInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDiagnosticManagerBundleInfo', 'DiagnosticManagerBundleInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSContactInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['contact', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSContactInfo', 'name', 'contact');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNetworkResourceManagementCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['networkResourceManagementSupported', 'boolean', undef, 1],
   ['networkResourcePoolHighShareValue', undef, undef, 1],
   ['qosSupported', 'boolean', undef, 1],
   ['userDefinedNetworkResourcePoolsSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('DVSNetworkResourceManagementCapability', 'networkResourceManagementSupported', 'networkResourcePoolHighShareValue', 'qosSupported', 'userDefinedNetworkResourcePoolsSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSRollbackCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['rollbackSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('DVSRollbackCapability', 'rollbackSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSBackupRestoreCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['backupRestoreSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('DVSBackupRestoreCapability', 'backupRestoreSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSFeatureCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['networkResourceManagementSupported', 'boolean', undef, 1],
   ['vmDirectPathGen2Supported', 'boolean', undef, 1],
   ['nicTeamingPolicy', undef, 1, 0],
   ['networkResourcePoolHighShareValue', undef, undef, 0],
   ['networkResourceManagementCapability', 'DVSNetworkResourceManagementCapability', undef, 0],
   ['healthCheckCapability', 'DVSHealthCheckCapability', undef, 0],
   ['rollbackCapability', 'DVSRollbackCapability', undef, 0],
   ['backupRestoreCapability', 'DVSBackupRestoreCapability', undef, 0],
   ['networkFilterSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DVSFeatureCapability', 'networkResourceManagementSupported', 'vmDirectPathGen2Supported', 'nicTeamingPolicy', 'networkResourcePoolHighShareValue', 'networkResourceManagementCapability', 'healthCheckCapability', 'rollbackCapability', 'backupRestoreCapability', 'networkFilterSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSHealthCheckCapability;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('DVSHealthCheckCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dvsOperationSupported', 'boolean', undef, 0],
   ['dvPortGroupOperationSupported', 'boolean', undef, 0],
   ['dvPortOperationSupported', 'boolean', undef, 0],
   ['compatibleHostComponentProductInfo', 'DistributedVirtualSwitchHostProductSpec', 1, 0],
   ['featuresSupported', 'DVSFeatureCapability', undef, 0],
);


VIMRuntime::make_get_set('DVSCapability', 'dvsOperationSupported', 'dvPortGroupOperationSupported', 'dvPortOperationSupported', 'compatibleHostComponentProductInfo', 'featuresSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['uuid', undef, undef, 1],
   ['numPorts', undef, undef, 1],
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['hostMember', 'ManagedObjectReference', 1, 0],
   ['vm', 'ManagedObjectReference', 1, 0],
   ['host', 'ManagedObjectReference', 1, 0],
   ['portgroupName', undef, 1, 0],
   ['description', undef, undef, 0],
   ['contact', 'DVSContactInfo', undef, 0],
   ['numHosts', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSSummary', 'name', 'uuid', 'numPorts', 'productInfo', 'hostMember', 'vm', 'host', 'portgroupName', 'description', 'contact', 'numHosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
   ['autoPreInstallAllowed', 'boolean', undef, 0],
   ['autoUpgradeAllowed', 'boolean', undef, 0],
   ['partialUpgradeAllowed', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DVSPolicy', 'autoPreInstallAllowed', 'autoUpgradeAllowed', 'partialUpgradeAllowed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSUplinkPortPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('DVSUplinkPortPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNameArrayUplinkPortPolicy;
our @ISA = qw(DVSUplinkPortPolicy);

our @property_list = (
   ['uplinkPortName', undef, 1, 1],
);


VIMRuntime::make_get_set('DVSNameArrayUplinkPortPolicy', 'uplinkPortName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['configVersion', undef, undef, 0],
   ['name', undef, undef, 0],
   ['numStandalonePorts', undef, undef, 0],
   ['maxPorts', undef, undef, 0],
   ['uplinkPortPolicy', 'DVSUplinkPortPolicy', undef, 0],
   ['uplinkPortgroup', 'ManagedObjectReference', 1, 0],
   ['defaultPortConfig', 'DVPortSetting', undef, 0],
   ['host', 'DistributedVirtualSwitchHostMemberConfigSpec', 1, 0],
   ['extensionKey', undef, undef, 0],
   ['description', undef, undef, 0],
   ['policy', 'DVSPolicy', undef, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['contact', 'DVSContactInfo', undef, 0],
   ['switchIpAddress', undef, undef, 0],
   ['defaultProxySwitchMaxNumPorts', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSConfigSpec', 'configVersion', 'name', 'numStandalonePorts', 'maxPorts', 'uplinkPortPolicy', 'uplinkPortgroup', 'defaultPortConfig', 'host', 'extensionKey', 'description', 'policy', 'vendorSpecificConfig', 'contact', 'switchIpAddress', 'defaultProxySwitchMaxNumPorts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSCreateSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['configSpec', 'DVSConfigSpec', undef, 1],
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['capability', 'DVSCapability', undef, 0],
);


VIMRuntime::make_get_set('DVSCreateSpec', 'configSpec', 'productInfo', 'capability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['uuid', undef, undef, 1],
   ['name', undef, undef, 1],
   ['numStandalonePorts', undef, undef, 1],
   ['numPorts', undef, undef, 1],
   ['maxPorts', undef, undef, 1],
   ['uplinkPortPolicy', 'DVSUplinkPortPolicy', undef, 1],
   ['uplinkPortgroup', 'ManagedObjectReference', 1, 0],
   ['defaultPortConfig', 'DVPortSetting', undef, 1],
   ['host', 'DistributedVirtualSwitchHostMember', 1, 0],
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 1],
   ['targetInfo', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['extensionKey', undef, undef, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['policy', 'DVSPolicy', undef, 0],
   ['description', undef, undef, 0],
   ['configVersion', undef, undef, 1],
   ['contact', 'DVSContactInfo', undef, 1],
   ['switchIpAddress', undef, undef, 0],
   ['createTime', undef, undef, 1],
   ['networkResourceManagementEnabled', 'boolean', undef, 0],
   ['defaultProxySwitchMaxNumPorts', undef, undef, 0],
   ['healthCheckConfig', 'DVSHealthCheckConfig', 1, 0],
);


VIMRuntime::make_get_set('DVSConfigInfo', 'uuid', 'name', 'numStandalonePorts', 'numPorts', 'maxPorts', 'uplinkPortPolicy', 'uplinkPortgroup', 'defaultPortConfig', 'host', 'productInfo', 'targetInfo', 'extensionKey', 'vendorSpecificConfig', 'policy', 'description', 'configVersion', 'contact', 'switchIpAddress', 'createTime', 'networkResourceManagementEnabled', 'defaultProxySwitchMaxNumPorts', 'healthCheckConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSHealthCheckConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enable', 'boolean', undef, 0],
   ['interval', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSHealthCheckConfig', 'enable', 'interval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVSHealthCheckConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVSHealthCheckConfig', 'DVSHealthCheckConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVSHealthCheckConfig', 'DVSHealthCheckConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostMemberRuntime', 'HostMemberRuntimeInfo', 1, 0],
);


VIMRuntime::make_get_set('DVSRuntimeInfo', 'hostMemberRuntime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCMode;
our @ISA = qw(ElementDescription);

our @property_list = (
   ['guaranteedCPUFeatures', 'HostCpuIdInfo', 1, 0],
   ['featureCapability', 'HostFeatureCapability', 1, 0],
   ['featureMask', 'HostFeatureMask', 1, 0],
   ['featureRequirement', 'VirtualMachineFeatureRequirement', 1, 0],
   ['vendor', undef, undef, 1],
   ['track', undef, 1, 0],
   ['vendorTier', undef, undef, 1],
);


VIMRuntime::make_get_set('EVCMode', 'guaranteedCPUFeatures', 'featureCapability', 'featureMask', 'featureRequirement', 'vendor', 'track', 'vendorTier');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEVCMode;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EVCMode', 'EVCMode', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEVCMode', 'EVCMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ElementDescription;
our @ISA = qw(Description);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('ElementDescription', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfElementDescription;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ElementDescription', 'ElementDescription', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfElementDescription', 'ElementDescription');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnumDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['tags', 'ElementDescription', 1, 1],
);


VIMRuntime::make_get_set('EnumDescription', 'key', 'tags');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEnumDescription;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EnumDescription', 'EnumDescription', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEnumDescription', 'EnumDescription');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtendedDescription;
our @ISA = qw(Description);

our @property_list = (
   ['messageCatalogKeyPrefix', undef, undef, 1],
   ['messageArg', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('ExtendedDescription', 'messageCatalogKeyPrefix', 'messageArg');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtendedElementDescription;
our @ISA = qw(ElementDescription);

our @property_list = (
   ['messageCatalogKeyPrefix', undef, undef, 1],
   ['messageArg', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('ExtendedElementDescription', 'messageCatalogKeyPrefix', 'messageArg');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionServerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['url', undef, undef, 1],
   ['description', 'Description', undef, 1],
   ['company', undef, undef, 1],
   ['type', undef, undef, 1],
   ['adminEmail', undef, 1, 1],
   ['serverThumbprint', undef, undef, 0],
);


VIMRuntime::make_get_set('ExtensionServerInfo', 'url', 'description', 'company', 'type', 'adminEmail', 'serverThumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionServerInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionServerInfo', 'ExtensionServerInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionServerInfo', 'ExtensionServerInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionClientInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['version', undef, undef, 1],
   ['description', 'Description', undef, 1],
   ['company', undef, undef, 1],
   ['type', undef, undef, 1],
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionClientInfo', 'version', 'description', 'company', 'type', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionClientInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionClientInfo', 'ExtensionClientInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionClientInfo', 'ExtensionClientInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionTaskTypeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['taskID', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionTaskTypeInfo', 'taskID');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionTaskTypeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionTaskTypeInfo', 'ExtensionTaskTypeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionTaskTypeInfo', 'ExtensionTaskTypeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionEventTypeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['eventID', undef, undef, 1],
   ['eventTypeSchema', undef, undef, 0],
);


VIMRuntime::make_get_set('ExtensionEventTypeInfo', 'eventID', 'eventTypeSchema');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionEventTypeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionEventTypeInfo', 'ExtensionEventTypeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionEventTypeInfo', 'ExtensionEventTypeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionFaultTypeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['faultID', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionFaultTypeInfo', 'faultID');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionFaultTypeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionFaultTypeInfo', 'ExtensionFaultTypeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionFaultTypeInfo', 'ExtensionFaultTypeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionPrivilegeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['privID', undef, undef, 1],
   ['privGroupName', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionPrivilegeInfo', 'privID', 'privGroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionPrivilegeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionPrivilegeInfo', 'ExtensionPrivilegeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionPrivilegeInfo', 'ExtensionPrivilegeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionResourceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['locale', undef, undef, 1],
   ['module', undef, undef, 1],
   ['data', 'KeyValue', 1, 1],
);


VIMRuntime::make_get_set('ExtensionResourceInfo', 'locale', 'module', 'data');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionResourceInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionResourceInfo', 'ExtensionResourceInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionResourceInfo', 'ExtensionResourceInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionHealthInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionHealthInfo', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionOvfConsumerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['callbackUrl', undef, undef, 1],
   ['sectionType', undef, 1, 1],
);


VIMRuntime::make_get_set('ExtensionOvfConsumerInfo', 'callbackUrl', 'sectionType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Extension;
our @ISA = qw(DynamicData);

our @property_list = (
   ['description', 'Description', undef, 1],
   ['key', undef, undef, 1],
   ['company', undef, undef, 0],
   ['type', undef, undef, 0],
   ['version', undef, undef, 1],
   ['subjectName', undef, undef, 0],
   ['server', 'ExtensionServerInfo', 1, 0],
   ['client', 'ExtensionClientInfo', 1, 0],
   ['taskList', 'ExtensionTaskTypeInfo', 1, 0],
   ['eventList', 'ExtensionEventTypeInfo', 1, 0],
   ['faultList', 'ExtensionFaultTypeInfo', 1, 0],
   ['privilegeList', 'ExtensionPrivilegeInfo', 1, 0],
   ['resourceList', 'ExtensionResourceInfo', 1, 0],
   ['lastHeartbeatTime', undef, undef, 1],
   ['healthInfo', 'ExtensionHealthInfo', undef, 0],
   ['ovfConsumerInfo', 'ExtensionOvfConsumerInfo', undef, 0],
   ['extendedProductInfo', 'ExtExtendedProductInfo', undef, 0],
   ['managedEntityInfo', 'ExtManagedEntityInfo', 1, 0],
   ['shownInSolutionManager', 'boolean', undef, 0],
   ['solutionManagerInfo', 'ExtSolutionManagerInfo', undef, 0],
);


VIMRuntime::make_get_set('Extension', 'description', 'key', 'company', 'type', 'version', 'subjectName', 'server', 'client', 'taskList', 'eventList', 'faultList', 'privilegeList', 'resourceList', 'lastHeartbeatTime', 'healthInfo', 'ovfConsumerInfo', 'extendedProductInfo', 'managedEntityInfo', 'shownInSolutionManager', 'solutionManagerInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtension;
our @ISA = qw(ComplexType);

our @property_list = (
   ['Extension', 'Extension', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtension', 'Extension');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtensionManagerIpAllocationUsage;
our @ISA = qw(DynamicData);

our @property_list = (
   ['extensionKey', undef, undef, 1],
   ['numAddresses', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtensionManagerIpAllocationUsage', 'extensionKey', 'numAddresses');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtensionManagerIpAllocationUsage;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtensionManagerIpAllocationUsage', 'ExtensionManagerIpAllocationUsage', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtensionManagerIpAllocationUsage', 'ExtensionManagerIpAllocationUsage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationVmProgressInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['progress', undef, undef, 1],
   ['bytesTransferred', undef, undef, 1],
   ['bytesToTransfer', undef, undef, 1],
   ['checksumTotalBytes', undef, undef, 0],
   ['checksumComparedBytes', undef, undef, 0],
);


VIMRuntime::make_get_set('ReplicationVmProgressInfo', 'progress', 'bytesTransferred', 'bytesToTransfer', 'checksumTotalBytes', 'checksumComparedBytes');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HbrManagerReplicationVmInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['state', undef, undef, 1],
   ['progressInfo', 'ReplicationVmProgressInfo', undef, 0],
   ['imageId', undef, undef, 0],
   ['lastError', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('HbrManagerReplicationVmInfo', 'state', 'progressInfo', 'imageId', 'lastError');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostServiceTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', undef, undef, 0],
   ['port', undef, undef, 0],
   ['sslThumbprint', undef, undef, 0],
   ['service', undef, undef, 1],
   ['serviceVersion', undef, undef, 1],
   ['sessionId', undef, undef, 1],
);


VIMRuntime::make_get_set('HostServiceTicket', 'host', 'port', 'sslThumbprint', 'service', 'serviceVersion', 'sessionId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSystemReconnectSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['syncState', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('HostSystemReconnectSpec', 'syncState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseDatastoreLeaseInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastoreKey', undef, undef, 1],
   ['hosts', 'HttpNfcLeaseHostInfo', 1, 1],
);


VIMRuntime::make_get_set('HttpNfcLeaseDatastoreLeaseInfo', 'datastoreKey', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseDatastoreLeaseInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseDatastoreLeaseInfo', 'HttpNfcLeaseDatastoreLeaseInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseDatastoreLeaseInfo', 'HttpNfcLeaseDatastoreLeaseInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseHostInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['url', undef, undef, 1],
   ['sslThumbprint', undef, undef, 1],
);


VIMRuntime::make_get_set('HttpNfcLeaseHostInfo', 'url', 'sslThumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseHostInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseHostInfo', 'HttpNfcLeaseHostInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseHostInfo', 'HttpNfcLeaseHostInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lease', 'ManagedObjectReference', undef, 1],
   ['entity', 'ManagedObjectReference', undef, 1],
   ['deviceUrl', 'HttpNfcLeaseDeviceUrl', 1, 0],
   ['totalDiskCapacityInKB', undef, undef, 1],
   ['leaseTimeout', undef, undef, 1],
   ['hostMap', 'HttpNfcLeaseDatastoreLeaseInfo', 1, 0],
);


VIMRuntime::make_get_set('HttpNfcLeaseInfo', 'lease', 'entity', 'deviceUrl', 'totalDiskCapacityInKB', 'leaseTimeout', 'hostMap');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseDeviceUrl;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['importKey', undef, undef, 1],
   ['url', undef, undef, 1],
   ['sslThumbprint', undef, undef, 1],
   ['disk', 'boolean', undef, 0],
   ['targetId', undef, undef, 0],
   ['datastoreKey', undef, undef, 0],
   ['fileSize', undef, undef, 0],
);


VIMRuntime::make_get_set('HttpNfcLeaseDeviceUrl', 'key', 'importKey', 'url', 'sslThumbprint', 'disk', 'targetId', 'datastoreKey', 'fileSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseDeviceUrl;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseDeviceUrl', 'HttpNfcLeaseDeviceUrl', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseDeviceUrl', 'HttpNfcLeaseDeviceUrl');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HttpNfcLeaseManifestEntry;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['sha1', undef, undef, 1],
   ['size', undef, undef, 1],
   ['disk', 'boolean', undef, 1],
   ['capacity', undef, undef, 0],
   ['populatedSize', undef, undef, 0],
);


VIMRuntime::make_get_set('HttpNfcLeaseManifestEntry', 'key', 'sha1', 'size', 'disk', 'capacity', 'populatedSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHttpNfcLeaseManifestEntry;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HttpNfcLeaseManifestEntry', 'HttpNfcLeaseManifestEntry', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHttpNfcLeaseManifestEntry', 'HttpNfcLeaseManifestEntry');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ImportSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityConfig', 'VAppEntityConfigInfo', undef, 0],
   ['instantiationOst', 'OvfConsumerOstNode', undef, 0],
);


VIMRuntime::make_get_set('ImportSpec', 'entityConfig', 'instantiationOst');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfImportSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ImportSpec', 'ImportSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfImportSpec', 'ImportSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InheritablePolicy;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inherited', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('InheritablePolicy', 'inherited');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IntExpression;
our @ISA = qw(NegatableExpression);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('IntExpression', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IntPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('IntPolicy', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IpAddress;
our @ISA = qw(NegatableExpression);

our @property_list = (
);


VIMRuntime::make_get_set('IpAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IpPoolManagerIpAllocation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ipAddress', undef, undef, 1],
   ['allocationId', undef, undef, 1],
);


VIMRuntime::make_get_set('IpPoolManagerIpAllocation', 'ipAddress', 'allocationId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfIpPoolManagerIpAllocation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['IpPoolManagerIpAllocation', 'IpPoolManagerIpAllocation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfIpPoolManagerIpAllocation', 'IpPoolManagerIpAllocation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IpRange;
our @ISA = qw(IpAddress);

our @property_list = (
   ['addressPrefix', undef, undef, 1],
   ['prefixLength', undef, undef, 0],
);


VIMRuntime::make_get_set('IpRange', 'addressPrefix', 'prefixLength');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package KeyValue;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('KeyValue', 'key', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfKeyValue;
our @ISA = qw(ComplexType);

our @property_list = (
   ['KeyValue', 'KeyValue', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfKeyValue', 'KeyValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LatencySensitivity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['level', 'LatencySensitivitySensitivityLevel', undef, 1],
   ['sensitivity', undef, undef, 0],
);


VIMRuntime::make_get_set('LatencySensitivity', 'level', 'sensitivity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseAssignmentManagerLicenseAssignment;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityId', undef, undef, 1],
   ['scope', undef, undef, 0],
   ['entityDisplayName', undef, undef, 0],
   ['assignedLicense', 'LicenseManagerLicenseInfo', undef, 1],
   ['properties', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('LicenseAssignmentManagerLicenseAssignment', 'entityId', 'scope', 'entityDisplayName', 'assignedLicense', 'properties');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseAssignmentManagerLicenseAssignment;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseAssignmentManagerLicenseAssignment', 'LicenseAssignmentManagerLicenseAssignment', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseAssignmentManagerLicenseAssignment', 'LicenseAssignmentManagerLicenseAssignment');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseSource;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('LicenseSource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseServerSource;
our @ISA = qw(LicenseSource);

our @property_list = (
   ['licenseServer', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseServerSource', 'licenseServer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LocalLicenseSource;
our @ISA = qw(LicenseSource);

our @property_list = (
   ['licenseKeys', undef, undef, 1],
);


VIMRuntime::make_get_set('LocalLicenseSource', 'licenseKeys');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EvaluationLicenseSource;
our @ISA = qw(LicenseSource);

our @property_list = (
   ['remainingHours', undef, undef, 0],
);


VIMRuntime::make_get_set('EvaluationLicenseSource', 'remainingHours');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseFeatureInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['featureName', undef, undef, 1],
   ['featureDescription', undef, undef, 0],
   ['state', 'LicenseFeatureInfoState', undef, 0],
   ['costUnit', undef, undef, 1],
   ['sourceRestriction', undef, undef, 0],
   ['dependentKey', undef, 1, 0],
   ['edition', 'boolean', undef, 0],
   ['expiresOn', undef, undef, 0],
);


VIMRuntime::make_get_set('LicenseFeatureInfo', 'key', 'featureName', 'featureDescription', 'state', 'costUnit', 'sourceRestriction', 'dependentKey', 'edition', 'expiresOn');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseFeatureInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseFeatureInfo', 'LicenseFeatureInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseFeatureInfo', 'LicenseFeatureInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseReservationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['state', 'LicenseReservationInfoState', undef, 1],
   ['required', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseReservationInfo', 'key', 'state', 'required');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseReservationInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseReservationInfo', 'LicenseReservationInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseReservationInfo', 'LicenseReservationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseAvailabilityInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['feature', 'LicenseFeatureInfo', undef, 1],
   ['total', undef, undef, 1],
   ['available', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseAvailabilityInfo', 'feature', 'total', 'available');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseAvailabilityInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseAvailabilityInfo', 'LicenseAvailabilityInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseAvailabilityInfo', 'LicenseAvailabilityInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseDiagnostics;
our @ISA = qw(DynamicData);

our @property_list = (
   ['sourceLastChanged', undef, undef, 1],
   ['sourceLost', undef, undef, 1],
   ['sourceLatency', undef, undef, 1],
   ['licenseRequests', undef, undef, 1],
   ['licenseRequestFailures', undef, undef, 1],
   ['licenseFeatureUnknowns', undef, undef, 1],
   ['opState', 'LicenseManagerState', undef, 1],
   ['lastStatusUpdate', undef, undef, 1],
   ['opFailureMessage', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseDiagnostics', 'sourceLastChanged', 'sourceLost', 'sourceLatency', 'licenseRequests', 'licenseRequestFailures', 'licenseFeatureUnknowns', 'opState', 'lastStatusUpdate', 'opFailureMessage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseUsageInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['source', 'LicenseSource', undef, 1],
   ['sourceAvailable', 'boolean', undef, 1],
   ['reservationInfo', 'LicenseReservationInfo', 1, 0],
   ['featureInfo', 'LicenseFeatureInfo', 1, 0],
);


VIMRuntime::make_get_set('LicenseUsageInfo', 'source', 'sourceAvailable', 'reservationInfo', 'featureInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseManagerEvaluationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['properties', 'KeyAnyValue', 1, 1],
);


VIMRuntime::make_get_set('LicenseManagerEvaluationInfo', 'properties');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostLicensableResourceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['resource', 'KeyAnyValue', 1, 1],
);


VIMRuntime::make_get_set('HostLicensableResourceInfo', 'resource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseManagerLicenseInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['licenseKey', undef, undef, 1],
   ['editionKey', undef, undef, 1],
   ['name', undef, undef, 1],
   ['total', undef, undef, 1],
   ['used', undef, undef, 0],
   ['costUnit', undef, undef, 1],
   ['properties', 'KeyAnyValue', 1, 0],
   ['labels', 'KeyValue', 1, 0],
);


VIMRuntime::make_get_set('LicenseManagerLicenseInfo', 'licenseKey', 'editionKey', 'name', 'total', 'used', 'costUnit', 'properties', 'labels');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLicenseManagerLicenseInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LicenseManagerLicenseInfo', 'LicenseManagerLicenseInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLicenseManagerLicenseInfo', 'LicenseManagerLicenseInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LocalizationManagerMessageCatalog;
our @ISA = qw(DynamicData);

our @property_list = (
   ['moduleName', undef, undef, 1],
   ['catalogName', undef, undef, 1],
   ['locale', undef, undef, 1],
   ['catalogUri', undef, undef, 1],
   ['lastModified', undef, undef, 0],
   ['md5sum', undef, undef, 0],
   ['version', undef, undef, 0],
);


VIMRuntime::make_get_set('LocalizationManagerMessageCatalog', 'moduleName', 'catalogName', 'locale', 'catalogUri', 'lastModified', 'md5sum', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfLocalizationManagerMessageCatalog;
our @ISA = qw(ComplexType);

our @property_list = (
   ['LocalizationManagerMessageCatalog', 'LocalizationManagerMessageCatalog', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfLocalizationManagerMessageCatalog', 'LocalizationManagerMessageCatalog');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LongPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('LongPolicy', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MacAddress;
our @ISA = qw(NegatableExpression);

our @property_list = (
);


VIMRuntime::make_get_set('MacAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MacRange;
our @ISA = qw(MacAddress);

our @property_list = (
   ['address', undef, undef, 1],
   ['mask', undef, undef, 1],
);


VIMRuntime::make_get_set('MacRange', 'address', 'mask');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MethodDescription;
our @ISA = qw(Description);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('MethodDescription', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NegatableExpression;
our @ISA = qw(DynamicData);

our @property_list = (
   ['negate', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('NegatableExpression', 'negate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NetworkSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['network', 'ManagedObjectReference', undef, 0],
   ['name', undef, undef, 1],
   ['accessible', 'boolean', undef, 1],
   ['ipPoolName', undef, undef, 0],
   ['ipPoolId', undef, undef, 0],
);


VIMRuntime::make_get_set('NetworkSummary', 'network', 'name', 'accessible', 'ipPoolName', 'ipPoolId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NumericRange;
our @ISA = qw(DynamicData);

our @property_list = (
   ['start', undef, undef, 1],
   ['end', undef, undef, 1],
);


VIMRuntime::make_get_set('NumericRange', 'start', 'end');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfNumericRange;
our @ISA = qw(ComplexType);

our @property_list = (
   ['NumericRange', 'NumericRange', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfNumericRange', 'NumericRange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OpaqueNetworkSummary;
our @ISA = qw(NetworkSummary);

our @property_list = (
   ['opaqueNetworkId', undef, undef, 1],
   ['opaqueNetworkType', undef, undef, 1],
);


VIMRuntime::make_get_set('OpaqueNetworkSummary', 'opaqueNetworkId', 'opaqueNetworkType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerOvfSection;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lineNumber', undef, undef, 1],
   ['xml', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConsumerOvfSection', 'lineNumber', 'xml');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfConsumerOvfSection;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfConsumerOvfSection', 'OvfConsumerOvfSection', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfConsumerOvfSection', 'OvfConsumerOvfSection');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerOstNode;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['type', undef, undef, 1],
   ['section', 'OvfConsumerOvfSection', 1, 0],
   ['child', 'OvfConsumerOstNode', 1, 0],
   ['entity', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('OvfConsumerOstNode', 'id', 'type', 'section', 'child', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfConsumerOstNode;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfConsumerOstNode', 'OvfConsumerOstNode', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfConsumerOstNode', 'OvfConsumerOstNode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfOptionInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['option', undef, undef, 1],
   ['description', 'LocalizableMessage', undef, 1],
);


VIMRuntime::make_get_set('OvfOptionInfo', 'option', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfOptionInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfOptionInfo', 'OvfOptionInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfOptionInfo', 'OvfOptionInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfDeploymentOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['label', undef, undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfDeploymentOption', 'key', 'label', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfDeploymentOption;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfDeploymentOption', 'OvfDeploymentOption', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfDeploymentOption', 'OvfDeploymentOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfManagerCommonParams;
our @ISA = qw(DynamicData);

our @property_list = (
   ['locale', undef, undef, 1],
   ['deploymentOption', undef, undef, 1],
   ['msgBundle', 'KeyValue', 1, 0],
   ['importOption', undef, 1, 0],
);


VIMRuntime::make_get_set('OvfManagerCommonParams', 'locale', 'deploymentOption', 'msgBundle', 'importOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfValidateHostParams;
our @ISA = qw(OvfManagerCommonParams);

our @property_list = (
);


VIMRuntime::make_get_set('OvfValidateHostParams');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfValidateHostResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['downloadSize', undef, undef, 0],
   ['flatDeploymentSize', undef, undef, 0],
   ['sparseDeploymentSize', undef, undef, 0],
   ['error', 'LocalizedMethodFault', 1, 0],
   ['warning', 'LocalizedMethodFault', 1, 0],
   ['supportedDiskProvisioning', undef, 1, 0],
);


VIMRuntime::make_get_set('OvfValidateHostResult', 'downloadSize', 'flatDeploymentSize', 'sparseDeploymentSize', 'error', 'warning', 'supportedDiskProvisioning');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfParseDescriptorParams;
our @ISA = qw(OvfManagerCommonParams);

our @property_list = (
);


VIMRuntime::make_get_set('OvfParseDescriptorParams');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfParseDescriptorResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['eula', undef, 1, 0],
   ['network', 'OvfNetworkInfo', 1, 0],
   ['ipAllocationScheme', undef, 1, 0],
   ['ipProtocols', undef, 1, 0],
   ['property', 'VAppPropertyInfo', 1, 0],
   ['productInfo', 'VAppProductInfo', undef, 0],
   ['annotation', undef, undef, 1],
   ['approximateDownloadSize', undef, undef, 0],
   ['approximateFlatDeploymentSize', undef, undef, 0],
   ['approximateSparseDeploymentSize', undef, undef, 0],
   ['defaultEntityName', undef, undef, 1],
   ['virtualApp', 'boolean', undef, 1],
   ['deploymentOption', 'OvfDeploymentOption', 1, 0],
   ['defaultDeploymentOption', undef, undef, 1],
   ['entityName', 'KeyValue', 1, 0],
   ['annotatedOst', 'OvfConsumerOstNode', undef, 0],
   ['error', 'LocalizedMethodFault', 1, 0],
   ['warning', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('OvfParseDescriptorResult', 'eula', 'network', 'ipAllocationScheme', 'ipProtocols', 'property', 'productInfo', 'annotation', 'approximateDownloadSize', 'approximateFlatDeploymentSize', 'approximateSparseDeploymentSize', 'defaultEntityName', 'virtualApp', 'deploymentOption', 'defaultDeploymentOption', 'entityName', 'annotatedOst', 'error', 'warning');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfNetworkInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfNetworkInfo', 'name', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfNetworkInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfNetworkInfo', 'OvfNetworkInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfNetworkInfo', 'OvfNetworkInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCreateImportSpecParams;
our @ISA = qw(OvfManagerCommonParams);

our @property_list = (
   ['entityName', undef, undef, 1],
   ['hostSystem', 'ManagedObjectReference', undef, 0],
   ['networkMapping', 'OvfNetworkMapping', 1, 0],
   ['ipAllocationPolicy', undef, undef, 0],
   ['ipProtocol', undef, undef, 0],
   ['propertyMapping', 'KeyValue', 1, 0],
   ['resourceMapping', 'OvfResourceMap', 1, 0],
   ['diskProvisioning', undef, undef, 0],
   ['instantiationOst', 'OvfConsumerOstNode', undef, 0],
);


VIMRuntime::make_get_set('OvfCreateImportSpecParams', 'entityName', 'hostSystem', 'networkMapping', 'ipAllocationPolicy', 'ipProtocol', 'propertyMapping', 'resourceMapping', 'diskProvisioning', 'instantiationOst');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfResourceMap;
our @ISA = qw(DynamicData);

our @property_list = (
   ['source', undef, undef, 1],
   ['parent', 'ManagedObjectReference', undef, 0],
   ['resourceSpec', 'ResourceConfigSpec', undef, 0],
   ['datastore', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('OvfResourceMap', 'source', 'parent', 'resourceSpec', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfResourceMap;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfResourceMap', 'OvfResourceMap', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfResourceMap', 'OvfResourceMap');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfNetworkMapping;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['network', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('OvfNetworkMapping', 'name', 'network');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfNetworkMapping;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfNetworkMapping', 'OvfNetworkMapping', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfNetworkMapping', 'OvfNetworkMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCreateImportSpecResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['importSpec', 'ImportSpec', undef, 0],
   ['fileItem', 'OvfFileItem', 1, 0],
   ['warning', 'LocalizedMethodFault', 1, 0],
   ['error', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('OvfCreateImportSpecResult', 'importSpec', 'fileItem', 'warning', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfFileItem;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceId', undef, undef, 1],
   ['path', undef, undef, 1],
   ['compressionMethod', undef, undef, 0],
   ['chunkSize', undef, undef, 0],
   ['size', undef, undef, 0],
   ['cimType', undef, undef, 1],
   ['create', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('OvfFileItem', 'deviceId', 'path', 'compressionMethod', 'chunkSize', 'size', 'cimType', 'create');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfFileItem;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfFileItem', 'OvfFileItem', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfFileItem', 'OvfFileItem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCreateDescriptorParams;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ovfFiles', 'OvfFile', 1, 0],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
   ['includeImageFiles', 'boolean', undef, 0],
   ['exportOption', undef, 1, 0],
   ['snapshot', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('OvfCreateDescriptorParams', 'ovfFiles', 'name', 'description', 'includeImageFiles', 'exportOption', 'snapshot');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCreateDescriptorResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ovfDescriptor', undef, undef, 1],
   ['error', 'LocalizedMethodFault', 1, 0],
   ['warning', 'LocalizedMethodFault', 1, 0],
   ['includeImageFiles', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('OvfCreateDescriptorResult', 'ovfDescriptor', 'error', 'warning', 'includeImageFiles');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfFile;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceId', undef, undef, 1],
   ['path', undef, undef, 1],
   ['compressionMethod', undef, undef, 0],
   ['chunkSize', undef, undef, 0],
   ['size', undef, undef, 1],
   ['capacity', undef, undef, 0],
   ['populatedSize', undef, undef, 0],
);


VIMRuntime::make_get_set('OvfFile', 'deviceId', 'path', 'compressionMethod', 'chunkSize', 'size', 'capacity', 'populatedSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfOvfFile;
our @ISA = qw(ComplexType);

our @property_list = (
   ['OvfFile', 'OvfFile', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfOvfFile', 'OvfFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PasswordField;
our @ISA = qw(DynamicData);

our @property_list = (
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('PasswordField', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerformanceDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['counterType', 'ElementDescription', 1, 1],
   ['statsType', 'ElementDescription', 1, 1],
);


VIMRuntime::make_get_set('PerformanceDescription', 'counterType', 'statsType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfProviderSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['currentSupported', 'boolean', undef, 1],
   ['summarySupported', 'boolean', undef, 1],
   ['refreshRate', undef, undef, 0],
);


VIMRuntime::make_get_set('PerfProviderSummary', 'entity', 'currentSupported', 'summarySupported', 'refreshRate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfCounterInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['nameInfo', 'ElementDescription', undef, 1],
   ['groupInfo', 'ElementDescription', undef, 1],
   ['unitInfo', 'ElementDescription', undef, 1],
   ['rollupType', 'PerfSummaryType', undef, 1],
   ['statsType', 'PerfStatsType', undef, 1],
   ['level', undef, undef, 0],
   ['perDeviceLevel', undef, undef, 0],
   ['associatedCounterId', undef, 1, 0],
);


VIMRuntime::make_get_set('PerfCounterInfo', 'key', 'nameInfo', 'groupInfo', 'unitInfo', 'rollupType', 'statsType', 'level', 'perDeviceLevel', 'associatedCounterId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfCounterInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfCounterInfo', 'PerfCounterInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfCounterInfo', 'PerfCounterInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfMetricId;
our @ISA = qw(DynamicData);

our @property_list = (
   ['counterId', undef, undef, 1],
   ['instance', undef, undef, 1],
);


VIMRuntime::make_get_set('PerfMetricId', 'counterId', 'instance');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfMetricId;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfMetricId', 'PerfMetricId', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfMetricId', 'PerfMetricId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfQuerySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['startTime', undef, undef, 0],
   ['endTime', undef, undef, 0],
   ['maxSample', undef, undef, 0],
   ['metricId', 'PerfMetricId', 1, 0],
   ['intervalId', undef, undef, 0],
   ['format', undef, undef, 0],
);


VIMRuntime::make_get_set('PerfQuerySpec', 'entity', 'startTime', 'endTime', 'maxSample', 'metricId', 'intervalId', 'format');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfQuerySpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfQuerySpec', 'PerfQuerySpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfQuerySpec', 'PerfQuerySpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfSampleInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['timestamp', undef, undef, 1],
   ['interval', undef, undef, 1],
);


VIMRuntime::make_get_set('PerfSampleInfo', 'timestamp', 'interval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfSampleInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfSampleInfo', 'PerfSampleInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfSampleInfo', 'PerfSampleInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfMetricSeries;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', 'PerfMetricId', undef, 1],
);


VIMRuntime::make_get_set('PerfMetricSeries', 'id');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfMetricSeries;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfMetricSeries', 'PerfMetricSeries', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfMetricSeries', 'PerfMetricSeries');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfMetricIntSeries;
our @ISA = qw(PerfMetricSeries);

our @property_list = (
   ['value', undef, 1, 0],
);


VIMRuntime::make_get_set('PerfMetricIntSeries', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfMetricSeriesCSV;
our @ISA = qw(PerfMetricSeries);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('PerfMetricSeriesCSV', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfMetricSeriesCSV;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfMetricSeriesCSV', 'PerfMetricSeriesCSV', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfMetricSeriesCSV', 'PerfMetricSeriesCSV');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfEntityMetricBase;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('PerfEntityMetricBase', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfEntityMetricBase;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfEntityMetricBase', 'PerfEntityMetricBase', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfEntityMetricBase', 'PerfEntityMetricBase');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfEntityMetric;
our @ISA = qw(PerfEntityMetricBase);

our @property_list = (
   ['sampleInfo', 'PerfSampleInfo', 1, 0],
   ['value', 'PerfMetricSeries', 1, 0],
);


VIMRuntime::make_get_set('PerfEntityMetric', 'sampleInfo', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfEntityMetricCSV;
our @ISA = qw(PerfEntityMetricBase);

our @property_list = (
   ['sampleInfoCSV', undef, undef, 1],
   ['value', 'PerfMetricSeriesCSV', 1, 0],
);


VIMRuntime::make_get_set('PerfEntityMetricCSV', 'sampleInfoCSV', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfCompositeMetric;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'PerfEntityMetricBase', undef, 0],
   ['childEntity', 'PerfEntityMetricBase', 1, 0],
);


VIMRuntime::make_get_set('PerfCompositeMetric', 'entity', 'childEntity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerformanceManagerCounterLevelMapping;
our @ISA = qw(DynamicData);

our @property_list = (
   ['counterId', undef, undef, 1],
   ['aggregateLevel', undef, undef, 0],
   ['perDeviceLevel', undef, undef, 0],
);


VIMRuntime::make_get_set('PerformanceManagerCounterLevelMapping', 'counterId', 'aggregateLevel', 'perDeviceLevel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerformanceManagerCounterLevelMapping;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerformanceManagerCounterLevelMapping', 'PerformanceManagerCounterLevelMapping', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerformanceManagerCounterLevelMapping', 'PerformanceManagerCounterLevelMapping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerfInterval;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['samplingPeriod', undef, undef, 1],
   ['name', undef, undef, 1],
   ['length', undef, undef, 1],
   ['level', undef, undef, 0],
   ['enabled', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('PerfInterval', 'key', 'samplingPeriod', 'name', 'length', 'level', 'enabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfPerfInterval;
our @ISA = qw(ComplexType);

our @property_list = (
   ['PerfInterval', 'PerfInterval', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfPerfInterval', 'PerfInterval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PosixUserSearchResult;
our @ISA = qw(UserSearchResult);

our @property_list = (
   ['id', undef, undef, 1],
   ['shellAccess', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('PosixUserSearchResult', 'id', 'shellAccess');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PrivilegePolicyDef;
our @ISA = qw(DynamicData);

our @property_list = (
   ['createPrivilege', undef, undef, 1],
   ['readPrivilege', undef, undef, 1],
   ['updatePrivilege', undef, undef, 1],
   ['deletePrivilege', undef, undef, 1],
);


VIMRuntime::make_get_set('PrivilegePolicyDef', 'createPrivilege', 'readPrivilege', 'updatePrivilege', 'deletePrivilege');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceAllocationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['reservation', undef, undef, 0],
   ['expandableReservation', 'boolean', undef, 0],
   ['limit', undef, undef, 0],
   ['shares', 'SharesInfo', undef, 0],
   ['overheadLimit', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourceAllocationInfo', 'reservation', 'expandableReservation', 'limit', 'shares', 'overheadLimit');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceAllocationOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['sharesOption', 'SharesOption', undef, 1],
);


VIMRuntime::make_get_set('ResourceAllocationOption', 'sharesOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceConfigOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cpuAllocationOption', 'ResourceAllocationOption', undef, 1],
   ['memoryAllocationOption', 'ResourceAllocationOption', undef, 1],
);


VIMRuntime::make_get_set('ResourceConfigOption', 'cpuAllocationOption', 'memoryAllocationOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 0],
   ['changeVersion', undef, undef, 0],
   ['lastModified', undef, undef, 0],
   ['cpuAllocation', 'ResourceAllocationInfo', undef, 1],
   ['memoryAllocation', 'ResourceAllocationInfo', undef, 1],
);


VIMRuntime::make_get_set('ResourceConfigSpec', 'entity', 'changeVersion', 'lastModified', 'cpuAllocation', 'memoryAllocation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfResourceConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ResourceConfigSpec', 'ResourceConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfResourceConfigSpec', 'ResourceConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatabaseSizeParam;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inventoryDesc', 'InventoryDescription', undef, 1],
   ['perfStatsDesc', 'PerformanceStatisticsDescription', undef, 0],
);


VIMRuntime::make_get_set('DatabaseSizeParam', 'inventoryDesc', 'perfStatsDesc');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InventoryDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['numHosts', undef, undef, 1],
   ['numVirtualMachines', undef, undef, 1],
   ['numResourcePools', undef, undef, 0],
   ['numClusters', undef, undef, 0],
   ['numCpuDev', undef, undef, 0],
   ['numNetDev', undef, undef, 0],
   ['numDiskDev', undef, undef, 0],
   ['numvCpuDev', undef, undef, 0],
   ['numvNetDev', undef, undef, 0],
   ['numvDiskDev', undef, undef, 0],
);


VIMRuntime::make_get_set('InventoryDescription', 'numHosts', 'numVirtualMachines', 'numResourcePools', 'numClusters', 'numCpuDev', 'numNetDev', 'numDiskDev', 'numvCpuDev', 'numvNetDev', 'numvDiskDev');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PerformanceStatisticsDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['intervals', 'PerfInterval', 1, 0],
);


VIMRuntime::make_get_set('PerformanceStatisticsDescription', 'intervals');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatabaseSizeEstimate;
our @ISA = qw(DynamicData);

our @property_list = (
   ['size', undef, undef, 1],
);


VIMRuntime::make_get_set('DatabaseSizeEstimate', 'size');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolResourceUsage;
our @ISA = qw(DynamicData);

our @property_list = (
   ['reservationUsed', undef, undef, 1],
   ['reservationUsedForVm', undef, undef, 1],
   ['unreservedForPool', undef, undef, 1],
   ['unreservedForVm', undef, undef, 1],
   ['overallUsage', undef, undef, 1],
   ['maxUsage', undef, undef, 1],
);


VIMRuntime::make_get_set('ResourcePoolResourceUsage', 'reservationUsed', 'reservationUsedForVm', 'unreservedForPool', 'unreservedForVm', 'overallUsage', 'maxUsage');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['memory', 'ResourcePoolResourceUsage', undef, 1],
   ['cpu', 'ResourcePoolResourceUsage', undef, 1],
   ['overallStatus', 'ManagedEntityStatus', undef, 1],
);


VIMRuntime::make_get_set('ResourcePoolRuntimeInfo', 'memory', 'cpu', 'overallStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolQuickStats;
our @ISA = qw(DynamicData);

our @property_list = (
   ['overallCpuUsage', undef, undef, 0],
   ['overallCpuDemand', undef, undef, 0],
   ['guestMemoryUsage', undef, undef, 0],
   ['hostMemoryUsage', undef, undef, 0],
   ['distributedCpuEntitlement', undef, undef, 0],
   ['distributedMemoryEntitlement', undef, undef, 0],
   ['staticCpuEntitlement', undef, undef, 0],
   ['staticMemoryEntitlement', undef, undef, 0],
   ['privateMemory', undef, undef, 0],
   ['sharedMemory', undef, undef, 0],
   ['swappedMemory', undef, undef, 0],
   ['balloonedMemory', undef, undef, 0],
   ['overheadMemory', undef, undef, 0],
   ['consumedOverheadMemory', undef, undef, 0],
   ['compressedMemory', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourcePoolQuickStats', 'overallCpuUsage', 'overallCpuDemand', 'guestMemoryUsage', 'hostMemoryUsage', 'distributedCpuEntitlement', 'distributedMemoryEntitlement', 'staticCpuEntitlement', 'staticMemoryEntitlement', 'privateMemory', 'sharedMemory', 'swappedMemory', 'balloonedMemory', 'overheadMemory', 'consumedOverheadMemory', 'compressedMemory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['config', 'ResourceConfigSpec', undef, 1],
   ['runtime', 'ResourcePoolRuntimeInfo', undef, 1],
   ['quickStats', 'ResourcePoolQuickStats', undef, 0],
   ['configuredMemoryMB', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourcePoolSummary', 'name', 'config', 'runtime', 'quickStats', 'configuredMemoryMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SelectionSet;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('SelectionSet');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfSelectionSet;
our @ISA = qw(ComplexType);

our @property_list = (
   ['SelectionSet', 'SelectionSet', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfSelectionSet', 'SelectionSet');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostVMotionCompatibility;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['compatibility', undef, 1, 0],
);


VIMRuntime::make_get_set('HostVMotionCompatibility', 'host', 'compatibility');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostVMotionCompatibility;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostVMotionCompatibility', 'HostVMotionCompatibility', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostVMotionCompatibility', 'HostVMotionCompatibility');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProductComponentInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['name', undef, undef, 1],
   ['version', undef, undef, 1],
   ['release', undef, undef, 1],
);


VIMRuntime::make_get_set('ProductComponentInfo', 'id', 'name', 'version', 'release');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfProductComponentInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ProductComponentInfo', 'ProductComponentInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfProductComponentInfo', 'ProductComponentInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServiceContent;
our @ISA = qw(DynamicData);

our @property_list = (
   ['rootFolder', 'ManagedObjectReference', undef, 1],
   ['propertyCollector', 'ManagedObjectReference', undef, 1],
   ['viewManager', 'ManagedObjectReference', undef, 0],
   ['about', 'AboutInfo', undef, 1],
   ['setting', 'ManagedObjectReference', undef, 0],
   ['userDirectory', 'ManagedObjectReference', undef, 0],
   ['sessionManager', 'ManagedObjectReference', undef, 0],
   ['authorizationManager', 'ManagedObjectReference', undef, 0],
   ['serviceManager', 'ManagedObjectReference', undef, 0],
   ['perfManager', 'ManagedObjectReference', undef, 0],
   ['scheduledTaskManager', 'ManagedObjectReference', undef, 0],
   ['alarmManager', 'ManagedObjectReference', undef, 0],
   ['eventManager', 'ManagedObjectReference', undef, 0],
   ['taskManager', 'ManagedObjectReference', undef, 0],
   ['extensionManager', 'ManagedObjectReference', undef, 0],
   ['customizationSpecManager', 'ManagedObjectReference', undef, 0],
   ['customFieldsManager', 'ManagedObjectReference', undef, 0],
   ['accountManager', 'ManagedObjectReference', undef, 0],
   ['diagnosticManager', 'ManagedObjectReference', undef, 0],
   ['licenseManager', 'ManagedObjectReference', undef, 0],
   ['searchIndex', 'ManagedObjectReference', undef, 0],
   ['fileManager', 'ManagedObjectReference', undef, 0],
   ['datastoreNamespaceManager', 'ManagedObjectReference', undef, 0],
   ['virtualDiskManager', 'ManagedObjectReference', undef, 0],
   ['virtualizationManager', 'ManagedObjectReference', undef, 0],
   ['snmpSystem', 'ManagedObjectReference', undef, 0],
   ['vmProvisioningChecker', 'ManagedObjectReference', undef, 0],
   ['vmCompatibilityChecker', 'ManagedObjectReference', undef, 0],
   ['ovfManager', 'ManagedObjectReference', undef, 0],
   ['ipPoolManager', 'ManagedObjectReference', undef, 0],
   ['dvSwitchManager', 'ManagedObjectReference', undef, 0],
   ['hostProfileManager', 'ManagedObjectReference', undef, 0],
   ['clusterProfileManager', 'ManagedObjectReference', undef, 0],
   ['complianceManager', 'ManagedObjectReference', undef, 0],
   ['localizationManager', 'ManagedObjectReference', undef, 0],
   ['storageResourceManager', 'ManagedObjectReference', undef, 0],
   ['guestOperationsManager', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ServiceContent', 'rootFolder', 'propertyCollector', 'viewManager', 'about', 'setting', 'userDirectory', 'sessionManager', 'authorizationManager', 'serviceManager', 'perfManager', 'scheduledTaskManager', 'alarmManager', 'eventManager', 'taskManager', 'extensionManager', 'customizationSpecManager', 'customFieldsManager', 'accountManager', 'diagnosticManager', 'licenseManager', 'searchIndex', 'fileManager', 'datastoreNamespaceManager', 'virtualDiskManager', 'virtualizationManager', 'snmpSystem', 'vmProvisioningChecker', 'vmCompatibilityChecker', 'ovfManager', 'ipPoolManager', 'dvSwitchManager', 'hostProfileManager', 'clusterProfileManager', 'complianceManager', 'localizationManager', 'storageResourceManager', 'guestOperationsManager');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServiceManagerServiceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['serviceName', undef, undef, 1],
   ['location', undef, 1, 0],
   ['service', 'ManagedObjectReference', undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('ServiceManagerServiceInfo', 'serviceName', 'location', 'service', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfServiceManagerServiceInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ServiceManagerServiceInfo', 'ServiceManagerServiceInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfServiceManagerServiceInfo', 'ServiceManagerServiceInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerLocalTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['userName', undef, undef, 1],
   ['passwordFilePath', undef, undef, 1],
);


VIMRuntime::make_get_set('SessionManagerLocalTicket', 'userName', 'passwordFilePath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerGenericServiceTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['id', undef, undef, 1],
   ['hostName', undef, undef, 0],
   ['sslThumbprint', undef, undef, 0],
);


VIMRuntime::make_get_set('SessionManagerGenericServiceTicket', 'id', 'hostName', 'sslThumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerServiceRequestSpec;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('SessionManagerServiceRequestSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerVmomiServiceRequestSpec;
our @ISA = qw(SessionManagerServiceRequestSpec);

our @property_list = (
   ['method', undef, undef, 1],
);


VIMRuntime::make_get_set('SessionManagerVmomiServiceRequestSpec', 'method');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionManagerHttpServiceRequestSpec;
our @ISA = qw(SessionManagerServiceRequestSpec);

our @property_list = (
   ['method', undef, undef, 0],
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('SessionManagerHttpServiceRequestSpec', 'method', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SharesInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['shares', undef, undef, 1],
   ['level', 'SharesLevel', undef, 1],
);


VIMRuntime::make_get_set('SharesInfo', 'shares', 'level');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SharesOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['sharesOption', 'IntOption', undef, 1],
   ['defaultLevel', 'SharesLevel', undef, 1],
);


VIMRuntime::make_get_set('SharesOption', 'sharesOption', 'defaultLevel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SingleIp;
our @ISA = qw(IpAddress);

our @property_list = (
   ['address', undef, undef, 1],
);


VIMRuntime::make_get_set('SingleIp', 'address');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SingleMac;
our @ISA = qw(MacAddress);

our @property_list = (
   ['address', undef, undef, 1],
);


VIMRuntime::make_get_set('SingleMac', 'address');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StoragePodSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['capacity', undef, undef, 1],
   ['freeSpace', undef, undef, 1],
);


VIMRuntime::make_get_set('StoragePodSummary', 'name', 'capacity', 'freeSpace');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIOAllocationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['limit', undef, undef, 0],
   ['shares', 'SharesInfo', undef, 0],
   ['reservation', undef, undef, 0],
);


VIMRuntime::make_get_set('StorageIOAllocationInfo', 'limit', 'shares', 'reservation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIOAllocationOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['limitOption', 'LongOption', undef, 1],
   ['sharesOption', 'SharesOption', undef, 1],
);


VIMRuntime::make_get_set('StorageIOAllocationOption', 'limitOption', 'sharesOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIORMInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
   ['congestionThresholdMode', undef, undef, 0],
   ['congestionThreshold', undef, undef, 1],
   ['percentOfPeakThroughput', undef, undef, 0],
   ['statsCollectionEnabled', 'boolean', undef, 0],
   ['statsAggregationDisabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('StorageIORMInfo', 'enabled', 'congestionThresholdMode', 'congestionThreshold', 'percentOfPeakThroughput', 'statsCollectionEnabled', 'statsAggregationDisabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIORMConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['congestionThresholdMode', undef, undef, 0],
   ['congestionThreshold', undef, undef, 0],
   ['percentOfPeakThroughput', undef, undef, 0],
   ['statsCollectionEnabled', 'boolean', undef, 0],
   ['statsAggregationDisabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('StorageIORMConfigSpec', 'enabled', 'congestionThresholdMode', 'congestionThreshold', 'percentOfPeakThroughput', 'statsCollectionEnabled', 'statsAggregationDisabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageIORMConfigOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabledOption', 'BoolOption', undef, 1],
   ['congestionThresholdOption', 'IntOption', undef, 1],
   ['statsCollectionEnabledOption', 'BoolOption', undef, 0],
);


VIMRuntime::make_get_set('StorageIORMConfigOption', 'enabledOption', 'congestionThresholdOption', 'statsCollectionEnabledOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StoragePerformanceSummary;
our @ISA = qw(DynamicData);

our @property_list = (
   ['interval', undef, undef, 1],
   ['percentile', undef, 1, 1],
   ['datastoreReadLatency', undef, 1, 1],
   ['datastoreWriteLatency', undef, 1, 1],
   ['datastoreVmLatency', undef, 1, 1],
   ['datastoreReadIops', undef, 1, 1],
   ['datastoreWriteIops', undef, 1, 1],
   ['siocActivityDuration', undef, undef, 1],
);


VIMRuntime::make_get_set('StoragePerformanceSummary', 'interval', 'percentile', 'datastoreReadLatency', 'datastoreWriteLatency', 'datastoreVmLatency', 'datastoreReadIops', 'datastoreWriteIops', 'siocActivityDuration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfStoragePerformanceSummary;
our @ISA = qw(ComplexType);

our @property_list = (
   ['StoragePerformanceSummary', 'StoragePerformanceSummary', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfStoragePerformanceSummary', 'StoragePerformanceSummary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PodStorageDrsEntry;
our @ISA = qw(DynamicData);

our @property_list = (
   ['storageDrsConfig', 'StorageDrsConfigInfo', undef, 1],
   ['recommendation', 'ClusterRecommendation', 1, 0],
   ['drsFault', 'ClusterDrsFaults', 1, 0],
   ['actionHistory', 'ClusterActionHistory', 1, 0],
);


VIMRuntime::make_get_set('PodStorageDrsEntry', 'storageDrsConfig', 'recommendation', 'drsFault', 'actionHistory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StringExpression;
our @ISA = qw(NegatableExpression);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('StringExpression', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StringPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['value', undef, undef, 0],
);


VIMRuntime::make_get_set('StringPolicy', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Tag;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('Tag', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfTag;
our @ISA = qw(ComplexType);

our @property_list = (
   ['Tag', 'Tag', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfTag', 'Tag');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['methodInfo', 'ElementDescription', 1, 1],
   ['state', 'ElementDescription', 1, 1],
   ['reason', 'TypeDescription', 1, 1],
);


VIMRuntime::make_get_set('TaskDescription', 'methodInfo', 'state', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskFilterSpecByEntity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['recursion', 'TaskFilterSpecRecursionOption', undef, 1],
);


VIMRuntime::make_get_set('TaskFilterSpecByEntity', 'entity', 'recursion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskFilterSpecByTime;
our @ISA = qw(DynamicData);

our @property_list = (
   ['timeType', 'TaskFilterSpecTimeOption', undef, 1],
   ['beginTime', undef, undef, 0],
   ['endTime', undef, undef, 0],
);


VIMRuntime::make_get_set('TaskFilterSpecByTime', 'timeType', 'beginTime', 'endTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskFilterSpecByUsername;
our @ISA = qw(DynamicData);

our @property_list = (
   ['systemUser', 'boolean', undef, 1],
   ['userList', undef, 1, 0],
);


VIMRuntime::make_get_set('TaskFilterSpecByUsername', 'systemUser', 'userList');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskFilterSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'TaskFilterSpecByEntity', undef, 0],
   ['time', 'TaskFilterSpecByTime', undef, 0],
   ['userName', 'TaskFilterSpecByUsername', undef, 0],
   ['state', 'TaskInfoState', 1, 0],
   ['alarm', 'ManagedObjectReference', undef, 0],
   ['scheduledTask', 'ManagedObjectReference', undef, 0],
   ['eventChainId', undef, 1, 0],
   ['tag', undef, 1, 0],
   ['parentTaskKey', undef, 1, 0],
   ['rootTaskKey', undef, 1, 0],
);


VIMRuntime::make_get_set('TaskFilterSpec', 'entity', 'time', 'userName', 'state', 'alarm', 'scheduledTask', 'eventChainId', 'tag', 'parentTaskKey', 'rootTaskKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfTaskInfoState;
our @ISA = qw(ComplexType);

our @property_list = (
   ['TaskInfoState', 'TaskInfoState', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfTaskInfoState', 'TaskInfoState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['task', 'ManagedObjectReference', undef, 1],
   ['description', 'LocalizableMessage', undef, 0],
   ['name', undef, undef, 0],
   ['descriptionId', undef, undef, 1],
   ['entity', 'ManagedObjectReference', undef, 0],
   ['entityName', undef, undef, 0],
   ['locked', 'ManagedObjectReference', 1, 0],
   ['state', 'TaskInfoState', undef, 1],
   ['cancelled', 'boolean', undef, 1],
   ['cancelable', 'boolean', undef, 1],
   ['error', 'LocalizedMethodFault', undef, 0],
   ['result', 'anyType', undef, 0],
   ['progress', undef, undef, 0],
   ['reason', 'TaskReason', undef, 1],
   ['queueTime', undef, undef, 1],
   ['startTime', undef, undef, 0],
   ['completeTime', undef, undef, 0],
   ['eventChainId', undef, undef, 1],
   ['changeTag', undef, undef, 0],
   ['parentTaskKey', undef, undef, 0],
   ['rootTaskKey', undef, undef, 0],
);


VIMRuntime::make_get_set('TaskInfo', 'key', 'task', 'description', 'name', 'descriptionId', 'entity', 'entityName', 'locked', 'state', 'cancelled', 'cancelable', 'error', 'result', 'progress', 'reason', 'queueTime', 'startTime', 'completeTime', 'eventChainId', 'changeTag', 'parentTaskKey', 'rootTaskKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfTaskInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['TaskInfo', 'TaskInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfTaskInfo', 'TaskInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReason;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('TaskReason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReasonSystem;
our @ISA = qw(TaskReason);

our @property_list = (
);


VIMRuntime::make_get_set('TaskReasonSystem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReasonUser;
our @ISA = qw(TaskReason);

our @property_list = (
   ['userName', undef, undef, 1],
);


VIMRuntime::make_get_set('TaskReasonUser', 'userName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReasonAlarm;
our @ISA = qw(TaskReason);

our @property_list = (
   ['alarmName', undef, undef, 1],
   ['alarm', 'ManagedObjectReference', undef, 1],
   ['entityName', undef, undef, 1],
   ['entity', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('TaskReasonAlarm', 'alarmName', 'alarm', 'entityName', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskReasonSchedule;
our @ISA = qw(TaskReason);

our @property_list = (
   ['name', undef, undef, 1],
   ['scheduledTask', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('TaskReasonSchedule', 'name', 'scheduledTask');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TypeDescription;
our @ISA = qw(Description);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('TypeDescription', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfTypeDescription;
our @ISA = qw(ComplexType);

our @property_list = (
   ['TypeDescription', 'TypeDescription', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfTypeDescription', 'TypeDescription');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UpdateVirtualMachineFilesResultFailedVmFileInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vmFile', undef, undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('UpdateVirtualMachineFilesResultFailedVmFileInfo', 'vmFile', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['UpdateVirtualMachineFilesResultFailedVmFileInfo', 'UpdateVirtualMachineFilesResultFailedVmFileInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo', 'UpdateVirtualMachineFilesResultFailedVmFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UpdateVirtualMachineFilesResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['failedVmFile', 'UpdateVirtualMachineFilesResultFailedVmFileInfo', 1, 0],
);


VIMRuntime::make_get_set('UpdateVirtualMachineFilesResult', 'failedVmFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserSearchResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['principal', undef, undef, 1],
   ['fullName', undef, undef, 0],
   ['group', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('UserSearchResult', 'principal', 'fullName', 'group');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfUserSearchResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['UserSearchResult', 'UserSearchResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfUserSearchResult', 'UserSearchResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserSession;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['userName', undef, undef, 1],
   ['fullName', undef, undef, 1],
   ['loginTime', undef, undef, 1],
   ['lastActiveTime', undef, undef, 1],
   ['locale', undef, undef, 1],
   ['messageLocale', undef, undef, 1],
   ['extensionSession', 'boolean', undef, 0],
   ['ipAddress', undef, undef, 0],
   ['userAgent', undef, undef, 0],
   ['callCount', undef, undef, 0],
);


VIMRuntime::make_get_set('UserSession', 'key', 'userName', 'fullName', 'loginTime', 'lastActiveTime', 'locale', 'messageLocale', 'extensionSession', 'ipAddress', 'userAgent', 'callCount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfUserSession;
our @ISA = qw(ComplexType);

our @property_list = (
   ['UserSession', 'UserSession', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfUserSession', 'UserSession');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualAppSummary;
our @ISA = qw(ResourcePoolSummary);

our @property_list = (
   ['product', 'VAppProductInfo', undef, 0],
   ['vAppState', 'VirtualAppVAppState', undef, 0],
   ['suspended', 'boolean', undef, 0],
   ['installBootRequired', 'boolean', undef, 0],
   ['instanceUuid', undef, undef, 0],
);


VIMRuntime::make_get_set('VirtualAppSummary', 'product', 'vAppState', 'suspended', 'installBootRequired', 'instanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualAppLinkInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['destroyWithParent', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VirtualAppLinkInfo', 'key', 'destroyWithParent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVirtualAppLinkInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VirtualAppLinkInfo', 'VirtualAppLinkInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVirtualAppLinkInfo', 'VirtualAppLinkInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualDiskSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskType', undef, undef, 1],
   ['adapterType', undef, undef, 1],
);


VIMRuntime::make_get_set('VirtualDiskSpec', 'diskType', 'adapterType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileBackedVirtualDiskSpec;
our @ISA = qw(VirtualDiskSpec);

our @property_list = (
   ['capacityKb', undef, undef, 1],
   ['profile', 'VirtualMachineProfileSpec', 1, 0],
);


VIMRuntime::make_get_set('FileBackedVirtualDiskSpec', 'capacityKb', 'profile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SeSparseVirtualDiskSpec;
our @ISA = qw(FileBackedVirtualDiskSpec);

our @property_list = (
   ['grainSizeKb', undef, undef, 0],
);


VIMRuntime::make_get_set('SeSparseVirtualDiskSpec', 'grainSizeKb');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeviceBackedVirtualDiskSpec;
our @ISA = qw(VirtualDiskSpec);

our @property_list = (
   ['device', undef, undef, 1],
);


VIMRuntime::make_get_set('DeviceBackedVirtualDiskSpec', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageRequirement;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['freeSpaceRequiredInKb', undef, undef, 1],
);


VIMRuntime::make_get_set('StorageRequirement', 'datastore', 'freeSpaceRequiredInKb');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfStorageRequirement;
our @ISA = qw(ComplexType);

our @property_list = (
   ['StorageRequirement', 'StorageRequirement', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfStorageRequirement', 'StorageRequirement');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ticket', undef, undef, 1],
   ['cfgFile', undef, undef, 1],
   ['host', undef, undef, 0],
   ['port', undef, undef, 0],
   ['sslThumbprint', undef, undef, 0],
);


VIMRuntime::make_get_set('VirtualMachineTicket', 'ticket', 'cfgFile', 'host', 'port', 'sslThumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineMksTicket;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ticket', undef, undef, 1],
   ['cfgFile', undef, undef, 1],
   ['host', undef, undef, 0],
   ['port', undef, undef, 0],
   ['sslThumbprint', undef, undef, 0],
);


VIMRuntime::make_get_set('VirtualMachineMksTicket', 'ticket', 'cfgFile', 'host', 'port', 'sslThumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineDisplayTopology;
our @ISA = qw(DynamicData);

our @property_list = (
   ['x', undef, undef, 1],
   ['y', undef, undef, 1],
   ['width', undef, undef, 1],
   ['height', undef, undef, 1],
);


VIMRuntime::make_get_set('VirtualMachineDisplayTopology', 'x', 'y', 'width', 'height');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVirtualMachineDisplayTopology;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VirtualMachineDisplayTopology', 'VirtualMachineDisplayTopology', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVirtualMachineDisplayTopology', 'VirtualMachineDisplayTopology');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskChangeExtent;
our @ISA = qw(DynamicData);

our @property_list = (
   ['start', undef, undef, 1],
   ['length', undef, undef, 1],
);


VIMRuntime::make_get_set('DiskChangeExtent', 'start', 'length');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDiskChangeExtent;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DiskChangeExtent', 'DiskChangeExtent', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDiskChangeExtent', 'DiskChangeExtent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskChangeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['startOffset', undef, undef, 1],
   ['length', undef, undef, 1],
   ['changedArea', 'DiskChangeExtent', 1, 0],
);


VIMRuntime::make_get_set('DiskChangeInfo', 'startOffset', 'length', 'changedArea');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualMachineWipeResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskId', undef, undef, 1],
   ['shrinkableDiskSpace', undef, undef, 1],
);


VIMRuntime::make_get_set('VirtualMachineWipeResult', 'diskId', 'shrinkableDiskSpace');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Action;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('Action');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MethodActionArgument;
our @ISA = qw(DynamicData);

our @property_list = (
   ['value', 'anyType', undef, 0],
);


VIMRuntime::make_get_set('MethodActionArgument', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfMethodActionArgument;
our @ISA = qw(ComplexType);

our @property_list = (
   ['MethodActionArgument', 'MethodActionArgument', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfMethodActionArgument', 'MethodActionArgument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MethodAction;
our @ISA = qw(Action);

our @property_list = (
   ['name', undef, undef, 1],
   ['argument', 'MethodActionArgument', 1, 0],
);


VIMRuntime::make_get_set('MethodAction', 'name', 'argument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SendEmailAction;
our @ISA = qw(Action);

our @property_list = (
   ['toList', undef, undef, 1],
   ['ccList', undef, undef, 1],
   ['subject', undef, undef, 1],
   ['body', undef, undef, 1],
);


VIMRuntime::make_get_set('SendEmailAction', 'toList', 'ccList', 'subject', 'body');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SendSNMPAction;
our @ISA = qw(Action);

our @property_list = (
);


VIMRuntime::make_get_set('SendSNMPAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RunScriptAction;
our @ISA = qw(Action);

our @property_list = (
   ['script', undef, undef, 1],
);


VIMRuntime::make_get_set('RunScriptAction', 'script');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CreateTaskAction;
our @ISA = qw(Action);

our @property_list = (
   ['taskTypeId', undef, undef, 1],
   ['cancelable', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('CreateTaskAction', 'taskTypeId', 'cancelable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmAction;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('AlarmAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAlarmAction;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AlarmAction', 'AlarmAction', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAlarmAction', 'AlarmAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmTriggeringActionTransitionSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['startState', 'ManagedEntityStatus', undef, 1],
   ['finalState', 'ManagedEntityStatus', undef, 1],
   ['repeats', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('AlarmTriggeringActionTransitionSpec', 'startState', 'finalState', 'repeats');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAlarmTriggeringActionTransitionSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AlarmTriggeringActionTransitionSpec', 'AlarmTriggeringActionTransitionSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAlarmTriggeringActionTransitionSpec', 'AlarmTriggeringActionTransitionSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmTriggeringAction;
our @ISA = qw(AlarmAction);

our @property_list = (
   ['action', 'Action', undef, 1],
   ['transitionSpecs', 'AlarmTriggeringActionTransitionSpec', 1, 0],
   ['green2yellow', 'boolean', undef, 1],
   ['yellow2red', 'boolean', undef, 1],
   ['red2yellow', 'boolean', undef, 1],
   ['yellow2green', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('AlarmTriggeringAction', 'action', 'transitionSpecs', 'green2yellow', 'yellow2red', 'red2yellow', 'yellow2green');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GroupAlarmAction;
our @ISA = qw(AlarmAction);

our @property_list = (
   ['action', 'AlarmAction', 1, 1],
);


VIMRuntime::make_get_set('GroupAlarmAction', 'action');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['expr', 'TypeDescription', 1, 1],
   ['stateOperator', 'ElementDescription', 1, 1],
   ['metricOperator', 'ElementDescription', 1, 1],
   ['hostSystemConnectionState', 'ElementDescription', 1, 1],
   ['virtualMachinePowerState', 'ElementDescription', 1, 1],
   ['datastoreConnectionState', 'ElementDescription', 1, 0],
   ['hostSystemPowerState', 'ElementDescription', 1, 0],
   ['virtualMachineGuestHeartbeatStatus', 'ElementDescription', 1, 0],
   ['entityStatus', 'ElementDescription', 1, 1],
   ['action', 'TypeDescription', 1, 1],
);


VIMRuntime::make_get_set('AlarmDescription', 'expr', 'stateOperator', 'metricOperator', 'hostSystemConnectionState', 'virtualMachinePowerState', 'datastoreConnectionState', 'hostSystemPowerState', 'virtualMachineGuestHeartbeatStatus', 'entityStatus', 'action');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmExpression;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('AlarmExpression');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAlarmExpression;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AlarmExpression', 'AlarmExpression', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAlarmExpression', 'AlarmExpression');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AndAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['expression', 'AlarmExpression', 1, 1],
);


VIMRuntime::make_get_set('AndAlarmExpression', 'expression');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OrAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['expression', 'AlarmExpression', 1, 1],
);


VIMRuntime::make_get_set('OrAlarmExpression', 'expression');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StateAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['operator', 'StateAlarmOperator', undef, 1],
   ['type', undef, undef, 1],
   ['statePath', undef, undef, 1],
   ['yellow', undef, undef, 0],
   ['red', undef, undef, 0],
);


VIMRuntime::make_get_set('StateAlarmExpression', 'operator', 'type', 'statePath', 'yellow', 'red');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventAlarmExpressionComparison;
our @ISA = qw(DynamicData);

our @property_list = (
   ['attributeName', undef, undef, 1],
   ['operator', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('EventAlarmExpressionComparison', 'attributeName', 'operator', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEventAlarmExpressionComparison;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EventAlarmExpressionComparison', 'EventAlarmExpressionComparison', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEventAlarmExpressionComparison', 'EventAlarmExpressionComparison');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['comparisons', 'EventAlarmExpressionComparison', 1, 0],
   ['eventType', undef, undef, 1],
   ['eventTypeId', undef, undef, 0],
   ['objectType', undef, undef, 0],
   ['status', 'ManagedEntityStatus', undef, 0],
);


VIMRuntime::make_get_set('EventAlarmExpression', 'comparisons', 'eventType', 'eventTypeId', 'objectType', 'status');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MetricAlarmExpression;
our @ISA = qw(AlarmExpression);

our @property_list = (
   ['operator', 'MetricAlarmOperator', undef, 1],
   ['type', undef, undef, 1],
   ['metric', 'PerfMetricId', undef, 1],
   ['yellow', undef, undef, 0],
   ['yellowInterval', undef, undef, 0],
   ['red', undef, undef, 0],
   ['redInterval', undef, undef, 0],
);


VIMRuntime::make_get_set('MetricAlarmExpression', 'operator', 'type', 'metric', 'yellow', 'yellowInterval', 'red', 'redInterval');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmInfo;
our @ISA = qw(AlarmSpec);

our @property_list = (
   ['key', undef, undef, 1],
   ['alarm', 'ManagedObjectReference', undef, 1],
   ['entity', 'ManagedObjectReference', undef, 1],
   ['lastModifiedTime', undef, undef, 1],
   ['lastModifiedUser', undef, undef, 1],
   ['creationEventId', undef, undef, 1],
);


VIMRuntime::make_get_set('AlarmInfo', 'key', 'alarm', 'entity', 'lastModifiedTime', 'lastModifiedUser', 'creationEventId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmSetting;
our @ISA = qw(DynamicData);

our @property_list = (
   ['toleranceRange', undef, undef, 1],
   ['reportingFrequency', undef, undef, 1],
);


VIMRuntime::make_get_set('AlarmSetting', 'toleranceRange', 'reportingFrequency');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['systemName', undef, undef, 0],
   ['description', undef, undef, 1],
   ['enabled', 'boolean', undef, 1],
   ['expression', 'AlarmExpression', undef, 1],
   ['action', 'AlarmAction', undef, 0],
   ['actionFrequency', undef, undef, 0],
   ['setting', 'AlarmSetting', undef, 0],
);


VIMRuntime::make_get_set('AlarmSpec', 'name', 'systemName', 'description', 'enabled', 'expression', 'action', 'actionFrequency', 'setting');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['entity', 'ManagedObjectReference', undef, 1],
   ['alarm', 'ManagedObjectReference', undef, 1],
   ['overallStatus', 'ManagedEntityStatus', undef, 1],
   ['time', undef, undef, 1],
   ['acknowledged', 'boolean', undef, 0],
   ['acknowledgedByUser', undef, undef, 0],
   ['acknowledgedTime', undef, undef, 0],
);


VIMRuntime::make_get_set('AlarmState', 'key', 'entity', 'alarm', 'overallStatus', 'time', 'acknowledged', 'acknowledgedByUser', 'acknowledgedTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAlarmState;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AlarmState', 'AlarmState', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAlarmState', 'AlarmState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterAction;
our @ISA = qw(DynamicData);

our @property_list = (
   ['type', undef, undef, 1],
   ['target', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterAction', 'type', 'target');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterAction;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterAction', 'ClusterAction', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterAction', 'ClusterAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterActionHistory;
our @ISA = qw(DynamicData);

our @property_list = (
   ['action', 'ClusterAction', undef, 1],
   ['time', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterActionHistory', 'action', 'time');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterActionHistory;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterActionHistory', 'ClusterActionHistory', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterActionHistory', 'ClusterActionHistory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterAffinityRuleSpec;
our @ISA = qw(ClusterRuleInfo);

our @property_list = (
   ['vm', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('ClusterAffinityRuleSpec', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterAntiAffinityRuleSpec;
our @ISA = qw(ClusterRuleInfo);

our @property_list = (
   ['vm', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('ClusterAntiAffinityRuleSpec', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterAttemptedVmInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['task', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterAttemptedVmInfo', 'vm', 'task');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterAttemptedVmInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterAttemptedVmInfo', 'ClusterAttemptedVmInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterAttemptedVmInfo', 'ClusterAttemptedVmInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dasConfig', 'ClusterDasConfigInfo', undef, 1],
   ['dasVmConfig', 'ClusterDasVmConfigInfo', 1, 0],
   ['drsConfig', 'ClusterDrsConfigInfo', undef, 1],
   ['drsVmConfig', 'ClusterDrsVmConfigInfo', 1, 0],
   ['rule', 'ClusterRuleInfo', 1, 0],
);


VIMRuntime::make_get_set('ClusterConfigInfo', 'dasConfig', 'dasVmConfig', 'drsConfig', 'drsVmConfig', 'rule');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['enableVmBehaviorOverrides', 'boolean', undef, 0],
   ['defaultVmBehavior', 'DrsBehavior', undef, 0],
   ['vmotionRate', undef, undef, 0],
   ['option', 'OptionValue', 1, 0],
);


VIMRuntime::make_get_set('ClusterDrsConfigInfo', 'enabled', 'enableVmBehaviorOverrides', 'defaultVmBehavior', 'vmotionRate', 'option');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsVmConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['enabled', 'boolean', undef, 0],
   ['behavior', 'DrsBehavior', undef, 0],
);


VIMRuntime::make_get_set('ClusterDrsVmConfigInfo', 'key', 'enabled', 'behavior');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsVmConfigInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsVmConfigInfo', 'ClusterDrsVmConfigInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsVmConfigInfo', 'ClusterDrsVmConfigInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterConfigInfoEx;
our @ISA = qw(ComputeResourceConfigInfo);

our @property_list = (
   ['dasConfig', 'ClusterDasConfigInfo', undef, 1],
   ['dasVmConfig', 'ClusterDasVmConfigInfo', 1, 0],
   ['drsConfig', 'ClusterDrsConfigInfo', undef, 1],
   ['drsVmConfig', 'ClusterDrsVmConfigInfo', 1, 0],
   ['rule', 'ClusterRuleInfo', 1, 0],
   ['dpmConfigInfo', 'ClusterDpmConfigInfo', undef, 0],
   ['dpmHostConfig', 'ClusterDpmHostConfigInfo', 1, 0],
   ['vsanConfigInfo', 'VsanClusterConfigInfo', undef, 0],
   ['vsanHostConfig', 'VsanHostConfigInfo', 1, 0],
   ['group', 'ClusterGroupInfo', 1, 0],
);


VIMRuntime::make_get_set('ClusterConfigInfoEx', 'dasConfig', 'dasVmConfig', 'drsConfig', 'drsVmConfig', 'rule', 'dpmConfigInfo', 'dpmHostConfig', 'vsanConfigInfo', 'vsanHostConfig', 'group');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDpmConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['defaultDpmBehavior', 'DpmBehavior', undef, 0],
   ['hostPowerActionRate', undef, undef, 0],
   ['option', 'OptionValue', 1, 0],
);


VIMRuntime::make_get_set('ClusterDpmConfigInfo', 'enabled', 'defaultDpmBehavior', 'hostPowerActionRate', 'option');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDpmHostConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['enabled', 'boolean', undef, 0],
   ['behavior', 'DpmBehavior', undef, 0],
);


VIMRuntime::make_get_set('ClusterDpmHostConfigInfo', 'key', 'enabled', 'behavior');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDpmHostConfigInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDpmHostConfigInfo', 'ClusterDpmHostConfigInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDpmHostConfigInfo', 'ClusterDpmHostConfigInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dasConfig', 'ClusterDasConfigInfo', undef, 0],
   ['dasVmConfigSpec', 'ClusterDasVmConfigSpec', 1, 0],
   ['drsConfig', 'ClusterDrsConfigInfo', undef, 0],
   ['drsVmConfigSpec', 'ClusterDrsVmConfigSpec', 1, 0],
   ['rulesSpec', 'ClusterRuleSpec', 1, 0],
);


VIMRuntime::make_get_set('ClusterConfigSpec', 'dasConfig', 'dasVmConfigSpec', 'drsConfig', 'drsVmConfigSpec', 'rulesSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasVmConfigSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterDasVmConfigInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterDasVmConfigSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasVmConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasVmConfigSpec', 'ClusterDasVmConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasVmConfigSpec', 'ClusterDasVmConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsVmConfigSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterDrsVmConfigInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterDrsVmConfigSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsVmConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsVmConfigSpec', 'ClusterDrsVmConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsVmConfigSpec', 'ClusterDrsVmConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterConfigSpecEx;
our @ISA = qw(ComputeResourceConfigSpec);

our @property_list = (
   ['dasConfig', 'ClusterDasConfigInfo', undef, 0],
   ['dasVmConfigSpec', 'ClusterDasVmConfigSpec', 1, 0],
   ['drsConfig', 'ClusterDrsConfigInfo', undef, 0],
   ['drsVmConfigSpec', 'ClusterDrsVmConfigSpec', 1, 0],
   ['rulesSpec', 'ClusterRuleSpec', 1, 0],
   ['dpmConfig', 'ClusterDpmConfigInfo', undef, 0],
   ['dpmHostConfigSpec', 'ClusterDpmHostConfigSpec', 1, 0],
   ['vsanConfig', 'VsanClusterConfigInfo', undef, 0],
   ['vsanHostConfigSpec', 'VsanHostConfigInfo', 1, 0],
   ['groupSpec', 'ClusterGroupSpec', 1, 0],
);


VIMRuntime::make_get_set('ClusterConfigSpecEx', 'dasConfig', 'dasVmConfigSpec', 'drsConfig', 'drsVmConfigSpec', 'rulesSpec', 'dpmConfig', 'dpmHostConfigSpec', 'vsanConfig', 'vsanHostConfigSpec', 'groupSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDpmHostConfigSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterDpmHostConfigInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterDpmHostConfigSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDpmHostConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDpmHostConfigSpec', 'ClusterDpmHostConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDpmHostConfigSpec', 'ClusterDpmHostConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterGroupSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterGroupInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterGroupSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterGroupSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterGroupSpec', 'ClusterGroupSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterGroupSpec', 'ClusterGroupSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAamHostInfo;
our @ISA = qw(ClusterDasHostInfo);

our @property_list = (
   ['hostDasState', 'ClusterDasAamNodeState', 1, 0],
   ['primaryHosts', undef, 1, 0],
);


VIMRuntime::make_get_set('ClusterDasAamHostInfo', 'hostDasState', 'primaryHosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAamNodeState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['name', undef, undef, 1],
   ['configState', undef, undef, 1],
   ['runtimeState', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasAamNodeState', 'host', 'name', 'configState', 'runtimeState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasAamNodeState;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasAamNodeState', 'ClusterDasAamNodeState', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasAamNodeState', 'ClusterDasAamNodeState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAdmissionControlInfo;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterDasAdmissionControlInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAdmissionControlPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterDasAdmissionControlPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasHeartbeatDatastoreInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['hosts', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('DasHeartbeatDatastoreInfo', 'datastore', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDasHeartbeatDatastoreInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DasHeartbeatDatastoreInfo', 'DasHeartbeatDatastoreInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDasHeartbeatDatastoreInfo', 'DasHeartbeatDatastoreInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasAdvancedRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dasHostInfo', 'ClusterDasHostInfo', undef, 0],
   ['heartbeatDatastoreInfo', 'DasHeartbeatDatastoreInfo', 1, 0],
);


VIMRuntime::make_get_set('ClusterDasAdvancedRuntimeInfo', 'dasHostInfo', 'heartbeatDatastoreInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['vmMonitoring', undef, undef, 0],
   ['hostMonitoring', undef, undef, 0],
   ['failoverLevel', undef, undef, 0],
   ['admissionControlPolicy', 'ClusterDasAdmissionControlPolicy', undef, 0],
   ['admissionControlEnabled', 'boolean', undef, 0],
   ['defaultVmSettings', 'ClusterDasVmSettings', undef, 0],
   ['option', 'OptionValue', 1, 0],
   ['heartbeatDatastore', 'ManagedObjectReference', 1, 0],
   ['hBDatastoreCandidatePolicy', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterDasConfigInfo', 'enabled', 'vmMonitoring', 'hostMonitoring', 'failoverLevel', 'admissionControlPolicy', 'admissionControlEnabled', 'defaultVmSettings', 'option', 'heartbeatDatastore', 'hBDatastoreCandidatePolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasData;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterDasData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasDataSummary;
our @ISA = qw(ClusterDasData);

our @property_list = (
   ['hostListVersion', undef, undef, 1],
   ['clusterConfigVersion', undef, undef, 1],
   ['compatListVersion', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasDataSummary', 'hostListVersion', 'clusterConfigVersion', 'compatListVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['numVcpus', undef, undef, 1],
   ['cpuMHz', undef, undef, 1],
   ['memoryMB', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo', 'numVcpus', 'cpuMHz', 'memoryMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['slots', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 'host', 'slots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['slots', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 'vm', 'slots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFailoverLevelAdvancedRuntimeInfo;
our @ISA = qw(ClusterDasAdvancedRuntimeInfo);

our @property_list = (
   ['slotInfo', 'ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo', undef, 1],
   ['totalSlots', undef, undef, 1],
   ['usedSlots', undef, undef, 1],
   ['unreservedSlots', undef, undef, 1],
   ['totalVms', undef, undef, 1],
   ['totalHosts', undef, undef, 1],
   ['totalGoodHosts', undef, undef, 1],
   ['hostSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots', 1, 0],
   ['vmsRequiringMultipleSlots', 'ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots', 1, 0],
);


VIMRuntime::make_get_set('ClusterDasFailoverLevelAdvancedRuntimeInfo', 'slotInfo', 'totalSlots', 'usedSlots', 'unreservedSlots', 'totalVms', 'totalHosts', 'totalGoodHosts', 'hostSlots', 'vmsRequiringMultipleSlots');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasFdmHostState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['state', undef, undef, 1],
   ['stateReporter', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterDasFdmHostState', 'state', 'stateReporter');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasHostInfo;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterDasHostInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasHostRecommendation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['drsRating', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterDasHostRecommendation', 'host', 'drsRating');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasVmConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['restartPriority', 'DasVmPriority', undef, 0],
   ['powerOffOnIsolation', 'boolean', undef, 0],
   ['dasSettings', 'ClusterDasVmSettings', undef, 0],
);


VIMRuntime::make_get_set('ClusterDasVmConfigInfo', 'key', 'restartPriority', 'powerOffOnIsolation', 'dasSettings');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDasVmConfigInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDasVmConfigInfo', 'ClusterDasVmConfigInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDasVmConfigInfo', 'ClusterDasVmConfigInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDasVmSettings;
our @ISA = qw(DynamicData);

our @property_list = (
   ['restartPriority', undef, undef, 0],
   ['isolationResponse', undef, undef, 0],
   ['vmToolsMonitoringSettings', 'ClusterVmToolsMonitoringSettings', undef, 0],
);


VIMRuntime::make_get_set('ClusterDasVmSettings', 'restartPriority', 'isolationResponse', 'vmToolsMonitoringSettings');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsFaultsFaultsByVm;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 0],
   ['fault', 'LocalizedMethodFault', 1, 1],
);


VIMRuntime::make_get_set('ClusterDrsFaultsFaultsByVm', 'vm', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsFaultsFaultsByVm;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsFaultsFaultsByVm', 'ClusterDrsFaultsFaultsByVm', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsFaultsFaultsByVm', 'ClusterDrsFaultsFaultsByVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsFaultsFaultsByVirtualDisk;
our @ISA = qw(ClusterDrsFaultsFaultsByVm);

our @property_list = (
   ['disk', 'VirtualDiskId', undef, 0],
);


VIMRuntime::make_get_set('ClusterDrsFaultsFaultsByVirtualDisk', 'disk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsFaults;
our @ISA = qw(DynamicData);

our @property_list = (
   ['reason', undef, undef, 1],
   ['faultsByVm', 'ClusterDrsFaultsFaultsByVm', 1, 1],
);


VIMRuntime::make_get_set('ClusterDrsFaults', 'reason', 'faultsByVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsFaults;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsFaults', 'ClusterDrsFaults', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsFaults', 'ClusterDrsFaults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsMigration;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['time', undef, undef, 1],
   ['vm', 'ManagedObjectReference', undef, 1],
   ['cpuLoad', undef, undef, 0],
   ['memoryLoad', undef, undef, 0],
   ['source', 'ManagedObjectReference', undef, 1],
   ['sourceCpuLoad', undef, undef, 0],
   ['sourceMemoryLoad', undef, undef, 0],
   ['destination', 'ManagedObjectReference', undef, 1],
   ['destinationCpuLoad', undef, undef, 0],
   ['destinationMemoryLoad', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterDrsMigration', 'key', 'time', 'vm', 'cpuLoad', 'memoryLoad', 'source', 'sourceCpuLoad', 'sourceMemoryLoad', 'destination', 'destinationCpuLoad', 'destinationMemoryLoad');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsMigration;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsMigration', 'ClusterDrsMigration', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsMigration', 'ClusterDrsMigration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDrsRecommendation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['rating', undef, undef, 1],
   ['reason', undef, undef, 1],
   ['reasonText', undef, undef, 1],
   ['migrationList', 'ClusterDrsMigration', 1, 1],
);


VIMRuntime::make_get_set('ClusterDrsRecommendation', 'key', 'rating', 'reason', 'reasonText', 'migrationList');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterDrsRecommendation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterDrsRecommendation', 'ClusterDrsRecommendation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterDrsRecommendation', 'ClusterDrsRecommendation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterEnterMaintenanceResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['recommendations', 'ClusterRecommendation', 1, 0],
   ['fault', 'ClusterDrsFaults', undef, 0],
);


VIMRuntime::make_get_set('ClusterEnterMaintenanceResult', 'recommendations', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverHostAdmissionControlInfoHostStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['status', 'ManagedEntityStatus', undef, 1],
);


VIMRuntime::make_get_set('ClusterFailoverHostAdmissionControlInfoHostStatus', 'host', 'status');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterFailoverHostAdmissionControlInfoHostStatus', 'ClusterFailoverHostAdmissionControlInfoHostStatus', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus', 'ClusterFailoverHostAdmissionControlInfoHostStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverHostAdmissionControlInfo;
our @ISA = qw(ClusterDasAdmissionControlInfo);

our @property_list = (
   ['hostStatus', 'ClusterFailoverHostAdmissionControlInfoHostStatus', 1, 0],
);


VIMRuntime::make_get_set('ClusterFailoverHostAdmissionControlInfo', 'hostStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverHostAdmissionControlPolicy;
our @ISA = qw(ClusterDasAdmissionControlPolicy);

our @property_list = (
   ['failoverHosts', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('ClusterFailoverHostAdmissionControlPolicy', 'failoverHosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverLevelAdmissionControlInfo;
our @ISA = qw(ClusterDasAdmissionControlInfo);

our @property_list = (
   ['currentFailoverLevel', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterFailoverLevelAdmissionControlInfo', 'currentFailoverLevel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverLevelAdmissionControlPolicy;
our @ISA = qw(ClusterDasAdmissionControlPolicy);

our @property_list = (
   ['failoverLevel', undef, undef, 1],
   ['slotPolicy', 'ClusterSlotPolicy', undef, 0],
);


VIMRuntime::make_get_set('ClusterFailoverLevelAdmissionControlPolicy', 'failoverLevel', 'slotPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverResourcesAdmissionControlInfo;
our @ISA = qw(ClusterDasAdmissionControlInfo);

our @property_list = (
   ['currentCpuFailoverResourcesPercent', undef, undef, 1],
   ['currentMemoryFailoverResourcesPercent', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterFailoverResourcesAdmissionControlInfo', 'currentCpuFailoverResourcesPercent', 'currentMemoryFailoverResourcesPercent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFailoverResourcesAdmissionControlPolicy;
our @ISA = qw(ClusterDasAdmissionControlPolicy);

our @property_list = (
   ['cpuFailoverResourcesPercent', undef, undef, 1],
   ['memoryFailoverResourcesPercent', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterFailoverResourcesAdmissionControlPolicy', 'cpuFailoverResourcesPercent', 'memoryFailoverResourcesPercent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterGroupInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['userCreated', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('ClusterGroupInfo', 'name', 'userCreated');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterGroupInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterGroupInfo', 'ClusterGroupInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterGroupInfo', 'ClusterGroupInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterHostGroup;
our @ISA = qw(ClusterGroupInfo);

our @property_list = (
   ['host', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('ClusterHostGroup', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterHostPowerAction;
our @ISA = qw(ClusterAction);

our @property_list = (
   ['operationType', 'HostPowerOperationType', undef, 1],
   ['powerConsumptionWatt', undef, undef, 0],
   ['cpuCapacityMHz', undef, undef, 0],
   ['memCapacityMB', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterHostPowerAction', 'operationType', 'powerConsumptionWatt', 'cpuCapacityMHz', 'memCapacityMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterHostRecommendation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['rating', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterHostRecommendation', 'host', 'rating');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterHostRecommendation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterHostRecommendation', 'ClusterHostRecommendation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterHostRecommendation', 'ClusterHostRecommendation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterInitialPlacementAction;
our @ISA = qw(ClusterAction);

our @property_list = (
   ['targetHost', 'ManagedObjectReference', undef, 1],
   ['pool', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterInitialPlacementAction', 'targetHost', 'pool');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterMigrationAction;
our @ISA = qw(ClusterAction);

our @property_list = (
   ['drsMigration', 'ClusterDrsMigration', undef, 0],
);


VIMRuntime::make_get_set('ClusterMigrationAction', 'drsMigration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterNotAttemptedVmInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('ClusterNotAttemptedVmInfo', 'vm', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterNotAttemptedVmInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterNotAttemptedVmInfo', 'ClusterNotAttemptedVmInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterNotAttemptedVmInfo', 'ClusterNotAttemptedVmInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterPowerOnVmResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['attempted', 'ClusterAttemptedVmInfo', 1, 0],
   ['notAttempted', 'ClusterNotAttemptedVmInfo', 1, 0],
   ['recommendations', 'ClusterRecommendation', 1, 0],
);


VIMRuntime::make_get_set('ClusterPowerOnVmResult', 'attempted', 'notAttempted', 'recommendations');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterRecommendation;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['type', undef, undef, 1],
   ['time', undef, undef, 1],
   ['rating', undef, undef, 1],
   ['reason', undef, undef, 1],
   ['reasonText', undef, undef, 1],
   ['prerequisite', undef, 1, 0],
   ['action', 'ClusterAction', 1, 0],
   ['target', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ClusterRecommendation', 'key', 'type', 'time', 'rating', 'reason', 'reasonText', 'prerequisite', 'action', 'target');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterRecommendation;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterRecommendation', 'ClusterRecommendation', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterRecommendation', 'ClusterRecommendation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterRuleInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['status', 'ManagedEntityStatus', undef, 0],
   ['enabled', 'boolean', undef, 0],
   ['name', undef, undef, 0],
   ['mandatory', 'boolean', undef, 0],
   ['userCreated', 'boolean', undef, 0],
   ['inCompliance', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('ClusterRuleInfo', 'key', 'status', 'enabled', 'name', 'mandatory', 'userCreated', 'inCompliance');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterRuleInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterRuleInfo', 'ClusterRuleInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterRuleInfo', 'ClusterRuleInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterRuleSpec;
our @ISA = qw(ArrayUpdateSpec);

our @property_list = (
   ['info', 'ClusterRuleInfo', undef, 0],
);


VIMRuntime::make_get_set('ClusterRuleSpec', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfClusterRuleSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ClusterRuleSpec', 'ClusterRuleSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfClusterRuleSpec', 'ClusterRuleSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterSlotPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterSlotPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterFixedSizeSlotPolicy;
our @ISA = qw(ClusterSlotPolicy);

our @property_list = (
   ['cpu', undef, undef, 1],
   ['memory', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterFixedSizeSlotPolicy', 'cpu', 'memory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmGroup;
our @ISA = qw(ClusterGroupInfo);

our @property_list = (
   ['vm', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('ClusterVmGroup', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmHostRuleInfo;
our @ISA = qw(ClusterRuleInfo);

our @property_list = (
   ['vmGroupName', undef, undef, 0],
   ['affineHostGroupName', undef, undef, 0],
   ['antiAffineHostGroupName', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterVmHostRuleInfo', 'vmGroupName', 'affineHostGroupName', 'antiAffineHostGroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterVmToolsMonitoringSettings;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['vmMonitoring', undef, undef, 0],
   ['clusterSettings', 'boolean', undef, 0],
   ['failureInterval', undef, undef, 0],
   ['minUpTime', undef, undef, 0],
   ['maxFailures', undef, undef, 0],
   ['maxFailureWindow', undef, undef, 0],
);


VIMRuntime::make_get_set('ClusterVmToolsMonitoringSettings', 'enabled', 'vmMonitoring', 'clusterSettings', 'failureInterval', 'minUpTime', 'maxFailures', 'maxFailureWindow');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['operation', undef, undef, 1],
   ['key', undef, undef, 0],
   ['name', undef, undef, 0],
   ['scope', 'ManagedObjectReference', 1, 0],
   ['description', undef, undef, 0],
   ['setting', 'DVPortSetting', undef, 0],
   ['configVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('DVPortConfigSpec', 'operation', 'key', 'name', 'scope', 'description', 'setting', 'configVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVPortConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVPortConfigSpec', 'DVPortConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVPortConfigSpec', 'DVPortConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['scope', 'ManagedObjectReference', 1, 0],
   ['description', undef, undef, 0],
   ['setting', 'DVPortSetting', undef, 0],
   ['configVersion', undef, undef, 1],
);


VIMRuntime::make_get_set('DVPortConfigInfo', 'name', 'scope', 'description', 'setting', 'configVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSTrafficShapingPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['enabled', 'BoolPolicy', undef, 0],
   ['averageBandwidth', 'LongPolicy', undef, 0],
   ['peakBandwidth', 'LongPolicy', undef, 0],
   ['burstSize', 'LongPolicy', undef, 0],
);


VIMRuntime::make_get_set('DVSTrafficShapingPolicy', 'enabled', 'averageBandwidth', 'peakBandwidth', 'burstSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSHostLocalPortInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['switchUuid', undef, undef, 1],
   ['portKey', undef, undef, 1],
   ['setting', 'DVPortSetting', undef, 1],
   ['vnic', undef, undef, 1],
);


VIMRuntime::make_get_set('DVSHostLocalPortInfo', 'switchUuid', 'portKey', 'setting', 'vnic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSVendorSpecificConfig;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['keyValue', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
);


VIMRuntime::make_get_set('DVSVendorSpecificConfig', 'keyValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsFilterParameter;
our @ISA = qw(DynamicData);

our @property_list = (
   ['parameters', undef, 1, 0],
);


VIMRuntime::make_get_set('DvsFilterParameter', 'parameters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsFilterConfig;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['key', undef, undef, 0],
   ['agentName', undef, undef, 0],
   ['slotNumber', undef, undef, 0],
   ['parameters', 'DvsFilterParameter', undef, 0],
   ['onFailure', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsFilterConfig', 'key', 'agentName', 'slotNumber', 'parameters', 'onFailure');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsFilterConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsFilterConfig', 'DvsFilterConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsFilterConfig', 'DvsFilterConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsTrafficFilterConfig;
our @ISA = qw(DvsFilterConfig);

our @property_list = (
   ['trafficRuleset', 'DvsTrafficRuleset', undef, 0],
);


VIMRuntime::make_get_set('DvsTrafficFilterConfig', 'trafficRuleset');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsFilterConfigSpec;
our @ISA = qw(DvsFilterConfig);

our @property_list = (
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsFilterConfigSpec', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsTrafficFilterConfigSpec;
our @ISA = qw(DvsTrafficFilterConfig);

our @property_list = (
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsTrafficFilterConfigSpec', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsFilterPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['filterConfig', 'DvsFilterConfig', 1, 0],
);


VIMRuntime::make_get_set('DvsFilterPolicy', 'filterConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortSetting;
our @ISA = qw(DynamicData);

our @property_list = (
   ['blocked', 'BoolPolicy', undef, 0],
   ['vmDirectPathGen2Allowed', 'BoolPolicy', undef, 0],
   ['inShapingPolicy', 'DVSTrafficShapingPolicy', undef, 0],
   ['outShapingPolicy', 'DVSTrafficShapingPolicy', undef, 0],
   ['vendorSpecificConfig', 'DVSVendorSpecificConfig', undef, 0],
   ['networkResourcePoolKey', 'StringPolicy', undef, 0],
   ['filterPolicy', 'DvsFilterPolicy', undef, 0],
);


VIMRuntime::make_get_set('DVPortSetting', 'blocked', 'vmDirectPathGen2Allowed', 'inShapingPolicy', 'outShapingPolicy', 'vendorSpecificConfig', 'networkResourcePoolKey', 'filterPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortStatus;
our @ISA = qw(DynamicData);

our @property_list = (
   ['linkUp', 'boolean', undef, 1],
   ['blocked', 'boolean', undef, 1],
   ['vlanIds', 'NumericRange', 1, 0],
   ['trunkingMode', 'boolean', undef, 0],
   ['mtu', undef, undef, 0],
   ['linkPeer', undef, undef, 0],
   ['macAddress', undef, undef, 0],
   ['statusDetail', undef, undef, 0],
   ['vmDirectPathGen2Active', 'boolean', undef, 0],
   ['vmDirectPathGen2InactiveReasonNetwork', undef, 1, 0],
   ['vmDirectPathGen2InactiveReasonOther', undef, 1, 0],
   ['vmDirectPathGen2InactiveReasonExtended', undef, undef, 0],
);


VIMRuntime::make_get_set('DVPortStatus', 'linkUp', 'blocked', 'vlanIds', 'trunkingMode', 'mtu', 'linkPeer', 'macAddress', 'statusDetail', 'vmDirectPathGen2Active', 'vmDirectPathGen2InactiveReasonNetwork', 'vmDirectPathGen2InactiveReasonOther', 'vmDirectPathGen2InactiveReasonExtended');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['runtimeInfo', 'DVPortStatus', undef, 0],
   ['stats', 'DistributedVirtualSwitchPortStatistics', undef, 1],
   ['vendorSpecificState', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
);


VIMRuntime::make_get_set('DVPortState', 'runtimeInfo', 'stats', 'vendorSpecificState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualPort;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['config', 'DVPortConfigInfo', undef, 1],
   ['dvsUuid', undef, undef, 1],
   ['portgroupKey', undef, undef, 0],
   ['proxyHost', 'ManagedObjectReference', undef, 0],
   ['connectee', 'DistributedVirtualSwitchPortConnectee', undef, 0],
   ['conflict', 'boolean', undef, 1],
   ['conflictPortKey', undef, undef, 0],
   ['state', 'DVPortState', undef, 0],
   ['connectionCookie', undef, undef, 0],
   ['lastStatusChange', undef, undef, 1],
   ['hostLocalPort', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualPort', 'key', 'config', 'dvsUuid', 'portgroupKey', 'proxyHost', 'connectee', 'conflict', 'conflictPortKey', 'state', 'connectionCookie', 'lastStatusChange', 'hostLocalPort');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualPort;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualPort', 'DistributedVirtualPort', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualPort', 'DistributedVirtualPort');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupPolicy;
our @ISA = qw(DynamicData);

our @property_list = (
   ['blockOverrideAllowed', 'boolean', undef, 1],
   ['shapingOverrideAllowed', 'boolean', undef, 1],
   ['vendorConfigOverrideAllowed', 'boolean', undef, 1],
   ['livePortMovingAllowed', 'boolean', undef, 1],
   ['portConfigResetAtDisconnect', 'boolean', undef, 1],
   ['networkResourcePoolOverrideAllowed', 'boolean', undef, 0],
   ['trafficFilterOverrideAllowed', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DVPortgroupPolicy', 'blockOverrideAllowed', 'shapingOverrideAllowed', 'vendorConfigOverrideAllowed', 'livePortMovingAllowed', 'portConfigResetAtDisconnect', 'networkResourcePoolOverrideAllowed', 'trafficFilterOverrideAllowed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['configVersion', undef, undef, 0],
   ['name', undef, undef, 0],
   ['numPorts', undef, undef, 0],
   ['portNameFormat', undef, undef, 0],
   ['defaultPortConfig', 'DVPortSetting', undef, 0],
   ['description', undef, undef, 0],
   ['type', undef, undef, 0],
   ['scope', 'ManagedObjectReference', 1, 0],
   ['policy', 'DVPortgroupPolicy', undef, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['autoExpand', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DVPortgroupConfigSpec', 'configVersion', 'name', 'numPorts', 'portNameFormat', 'defaultPortConfig', 'description', 'type', 'scope', 'policy', 'vendorSpecificConfig', 'autoExpand');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVPortgroupConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVPortgroupConfigSpec', 'DVPortgroupConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVPortgroupConfigSpec', 'DVPortgroupConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['name', undef, undef, 1],
   ['numPorts', undef, undef, 1],
   ['distributedVirtualSwitch', 'ManagedObjectReference', undef, 0],
   ['defaultPortConfig', 'DVPortSetting', undef, 0],
   ['description', undef, undef, 0],
   ['type', undef, undef, 1],
   ['policy', 'DVPortgroupPolicy', undef, 1],
   ['portNameFormat', undef, undef, 0],
   ['scope', 'ManagedObjectReference', 1, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['configVersion', undef, undef, 0],
   ['autoExpand', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('DVPortgroupConfigInfo', 'key', 'name', 'numPorts', 'distributedVirtualSwitch', 'defaultPortConfig', 'description', 'type', 'policy', 'portNameFormat', 'scope', 'vendorSpecificConfig', 'configVersion', 'autoExpand');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualPortgroupInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['switchName', undef, undef, 1],
   ['switchUuid', undef, undef, 1],
   ['portgroupName', undef, undef, 1],
   ['portgroupKey', undef, undef, 1],
   ['portgroupType', undef, undef, 1],
   ['uplinkPortgroup', 'boolean', undef, 1],
   ['portgroup', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualPortgroupInfo', 'switchName', 'switchUuid', 'portgroupName', 'portgroupKey', 'portgroupType', 'uplinkPortgroup', 'portgroup');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualPortgroupInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualPortgroupInfo', 'DistributedVirtualPortgroupInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualPortgroupInfo', 'DistributedVirtualPortgroupInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupSelection;
our @ISA = qw(SelectionSet);

our @property_list = (
   ['dvsUuid', undef, undef, 1],
   ['portgroupKey', undef, 1, 1],
);


VIMRuntime::make_get_set('DVPortgroupSelection', 'dvsUuid', 'portgroupKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['switchName', undef, undef, 1],
   ['switchUuid', undef, undef, 1],
   ['distributedVirtualSwitch', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchInfo', 'switchName', 'switchUuid', 'distributedVirtualSwitch');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchInfo', 'DistributedVirtualSwitchInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchInfo', 'DistributedVirtualSwitchInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSManagerDvsConfigTarget;
our @ISA = qw(DynamicData);

our @property_list = (
   ['distributedVirtualPortgroup', 'DistributedVirtualPortgroupInfo', 1, 0],
   ['distributedVirtualSwitch', 'DistributedVirtualSwitchInfo', 1, 0],
);


VIMRuntime::make_get_set('DVSManagerDvsConfigTarget', 'distributedVirtualPortgroup', 'distributedVirtualSwitch');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerCompatibilityResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['error', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerCompatibilityResult', 'host', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchManagerCompatibilityResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchManagerCompatibilityResult', 'DistributedVirtualSwitchManagerCompatibilityResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchManagerCompatibilityResult', 'DistributedVirtualSwitchManagerCompatibilityResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostContainer;
our @ISA = qw(DynamicData);

our @property_list = (
   ['container', 'ManagedObjectReference', undef, 1],
   ['recursive', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostContainer', 'container', 'recursive');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostDvsFilterSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['inclusive', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostDvsFilterSpec', 'inclusive');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchManagerHostDvsFilterSpec', 'DistributedVirtualSwitchManagerHostDvsFilterSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec', 'DistributedVirtualSwitchManagerHostDvsFilterSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostArrayFilter;
our @ISA = qw(DistributedVirtualSwitchManagerHostDvsFilterSpec);

our @property_list = (
   ['host', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostArrayFilter', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostContainerFilter;
our @ISA = qw(DistributedVirtualSwitchManagerHostDvsFilterSpec);

our @property_list = (
   ['hostContainer', 'DistributedVirtualSwitchManagerHostContainer', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostContainerFilter', 'hostContainer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerHostDvsMembershipFilter;
our @ISA = qw(DistributedVirtualSwitchManagerHostDvsFilterSpec);

our @property_list = (
   ['distributedVirtualSwitch', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerHostDvsMembershipFilter', 'distributedVirtualSwitch');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerDvsProductSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['newSwitchProductSpec', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['distributedVirtualSwitch', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerDvsProductSpec', 'newSwitchProductSpec', 'distributedVirtualSwitch');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchManagerImportResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['distributedVirtualSwitch', 'ManagedObjectReference', 1, 0],
   ['distributedVirtualPortgroup', 'ManagedObjectReference', 1, 0],
   ['importFault', 'ImportOperationBulkFaultFaultOnImport', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchManagerImportResult', 'distributedVirtualSwitch', 'distributedVirtualPortgroup', 'importFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSSelection;
our @ISA = qw(SelectionSet);

our @property_list = (
   ['dvsUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('DVSSelection', 'dvsUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EntityBackupConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityType', undef, undef, 1],
   ['configBlob', undef, undef, 1],
   ['key', undef, undef, 0],
   ['name', undef, undef, 0],
   ['container', 'ManagedObjectReference', undef, 0],
   ['configVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('EntityBackupConfig', 'entityType', 'configBlob', 'key', 'name', 'container', 'configVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEntityBackupConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EntityBackupConfig', 'EntityBackupConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEntityBackupConfig', 'EntityBackupConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EntityBackup;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('EntityBackup');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['operation', undef, undef, 1],
   ['host', 'ManagedObjectReference', undef, 1],
   ['backing', 'DistributedVirtualSwitchHostMemberBacking', undef, 0],
   ['maxProxySwitchPorts', undef, undef, 0],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberConfigSpec', 'operation', 'host', 'backing', 'maxProxySwitchPorts', 'vendorSpecificConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchHostMemberConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchHostMemberConfigSpec', 'DistributedVirtualSwitchHostMemberConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchHostMemberConfigSpec', 'DistributedVirtualSwitchHostMemberConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberPnicSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['pnicDevice', undef, undef, 1],
   ['uplinkPortKey', undef, undef, 0],
   ['uplinkPortgroupKey', undef, undef, 0],
   ['connectionCookie', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberPnicSpec', 'pnicDevice', 'uplinkPortKey', 'uplinkPortgroupKey', 'connectionCookie');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchHostMemberPnicSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchHostMemberPnicSpec', 'DistributedVirtualSwitchHostMemberPnicSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchHostMemberPnicSpec', 'DistributedVirtualSwitchHostMemberPnicSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberBacking;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberBacking');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberPnicBacking;
our @ISA = qw(DistributedVirtualSwitchHostMemberBacking);

our @property_list = (
   ['pnicSpec', 'DistributedVirtualSwitchHostMemberPnicSpec', 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberPnicBacking', 'pnicSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberRuntimeState;
our @ISA = qw(DynamicData);

our @property_list = (
   ['currentMaxProxySwitchPorts', undef, undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberRuntimeState', 'currentMaxProxySwitchPorts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMemberConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 0],
   ['maxProxySwitchPorts', undef, undef, 1],
   ['vendorSpecificConfig', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
   ['backing', 'DistributedVirtualSwitchHostMemberBacking', undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMemberConfigInfo', 'host', 'maxProxySwitchPorts', 'vendorSpecificConfig', 'backing');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostMemberRuntimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['status', undef, undef, 0],
   ['statusDetail', undef, undef, 0],
   ['healthCheckResult', 'HostMemberHealthCheckResult', 1, 0],
);


VIMRuntime::make_get_set('HostMemberRuntimeInfo', 'host', 'status', 'statusDetail', 'healthCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostMemberRuntimeInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostMemberRuntimeInfo', 'HostMemberRuntimeInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostMemberRuntimeInfo', 'HostMemberRuntimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostMemberHealthCheckResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['summary', undef, undef, 0],
);


VIMRuntime::make_get_set('HostMemberHealthCheckResult', 'summary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostMemberHealthCheckResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostMemberHealthCheckResult', 'HostMemberHealthCheckResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostMemberHealthCheckResult', 'HostMemberHealthCheckResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostMemberUplinkHealthCheckResult;
our @ISA = qw(HostMemberHealthCheckResult);

our @property_list = (
   ['uplinkPortKey', undef, undef, 1],
);


VIMRuntime::make_get_set('HostMemberUplinkHealthCheckResult', 'uplinkPortKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostMember;
our @ISA = qw(DynamicData);

our @property_list = (
   ['runtimeState', 'DistributedVirtualSwitchHostMemberRuntimeState', undef, 0],
   ['config', 'DistributedVirtualSwitchHostMemberConfigInfo', undef, 1],
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 0],
   ['uplinkPortKey', undef, 1, 0],
   ['status', undef, undef, 1],
   ['statusDetail', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostMember', 'runtimeState', 'config', 'productInfo', 'uplinkPortKey', 'status', 'statusDetail');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchHostMember;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchHostMember', 'DistributedVirtualSwitchHostMember', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchHostMember', 'DistributedVirtualSwitchHostMember');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchHostProductSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['productLineId', undef, undef, 0],
   ['version', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchHostProductSpec', 'productLineId', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchHostProductSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchHostProductSpec', 'DistributedVirtualSwitchHostProductSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchHostProductSpec', 'DistributedVirtualSwitchHostProductSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchKeyedOpaqueBlob;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['opaqueData', undef, undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchKeyedOpaqueBlob', 'key', 'opaqueData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchKeyedOpaqueBlob', 'DistributedVirtualSwitchKeyedOpaqueBlob', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob', 'DistributedVirtualSwitchKeyedOpaqueBlob');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNetworkResourcePoolAllocationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['limit', undef, undef, 0],
   ['shares', 'SharesInfo', undef, 0],
   ['priorityTag', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSNetworkResourcePoolAllocationInfo', 'limit', 'shares', 'priorityTag');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNetworkResourcePoolConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['configVersion', undef, undef, 0],
   ['allocationInfo', 'DVSNetworkResourcePoolAllocationInfo', undef, 0],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
);


VIMRuntime::make_get_set('DVSNetworkResourcePoolConfigSpec', 'key', 'configVersion', 'allocationInfo', 'name', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVSNetworkResourcePoolConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVSNetworkResourcePoolConfigSpec', 'DVSNetworkResourcePoolConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVSNetworkResourcePoolConfigSpec', 'DVSNetworkResourcePoolConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSNetworkResourcePool;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
   ['configVersion', undef, undef, 1],
   ['allocationInfo', 'DVSNetworkResourcePoolAllocationInfo', undef, 1],
);


VIMRuntime::make_get_set('DVSNetworkResourcePool', 'key', 'name', 'description', 'configVersion', 'allocationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDVSNetworkResourcePool;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DVSNetworkResourcePool', 'DVSNetworkResourcePool', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDVSNetworkResourcePool', 'DVSNetworkResourcePool');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchPortConnectee;
our @ISA = qw(DynamicData);

our @property_list = (
   ['connectedEntity', 'ManagedObjectReference', undef, 0],
   ['nicKey', undef, undef, 0],
   ['type', undef, undef, 0],
   ['addressHint', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchPortConnectee', 'connectedEntity', 'nicKey', 'type', 'addressHint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchPortConnection;
our @ISA = qw(DynamicData);

our @property_list = (
   ['switchUuid', undef, undef, 1],
   ['portgroupKey', undef, undef, 0],
   ['portKey', undef, undef, 0],
   ['connectionCookie', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchPortConnection', 'switchUuid', 'portgroupKey', 'portKey', 'connectionCookie');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchPortCriteria;
our @ISA = qw(DynamicData);

our @property_list = (
   ['connected', 'boolean', undef, 0],
   ['active', 'boolean', undef, 0],
   ['uplinkPort', 'boolean', undef, 0],
   ['scope', 'ManagedObjectReference', undef, 0],
   ['portgroupKey', undef, 1, 0],
   ['inside', 'boolean', undef, 0],
   ['portKey', undef, 1, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchPortCriteria', 'connected', 'active', 'uplinkPort', 'scope', 'portgroupKey', 'inside', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchPortStatistics;
our @ISA = qw(DynamicData);

our @property_list = (
   ['packetsInMulticast', undef, undef, 1],
   ['packetsOutMulticast', undef, undef, 1],
   ['bytesInMulticast', undef, undef, 1],
   ['bytesOutMulticast', undef, undef, 1],
   ['packetsInUnicast', undef, undef, 1],
   ['packetsOutUnicast', undef, undef, 1],
   ['bytesInUnicast', undef, undef, 1],
   ['bytesOutUnicast', undef, undef, 1],
   ['packetsInBroadcast', undef, undef, 1],
   ['packetsOutBroadcast', undef, undef, 1],
   ['bytesInBroadcast', undef, undef, 1],
   ['bytesOutBroadcast', undef, undef, 1],
   ['packetsInDropped', undef, undef, 1],
   ['packetsOutDropped', undef, undef, 1],
   ['packetsInException', undef, undef, 1],
   ['packetsOutException', undef, undef, 1],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchPortStatistics', 'packetsInMulticast', 'packetsOutMulticast', 'bytesInMulticast', 'bytesOutMulticast', 'packetsInUnicast', 'packetsOutUnicast', 'bytesInUnicast', 'bytesOutUnicast', 'packetsInBroadcast', 'packetsOutBroadcast', 'bytesInBroadcast', 'bytesOutBroadcast', 'packetsInDropped', 'packetsOutDropped', 'packetsInException', 'packetsOutException');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DistributedVirtualSwitchProductSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 0],
   ['vendor', undef, undef, 0],
   ['version', undef, undef, 0],
   ['build', undef, undef, 0],
   ['forwardingClass', undef, undef, 0],
   ['bundleId', undef, undef, 0],
   ['bundleUrl', undef, undef, 0],
);


VIMRuntime::make_get_set('DistributedVirtualSwitchProductSpec', 'name', 'vendor', 'version', 'build', 'forwardingClass', 'bundleId', 'bundleUrl');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDistributedVirtualSwitchProductSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DistributedVirtualSwitchProductSpec', 'DistributedVirtualSwitchProductSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDistributedVirtualSwitchProductSpec', 'DistributedVirtualSwitchProductSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsNetworkRuleQualifier;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsNetworkRuleQualifier', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsNetworkRuleQualifier;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsNetworkRuleQualifier', 'DvsNetworkRuleQualifier', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsNetworkRuleQualifier', 'DvsNetworkRuleQualifier');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsNetworkRuleAction;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('DvsNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsIpNetworkRuleQualifier;
our @ISA = qw(DvsNetworkRuleQualifier);

our @property_list = (
   ['sourceAddress', 'IpAddress', undef, 0],
   ['destinationAddress', 'IpAddress', undef, 0],
   ['protocol', 'IntExpression', undef, 0],
   ['sourceIpPort', 'DvsIpPort', undef, 0],
   ['destinationIpPort', 'DvsIpPort', undef, 0],
   ['tcpFlags', 'IntExpression', undef, 0],
);


VIMRuntime::make_get_set('DvsIpNetworkRuleQualifier', 'sourceAddress', 'destinationAddress', 'protocol', 'sourceIpPort', 'destinationIpPort', 'tcpFlags');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsIpPort;
our @ISA = qw(NegatableExpression);

our @property_list = (
);


VIMRuntime::make_get_set('DvsIpPort');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsSingleIpPort;
our @ISA = qw(DvsIpPort);

our @property_list = (
   ['portNumber', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsSingleIpPort', 'portNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsIpPortRange;
our @ISA = qw(DvsIpPort);

our @property_list = (
   ['startPortNumber', undef, undef, 1],
   ['endPortNumber', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsIpPortRange', 'startPortNumber', 'endPortNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsMacNetworkRuleQualifier;
our @ISA = qw(DvsNetworkRuleQualifier);

our @property_list = (
   ['sourceAddress', 'MacAddress', undef, 0],
   ['destinationAddress', 'MacAddress', undef, 0],
   ['protocol', 'IntExpression', undef, 0],
   ['vlanId', 'IntExpression', undef, 0],
);


VIMRuntime::make_get_set('DvsMacNetworkRuleQualifier', 'sourceAddress', 'destinationAddress', 'protocol', 'vlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsSystemTrafficNetworkRuleQualifier;
our @ISA = qw(DvsNetworkRuleQualifier);

our @property_list = (
   ['typeOfSystemTraffic', 'StringExpression', undef, 0],
);


VIMRuntime::make_get_set('DvsSystemTrafficNetworkRuleQualifier', 'typeOfSystemTraffic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsDropNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsDropNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsAcceptNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsAcceptNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsUpdateTagNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
   ['qosTag', undef, undef, 0],
   ['dscpTag', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsUpdateTagNetworkRuleAction', 'qosTag', 'dscpTag');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsRateLimitNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
   ['packetsPerSecond', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsRateLimitNetworkRuleAction', 'packetsPerSecond');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsLogNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsLogNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsGreEncapNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
   ['encapsulationIp', 'SingleIp', undef, 1],
);


VIMRuntime::make_get_set('DvsGreEncapNetworkRuleAction', 'encapsulationIp');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsMacRewriteNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
   ['rewriteMac', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsMacRewriteNetworkRuleAction', 'rewriteMac');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPuntNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsPuntNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsCopyNetworkRuleAction;
our @ISA = qw(DvsNetworkRuleAction);

our @property_list = (
);


VIMRuntime::make_get_set('DvsCopyNetworkRuleAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsTrafficRule;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['description', undef, undef, 0],
   ['sequence', undef, undef, 0],
   ['qualifier', 'DvsNetworkRuleQualifier', 1, 0],
   ['action', 'DvsNetworkRuleAction', undef, 0],
   ['direction', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsTrafficRule', 'key', 'description', 'sequence', 'qualifier', 'action', 'direction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsTrafficRule;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsTrafficRule', 'DvsTrafficRule', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsTrafficRule', 'DvsTrafficRule');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsTrafficRuleset;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['enabled', 'boolean', undef, 0],
   ['precedence', undef, undef, 0],
   ['rules', 'DvsTrafficRule', 1, 0],
);


VIMRuntime::make_get_set('DvsTrafficRuleset', 'key', 'enabled', 'precedence', 'rules');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSFeatureCapability;
our @ISA = qw(DVSFeatureCapability);

our @property_list = (
   ['vspanSupported', 'boolean', undef, 0],
   ['lldpSupported', 'boolean', undef, 0],
   ['ipfixSupported', 'boolean', undef, 0],
   ['vspanCapability', 'VMwareDVSVspanCapability', undef, 0],
   ['lacpCapability', 'VMwareDvsLacpCapability', undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSFeatureCapability', 'vspanSupported', 'lldpSupported', 'ipfixSupported', 'vspanCapability', 'lacpCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLacpCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lacpSupported', 'boolean', undef, 0],
   ['multiLacpGroupSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VMwareDvsLacpCapability', 'lacpSupported', 'multiLacpGroupSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSHealthCheckCapability;
our @ISA = qw(DVSHealthCheckCapability);

our @property_list = (
   ['vlanMtuSupported', 'boolean', undef, 1],
   ['teamingSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSHealthCheckCapability', 'vlanMtuSupported', 'teamingSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSVspanCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['mixedDestSupported', 'boolean', undef, 1],
   ['dvportSupported', 'boolean', undef, 1],
   ['remoteSourceSupported', 'boolean', undef, 1],
   ['remoteDestSupported', 'boolean', undef, 1],
   ['encapRemoteSourceSupported', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSVspanCapability', 'mixedDestSupported', 'dvportSupported', 'remoteSourceSupported', 'remoteDestSupported', 'encapRemoteSourceSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareVspanPort;
our @ISA = qw(DynamicData);

our @property_list = (
   ['portKey', undef, 1, 0],
   ['uplinkPortName', undef, 1, 0],
   ['wildcardPortConnecteeType', undef, 1, 0],
   ['vlans', undef, 1, 0],
   ['ipAddress', undef, 1, 0],
);


VIMRuntime::make_get_set('VMwareVspanPort', 'portKey', 'uplinkPortName', 'wildcardPortConnecteeType', 'vlans', 'ipAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareVspanSession;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['name', undef, undef, 0],
   ['description', undef, undef, 0],
   ['enabled', 'boolean', undef, 1],
   ['sourcePortTransmitted', 'VMwareVspanPort', undef, 0],
   ['sourcePortReceived', 'VMwareVspanPort', undef, 0],
   ['destinationPort', 'VMwareVspanPort', undef, 0],
   ['encapsulationVlanId', undef, undef, 0],
   ['stripOriginalVlan', 'boolean', undef, 1],
   ['mirroredPacketLength', undef, undef, 0],
   ['normalTrafficAllowed', 'boolean', undef, 1],
   ['sessionType', undef, undef, 0],
   ['samplingRate', undef, undef, 0],
);


VIMRuntime::make_get_set('VMwareVspanSession', 'key', 'name', 'description', 'enabled', 'sourcePortTransmitted', 'sourcePortReceived', 'destinationPort', 'encapsulationVlanId', 'stripOriginalVlan', 'mirroredPacketLength', 'normalTrafficAllowed', 'sessionType', 'samplingRate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareVspanSession;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareVspanSession', 'VMwareVspanSession', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareVspanSession', 'VMwareVspanSession');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareIpfixConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['collectorIpAddress', undef, undef, 0],
   ['collectorPort', undef, undef, 0],
   ['activeFlowTimeout', undef, undef, 1],
   ['idleFlowTimeout', undef, undef, 1],
   ['samplingRate', undef, undef, 1],
   ['internalFlowsOnly', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VMwareIpfixConfig', 'collectorIpAddress', 'collectorPort', 'activeFlowTimeout', 'idleFlowTimeout', 'samplingRate', 'internalFlowsOnly');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSConfigInfo;
our @ISA = qw(DVSConfigInfo);

our @property_list = (
   ['vspanSession', 'VMwareVspanSession', 1, 0],
   ['pvlanConfig', 'VMwareDVSPvlanMapEntry', 1, 0],
   ['maxMtu', undef, undef, 1],
   ['linkDiscoveryProtocolConfig', 'LinkDiscoveryProtocolConfig', undef, 0],
   ['ipfixConfig', 'VMwareIpfixConfig', undef, 0],
   ['lacpGroupConfig', 'VMwareDvsLacpGroupConfig', 1, 0],
   ['lacpApiVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSConfigInfo', 'vspanSession', 'pvlanConfig', 'maxMtu', 'linkDiscoveryProtocolConfig', 'ipfixConfig', 'lacpGroupConfig', 'lacpApiVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSConfigSpec;
our @ISA = qw(DVSConfigSpec);

our @property_list = (
   ['pvlanConfigSpec', 'VMwareDVSPvlanConfigSpec', 1, 0],
   ['vspanConfigSpec', 'VMwareDVSVspanConfigSpec', 1, 0],
   ['maxMtu', undef, undef, 0],
   ['linkDiscoveryProtocolConfig', 'LinkDiscoveryProtocolConfig', undef, 0],
   ['ipfixConfig', 'VMwareIpfixConfig', undef, 0],
   ['lacpApiVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSConfigSpec', 'pvlanConfigSpec', 'vspanConfigSpec', 'maxMtu', 'linkDiscoveryProtocolConfig', 'ipfixConfig', 'lacpApiVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareUplinkPortOrderPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['activeUplinkPort', undef, 1, 0],
   ['standbyUplinkPort', undef, 1, 0],
);


VIMRuntime::make_get_set('VMwareUplinkPortOrderPolicy', 'activeUplinkPort', 'standbyUplinkPort');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSFailureCriteria;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['checkSpeed', 'StringPolicy', undef, 0],
   ['speed', 'IntPolicy', undef, 0],
   ['checkDuplex', 'BoolPolicy', undef, 0],
   ['fullDuplex', 'BoolPolicy', undef, 0],
   ['checkErrorPercent', 'BoolPolicy', undef, 0],
   ['percentage', 'IntPolicy', undef, 0],
   ['checkBeacon', 'BoolPolicy', undef, 0],
);


VIMRuntime::make_get_set('DVSFailureCriteria', 'checkSpeed', 'speed', 'checkDuplex', 'fullDuplex', 'checkErrorPercent', 'percentage', 'checkBeacon');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareUplinkPortTeamingPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['policy', 'StringPolicy', undef, 0],
   ['reversePolicy', 'BoolPolicy', undef, 0],
   ['notifySwitches', 'BoolPolicy', undef, 0],
   ['rollingOrder', 'BoolPolicy', undef, 0],
   ['failureCriteria', 'DVSFailureCriteria', undef, 0],
   ['uplinkPortOrder', 'VMwareUplinkPortOrderPolicy', undef, 0],
);


VIMRuntime::make_get_set('VmwareUplinkPortTeamingPolicy', 'policy', 'reversePolicy', 'notifySwitches', 'rollingOrder', 'failureCriteria', 'uplinkPortOrder');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareDistributedVirtualSwitchVlanSpec;
our @ISA = qw(InheritablePolicy);

our @property_list = (
);


VIMRuntime::make_get_set('VmwareDistributedVirtualSwitchVlanSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareDistributedVirtualSwitchPvlanSpec;
our @ISA = qw(VmwareDistributedVirtualSwitchVlanSpec);

our @property_list = (
   ['pvlanId', undef, undef, 1],
);


VIMRuntime::make_get_set('VmwareDistributedVirtualSwitchPvlanSpec', 'pvlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareDistributedVirtualSwitchVlanIdSpec;
our @ISA = qw(VmwareDistributedVirtualSwitchVlanSpec);

our @property_list = (
   ['vlanId', undef, undef, 1],
);


VIMRuntime::make_get_set('VmwareDistributedVirtualSwitchVlanIdSpec', 'vlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmwareDistributedVirtualSwitchTrunkVlanSpec;
our @ISA = qw(VmwareDistributedVirtualSwitchVlanSpec);

our @property_list = (
   ['vlanId', 'NumericRange', 1, 1],
);


VIMRuntime::make_get_set('VmwareDistributedVirtualSwitchTrunkVlanSpec', 'vlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVSSecurityPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['allowPromiscuous', 'BoolPolicy', undef, 0],
   ['macChanges', 'BoolPolicy', undef, 0],
   ['forgedTransmits', 'BoolPolicy', undef, 0],
);


VIMRuntime::make_get_set('DVSSecurityPolicy', 'allowPromiscuous', 'macChanges', 'forgedTransmits');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSPortSetting;
our @ISA = qw(DVPortSetting);

our @property_list = (
   ['vlan', 'VmwareDistributedVirtualSwitchVlanSpec', undef, 0],
   ['qosTag', 'IntPolicy', undef, 0],
   ['uplinkTeamingPolicy', 'VmwareUplinkPortTeamingPolicy', undef, 0],
   ['securityPolicy', 'DVSSecurityPolicy', undef, 0],
   ['ipfixEnabled', 'BoolPolicy', undef, 0],
   ['txUplink', 'BoolPolicy', undef, 0],
   ['lacpPolicy', 'VMwareUplinkLacpPolicy', undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSPortSetting', 'vlan', 'qosTag', 'uplinkTeamingPolicy', 'securityPolicy', 'ipfixEnabled', 'txUplink', 'lacpPolicy');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSPortgroupPolicy;
our @ISA = qw(DVPortgroupPolicy);

our @property_list = (
   ['vlanOverrideAllowed', 'boolean', undef, 1],
   ['uplinkTeamingOverrideAllowed', 'boolean', undef, 1],
   ['securityPolicyOverrideAllowed', 'boolean', undef, 1],
   ['ipfixOverrideAllowed', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VMwareDVSPortgroupPolicy', 'vlanOverrideAllowed', 'uplinkTeamingOverrideAllowed', 'securityPolicyOverrideAllowed', 'ipfixOverrideAllowed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSPvlanConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['pvlanEntry', 'VMwareDVSPvlanMapEntry', undef, 1],
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSPvlanConfigSpec', 'pvlanEntry', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDVSPvlanConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDVSPvlanConfigSpec', 'VMwareDVSPvlanConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDVSPvlanConfigSpec', 'VMwareDVSPvlanConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSPvlanMapEntry;
our @ISA = qw(DynamicData);

our @property_list = (
   ['primaryVlanId', undef, undef, 1],
   ['secondaryVlanId', undef, undef, 1],
   ['pvlanType', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSPvlanMapEntry', 'primaryVlanId', 'secondaryVlanId', 'pvlanType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDVSPvlanMapEntry;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDVSPvlanMapEntry', 'VMwareDVSPvlanMapEntry', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDVSPvlanMapEntry', 'VMwareDVSPvlanMapEntry');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSVspanConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vspanSession', 'VMwareVspanSession', undef, 1],
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSVspanConfigSpec', 'vspanSession', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDVSVspanConfigSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDVSVspanConfigSpec', 'VMwareDVSVspanConfigSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDVSVspanConfigSpec', 'VMwareDVSVspanConfigSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSHealthCheckConfig;
our @ISA = qw(DVSHealthCheckConfig);

our @property_list = (
);


VIMRuntime::make_get_set('VMwareDVSHealthCheckConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSVlanMtuHealthCheckConfig;
our @ISA = qw(VMwareDVSHealthCheckConfig);

our @property_list = (
);


VIMRuntime::make_get_set('VMwareDVSVlanMtuHealthCheckConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSTeamingHealthCheckConfig;
our @ISA = qw(VMwareDVSHealthCheckConfig);

our @property_list = (
);


VIMRuntime::make_get_set('VMwareDVSTeamingHealthCheckConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSVlanHealthCheckResult;
our @ISA = qw(HostMemberUplinkHealthCheckResult);

our @property_list = (
   ['trunkedVlan', 'NumericRange', 1, 0],
   ['untrunkedVlan', 'NumericRange', 1, 0],
);


VIMRuntime::make_get_set('VMwareDVSVlanHealthCheckResult', 'trunkedVlan', 'untrunkedVlan');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSMtuHealthCheckResult;
our @ISA = qw(HostMemberUplinkHealthCheckResult);

our @property_list = (
   ['mtuMismatch', 'boolean', undef, 1],
   ['vlanSupportSwitchMtu', 'NumericRange', 1, 0],
   ['vlanNotSupportSwitchMtu', 'NumericRange', 1, 0],
);


VIMRuntime::make_get_set('VMwareDVSMtuHealthCheckResult', 'mtuMismatch', 'vlanSupportSwitchMtu', 'vlanNotSupportSwitchMtu');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDVSTeamingHealthCheckResult;
our @ISA = qw(HostMemberHealthCheckResult);

our @property_list = (
   ['teamingStatus', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDVSTeamingHealthCheckResult', 'teamingStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareUplinkLacpPolicy;
our @ISA = qw(InheritablePolicy);

our @property_list = (
   ['enable', 'BoolPolicy', undef, 0],
   ['mode', 'StringPolicy', undef, 0],
);


VIMRuntime::make_get_set('VMwareUplinkLacpPolicy', 'enable', 'mode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLacpGroupConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 0],
   ['name', undef, undef, 0],
   ['mode', undef, undef, 0],
   ['uplinkNum', undef, undef, 0],
   ['loadbalanceAlgorithm', undef, undef, 0],
   ['vlan', 'VMwareDvsLagVlanConfig', undef, 0],
   ['ipfix', 'VMwareDvsLagIpfixConfig', undef, 0],
   ['uplinkName', undef, 1, 0],
   ['uplinkPortKey', undef, 1, 0],
);


VIMRuntime::make_get_set('VMwareDvsLacpGroupConfig', 'key', 'name', 'mode', 'uplinkNum', 'loadbalanceAlgorithm', 'vlan', 'ipfix', 'uplinkName', 'uplinkPortKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDvsLacpGroupConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDvsLacpGroupConfig', 'VMwareDvsLacpGroupConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDvsLacpGroupConfig', 'VMwareDvsLacpGroupConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLagVlanConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vlanId', 'NumericRange', 1, 0],
);


VIMRuntime::make_get_set('VMwareDvsLagVlanConfig', 'vlanId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLagIpfixConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['ipfixEnabled', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VMwareDvsLagIpfixConfig', 'ipfixEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMwareDvsLacpGroupSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['lacpGroupConfig', 'VMwareDvsLacpGroupConfig', undef, 1],
   ['operation', undef, undef, 1],
);


VIMRuntime::make_get_set('VMwareDvsLacpGroupSpec', 'lacpGroupConfig', 'operation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVMwareDvsLacpGroupSpec;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VMwareDvsLacpGroupSpec', 'VMwareDvsLacpGroupSpec', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVMwareDvsLacpGroupSpec', 'VMwareDvsLacpGroupSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Event;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['chainId', undef, undef, 1],
   ['createdTime', undef, undef, 1],
   ['userName', undef, undef, 1],
   ['datacenter', 'DatacenterEventArgument', undef, 0],
   ['computeResource', 'ComputeResourceEventArgument', undef, 0],
   ['host', 'HostEventArgument', undef, 0],
   ['vm', 'VmEventArgument', undef, 0],
   ['ds', 'DatastoreEventArgument', undef, 0],
   ['net', 'NetworkEventArgument', undef, 0],
   ['dvs', 'DvsEventArgument', undef, 0],
   ['fullFormattedMessage', undef, undef, 0],
   ['changeTag', undef, undef, 0],
);


VIMRuntime::make_get_set('Event', 'key', 'chainId', 'createdTime', 'userName', 'datacenter', 'computeResource', 'host', 'vm', 'ds', 'net', 'dvs', 'fullFormattedMessage', 'changeTag');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEvent;
our @ISA = qw(ComplexType);

our @property_list = (
   ['Event', 'Event', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEvent', 'Event');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralEvent;
our @ISA = qw(Event);

our @property_list = (
   ['message', undef, undef, 1],
);


VIMRuntime::make_get_set('GeneralEvent', 'message');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralHostInfoEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralHostInfoEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralHostWarningEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralHostWarningEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralHostErrorEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralHostErrorEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralVmInfoEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralVmInfoEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralVmWarningEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralVmWarningEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralVmErrorEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
);


VIMRuntime::make_get_set('GeneralVmErrorEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GeneralUserEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 0],
);


VIMRuntime::make_get_set('GeneralUserEvent', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtendedEventPair;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtendedEventPair', 'key', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtendedEventPair;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtendedEventPair', 'ExtendedEventPair', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtendedEventPair', 'ExtendedEventPair');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtendedEvent;
our @ISA = qw(GeneralEvent);

our @property_list = (
   ['eventTypeId', undef, undef, 1],
   ['managedObject', 'ManagedObjectReference', undef, 1],
   ['data', 'ExtendedEventPair', 1, 0],
);


VIMRuntime::make_get_set('ExtendedEvent', 'eventTypeId', 'managedObject', 'data');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HealthStatusChangedEvent;
our @ISA = qw(Event);

our @property_list = (
   ['componentId', undef, undef, 1],
   ['oldStatus', undef, undef, 1],
   ['newStatus', undef, undef, 1],
   ['componentName', undef, undef, 1],
);


VIMRuntime::make_get_set('HealthStatusChangedEvent', 'componentId', 'oldStatus', 'newStatus', 'componentName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostInventoryUnreadableEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('HostInventoryUnreadableEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('DatacenterEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterCreatedEvent;
our @ISA = qw(DatacenterEvent);

our @property_list = (
   ['parent', 'FolderEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DatacenterCreatedEvent', 'parent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterRenamedEvent;
our @ISA = qw(DatacenterEvent);

our @property_list = (
   ['oldName', undef, undef, 1],
   ['newName', undef, undef, 1],
);


VIMRuntime::make_get_set('DatacenterRenamedEvent', 'oldName', 'newName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('SessionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServerStartedSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ServerStartedSessionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserLoginSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['ipAddress', undef, undef, 1],
   ['userAgent', undef, undef, 0],
   ['locale', undef, undef, 1],
   ['sessionId', undef, undef, 1],
);


VIMRuntime::make_get_set('UserLoginSessionEvent', 'ipAddress', 'userAgent', 'locale', 'sessionId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserLogoutSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['ipAddress', undef, undef, 0],
   ['userAgent', undef, undef, 0],
   ['callCount', undef, undef, 0],
   ['sessionId', undef, undef, 0],
   ['loginTime', undef, undef, 0],
);


VIMRuntime::make_get_set('UserLogoutSessionEvent', 'ipAddress', 'userAgent', 'callCount', 'sessionId', 'loginTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package BadUsernameSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['ipAddress', undef, undef, 1],
);


VIMRuntime::make_get_set('BadUsernameSessionEvent', 'ipAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlreadyAuthenticatedSessionEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
);


VIMRuntime::make_get_set('AlreadyAuthenticatedSessionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoAccessUserEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['ipAddress', undef, undef, 1],
);


VIMRuntime::make_get_set('NoAccessUserEvent', 'ipAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SessionTerminatedEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['sessionId', undef, undef, 1],
   ['terminatedUsername', undef, undef, 1],
);


VIMRuntime::make_get_set('SessionTerminatedEvent', 'sessionId', 'terminatedUsername');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GlobalMessageChangedEvent;
our @ISA = qw(SessionEvent);

our @property_list = (
   ['message', undef, undef, 1],
);


VIMRuntime::make_get_set('GlobalMessageChangedEvent', 'message');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UpgradeEvent;
our @ISA = qw(Event);

our @property_list = (
   ['message', undef, undef, 1],
);


VIMRuntime::make_get_set('UpgradeEvent', 'message');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InfoUpgradeEvent;
our @ISA = qw(UpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('InfoUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package WarningUpgradeEvent;
our @ISA = qw(UpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('WarningUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ErrorUpgradeEvent;
our @ISA = qw(UpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ErrorUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserUpgradeEvent;
our @ISA = qw(UpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('UserUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('HostEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConnectedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostConnectedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDisconnectedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('HostDisconnectedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostSyncFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('HostSyncFailedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConnectionLostEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostConnectionLostEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostReconnectionFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostReconnectionFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNoConnectionEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNoConnectionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedBadUsernameEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedBadUsernameEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedBadVersionEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedBadVersionEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedAlreadyManagedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['serverName', undef, undef, 1],
);


VIMRuntime::make_get_set('HostCnxFailedAlreadyManagedEvent', 'serverName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNoLicenseEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNoLicenseEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNetworkErrorEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNetworkErrorEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostRemovedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostRemovedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedCcagentUpgradeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedCcagentUpgradeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedBadCcagentEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedBadCcagentEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedAccountFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedAccountFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNoAccessEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNoAccessEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostShutdownEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', undef, undef, 1],
);


VIMRuntime::make_get_set('HostShutdownEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedNotFoundEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedNotFoundEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCnxFailedTimeoutEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCnxFailedTimeoutEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostUpgradeFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostUpgradeFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnteringMaintenanceModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('EnteringMaintenanceModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnteredMaintenanceModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('EnteredMaintenanceModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExitMaintenanceModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ExitMaintenanceModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CanceledHostOperationEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('CanceledHostOperationEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TimedOutHostOperationEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('TimedOutHostOperationEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasEnabledEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasEnabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasDisabledEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasDisabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasEnablingEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasEnablingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasDisablingEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasDisablingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasErrorEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['message', undef, undef, 0],
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('HostDasErrorEvent', 'message', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDasOkEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostDasOkEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcAgentUpgradedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VcAgentUpgradedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcAgentUninstalledEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VcAgentUninstalledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcAgentUpgradeFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('VcAgentUpgradeFailedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VcAgentUninstallFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('VcAgentUninstallFailedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAddedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostAddedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAddFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['hostname', undef, undef, 1],
);


VIMRuntime::make_get_set('HostAddFailedEvent', 'hostname');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostIpChangedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['oldIP', undef, undef, 1],
   ['newIP', undef, undef, 1],
);


VIMRuntime::make_get_set('HostIpChangedEvent', 'oldIP', 'newIP');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnteringStandbyModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('EnteringStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsEnteringStandbyModeEvent;
our @ISA = qw(EnteringStandbyModeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsEnteringStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EnteredStandbyModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('EnteredStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsEnteredStandbyModeEvent;
our @ISA = qw(EnteredStandbyModeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsEnteredStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExitingStandbyModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ExitingStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsExitingStandbyModeEvent;
our @ISA = qw(ExitingStandbyModeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsExitingStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExitedStandbyModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ExitedStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsExitedStandbyModeEvent;
our @ISA = qw(ExitedStandbyModeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsExitedStandbyModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExitStandbyModeFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ExitStandbyModeFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsExitStandbyModeFailedEvent;
our @ISA = qw(ExitStandbyModeFailedEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsExitStandbyModeFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UpdatedAgentBeingRestartedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('UpdatedAgentBeingRestartedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AccountCreatedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['spec', 'HostAccountSpec', undef, 1],
   ['group', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('AccountCreatedEvent', 'spec', 'group');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AccountRemovedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['account', undef, undef, 1],
   ['group', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('AccountRemovedEvent', 'account', 'group');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserPasswordChanged;
our @ISA = qw(HostEvent);

our @property_list = (
   ['userLogin', undef, undef, 1],
);


VIMRuntime::make_get_set('UserPasswordChanged', 'userLogin');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AccountUpdatedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['spec', 'HostAccountSpec', undef, 1],
   ['group', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('AccountUpdatedEvent', 'spec', 'group');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserAssignedToGroup;
our @ISA = qw(HostEvent);

our @property_list = (
   ['userLogin', undef, undef, 1],
   ['group', undef, undef, 1],
);


VIMRuntime::make_get_set('UserAssignedToGroup', 'userLogin', 'group');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserUnassignedFromGroup;
our @ISA = qw(HostEvent);

our @property_list = (
   ['userLogin', undef, undef, 1],
   ['group', undef, undef, 1],
);


VIMRuntime::make_get_set('UserUnassignedFromGroup', 'userLogin', 'group');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastorePrincipalConfigured;
our @ISA = qw(HostEvent);

our @property_list = (
   ['datastorePrincipal', undef, undef, 1],
);


VIMRuntime::make_get_set('DatastorePrincipalConfigured', 'datastorePrincipal');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMFSDatastoreCreatedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['datastore', 'DatastoreEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VMFSDatastoreCreatedEvent', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NASDatastoreCreatedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['datastore', 'DatastoreEventArgument', undef, 1],
);


VIMRuntime::make_get_set('NASDatastoreCreatedEvent', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LocalDatastoreCreatedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['datastore', 'DatastoreEventArgument', undef, 1],
);


VIMRuntime::make_get_set('LocalDatastoreCreatedEvent', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMFSDatastoreExtendedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['datastore', 'DatastoreEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VMFSDatastoreExtendedEvent', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMFSDatastoreExpandedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['datastore', 'DatastoreEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VMFSDatastoreExpandedEvent', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreRemovedOnHostEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['datastore', 'DatastoreEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DatastoreRemovedOnHostEvent', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreRenamedOnHostEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['oldName', undef, undef, 1],
   ['newName', undef, undef, 1],
);


VIMRuntime::make_get_set('DatastoreRenamedOnHostEvent', 'oldName', 'newName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DuplicateIpDetectedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['duplicateIP', undef, undef, 1],
   ['macAddress', undef, undef, 1],
);


VIMRuntime::make_get_set('DuplicateIpDetectedEvent', 'duplicateIP', 'macAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreDiscoveredEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['datastore', 'DatastoreEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DatastoreDiscoveredEvent', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsResourceConfigureFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('DrsResourceConfigureFailedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsResourceConfigureSyncedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsResourceConfigureSyncedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostGetShortNameFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostGetShortNameFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostShortNameToIpFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['shortName', undef, undef, 1],
);


VIMRuntime::make_get_set('HostShortNameToIpFailedEvent', 'shortName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostIpToShortNameFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostIpToShortNameFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostPrimaryAgentNotShortNameEvent;
our @ISA = qw(HostDasEvent);

our @property_list = (
   ['primaryAgent', undef, undef, 1],
);


VIMRuntime::make_get_set('HostPrimaryAgentNotShortNameEvent', 'primaryAgent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostNotInClusterEvent;
our @ISA = qw(HostDasEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostNotInClusterEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostIsolationIpPingFailedEvent;
our @ISA = qw(HostDasEvent);

our @property_list = (
   ['isolationIp', undef, undef, 1],
);


VIMRuntime::make_get_set('HostIsolationIpPingFailedEvent', 'isolationIp');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostIpInconsistentEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['ipAddress', undef, undef, 1],
   ['ipAddress2', undef, undef, 1],
);


VIMRuntime::make_get_set('HostIpInconsistentEvent', 'ipAddress', 'ipAddress2');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostUserWorldSwapNotEnabledEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostUserWorldSwapNotEnabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostNonCompliantEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostNonCompliantEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCompliantEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostCompliantEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostComplianceCheckedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['profile', 'ProfileEventArgument', undef, 1],
);


VIMRuntime::make_get_set('HostComplianceCheckedEvent', 'profile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterComplianceCheckedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
   ['profile', 'ProfileEventArgument', undef, 1],
);


VIMRuntime::make_get_set('ClusterComplianceCheckedEvent', 'profile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileEvent;
our @ISA = qw(Event);

our @property_list = (
   ['profile', 'ProfileEventArgument', undef, 1],
);


VIMRuntime::make_get_set('ProfileEvent', 'profile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileCreatedEvent;
our @ISA = qw(ProfileEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ProfileCreatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileRemovedEvent;
our @ISA = qw(ProfileEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ProfileRemovedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileAssociatedEvent;
our @ISA = qw(ProfileEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ProfileAssociatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileDissociatedEvent;
our @ISA = qw(ProfileEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ProfileDissociatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConfigAppliedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostConfigAppliedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileReferenceHostChangedEvent;
our @ISA = qw(ProfileEvent);

our @property_list = (
   ['referenceHost', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ProfileReferenceHostChangedEvent', 'referenceHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileChangedEvent;
our @ISA = qw(ProfileEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ProfileChangedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostProfileAppliedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['profile', 'ProfileEventArgument', undef, 1],
);


VIMRuntime::make_get_set('HostProfileAppliedEvent', 'profile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostShortNameInconsistentEvent;
our @ISA = qw(HostDasEvent);

our @property_list = (
   ['shortName', undef, undef, 1],
   ['shortName2', undef, undef, 1],
);


VIMRuntime::make_get_set('HostShortNameInconsistentEvent', 'shortName', 'shortName2');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostNoRedundantManagementNetworkEvent;
our @ISA = qw(HostDasEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostNoRedundantManagementNetworkEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostNoAvailableNetworksEvent;
our @ISA = qw(HostDasEvent);

our @property_list = (
   ['ips', undef, undef, 0],
);


VIMRuntime::make_get_set('HostNoAvailableNetworksEvent', 'ips');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostExtraNetworksEvent;
our @ISA = qw(HostDasEvent);

our @property_list = (
   ['ips', undef, undef, 0],
);


VIMRuntime::make_get_set('HostExtraNetworksEvent', 'ips');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostNoHAEnabledPortGroupsEvent;
our @ISA = qw(HostDasEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostNoHAEnabledPortGroupsEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostMissingNetworksEvent;
our @ISA = qw(HostDasEvent);

our @property_list = (
   ['ips', undef, undef, 0],
);


VIMRuntime::make_get_set('HostMissingNetworksEvent', 'ips');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VnicPortArgument;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vnic', undef, undef, 1],
   ['port', 'DistributedVirtualSwitchPortConnection', undef, 1],
);


VIMRuntime::make_get_set('VnicPortArgument', 'vnic', 'port');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVnicPortArgument;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VnicPortArgument', 'VnicPortArgument', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVnicPortArgument', 'VnicPortArgument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostVnicConnectedToCustomizedDVPortEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['vnic', 'VnicPortArgument', undef, 1],
);


VIMRuntime::make_get_set('HostVnicConnectedToCustomizedDVPortEvent', 'vnic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GhostDvsProxySwitchDetectedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['switchUuid', undef, 1, 1],
);


VIMRuntime::make_get_set('GhostDvsProxySwitchDetectedEvent', 'switchUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GhostDvsProxySwitchRemovedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['switchUuid', undef, 1, 1],
);


VIMRuntime::make_get_set('GhostDvsProxySwitchRemovedEvent', 'switchUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmEvent;
our @ISA = qw(Event);

our @property_list = (
   ['template', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VmEvent', 'template');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmPoweredOffEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmPoweredOffEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmPoweredOnEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmPoweredOnEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmSuspendedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmSuspendedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmStartingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmStartingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmStoppingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmStoppingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmSuspendingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmSuspendingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmResumingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmResumingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDisconnectedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmDisconnectedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRemoteConsoleConnectedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmRemoteConsoleConnectedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRemoteConsoleDisconnectedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmRemoteConsoleDisconnectedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDiscoveredEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmDiscoveredEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmOrphanedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmOrphanedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmBeingCreatedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['configSpec', 'VirtualMachineConfigSpec', undef, 0],
);


VIMRuntime::make_get_set('VmBeingCreatedEvent', 'configSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmCreatedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmCreatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmStartRecordingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmStartRecordingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmEndRecordingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmEndRecordingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmStartReplayingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmStartReplayingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmEndReplayingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmEndReplayingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRegisteredEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmRegisteredEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmAutoRenameEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['oldName', undef, undef, 1],
   ['newName', undef, undef, 1],
);


VIMRuntime::make_get_set('VmAutoRenameEvent', 'oldName', 'newName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmBeingHotMigratedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['destHost', 'HostEventArgument', undef, 1],
   ['destDatacenter', 'DatacenterEventArgument', undef, 0],
   ['destDatastore', 'DatastoreEventArgument', undef, 0],
);


VIMRuntime::make_get_set('VmBeingHotMigratedEvent', 'destHost', 'destDatacenter', 'destDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmResettingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmResettingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmStaticMacConflictEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['conflictedVm', 'VmEventArgument', undef, 1],
   ['mac', undef, undef, 1],
);


VIMRuntime::make_get_set('VmStaticMacConflictEvent', 'conflictedVm', 'mac');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMacConflictEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['conflictedVm', 'VmEventArgument', undef, 1],
   ['mac', undef, undef, 1],
);


VIMRuntime::make_get_set('VmMacConflictEvent', 'conflictedVm', 'mac');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmBeingDeployedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['srcTemplate', 'VmEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VmBeingDeployedEvent', 'srcTemplate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDeployFailedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['destDatastore', 'EntityEventArgument', undef, 1],
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmDeployFailedEvent', 'destDatastore', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDeployedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['srcTemplate', 'VmEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VmDeployedEvent', 'srcTemplate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMacChangedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['adapter', undef, undef, 1],
   ['oldMac', undef, undef, 1],
   ['newMac', undef, undef, 1],
);


VIMRuntime::make_get_set('VmMacChangedEvent', 'adapter', 'oldMac', 'newMac');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMacAssignedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['adapter', undef, undef, 1],
   ['mac', undef, undef, 1],
);


VIMRuntime::make_get_set('VmMacAssignedEvent', 'adapter', 'mac');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmUuidConflictEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['conflictedVm', 'VmEventArgument', undef, 1],
   ['uuid', undef, undef, 1],
);


VIMRuntime::make_get_set('VmUuidConflictEvent', 'conflictedVm', 'uuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmInstanceUuidConflictEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['conflictedVm', 'VmEventArgument', undef, 1],
   ['instanceUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('VmInstanceUuidConflictEvent', 'conflictedVm', 'instanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmBeingMigratedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['destHost', 'HostEventArgument', undef, 1],
   ['destDatacenter', 'DatacenterEventArgument', undef, 0],
   ['destDatastore', 'DatastoreEventArgument', undef, 0],
);


VIMRuntime::make_get_set('VmBeingMigratedEvent', 'destHost', 'destDatacenter', 'destDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedMigrateEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['destHost', 'HostEventArgument', undef, 1],
   ['reason', 'LocalizedMethodFault', undef, 1],
   ['destDatacenter', 'DatacenterEventArgument', undef, 0],
   ['destDatastore', 'DatastoreEventArgument', undef, 0],
);


VIMRuntime::make_get_set('VmFailedMigrateEvent', 'destHost', 'reason', 'destDatacenter', 'destDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMigratedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['sourceHost', 'HostEventArgument', undef, 1],
   ['sourceDatacenter', 'DatacenterEventArgument', undef, 0],
   ['sourceDatastore', 'DatastoreEventArgument', undef, 0],
);


VIMRuntime::make_get_set('VmMigratedEvent', 'sourceHost', 'sourceDatacenter', 'sourceDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmUnsupportedStartingEvent;
our @ISA = qw(VmStartingEvent);

our @property_list = (
   ['guestId', undef, undef, 1],
);


VIMRuntime::make_get_set('VmUnsupportedStartingEvent', 'guestId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsVmMigratedEvent;
our @ISA = qw(VmMigratedEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsVmMigratedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsVmPoweredOnEvent;
our @ISA = qw(VmPoweredOnEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsVmPoweredOnEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsRuleViolationEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsRuleViolationEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsRuleComplianceEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsRuleComplianceEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRelocateSpecEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmRelocateSpecEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmBeingRelocatedEvent;
our @ISA = qw(VmRelocateSpecEvent);

our @property_list = (
   ['destHost', 'HostEventArgument', undef, 1],
   ['destDatacenter', 'DatacenterEventArgument', undef, 0],
   ['destDatastore', 'DatastoreEventArgument', undef, 0],
);


VIMRuntime::make_get_set('VmBeingRelocatedEvent', 'destHost', 'destDatacenter', 'destDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRelocatedEvent;
our @ISA = qw(VmRelocateSpecEvent);

our @property_list = (
   ['sourceHost', 'HostEventArgument', undef, 1],
   ['sourceDatacenter', 'DatacenterEventArgument', undef, 0],
   ['sourceDatastore', 'DatastoreEventArgument', undef, 0],
);


VIMRuntime::make_get_set('VmRelocatedEvent', 'sourceHost', 'sourceDatacenter', 'sourceDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRelocateFailedEvent;
our @ISA = qw(VmRelocateSpecEvent);

our @property_list = (
   ['destHost', 'HostEventArgument', undef, 1],
   ['reason', 'LocalizedMethodFault', undef, 1],
   ['destDatacenter', 'DatacenterEventArgument', undef, 0],
   ['destDatastore', 'DatastoreEventArgument', undef, 0],
);


VIMRuntime::make_get_set('VmRelocateFailedEvent', 'destHost', 'reason', 'destDatacenter', 'destDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmEmigratingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmEmigratingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmCloneEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmCloneEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmBeingClonedEvent;
our @ISA = qw(VmCloneEvent);

our @property_list = (
   ['destFolder', 'FolderEventArgument', undef, 1],
   ['destName', undef, undef, 1],
   ['destHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VmBeingClonedEvent', 'destFolder', 'destName', 'destHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmBeingClonedNoFolderEvent;
our @ISA = qw(VmCloneEvent);

our @property_list = (
   ['destName', undef, undef, 1],
   ['destHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VmBeingClonedNoFolderEvent', 'destName', 'destHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmCloneFailedEvent;
our @ISA = qw(VmCloneEvent);

our @property_list = (
   ['destFolder', 'FolderEventArgument', undef, 1],
   ['destName', undef, undef, 1],
   ['destHost', 'HostEventArgument', undef, 1],
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmCloneFailedEvent', 'destFolder', 'destName', 'destHost', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmClonedEvent;
our @ISA = qw(VmCloneEvent);

our @property_list = (
   ['sourceVm', 'VmEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VmClonedEvent', 'sourceVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmResourceReallocatedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmResourceReallocatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRenamedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['oldName', undef, undef, 1],
   ['newName', undef, undef, 1],
);


VIMRuntime::make_get_set('VmRenamedEvent', 'oldName', 'newName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDateRolledBackEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmDateRolledBackEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmNoNetworkAccessEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['destHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VmNoNetworkAccessEvent', 'destHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDiskFailedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['disk', undef, undef, 1],
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmDiskFailedEvent', 'disk', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedToPowerOnEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmFailedToPowerOnEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedToPowerOffEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmFailedToPowerOffEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedToSuspendEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmFailedToSuspendEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedToResetEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmFailedToResetEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedToShutdownGuestEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmFailedToShutdownGuestEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedToRebootGuestEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmFailedToRebootGuestEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedToStandbyGuestEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmFailedToStandbyGuestEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRemovedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmRemovedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmGuestShutdownEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmGuestShutdownEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmGuestRebootEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmGuestRebootEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmGuestStandbyEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmGuestStandbyEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmUpgradingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['version', undef, undef, 1],
);


VIMRuntime::make_get_set('VmUpgradingEvent', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmUpgradeCompleteEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['version', undef, undef, 1],
);


VIMRuntime::make_get_set('VmUpgradeCompleteEvent', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmUpgradeFailedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmUpgradeFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRestartedOnAlternateHostEvent;
our @ISA = qw(VmPoweredOnEvent);

our @property_list = (
   ['sourceHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VmRestartedOnAlternateHostEvent', 'sourceHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmReconfiguredEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['configSpec', 'VirtualMachineConfigSpec', undef, 1],
);


VIMRuntime::make_get_set('VmReconfiguredEvent', 'configSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMessageEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['message', undef, undef, 1],
   ['messageInfo', 'VirtualMachineMessage', 1, 0],
);


VIMRuntime::make_get_set('VmMessageEvent', 'message', 'messageInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMessageWarningEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['message', undef, undef, 1],
   ['messageInfo', 'VirtualMachineMessage', 1, 0],
);


VIMRuntime::make_get_set('VmMessageWarningEvent', 'message', 'messageInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMessageErrorEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['message', undef, undef, 1],
   ['messageInfo', 'VirtualMachineMessage', 1, 0],
);


VIMRuntime::make_get_set('VmMessageErrorEvent', 'message', 'messageInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmConfigMissingEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmConfigMissingEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmPowerOffOnIsolationEvent;
our @ISA = qw(VmPoweredOffEvent);

our @property_list = (
   ['isolatedHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VmPowerOffOnIsolationEvent', 'isolatedHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmShutdownOnIsolationEvent;
our @ISA = qw(VmPoweredOffEvent);

our @property_list = (
   ['isolatedHost', 'HostEventArgument', undef, 1],
   ['shutdownResult', undef, undef, 0],
);


VIMRuntime::make_get_set('VmShutdownOnIsolationEvent', 'isolatedHost', 'shutdownResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailoverFailed;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VmFailoverFailed', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDasBeingResetEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('VmDasBeingResetEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDasResetFailedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmDasResetFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMaxRestartCountReached;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmMaxRestartCountReached');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMaxFTRestartCountReached;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmMaxFTRestartCountReached');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDasBeingResetWithScreenshotEvent;
our @ISA = qw(VmDasBeingResetEvent);

our @property_list = (
   ['screenshotFilePath', undef, undef, 1],
);


VIMRuntime::make_get_set('VmDasBeingResetWithScreenshotEvent', 'screenshotFilePath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotEnoughResourcesToStartVmEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('NotEnoughResourcesToStartVmEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmUuidAssignedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['uuid', undef, undef, 1],
);


VIMRuntime::make_get_set('VmUuidAssignedEvent', 'uuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmInstanceUuidAssignedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['instanceUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('VmInstanceUuidAssignedEvent', 'instanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmUuidChangedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['oldUuid', undef, undef, 1],
   ['newUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('VmUuidChangedEvent', 'oldUuid', 'newUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmInstanceUuidChangedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['oldInstanceUuid', undef, undef, 1],
   ['newInstanceUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('VmInstanceUuidChangedEvent', 'oldInstanceUuid', 'newInstanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmWwnConflictEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['conflictedVms', 'VmEventArgument', 1, 0],
   ['conflictedHosts', 'HostEventArgument', 1, 0],
   ['wwn', undef, undef, 1],
);


VIMRuntime::make_get_set('VmWwnConflictEvent', 'conflictedVms', 'conflictedHosts', 'wwn');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmAcquiredMksTicketEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmAcquiredMksTicketEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmAcquiredTicketEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['ticketType', undef, undef, 1],
);


VIMRuntime::make_get_set('VmAcquiredTicketEvent', 'ticketType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostWwnConflictEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['conflictedVms', 'VmEventArgument', 1, 0],
   ['conflictedHosts', 'HostEventArgument', 1, 0],
   ['wwn', undef, undef, 1],
);


VIMRuntime::make_get_set('HostWwnConflictEvent', 'conflictedVms', 'conflictedHosts', 'wwn');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmWwnAssignedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['nodeWwns', undef, 1, 1],
   ['portWwns', undef, 1, 1],
);


VIMRuntime::make_get_set('VmWwnAssignedEvent', 'nodeWwns', 'portWwns');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmWwnChangedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['oldNodeWwns', undef, 1, 0],
   ['oldPortWwns', undef, 1, 0],
   ['newNodeWwns', undef, 1, 0],
   ['newPortWwns', undef, 1, 0],
);


VIMRuntime::make_get_set('VmWwnChangedEvent', 'oldNodeWwns', 'oldPortWwns', 'newNodeWwns', 'newPortWwns');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmSecondaryAddedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmSecondaryAddedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFaultToleranceTurnedOffEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmFaultToleranceTurnedOffEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFaultToleranceStateChangedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['oldState', 'VirtualMachineFaultToleranceState', undef, 1],
   ['newState', 'VirtualMachineFaultToleranceState', undef, 1],
);


VIMRuntime::make_get_set('VmFaultToleranceStateChangedEvent', 'oldState', 'newState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmSecondaryDisabledEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmSecondaryDisabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmSecondaryDisabledBySystemEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VmSecondaryDisabledBySystemEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmSecondaryEnabledEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmSecondaryEnabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmStartingSecondaryEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmStartingSecondaryEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmSecondaryStartedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmSecondaryStartedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedUpdatingSecondaryConfig;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmFailedUpdatingSecondaryConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedStartingSecondaryEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('VmFailedStartingSecondaryEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmTimedoutStartingSecondaryEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['timeout', undef, undef, 0],
);


VIMRuntime::make_get_set('VmTimedoutStartingSecondaryEvent', 'timeout');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmNoCompatibleHostForSecondaryEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmNoCompatibleHostForSecondaryEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmPrimaryFailoverEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('VmPrimaryFailoverEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFaultToleranceVmTerminatedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('VmFaultToleranceVmTerminatedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostWwnChangedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['oldNodeWwns', undef, 1, 0],
   ['oldPortWwns', undef, 1, 0],
   ['newNodeWwns', undef, 1, 0],
   ['newPortWwns', undef, 1, 0],
);


VIMRuntime::make_get_set('HostWwnChangedEvent', 'oldNodeWwns', 'oldPortWwns', 'newNodeWwns', 'newPortWwns');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAdminDisableEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostAdminDisableEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAdminEnableEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostAdminEnableEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostEnableAdminFailedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['permissions', 'Permission', 1, 1],
);


VIMRuntime::make_get_set('HostEnableAdminFailedEvent', 'permissions');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedRelayoutOnVmfs2DatastoreEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmFailedRelayoutOnVmfs2DatastoreEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFailedRelayoutEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('VmFailedRelayoutEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRelayoutSuccessfulEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmRelayoutSuccessfulEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRelayoutUpToDateEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmRelayoutUpToDateEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmConnectedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmConnectedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmPoweringOnWithCustomizedDVPortEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['vnic', 'VnicPortArgument', 1, 1],
);


VIMRuntime::make_get_set('VmPoweringOnWithCustomizedDVPortEvent', 'vnic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDasUpdateErrorEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmDasUpdateErrorEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoMaintenanceModeDrsRecommendationForVM;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('NoMaintenanceModeDrsRecommendationForVM');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDasUpdateOkEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmDasUpdateOkEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskEvent;
our @ISA = qw(Event);

our @property_list = (
   ['scheduledTask', 'ScheduledTaskEventArgument', undef, 1],
   ['entity', 'ManagedEntityEventArgument', undef, 1],
);


VIMRuntime::make_get_set('ScheduledTaskEvent', 'scheduledTask', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskCreatedEvent;
our @ISA = qw(ScheduledTaskEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ScheduledTaskCreatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskStartedEvent;
our @ISA = qw(ScheduledTaskEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ScheduledTaskStartedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskRemovedEvent;
our @ISA = qw(ScheduledTaskEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ScheduledTaskRemovedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskReconfiguredEvent;
our @ISA = qw(ScheduledTaskEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ScheduledTaskReconfiguredEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskCompletedEvent;
our @ISA = qw(ScheduledTaskEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ScheduledTaskCompletedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskFailedEvent;
our @ISA = qw(ScheduledTaskEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('ScheduledTaskFailedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskEmailCompletedEvent;
our @ISA = qw(ScheduledTaskEvent);

our @property_list = (
   ['to', undef, undef, 1],
);


VIMRuntime::make_get_set('ScheduledTaskEmailCompletedEvent', 'to');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskEmailFailedEvent;
our @ISA = qw(ScheduledTaskEvent);

our @property_list = (
   ['to', undef, undef, 1],
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('ScheduledTaskEmailFailedEvent', 'to', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmEvent;
our @ISA = qw(Event);

our @property_list = (
   ['alarm', 'AlarmEventArgument', undef, 1],
);


VIMRuntime::make_get_set('AlarmEvent', 'alarm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmCreatedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
);


VIMRuntime::make_get_set('AlarmCreatedEvent', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmStatusChangedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['source', 'ManagedEntityEventArgument', undef, 1],
   ['entity', 'ManagedEntityEventArgument', undef, 1],
   ['from', undef, undef, 1],
   ['to', undef, undef, 1],
);


VIMRuntime::make_get_set('AlarmStatusChangedEvent', 'source', 'entity', 'from', 'to');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmActionTriggeredEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['source', 'ManagedEntityEventArgument', undef, 1],
   ['entity', 'ManagedEntityEventArgument', undef, 1],
);


VIMRuntime::make_get_set('AlarmActionTriggeredEvent', 'source', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmEmailCompletedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
   ['to', undef, undef, 1],
);


VIMRuntime::make_get_set('AlarmEmailCompletedEvent', 'entity', 'to');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmEmailFailedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
   ['to', undef, undef, 1],
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('AlarmEmailFailedEvent', 'entity', 'to', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmSnmpCompletedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
);


VIMRuntime::make_get_set('AlarmSnmpCompletedEvent', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmSnmpFailedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('AlarmSnmpFailedEvent', 'entity', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmScriptCompleteEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
   ['script', undef, undef, 1],
);


VIMRuntime::make_get_set('AlarmScriptCompleteEvent', 'entity', 'script');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmScriptFailedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
   ['script', undef, undef, 1],
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('AlarmScriptFailedEvent', 'entity', 'script', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmRemovedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
);


VIMRuntime::make_get_set('AlarmRemovedEvent', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmReconfiguredEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
);


VIMRuntime::make_get_set('AlarmReconfiguredEvent', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmAcknowledgedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['source', 'ManagedEntityEventArgument', undef, 1],
   ['entity', 'ManagedEntityEventArgument', undef, 1],
);


VIMRuntime::make_get_set('AlarmAcknowledgedEvent', 'source', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmClearedEvent;
our @ISA = qw(AlarmEvent);

our @property_list = (
   ['source', 'ManagedEntityEventArgument', undef, 1],
   ['entity', 'ManagedEntityEventArgument', undef, 1],
   ['from', undef, undef, 1],
);


VIMRuntime::make_get_set('AlarmClearedEvent', 'source', 'entity', 'from');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('CustomFieldEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldDefEvent;
our @ISA = qw(CustomFieldEvent);

our @property_list = (
   ['fieldKey', undef, undef, 1],
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('CustomFieldDefEvent', 'fieldKey', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldDefAddedEvent;
our @ISA = qw(CustomFieldDefEvent);

our @property_list = (
);


VIMRuntime::make_get_set('CustomFieldDefAddedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldDefRemovedEvent;
our @ISA = qw(CustomFieldDefEvent);

our @property_list = (
);


VIMRuntime::make_get_set('CustomFieldDefRemovedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldDefRenamedEvent;
our @ISA = qw(CustomFieldDefEvent);

our @property_list = (
   ['newName', undef, undef, 1],
);


VIMRuntime::make_get_set('CustomFieldDefRenamedEvent', 'newName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomFieldValueChangedEvent;
our @ISA = qw(CustomFieldEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
   ['fieldKey', undef, undef, 1],
   ['name', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('CustomFieldValueChangedEvent', 'entity', 'fieldKey', 'name', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AuthorizationEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('AuthorizationEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PermissionEvent;
our @ISA = qw(AuthorizationEvent);

our @property_list = (
   ['entity', 'ManagedEntityEventArgument', undef, 1],
   ['principal', undef, undef, 1],
   ['group', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('PermissionEvent', 'entity', 'principal', 'group');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PermissionAddedEvent;
our @ISA = qw(PermissionEvent);

our @property_list = (
   ['role', 'RoleEventArgument', undef, 1],
   ['propagate', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('PermissionAddedEvent', 'role', 'propagate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PermissionUpdatedEvent;
our @ISA = qw(PermissionEvent);

our @property_list = (
   ['role', 'RoleEventArgument', undef, 1],
   ['propagate', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('PermissionUpdatedEvent', 'role', 'propagate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PermissionRemovedEvent;
our @ISA = qw(PermissionEvent);

our @property_list = (
);


VIMRuntime::make_get_set('PermissionRemovedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RoleEvent;
our @ISA = qw(AuthorizationEvent);

our @property_list = (
   ['role', 'RoleEventArgument', undef, 1],
);


VIMRuntime::make_get_set('RoleEvent', 'role');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RoleAddedEvent;
our @ISA = qw(RoleEvent);

our @property_list = (
   ['privilegeList', undef, 1, 0],
);


VIMRuntime::make_get_set('RoleAddedEvent', 'privilegeList');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RoleUpdatedEvent;
our @ISA = qw(RoleEvent);

our @property_list = (
   ['privilegeList', undef, 1, 0],
);


VIMRuntime::make_get_set('RoleUpdatedEvent', 'privilegeList');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RoleRemovedEvent;
our @ISA = qw(RoleEvent);

our @property_list = (
);


VIMRuntime::make_get_set('RoleRemovedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreEvent;
our @ISA = qw(Event);

our @property_list = (
   ['datastore', 'DatastoreEventArgument', undef, 0],
);


VIMRuntime::make_get_set('DatastoreEvent', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreDestroyedEvent;
our @ISA = qw(DatastoreEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DatastoreDestroyedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreRenamedEvent;
our @ISA = qw(DatastoreEvent);

our @property_list = (
   ['oldName', undef, undef, 1],
   ['newName', undef, undef, 1],
);


VIMRuntime::make_get_set('DatastoreRenamedEvent', 'oldName', 'newName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreCapacityIncreasedEvent;
our @ISA = qw(DatastoreEvent);

our @property_list = (
   ['oldCapacity', undef, undef, 1],
   ['newCapacity', undef, undef, 1],
);


VIMRuntime::make_get_set('DatastoreCapacityIncreasedEvent', 'oldCapacity', 'newCapacity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreDuplicatedEvent;
our @ISA = qw(DatastoreEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DatastoreDuplicatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreFileEvent;
our @ISA = qw(DatastoreEvent);

our @property_list = (
   ['targetFile', undef, undef, 1],
);


VIMRuntime::make_get_set('DatastoreFileEvent', 'targetFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreFileCopiedEvent;
our @ISA = qw(DatastoreFileEvent);

our @property_list = (
   ['sourceDatastore', 'DatastoreEventArgument', undef, 1],
   ['sourceFile', undef, undef, 1],
);


VIMRuntime::make_get_set('DatastoreFileCopiedEvent', 'sourceDatastore', 'sourceFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreFileMovedEvent;
our @ISA = qw(DatastoreFileEvent);

our @property_list = (
   ['sourceDatastore', 'DatastoreEventArgument', undef, 1],
   ['sourceFile', undef, undef, 1],
);


VIMRuntime::make_get_set('DatastoreFileMovedEvent', 'sourceDatastore', 'sourceFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreFileDeletedEvent;
our @ISA = qw(DatastoreFileEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DatastoreFileDeletedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NonVIWorkloadDetectedOnDatastoreEvent;
our @ISA = qw(DatastoreEvent);

our @property_list = (
);


VIMRuntime::make_get_set('NonVIWorkloadDetectedOnDatastoreEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreIORMReconfiguredEvent;
our @ISA = qw(DatastoreEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DatastoreIORMReconfiguredEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskEvent;
our @ISA = qw(Event);

our @property_list = (
   ['info', 'TaskInfo', undef, 1],
);


VIMRuntime::make_get_set('TaskEvent', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskTimeoutEvent;
our @ISA = qw(TaskEvent);

our @property_list = (
);


VIMRuntime::make_get_set('TaskTimeoutEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('LicenseEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ServerLicenseExpiredEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
   ['product', undef, undef, 1],
);


VIMRuntime::make_get_set('ServerLicenseExpiredEvent', 'product');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostLicenseExpiredEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostLicenseExpiredEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMotionLicenseExpiredEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VMotionLicenseExpiredEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoLicenseEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
   ['feature', 'LicenseFeatureInfo', undef, 1],
);


VIMRuntime::make_get_set('NoLicenseEvent', 'feature');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseServerUnavailableEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
   ['licenseServer', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseServerUnavailableEvent', 'licenseServer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseServerAvailableEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
   ['licenseServer', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseServerAvailableEvent', 'licenseServer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseExpiredEvent;
our @ISA = qw(Event);

our @property_list = (
   ['feature', 'LicenseFeatureInfo', undef, 1],
);


VIMRuntime::make_get_set('LicenseExpiredEvent', 'feature');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidEditionEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
   ['feature', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidEditionEvent', 'feature');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostInventoryFullEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
   ['capacity', undef, undef, 1],
);


VIMRuntime::make_get_set('HostInventoryFullEvent', 'capacity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseRestrictedEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
);


VIMRuntime::make_get_set('LicenseRestrictedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IncorrectHostInformationEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
);


VIMRuntime::make_get_set('IncorrectHostInformationEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnlicensedVirtualMachinesEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
   ['unlicensed', undef, undef, 1],
   ['available', undef, undef, 1],
);


VIMRuntime::make_get_set('UnlicensedVirtualMachinesEvent', 'unlicensed', 'available');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnlicensedVirtualMachinesFoundEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
   ['available', undef, undef, 1],
);


VIMRuntime::make_get_set('UnlicensedVirtualMachinesFoundEvent', 'available');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AllVirtualMachinesLicensedEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
);


VIMRuntime::make_get_set('AllVirtualMachinesLicensedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseNonComplianceEvent;
our @ISA = qw(LicenseEvent);

our @property_list = (
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseNonComplianceEvent', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('MigrationEvent', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationWarningEvent;
our @ISA = qw(MigrationEvent);

our @property_list = (
);


VIMRuntime::make_get_set('MigrationWarningEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationErrorEvent;
our @ISA = qw(MigrationEvent);

our @property_list = (
);


VIMRuntime::make_get_set('MigrationErrorEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationHostWarningEvent;
our @ISA = qw(MigrationEvent);

our @property_list = (
   ['dstHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('MigrationHostWarningEvent', 'dstHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationHostErrorEvent;
our @ISA = qw(MigrationEvent);

our @property_list = (
   ['dstHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('MigrationHostErrorEvent', 'dstHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationResourceWarningEvent;
our @ISA = qw(MigrationEvent);

our @property_list = (
   ['dstPool', 'ResourcePoolEventArgument', undef, 1],
   ['dstHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('MigrationResourceWarningEvent', 'dstPool', 'dstHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationResourceErrorEvent;
our @ISA = qw(MigrationEvent);

our @property_list = (
   ['dstPool', 'ResourcePoolEventArgument', undef, 1],
   ['dstHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('MigrationResourceErrorEvent', 'dstPool', 'dstHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasEnabledEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DasEnabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasDisabledEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DasDisabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasAdmissionControlDisabledEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DasAdmissionControlDisabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasAdmissionControlEnabledEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DasAdmissionControlEnabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasHostFailedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
   ['failedHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DasHostFailedEvent', 'failedHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasHostIsolatedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
   ['isolatedHost', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DasHostIsolatedEvent', 'isolatedHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasClusterIsolatedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DasClusterIsolatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasAgentUnavailableEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DasAgentUnavailableEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasAgentFoundEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DasAgentFoundEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientFailoverResourcesEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('InsufficientFailoverResourcesEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FailoverLevelRestored;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('FailoverLevelRestored');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterOvercommittedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterOvercommittedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostOvercommittedEvent;
our @ISA = qw(ClusterOvercommittedEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostOvercommittedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterStatusChangedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
   ['oldStatus', undef, undef, 1],
   ['newStatus', undef, undef, 1],
);


VIMRuntime::make_get_set('ClusterStatusChangedEvent', 'oldStatus', 'newStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostStatusChangedEvent;
our @ISA = qw(ClusterStatusChangedEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostStatusChangedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterCreatedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
   ['parent', 'FolderEventArgument', undef, 1],
);


VIMRuntime::make_get_set('ClusterCreatedEvent', 'parent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterDestroyedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterDestroyedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsEnabledEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
   ['behavior', undef, undef, 1],
);


VIMRuntime::make_get_set('DrsEnabledEvent', 'behavior');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsDisabledEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsDisabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClusterReconfiguredEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ClusterReconfiguredEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostMonitoringStateChangedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
   ['state', undef, undef, 1],
);


VIMRuntime::make_get_set('HostMonitoringStateChangedEvent', 'state');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmHealthMonitoringStateChangedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
   ['state', undef, undef, 1],
);


VIMRuntime::make_get_set('VmHealthMonitoringStateChangedEvent', 'state');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolEvent;
our @ISA = qw(Event);

our @property_list = (
   ['resourcePool', 'ResourcePoolEventArgument', undef, 1],
);


VIMRuntime::make_get_set('ResourcePoolEvent', 'resourcePool');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolCreatedEvent;
our @ISA = qw(ResourcePoolEvent);

our @property_list = (
   ['parent', 'ResourcePoolEventArgument', undef, 1],
);


VIMRuntime::make_get_set('ResourcePoolCreatedEvent', 'parent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolDestroyedEvent;
our @ISA = qw(ResourcePoolEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ResourcePoolDestroyedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolMovedEvent;
our @ISA = qw(ResourcePoolEvent);

our @property_list = (
   ['oldParent', 'ResourcePoolEventArgument', undef, 1],
   ['newParent', 'ResourcePoolEventArgument', undef, 1],
);


VIMRuntime::make_get_set('ResourcePoolMovedEvent', 'oldParent', 'newParent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolReconfiguredEvent;
our @ISA = qw(ResourcePoolEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ResourcePoolReconfiguredEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceViolatedEvent;
our @ISA = qw(ResourcePoolEvent);

our @property_list = (
);


VIMRuntime::make_get_set('ResourceViolatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmResourcePoolMovedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['oldParent', 'ResourcePoolEventArgument', undef, 1],
   ['newParent', 'ResourcePoolEventArgument', undef, 1],
);


VIMRuntime::make_get_set('VmResourcePoolMovedEvent', 'oldParent', 'newParent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TemplateUpgradeEvent;
our @ISA = qw(Event);

our @property_list = (
   ['legacyTemplate', undef, undef, 1],
);


VIMRuntime::make_get_set('TemplateUpgradeEvent', 'legacyTemplate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TemplateBeingUpgradedEvent;
our @ISA = qw(TemplateUpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('TemplateBeingUpgradedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TemplateUpgradeFailedEvent;
our @ISA = qw(TemplateUpgradeEvent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('TemplateUpgradeFailedEvent', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TemplateUpgradedEvent;
our @ISA = qw(TemplateUpgradeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('TemplateUpgradedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['logLocation', undef, undef, 0],
);


VIMRuntime::make_get_set('CustomizationEvent', 'logLocation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationStartedEvent;
our @ISA = qw(CustomizationEvent);

our @property_list = (
);


VIMRuntime::make_get_set('CustomizationStartedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationSucceeded;
our @ISA = qw(CustomizationEvent);

our @property_list = (
);


VIMRuntime::make_get_set('CustomizationSucceeded');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationFailed;
our @ISA = qw(CustomizationEvent);

our @property_list = (
);


VIMRuntime::make_get_set('CustomizationFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationUnknownFailure;
our @ISA = qw(CustomizationFailed);

our @property_list = (
);


VIMRuntime::make_get_set('CustomizationUnknownFailure');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationSysprepFailed;
our @ISA = qw(CustomizationFailed);

our @property_list = (
   ['sysprepVersion', undef, undef, 1],
   ['systemVersion', undef, undef, 1],
);


VIMRuntime::make_get_set('CustomizationSysprepFailed', 'sysprepVersion', 'systemVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationLinuxIdentityFailed;
our @ISA = qw(CustomizationFailed);

our @property_list = (
);


VIMRuntime::make_get_set('CustomizationLinuxIdentityFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationNetworkSetupFailed;
our @ISA = qw(CustomizationFailed);

our @property_list = (
);


VIMRuntime::make_get_set('CustomizationNetworkSetupFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LockerMisconfiguredEvent;
our @ISA = qw(Event);

our @property_list = (
   ['datastore', 'DatastoreEventArgument', undef, 1],
);


VIMRuntime::make_get_set('LockerMisconfiguredEvent', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LockerReconfiguredEvent;
our @ISA = qw(Event);

our @property_list = (
   ['oldDatastore', 'DatastoreEventArgument', undef, 0],
   ['newDatastore', 'DatastoreEventArgument', undef, 0],
);


VIMRuntime::make_get_set('LockerReconfiguredEvent', 'oldDatastore', 'newDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoDatastoresConfiguredEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('NoDatastoresConfiguredEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AdminPasswordNotChangedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('AdminPasswordNotChangedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostInAuditModeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('HostInAuditModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LocalTSMEnabledEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('LocalTSMEnabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RemoteTSMEnabledEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('RemoteTSMEnabledEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimAccountPasswordChangedEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VimAccountPasswordChangedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IScsiBootFailureEvent;
our @ISA = qw(HostEvent);

our @property_list = (
);


VIMRuntime::make_get_set('IScsiBootFailureEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsHealthStatusChangeEvent;
our @ISA = qw(HostEvent);

our @property_list = (
   ['switchUuid', undef, undef, 1],
   ['healthResult', 'HostMemberHealthCheckResult', undef, 0],
);


VIMRuntime::make_get_set('DvsHealthStatusChangeEvent', 'switchUuid', 'healthResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NetworkRollbackEvent;
our @ISA = qw(Event);

our @property_list = (
   ['methodName', undef, undef, 1],
   ['transactionId', undef, undef, 1],
);


VIMRuntime::make_get_set('NetworkRollbackEvent', 'methodName', 'transactionId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UplinkPortVlanTrunkedEvent;
our @ISA = qw(DvsHealthStatusChangeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('UplinkPortVlanTrunkedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UplinkPortVlanUntrunkedEvent;
our @ISA = qw(DvsHealthStatusChangeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('UplinkPortVlanUntrunkedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MtuMatchEvent;
our @ISA = qw(DvsHealthStatusChangeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('MtuMatchEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MtuMismatchEvent;
our @ISA = qw(DvsHealthStatusChangeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('MtuMismatchEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UplinkPortMtuNotSupportEvent;
our @ISA = qw(DvsHealthStatusChangeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('UplinkPortMtuNotSupportEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UplinkPortMtuSupportEvent;
our @ISA = qw(DvsHealthStatusChangeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('UplinkPortMtuSupportEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TeamingMatchEvent;
our @ISA = qw(DvsHealthStatusChangeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('TeamingMatchEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TeamingMisMatchEvent;
our @ISA = qw(DvsHealthStatusChangeEvent);

our @property_list = (
);


VIMRuntime::make_get_set('TeamingMisMatchEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('DvsEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsCreatedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['parent', 'FolderEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DvsCreatedEvent', 'parent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsRenamedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['oldName', undef, undef, 1],
   ['newName', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsRenamedEvent', 'oldName', 'newName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsReconfiguredEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['configSpec', 'DVSConfigSpec', undef, 1],
);


VIMRuntime::make_get_set('DvsReconfiguredEvent', 'configSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsUpgradeAvailableEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 1],
);


VIMRuntime::make_get_set('DvsUpgradeAvailableEvent', 'productInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsUpgradeInProgressEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 1],
);


VIMRuntime::make_get_set('DvsUpgradeInProgressEvent', 'productInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsUpgradeRejectedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 1],
);


VIMRuntime::make_get_set('DvsUpgradeRejectedEvent', 'productInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsUpgradedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['productInfo', 'DistributedVirtualSwitchProductSpec', undef, 1],
);


VIMRuntime::make_get_set('DvsUpgradedEvent', 'productInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsHostJoinedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['hostJoined', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DvsHostJoinedEvent', 'hostJoined');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsHostLeftEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['hostLeft', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DvsHostLeftEvent', 'hostLeft');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsOutOfSyncHostArgument;
our @ISA = qw(DynamicData);

our @property_list = (
   ['outOfSyncHost', 'HostEventArgument', undef, 1],
   ['configParamters', undef, 1, 1],
);


VIMRuntime::make_get_set('DvsOutOfSyncHostArgument', 'outOfSyncHost', 'configParamters');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsOutOfSyncHostArgument;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsOutOfSyncHostArgument', 'DvsOutOfSyncHostArgument', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsOutOfSyncHostArgument', 'DvsOutOfSyncHostArgument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OutOfSyncDvsHost;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['hostOutOfSync', 'DvsOutOfSyncHostArgument', 1, 1],
);


VIMRuntime::make_get_set('OutOfSyncDvsHost', 'hostOutOfSync');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsHostWentOutOfSyncEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['hostOutOfSync', 'DvsOutOfSyncHostArgument', undef, 1],
);


VIMRuntime::make_get_set('DvsHostWentOutOfSyncEvent', 'hostOutOfSync');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsHostBackInSyncEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['hostBackInSync', 'HostEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DvsHostBackInSyncEvent', 'hostBackInSync');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsHostStatusUpdated;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['hostMember', 'HostEventArgument', undef, 1],
   ['oldStatus', undef, undef, 0],
   ['newStatus', undef, undef, 0],
   ['oldStatusDetail', undef, undef, 0],
   ['newStatusDetail', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsHostStatusUpdated', 'hostMember', 'oldStatus', 'newStatus', 'oldStatusDetail', 'newStatusDetail');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortCreatedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, 1, 1],
);


VIMRuntime::make_get_set('DvsPortCreatedEvent', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortReconfiguredEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, 1, 1],
);


VIMRuntime::make_get_set('DvsPortReconfiguredEvent', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortDeletedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, 1, 1],
);


VIMRuntime::make_get_set('DvsPortDeletedEvent', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortConnectedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['connectee', 'DistributedVirtualSwitchPortConnectee', undef, 0],
);


VIMRuntime::make_get_set('DvsPortConnectedEvent', 'portKey', 'connectee');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortDisconnectedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['connectee', 'DistributedVirtualSwitchPortConnectee', undef, 0],
);


VIMRuntime::make_get_set('DvsPortDisconnectedEvent', 'portKey', 'connectee');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortVendorSpecificStateChangeEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsPortVendorSpecificStateChangeEvent', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortRuntimeChangeEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['runtimeInfo', 'DVPortStatus', undef, 1],
);


VIMRuntime::make_get_set('DvsPortRuntimeChangeEvent', 'portKey', 'runtimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortLinkUpEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['runtimeInfo', 'DVPortStatus', undef, 0],
);


VIMRuntime::make_get_set('DvsPortLinkUpEvent', 'portKey', 'runtimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortLinkDownEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['runtimeInfo', 'DVPortStatus', undef, 0],
);


VIMRuntime::make_get_set('DvsPortLinkDownEvent', 'portKey', 'runtimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortJoinPortgroupEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['portgroupKey', undef, undef, 1],
   ['portgroupName', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsPortJoinPortgroupEvent', 'portKey', 'portgroupKey', 'portgroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortLeavePortgroupEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['portgroupKey', undef, undef, 1],
   ['portgroupName', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsPortLeavePortgroupEvent', 'portKey', 'portgroupKey', 'portgroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortBlockedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['statusDetail', undef, undef, 0],
   ['runtimeInfo', 'DVPortStatus', undef, 0],
);


VIMRuntime::make_get_set('DvsPortBlockedEvent', 'portKey', 'statusDetail', 'runtimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortUnblockedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['runtimeInfo', 'DVPortStatus', undef, 0],
);


VIMRuntime::make_get_set('DvsPortUnblockedEvent', 'portKey', 'runtimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortEnteredPassthruEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['runtimeInfo', 'DVPortStatus', undef, 0],
);


VIMRuntime::make_get_set('DvsPortEnteredPassthruEvent', 'portKey', 'runtimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsPortExitedPassthruEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['portKey', undef, undef, 1],
   ['runtimeInfo', 'DVPortStatus', undef, 0],
);


VIMRuntime::make_get_set('DvsPortExitedPassthruEvent', 'portKey', 'runtimeInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsDestroyedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DvsDestroyedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsMergedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['sourceDvs', 'DvsEventArgument', undef, 1],
   ['destinationDvs', 'DvsEventArgument', undef, 1],
);


VIMRuntime::make_get_set('DvsMergedEvent', 'sourceDvs', 'destinationDvs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostLocalPortCreatedEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['hostLocalPort', 'DVSHostLocalPortInfo', undef, 1],
);


VIMRuntime::make_get_set('HostLocalPortCreatedEvent', 'hostLocalPort');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RollbackEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['hostName', undef, undef, 1],
   ['methodName', undef, undef, 0],
);


VIMRuntime::make_get_set('RollbackEvent', 'hostName', 'methodName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RecoveryEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['hostName', undef, undef, 1],
   ['portKey', undef, undef, 1],
   ['dvsUuid', undef, undef, 0],
   ['vnic', undef, undef, 0],
);


VIMRuntime::make_get_set('RecoveryEvent', 'hostName', 'portKey', 'dvsUuid', 'vnic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsImportEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
   ['importType', undef, undef, 1],
);


VIMRuntime::make_get_set('DvsImportEvent', 'importType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsRestoreEvent;
our @ISA = qw(DvsEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DvsRestoreEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupEvent;
our @ISA = qw(Event);

our @property_list = (
);


VIMRuntime::make_get_set('DVPortgroupEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupCreatedEvent;
our @ISA = qw(DVPortgroupEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DVPortgroupCreatedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupRenamedEvent;
our @ISA = qw(DVPortgroupEvent);

our @property_list = (
   ['oldName', undef, undef, 1],
   ['newName', undef, undef, 1],
);


VIMRuntime::make_get_set('DVPortgroupRenamedEvent', 'oldName', 'newName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupReconfiguredEvent;
our @ISA = qw(DVPortgroupEvent);

our @property_list = (
   ['configSpec', 'DVPortgroupConfigSpec', undef, 1],
);


VIMRuntime::make_get_set('DVPortgroupReconfiguredEvent', 'configSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortgroupDestroyedEvent;
our @ISA = qw(DVPortgroupEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DVPortgroupDestroyedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvpgImportEvent;
our @ISA = qw(DVPortgroupEvent);

our @property_list = (
   ['importType', undef, undef, 1],
);


VIMRuntime::make_get_set('DvpgImportEvent', 'importType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvpgRestoreEvent;
our @ISA = qw(DVPortgroupEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DvpgRestoreEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsInvocationFailedEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsInvocationFailedEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsRecoveredFromFailureEvent;
our @ISA = qw(ClusterEvent);

our @property_list = (
);


VIMRuntime::make_get_set('DrsRecoveredFromFailureEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmReloadFromPathEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['configPath', undef, undef, 1],
);


VIMRuntime::make_get_set('VmReloadFromPathEvent', 'configPath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmReloadFromPathFailedEvent;
our @ISA = qw(VmEvent);

our @property_list = (
   ['configPath', undef, undef, 1],
);


VIMRuntime::make_get_set('VmReloadFromPathFailedEvent', 'configPath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmRequirementsExceedCurrentEVCModeEvent;
our @ISA = qw(VmEvent);

our @property_list = (
);


VIMRuntime::make_get_set('VmRequirementsExceedCurrentEVCModeEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventArgument;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('EventArgument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RoleEventArgument;
our @ISA = qw(EventArgument);

our @property_list = (
   ['roleId', undef, undef, 1],
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('RoleEventArgument', 'roleId', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EntityEventArgument;
our @ISA = qw(EventArgument);

our @property_list = (
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('EntityEventArgument', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ManagedEntityEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('ManagedEntityEventArgument', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FolderEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['folder', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('FolderEventArgument', 'folder');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['datacenter', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DatacenterEventArgument', 'datacenter');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ComputeResourceEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['computeResource', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('ComputeResourceEventArgument', 'computeResource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourcePoolEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['resourcePool', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('ResourcePoolEventArgument', 'resourcePool');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('HostEventArgument', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostEventArgument;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostEventArgument', 'HostEventArgument', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostEventArgument', 'HostEventArgument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('VmEventArgument', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVmEventArgument;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VmEventArgument', 'VmEventArgument', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVmEventArgument', 'VmEventArgument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DatastoreEventArgument', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NetworkEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['network', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('NetworkEventArgument', 'network');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlarmEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['alarm', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('AlarmEventArgument', 'alarm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ScheduledTaskEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['scheduledTask', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('ScheduledTaskEventArgument', 'scheduledTask');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileEventArgument;
our @ISA = qw(EventArgument);

our @property_list = (
   ['profile', 'ManagedObjectReference', undef, 1],
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('ProfileEventArgument', 'profile', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsEventArgument;
our @ISA = qw(EntityEventArgument);

our @property_list = (
   ['dvs', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DvsEventArgument', 'dvs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventArgDesc;
our @ISA = qw(DynamicData);

our @property_list = (
   ['name', undef, undef, 1],
   ['type', undef, undef, 1],
   ['description', 'ElementDescription', undef, 0],
);


VIMRuntime::make_get_set('EventArgDesc', 'name', 'type', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEventArgDesc;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EventArgDesc', 'EventArgDesc', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEventArgDesc', 'EventArgDesc');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventDescriptionEventDetail;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['description', undef, undef, 0],
   ['category', undef, undef, 1],
   ['formatOnDatacenter', undef, undef, 1],
   ['formatOnComputeResource', undef, undef, 1],
   ['formatOnHost', undef, undef, 1],
   ['formatOnVm', undef, undef, 1],
   ['fullFormat', undef, undef, 1],
   ['longDescription', undef, undef, 0],
);


VIMRuntime::make_get_set('EventDescriptionEventDetail', 'key', 'description', 'category', 'formatOnDatacenter', 'formatOnComputeResource', 'formatOnHost', 'formatOnVm', 'fullFormat', 'longDescription');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfEventDescriptionEventDetail;
our @ISA = qw(ComplexType);

our @property_list = (
   ['EventDescriptionEventDetail', 'EventDescriptionEventDetail', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfEventDescriptionEventDetail', 'EventDescriptionEventDetail');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['category', 'ElementDescription', 1, 1],
   ['eventInfo', 'EventDescriptionEventDetail', 1, 1],
   ['enumeratedTypes', 'EnumDescription', 1, 0],
);


VIMRuntime::make_get_set('EventDescription', 'category', 'eventInfo', 'enumeratedTypes');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventEx;
our @ISA = qw(Event);

our @property_list = (
   ['eventTypeId', undef, undef, 1],
   ['severity', undef, undef, 0],
   ['message', undef, undef, 0],
   ['arguments', 'KeyAnyValue', 1, 0],
   ['objectId', undef, undef, 0],
   ['objectType', undef, undef, 0],
   ['objectName', undef, undef, 0],
   ['fault', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('EventEx', 'eventTypeId', 'severity', 'message', 'arguments', 'objectId', 'objectType', 'objectName', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventFilterSpecByEntity;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['recursion', 'EventFilterSpecRecursionOption', undef, 1],
);


VIMRuntime::make_get_set('EventFilterSpecByEntity', 'entity', 'recursion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventFilterSpecByTime;
our @ISA = qw(DynamicData);

our @property_list = (
   ['beginTime', undef, undef, 0],
   ['endTime', undef, undef, 0],
);


VIMRuntime::make_get_set('EventFilterSpecByTime', 'beginTime', 'endTime');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventFilterSpecByUsername;
our @ISA = qw(DynamicData);

our @property_list = (
   ['systemUser', 'boolean', undef, 1],
   ['userList', undef, 1, 0],
);


VIMRuntime::make_get_set('EventFilterSpecByUsername', 'systemUser', 'userList');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EventFilterSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'EventFilterSpecByEntity', undef, 0],
   ['time', 'EventFilterSpecByTime', undef, 0],
   ['userName', 'EventFilterSpecByUsername', undef, 0],
   ['eventChainId', undef, undef, 0],
   ['alarm', 'ManagedObjectReference', undef, 0],
   ['scheduledTask', 'ManagedObjectReference', undef, 0],
   ['disableFullMessage', 'boolean', undef, 0],
   ['category', undef, 1, 0],
   ['type', undef, 1, 0],
   ['tag', undef, 1, 0],
   ['eventTypeId', undef, 1, 0],
);


VIMRuntime::make_get_set('EventFilterSpec', 'entity', 'time', 'userName', 'eventChainId', 'alarm', 'scheduledTask', 'disableFullMessage', 'category', 'type', 'tag', 'eventTypeId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtExtendedProductInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['companyUrl', undef, undef, 0],
   ['productUrl', undef, undef, 0],
   ['managementUrl', undef, undef, 0],
   ['self', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ExtExtendedProductInfo', 'companyUrl', 'productUrl', 'managementUrl', 'self');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ManagedByInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['extensionKey', undef, undef, 1],
   ['type', undef, undef, 1],
);


VIMRuntime::make_get_set('ManagedByInfo', 'extensionKey', 'type');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtManagedEntityInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['type', undef, undef, 1],
   ['smallIconUrl', undef, undef, 0],
   ['iconUrl', undef, undef, 0],
   ['description', undef, undef, 0],
);


VIMRuntime::make_get_set('ExtManagedEntityInfo', 'type', 'smallIconUrl', 'iconUrl', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtManagedEntityInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtManagedEntityInfo', 'ExtManagedEntityInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtManagedEntityInfo', 'ExtManagedEntityInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtSolutionManagerInfoTabInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['label', undef, undef, 1],
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('ExtSolutionManagerInfoTabInfo', 'label', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfExtSolutionManagerInfoTabInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ExtSolutionManagerInfoTabInfo', 'ExtSolutionManagerInfoTabInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfExtSolutionManagerInfoTabInfo', 'ExtSolutionManagerInfoTabInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtSolutionManagerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['tab', 'ExtSolutionManagerInfoTabInfo', 1, 0],
   ['smallIconUrl', undef, undef, 0],
);


VIMRuntime::make_get_set('ExtSolutionManagerInfo', 'tab', 'smallIconUrl');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ActiveDirectoryFault;
our @ISA = qw(VimFault);

our @property_list = (
   ['errorCode', undef, undef, 0],
);


VIMRuntime::make_get_set('ActiveDirectoryFault', 'errorCode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AdminDisabled;
our @ISA = qw(HostConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('AdminDisabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AdminNotDisabled;
our @ISA = qw(HostConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('AdminNotDisabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AffinityConfigured;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['configuredAffinity', undef, 1, 1],
);


VIMRuntime::make_get_set('AffinityConfigured', 'configuredAffinity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AgentInstallFailed;
our @ISA = qw(HostConnectFault);

our @property_list = (
   ['reason', undef, undef, 0],
   ['statusCode', undef, undef, 0],
   ['installerOutput', undef, undef, 0],
);


VIMRuntime::make_get_set('AgentInstallFailed', 'reason', 'statusCode', 'installerOutput');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlreadyBeingManaged;
our @ISA = qw(HostConnectFault);

our @property_list = (
   ['ipAddress', undef, undef, 1],
);


VIMRuntime::make_get_set('AlreadyBeingManaged', 'ipAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlreadyConnected;
our @ISA = qw(HostConnectFault);

our @property_list = (
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('AlreadyConnected', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlreadyExists;
our @ISA = qw(VimFault);

our @property_list = (
   ['name', undef, undef, 0],
);


VIMRuntime::make_get_set('AlreadyExists', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AlreadyUpgraded;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('AlreadyUpgraded');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AnswerFileUpdateFailure;
our @ISA = qw(DynamicData);

our @property_list = (
   ['userInputPath', 'ProfilePropertyPath', undef, 1],
   ['errMsg', 'LocalizableMessage', undef, 1],
);


VIMRuntime::make_get_set('AnswerFileUpdateFailure', 'userInputPath', 'errMsg');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAnswerFileUpdateFailure;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AnswerFileUpdateFailure', 'AnswerFileUpdateFailure', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAnswerFileUpdateFailure', 'AnswerFileUpdateFailure');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AnswerFileUpdateFailed;
our @ISA = qw(VimFault);

our @property_list = (
   ['failure', 'AnswerFileUpdateFailure', 1, 1],
);


VIMRuntime::make_get_set('AnswerFileUpdateFailed', 'failure');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ApplicationQuiesceFault;
our @ISA = qw(SnapshotFault);

our @property_list = (
);


VIMRuntime::make_get_set('ApplicationQuiesceFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AuthMinimumAdminPermission;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('AuthMinimumAdminPermission');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package BackupBlobReadFailure;
our @ISA = qw(DvsFault);

our @property_list = (
   ['entityName', undef, undef, 1],
   ['entityType', undef, undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('BackupBlobReadFailure', 'entityName', 'entityType', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package BackupBlobWriteFailure;
our @ISA = qw(DvsFault);

our @property_list = (
   ['entityName', undef, undef, 1],
   ['entityType', undef, undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('BackupBlobWriteFailure', 'entityName', 'entityType', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package BlockedByFirewall;
our @ISA = qw(HostConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('BlockedByFirewall');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CAMServerRefusedConnection;
our @ISA = qw(InvalidCAMServer);

our @property_list = (
);


VIMRuntime::make_get_set('CAMServerRefusedConnection');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAccessFile;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotAccessFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAccessLocalSource;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotAccessLocalSource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAccessNetwork;
our @ISA = qw(CannotAccessVmDevice);

our @property_list = (
);


VIMRuntime::make_get_set('CannotAccessNetwork');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAccessVmComponent;
our @ISA = qw(VmConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotAccessVmComponent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAccessVmConfig;
our @ISA = qw(CannotAccessVmComponent);

our @property_list = (
   ['reason', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('CannotAccessVmConfig', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAccessVmDevice;
our @ISA = qw(CannotAccessVmComponent);

our @property_list = (
   ['device', undef, undef, 1],
   ['backing', undef, undef, 1],
   ['connected', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('CannotAccessVmDevice', 'device', 'backing', 'connected');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAccessVmDisk;
our @ISA = qw(CannotAccessVmDevice);

our @property_list = (
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('CannotAccessVmDisk', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAddHostWithFTVmAsStandalone;
our @ISA = qw(HostConnectFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotAddHostWithFTVmAsStandalone');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAddHostWithFTVmToDifferentCluster;
our @ISA = qw(HostConnectFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotAddHostWithFTVmToDifferentCluster');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotAddHostWithFTVmToNonHACluster;
our @ISA = qw(HostConnectFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotAddHostWithFTVmToNonHACluster');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotChangeDrsBehaviorForFtSecondary;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('CannotChangeDrsBehaviorForFtSecondary', 'vm', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotChangeHaSettingsForFtSecondary;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('CannotChangeHaSettingsForFtSecondary', 'vm', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotChangeVsanClusterUuid;
our @ISA = qw(VsanFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotChangeVsanClusterUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotChangeVsanNodeUuid;
our @ISA = qw(VsanFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotChangeVsanNodeUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotCreateFile;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotCreateFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotDecryptPasswords;
our @ISA = qw(CustomizationFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotDecryptPasswords');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotDeleteFile;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotDeleteFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotDisableDrsOnClustersWithVApps;
our @ISA = qw(RuntimeFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotDisableDrsOnClustersWithVApps');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotDisableSnapshot;
our @ISA = qw(VmConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotDisableSnapshot');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotDisconnectHostWithFaultToleranceVm;
our @ISA = qw(VimFault);

our @property_list = (
   ['hostName', undef, undef, 1],
);


VIMRuntime::make_get_set('CannotDisconnectHostWithFaultToleranceVm', 'hostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotModifyConfigCpuRequirements;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotModifyConfigCpuRequirements');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotMoveFaultToleranceVm;
our @ISA = qw(VimFault);

our @property_list = (
   ['moveType', undef, undef, 1],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('CannotMoveFaultToleranceVm', 'moveType', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotMoveHostWithFaultToleranceVm;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotMoveHostWithFaultToleranceVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotMoveVmWithDeltaDisk;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['device', undef, undef, 1],
);


VIMRuntime::make_get_set('CannotMoveVmWithDeltaDisk', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotMoveVmWithNativeDeltaDisk;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotMoveVmWithNativeDeltaDisk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotMoveVsanEnabledHost;
our @ISA = qw(VsanFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotMoveVsanEnabledHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotPlaceWithoutPrerequisiteMoves;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotPlaceWithoutPrerequisiteMoves');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotPowerOffVmInCluster;
our @ISA = qw(InvalidState);

our @property_list = (
   ['operation', undef, undef, 1],
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('CannotPowerOffVmInCluster', 'operation', 'vm', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotReconfigureVsanWhenHaEnabled;
our @ISA = qw(VsanFault);

our @property_list = (
);


VIMRuntime::make_get_set('CannotReconfigureVsanWhenHaEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CannotUseNetwork;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['device', undef, undef, 1],
   ['backing', undef, undef, 1],
   ['connected', 'boolean', undef, 1],
   ['reason', undef, undef, 1],
);


VIMRuntime::make_get_set('CannotUseNetwork', 'device', 'backing', 'connected', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ClockSkew;
our @ISA = qw(HostConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('ClockSkew');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CloneFromSnapshotNotSupported;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('CloneFromSnapshotNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CollectorAddressUnset;
our @ISA = qw(DvsFault);

our @property_list = (
);


VIMRuntime::make_get_set('CollectorAddressUnset');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ConcurrentAccess;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('ConcurrentAccess');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ConflictingConfigurationConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 0],
   ['propertyPath', undef, undef, 1],
);


VIMRuntime::make_get_set('ConflictingConfigurationConfig', 'entity', 'propertyPath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfConflictingConfigurationConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ConflictingConfigurationConfig', 'ConflictingConfigurationConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfConflictingConfigurationConfig', 'ConflictingConfigurationConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ConflictingConfiguration;
our @ISA = qw(DvsFault);

our @property_list = (
   ['configInConflict', 'ConflictingConfigurationConfig', 1, 1],
);


VIMRuntime::make_get_set('ConflictingConfiguration', 'configInConflict');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ConflictingDatastoreFound;
our @ISA = qw(RuntimeFault);

our @property_list = (
   ['name', undef, undef, 1],
   ['url', undef, undef, 1],
);


VIMRuntime::make_get_set('ConflictingDatastoreFound', 'name', 'url');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ConnectedIso;
our @ISA = qw(OvfExport);

our @property_list = (
   ['cdrom', 'VirtualCdrom', undef, 1],
   ['filename', undef, undef, 1],
);


VIMRuntime::make_get_set('ConnectedIso', 'cdrom', 'filename');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CpuCompatibilityUnknown;
our @ISA = qw(CpuIncompatible);

our @property_list = (
);


VIMRuntime::make_get_set('CpuCompatibilityUnknown');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CpuHotPlugNotSupported;
our @ISA = qw(VmConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('CpuHotPlugNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CpuIncompatible;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['level', undef, undef, 1],
   ['registerName', undef, undef, 1],
   ['registerBits', undef, undef, 0],
   ['desiredBits', undef, undef, 0],
   ['host', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('CpuIncompatible', 'level', 'registerName', 'registerBits', 'desiredBits', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CpuIncompatible1ECX;
our @ISA = qw(CpuIncompatible);

our @property_list = (
   ['sse3', 'boolean', undef, 1],
   ['pclmulqdq', 'boolean', undef, 0],
   ['ssse3', 'boolean', undef, 1],
   ['sse41', 'boolean', undef, 1],
   ['sse42', 'boolean', undef, 1],
   ['aes', 'boolean', undef, 0],
   ['other', 'boolean', undef, 1],
   ['otherOnly', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('CpuIncompatible1ECX', 'sse3', 'pclmulqdq', 'ssse3', 'sse41', 'sse42', 'aes', 'other', 'otherOnly');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CpuIncompatible81EDX;
our @ISA = qw(CpuIncompatible);

our @property_list = (
   ['nx', 'boolean', undef, 1],
   ['ffxsr', 'boolean', undef, 1],
   ['rdtscp', 'boolean', undef, 1],
   ['lm', 'boolean', undef, 1],
   ['other', 'boolean', undef, 1],
   ['otherOnly', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('CpuIncompatible81EDX', 'nx', 'ffxsr', 'rdtscp', 'lm', 'other', 'otherOnly');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('CustomizationFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package CustomizationPending;
our @ISA = qw(CustomizationFault);

our @property_list = (
);


VIMRuntime::make_get_set('CustomizationPending');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DVPortNotSupported;
our @ISA = qw(DeviceBackingNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('DVPortNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DasConfigFault;
our @ISA = qw(VimFault);

our @property_list = (
   ['reason', undef, undef, 0],
   ['output', undef, undef, 0],
   ['event', 'Event', 1, 0],
);


VIMRuntime::make_get_set('DasConfigFault', 'reason', 'output', 'event');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatabaseError;
our @ISA = qw(RuntimeFault);

our @property_list = (
);


VIMRuntime::make_get_set('DatabaseError');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterMismatchArgument;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entity', 'ManagedObjectReference', undef, 1],
   ['inputDatacenter', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('DatacenterMismatchArgument', 'entity', 'inputDatacenter');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDatacenterMismatchArgument;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DatacenterMismatchArgument', 'DatacenterMismatchArgument', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDatacenterMismatchArgument', 'DatacenterMismatchArgument');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatacenterMismatch;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['invalidArgument', 'DatacenterMismatchArgument', 1, 1],
   ['expectedDatacenter', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DatacenterMismatch', 'invalidArgument', 'expectedDatacenter');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DatastoreNotWritableOnHost;
our @ISA = qw(InvalidDatastore);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DatastoreNotWritableOnHost', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeltaDiskFormatNotSupported;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['datastore', 'ManagedObjectReference', 1, 0],
   ['deltaDiskFormat', undef, undef, 1],
);


VIMRuntime::make_get_set('DeltaDiskFormatNotSupported', 'datastore', 'deltaDiskFormat');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DestinationSwitchFull;
our @ISA = qw(CannotAccessNetwork);

our @property_list = (
);


VIMRuntime::make_get_set('DestinationSwitchFull');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DestinationVsanDisabled;
our @ISA = qw(CannotMoveVsanEnabledHost);

our @property_list = (
   ['destinationCluster', undef, undef, 1],
);


VIMRuntime::make_get_set('DestinationVsanDisabled', 'destinationCluster');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeviceBackingNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
   ['backing', undef, undef, 1],
);


VIMRuntime::make_get_set('DeviceBackingNotSupported', 'backing');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeviceControllerNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
   ['controller', undef, undef, 1],
);


VIMRuntime::make_get_set('DeviceControllerNotSupported', 'controller');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeviceHotPlugNotSupported;
our @ISA = qw(InvalidDeviceSpec);

our @property_list = (
);


VIMRuntime::make_get_set('DeviceHotPlugNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeviceNotFound;
our @ISA = qw(InvalidDeviceSpec);

our @property_list = (
);


VIMRuntime::make_get_set('DeviceNotFound');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeviceNotSupported;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['device', undef, undef, 1],
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('DeviceNotSupported', 'device', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeviceUnsupportedForVmPlatform;
our @ISA = qw(InvalidDeviceSpec);

our @property_list = (
);


VIMRuntime::make_get_set('DeviceUnsupportedForVmPlatform');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DeviceUnsupportedForVmVersion;
our @ISA = qw(InvalidDeviceSpec);

our @property_list = (
   ['currentVersion', undef, undef, 1],
   ['expectedVersion', undef, undef, 1],
);


VIMRuntime::make_get_set('DeviceUnsupportedForVmVersion', 'currentVersion', 'expectedVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DirectoryNotEmpty;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('DirectoryNotEmpty');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DisableAdminNotSupported;
our @ISA = qw(HostConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('DisableAdminNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DisallowedChangeByService;
our @ISA = qw(RuntimeFault);

our @property_list = (
   ['serviceName', undef, undef, 1],
   ['disallowedChange', undef, undef, 0],
);


VIMRuntime::make_get_set('DisallowedChangeByService', 'serviceName', 'disallowedChange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DisallowedDiskModeChange;
our @ISA = qw(InvalidDeviceSpec);

our @property_list = (
);


VIMRuntime::make_get_set('DisallowedDiskModeChange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DisallowedMigrationDeviceAttached;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('DisallowedMigrationDeviceAttached', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DisallowedOperationOnFailoverHost;
our @ISA = qw(RuntimeFault);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['hostname', undef, undef, 1],
);


VIMRuntime::make_get_set('DisallowedOperationOnFailoverHost', 'host', 'hostname');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskHasPartitions;
our @ISA = qw(VsanDiskFault);

our @property_list = (
);


VIMRuntime::make_get_set('DiskHasPartitions');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskIsLastRemainingNonSSD;
our @ISA = qw(VsanDiskFault);

our @property_list = (
);


VIMRuntime::make_get_set('DiskIsLastRemainingNonSSD');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskIsNonLocal;
our @ISA = qw(VsanDiskFault);

our @property_list = (
);


VIMRuntime::make_get_set('DiskIsNonLocal');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskIsUSB;
our @ISA = qw(VsanDiskFault);

our @property_list = (
);


VIMRuntime::make_get_set('DiskIsUSB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskMoveTypeNotSupported;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('DiskMoveTypeNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskNotSupported;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['disk', undef, undef, 1],
);


VIMRuntime::make_get_set('DiskNotSupported', 'disk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DiskTooSmall;
our @ISA = qw(VsanDiskFault);

our @property_list = (
);


VIMRuntime::make_get_set('DiskTooSmall');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DomainNotFound;
our @ISA = qw(ActiveDirectoryFault);

our @property_list = (
   ['domainName', undef, undef, 1],
);


VIMRuntime::make_get_set('DomainNotFound', 'domainName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsDisabledOnVm;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('DrsDisabledOnVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DrsVmotionIncompatibleFault;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DrsVmotionIncompatibleFault', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DuplicateDisks;
our @ISA = qw(VsanDiskFault);

our @property_list = (
);


VIMRuntime::make_get_set('DuplicateDisks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DuplicateName;
our @ISA = qw(VimFault);

our @property_list = (
   ['name', undef, undef, 1],
   ['object', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DuplicateName', 'name', 'object');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DuplicateVsanNetworkInterface;
our @ISA = qw(VsanFault);

our @property_list = (
   ['device', undef, undef, 1],
);


VIMRuntime::make_get_set('DuplicateVsanNetworkInterface', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsApplyOperationFaultFaultOnObject;
our @ISA = qw(DynamicData);

our @property_list = (
   ['objectId', undef, undef, 1],
   ['type', undef, undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('DvsApplyOperationFaultFaultOnObject', 'objectId', 'type', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsApplyOperationFaultFaultOnObject;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsApplyOperationFaultFaultOnObject', 'DvsApplyOperationFaultFaultOnObject', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsApplyOperationFaultFaultOnObject', 'DvsApplyOperationFaultFaultOnObject');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsApplyOperationFault;
our @ISA = qw(DvsFault);

our @property_list = (
   ['objectFault', 'DvsApplyOperationFaultFaultOnObject', 1, 1],
);


VIMRuntime::make_get_set('DvsApplyOperationFault', 'objectFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('DvsFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsNotAuthorized;
our @ISA = qw(DvsFault);

our @property_list = (
   ['sessionExtensionKey', undef, undef, 0],
   ['dvsExtensionKey', undef, undef, 0],
);


VIMRuntime::make_get_set('DvsNotAuthorized', 'sessionExtensionKey', 'dvsExtensionKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsOperationBulkFaultFaultOnHost;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('DvsOperationBulkFaultFaultOnHost', 'host', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfDvsOperationBulkFaultFaultOnHost;
our @ISA = qw(ComplexType);

our @property_list = (
   ['DvsOperationBulkFaultFaultOnHost', 'DvsOperationBulkFaultFaultOnHost', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfDvsOperationBulkFaultFaultOnHost', 'DvsOperationBulkFaultFaultOnHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsOperationBulkFault;
our @ISA = qw(DvsFault);

our @property_list = (
   ['hostFault', 'DvsOperationBulkFaultFaultOnHost', 1, 1],
);


VIMRuntime::make_get_set('DvsOperationBulkFault', 'hostFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package DvsScopeViolated;
our @ISA = qw(DvsFault);

our @property_list = (
   ['scope', 'ManagedObjectReference', 1, 1],
   ['entity', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('DvsScopeViolated', 'scope', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailed;
our @ISA = qw(NotSupportedHostInCluster);

our @property_list = (
   ['faults', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('EVCAdmissionFailed', 'faults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailedCPUFeaturesForMode;
our @ISA = qw(EVCAdmissionFailed);

our @property_list = (
   ['currentEVCModeKey', undef, undef, 1],
);


VIMRuntime::make_get_set('EVCAdmissionFailedCPUFeaturesForMode', 'currentEVCModeKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailedCPUModel;
our @ISA = qw(EVCAdmissionFailed);

our @property_list = (
);


VIMRuntime::make_get_set('EVCAdmissionFailedCPUModel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailedCPUModelForMode;
our @ISA = qw(EVCAdmissionFailed);

our @property_list = (
   ['currentEVCModeKey', undef, undef, 1],
);


VIMRuntime::make_get_set('EVCAdmissionFailedCPUModelForMode', 'currentEVCModeKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailedCPUVendor;
our @ISA = qw(EVCAdmissionFailed);

our @property_list = (
   ['clusterCPUVendor', undef, undef, 1],
   ['hostCPUVendor', undef, undef, 1],
);


VIMRuntime::make_get_set('EVCAdmissionFailedCPUVendor', 'clusterCPUVendor', 'hostCPUVendor');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailedCPUVendorUnknown;
our @ISA = qw(EVCAdmissionFailed);

our @property_list = (
);


VIMRuntime::make_get_set('EVCAdmissionFailedCPUVendorUnknown');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailedHostDisconnected;
our @ISA = qw(EVCAdmissionFailed);

our @property_list = (
);


VIMRuntime::make_get_set('EVCAdmissionFailedHostDisconnected');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailedHostSoftware;
our @ISA = qw(EVCAdmissionFailed);

our @property_list = (
);


VIMRuntime::make_get_set('EVCAdmissionFailedHostSoftware');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailedHostSoftwareForMode;
our @ISA = qw(EVCAdmissionFailed);

our @property_list = (
);


VIMRuntime::make_get_set('EVCAdmissionFailedHostSoftwareForMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EVCAdmissionFailedVmActive;
our @ISA = qw(EVCAdmissionFailed);

our @property_list = (
);


VIMRuntime::make_get_set('EVCAdmissionFailedVmActive');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package EightHostLimitViolated;
our @ISA = qw(VmConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('EightHostLimitViolated');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExpiredAddonLicense;
our @ISA = qw(ExpiredFeatureLicense);

our @property_list = (
);


VIMRuntime::make_get_set('ExpiredAddonLicense');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExpiredEditionLicense;
our @ISA = qw(ExpiredFeatureLicense);

our @property_list = (
);


VIMRuntime::make_get_set('ExpiredEditionLicense');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExpiredFeatureLicense;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['feature', undef, undef, 1],
   ['count', undef, undef, 1],
   ['expirationDate', undef, undef, 1],
);


VIMRuntime::make_get_set('ExpiredFeatureLicense', 'feature', 'count', 'expirationDate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ExtendedFault;
our @ISA = qw(VimFault);

our @property_list = (
   ['faultTypeId', undef, undef, 1],
   ['data', 'KeyValue', 1, 0],
);


VIMRuntime::make_get_set('ExtendedFault', 'faultTypeId', 'data');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FailToEnableSPBM;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['cs', 'ManagedObjectReference', undef, 1],
   ['csName', undef, undef, 1],
   ['hostLicenseStates', 'ComputeResourceHostSPBMLicenseInfo', 1, 1],
);


VIMRuntime::make_get_set('FailToEnableSPBM', 'cs', 'csName', 'hostLicenseStates');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FailToLockFaultToleranceVMs;
our @ISA = qw(RuntimeFault);

our @property_list = (
   ['vmName', undef, undef, 1],
   ['vm', 'ManagedObjectReference', undef, 1],
   ['alreadyLockedVm', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('FailToLockFaultToleranceVMs', 'vmName', 'vm', 'alreadyLockedVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultToleranceAntiAffinityViolated;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['hostName', undef, undef, 1],
   ['host', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('FaultToleranceAntiAffinityViolated', 'hostName', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultToleranceCannotEditMem;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['vmName', undef, undef, 1],
   ['vm', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('FaultToleranceCannotEditMem', 'vmName', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultToleranceCpuIncompatible;
our @ISA = qw(CpuIncompatible);

our @property_list = (
   ['model', 'boolean', undef, 1],
   ['family', 'boolean', undef, 1],
   ['stepping', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('FaultToleranceCpuIncompatible', 'model', 'family', 'stepping');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultToleranceNeedsThickDisk;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('FaultToleranceNeedsThickDisk', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultToleranceNotLicensed;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['hostName', undef, undef, 0],
);


VIMRuntime::make_get_set('FaultToleranceNotLicensed', 'hostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultToleranceNotSameBuild;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['build', undef, undef, 1],
);


VIMRuntime::make_get_set('FaultToleranceNotSameBuild', 'build');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultTolerancePrimaryPowerOnNotAttempted;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['secondaryVm', 'ManagedObjectReference', undef, 1],
   ['primaryVm', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('FaultTolerancePrimaryPowerOnNotAttempted', 'secondaryVm', 'primaryVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FaultToleranceVmNotDasProtected;
our @ISA = qw(VimFault);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('FaultToleranceVmNotDasProtected', 'vm', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FcoeFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('FcoeFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FcoeFaultPnicHasNoPortSet;
our @ISA = qw(FcoeFault);

our @property_list = (
   ['nicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('FcoeFaultPnicHasNoPortSet', 'nicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FeatureRequirementsNotMet;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['featureRequirement', 'VirtualMachineFeatureRequirement', 1, 0],
   ['vm', 'ManagedObjectReference', undef, 0],
   ['host', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('FeatureRequirementsNotMet', 'featureRequirement', 'vm', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileAlreadyExists;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('FileAlreadyExists');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileBackedPortNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('FileBackedPortNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileFault;
our @ISA = qw(VimFault);

our @property_list = (
   ['file', undef, undef, 1],
);


VIMRuntime::make_get_set('FileFault', 'file');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileLocked;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('FileLocked');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileNameTooLong;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('FileNameTooLong');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileNotFound;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('FileNotFound');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileNotWritable;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('FileNotWritable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileTooLarge;
our @ISA = qw(FileFault);

our @property_list = (
   ['datastore', undef, undef, 1],
   ['fileSize', undef, undef, 1],
   ['maxFileSize', undef, undef, 0],
);


VIMRuntime::make_get_set('FileTooLarge', 'datastore', 'fileSize', 'maxFileSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FilesystemQuiesceFault;
our @ISA = qw(SnapshotFault);

our @property_list = (
);


VIMRuntime::make_get_set('FilesystemQuiesceFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FtIssuesOnHost;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['hostName', undef, undef, 1],
   ['errors', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('FtIssuesOnHost', 'host', 'hostName', 'errors');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FullStorageVMotionNotSupported;
our @ISA = qw(MigrationFeatureNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('FullStorageVMotionNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GenericDrsFault;
our @ISA = qw(VimFault);

our @property_list = (
   ['hostFaults', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('GenericDrsFault', 'hostFaults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GenericVmConfigFault;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['reason', undef, undef, 1],
);


VIMRuntime::make_get_set('GenericVmConfigFault', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GuestAuthenticationChallenge;
our @ISA = qw(GuestOperationsFault);

our @property_list = (
   ['serverChallenge', 'GuestAuthentication', undef, 1],
   ['sessionID', undef, undef, 1],
);


VIMRuntime::make_get_set('GuestAuthenticationChallenge', 'serverChallenge', 'sessionID');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GuestComponentsOutOfDate;
our @ISA = qw(GuestOperationsFault);

our @property_list = (
);


VIMRuntime::make_get_set('GuestComponentsOutOfDate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GuestOperationsFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('GuestOperationsFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GuestOperationsUnavailable;
our @ISA = qw(GuestOperationsFault);

our @property_list = (
);


VIMRuntime::make_get_set('GuestOperationsUnavailable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GuestPermissionDenied;
our @ISA = qw(GuestOperationsFault);

our @property_list = (
);


VIMRuntime::make_get_set('GuestPermissionDenied');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package GuestProcessNotFound;
our @ISA = qw(GuestOperationsFault);

our @property_list = (
   ['pid', undef, undef, 1],
);


VIMRuntime::make_get_set('GuestProcessNotFound', 'pid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HAErrorsAtDest;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('HAErrorsAtDest');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAccessRestrictedToManagementServer;
our @ISA = qw(NotSupported);

our @property_list = (
   ['managementServer', undef, undef, 1],
);


VIMRuntime::make_get_set('HostAccessRestrictedToManagementServer', 'managementServer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConfigFailed;
our @ISA = qw(HostConfigFault);

our @property_list = (
   ['failure', 'LocalizedMethodFault', 1, 1],
);


VIMRuntime::make_get_set('HostConfigFailed', 'failure');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConfigFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('HostConfigFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConnectFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('HostConnectFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostInDomain;
our @ISA = qw(HostConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('HostInDomain');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostIncompatibleForFaultTolerance;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['hostName', undef, undef, 0],
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('HostIncompatibleForFaultTolerance', 'hostName', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostIncompatibleForRecordReplay;
our @ISA = qw(VimFault);

our @property_list = (
   ['hostName', undef, undef, 0],
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('HostIncompatibleForRecordReplay', 'hostName', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostInventoryFull;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['capacity', undef, undef, 1],
);


VIMRuntime::make_get_set('HostInventoryFull', 'capacity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostPowerOpFailed;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('HostPowerOpFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HotSnapshotMoveNotSupported;
our @ISA = qw(SnapshotCopyNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('HotSnapshotMoveNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IDEDiskNotSupported;
our @ISA = qw(DiskNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('IDEDiskNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IORMNotSupportedHostOnDatastore;
our @ISA = qw(VimFault);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['datastoreName', undef, undef, 1],
   ['host', 'ManagedObjectReference', 1, 0],
);


VIMRuntime::make_get_set('IORMNotSupportedHostOnDatastore', 'datastore', 'datastoreName', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ImportHostAddFailure;
our @ISA = qw(DvsFault);

our @property_list = (
   ['hostIp', undef, 1, 1],
);


VIMRuntime::make_get_set('ImportHostAddFailure', 'hostIp');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ImportOperationBulkFaultFaultOnImport;
our @ISA = qw(DynamicData);

our @property_list = (
   ['entityType', undef, undef, 0],
   ['key', undef, undef, 0],
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('ImportOperationBulkFaultFaultOnImport', 'entityType', 'key', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfImportOperationBulkFaultFaultOnImport;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ImportOperationBulkFaultFaultOnImport', 'ImportOperationBulkFaultFaultOnImport', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfImportOperationBulkFaultFaultOnImport', 'ImportOperationBulkFaultFaultOnImport');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ImportOperationBulkFault;
our @ISA = qw(DvsFault);

our @property_list = (
   ['importFaults', 'ImportOperationBulkFaultFaultOnImport', 1, 1],
);


VIMRuntime::make_get_set('ImportOperationBulkFault', 'importFaults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InUseFeatureManipulationDisallowed;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
);


VIMRuntime::make_get_set('InUseFeatureManipulationDisallowed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InaccessibleDatastore;
our @ISA = qw(InvalidDatastore);

our @property_list = (
   ['detail', undef, undef, 0],
);


VIMRuntime::make_get_set('InaccessibleDatastore', 'detail');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InaccessibleVFlashSource;
our @ISA = qw(VimFault);

our @property_list = (
   ['hostName', undef, undef, 1],
);


VIMRuntime::make_get_set('InaccessibleVFlashSource', 'hostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IncompatibleDefaultDevice;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['device', undef, undef, 1],
);


VIMRuntime::make_get_set('IncompatibleDefaultDevice', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IncompatibleHostForFtSecondary;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['error', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('IncompatibleHostForFtSecondary', 'host', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IncompatibleSetting;
our @ISA = qw(InvalidArgument);

our @property_list = (
   ['conflictingProperty', undef, undef, 1],
);


VIMRuntime::make_get_set('IncompatibleSetting', 'conflictingProperty');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IncorrectFileType;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('IncorrectFileType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IncorrectHostInformation;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
);


VIMRuntime::make_get_set('IncorrectHostInformation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IndependentDiskVMotionNotSupported;
our @ISA = qw(MigrationFeatureNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('IndependentDiskVMotionNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientAgentVmsDeployed;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
   ['hostName', undef, undef, 1],
   ['requiredNumAgentVms', undef, undef, 1],
   ['currentNumAgentVms', undef, undef, 1],
);


VIMRuntime::make_get_set('InsufficientAgentVmsDeployed', 'hostName', 'requiredNumAgentVms', 'currentNumAgentVms');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientCpuResourcesFault;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
   ['unreserved', undef, undef, 1],
   ['requested', undef, undef, 1],
);


VIMRuntime::make_get_set('InsufficientCpuResourcesFault', 'unreserved', 'requested');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientDisks;
our @ISA = qw(VsanDiskFault);

our @property_list = (
);


VIMRuntime::make_get_set('InsufficientDisks');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientFailoverResourcesFault;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
);


VIMRuntime::make_get_set('InsufficientFailoverResourcesFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientHostCapacityFault;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('InsufficientHostCapacityFault', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientHostCpuCapacityFault;
our @ISA = qw(InsufficientHostCapacityFault);

our @property_list = (
   ['unreserved', undef, undef, 1],
   ['requested', undef, undef, 1],
);


VIMRuntime::make_get_set('InsufficientHostCpuCapacityFault', 'unreserved', 'requested');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientHostMemoryCapacityFault;
our @ISA = qw(InsufficientHostCapacityFault);

our @property_list = (
   ['unreserved', undef, undef, 1],
   ['requested', undef, undef, 1],
);


VIMRuntime::make_get_set('InsufficientHostMemoryCapacityFault', 'unreserved', 'requested');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientMemoryResourcesFault;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
   ['unreserved', undef, undef, 1],
   ['requested', undef, undef, 1],
);


VIMRuntime::make_get_set('InsufficientMemoryResourcesFault', 'unreserved', 'requested');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientPerCpuCapacity;
our @ISA = qw(InsufficientHostCapacityFault);

our @property_list = (
);


VIMRuntime::make_get_set('InsufficientPerCpuCapacity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientResourcesFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('InsufficientResourcesFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientStandbyCpuResource;
our @ISA = qw(InsufficientStandbyResource);

our @property_list = (
   ['available', undef, undef, 1],
   ['requested', undef, undef, 1],
);


VIMRuntime::make_get_set('InsufficientStandbyCpuResource', 'available', 'requested');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientStandbyMemoryResource;
our @ISA = qw(InsufficientStandbyResource);

our @property_list = (
   ['available', undef, undef, 1],
   ['requested', undef, undef, 1],
);


VIMRuntime::make_get_set('InsufficientStandbyMemoryResource', 'available', 'requested');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientStandbyResource;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
);


VIMRuntime::make_get_set('InsufficientStandbyResource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientStorageSpace;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
);


VIMRuntime::make_get_set('InsufficientStorageSpace');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InsufficientVFlashResourcesFault;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
   ['freeSpace', undef, undef, 1],
   ['requestedSpace', undef, undef, 1],
);


VIMRuntime::make_get_set('InsufficientVFlashResourcesFault', 'freeSpace', 'requestedSpace');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidAffinitySettingFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidAffinitySettingFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidBmcRole;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidBmcRole');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidBundle;
our @ISA = qw(PlatformConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidBundle');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidCAMCertificate;
our @ISA = qw(InvalidCAMServer);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidCAMCertificate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidCAMServer;
our @ISA = qw(ActiveDirectoryFault);

our @property_list = (
   ['camServer', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidCAMServer', 'camServer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidClientCertificate;
our @ISA = qw(InvalidLogin);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidClientCertificate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidController;
our @ISA = qw(InvalidDeviceSpec);

our @property_list = (
   ['controllerKey', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidController', 'controllerKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDasConfigArgument;
our @ISA = qw(InvalidArgument);

our @property_list = (
   ['entry', undef, undef, 0],
   ['clusterName', undef, undef, 0],
);


VIMRuntime::make_get_set('InvalidDasConfigArgument', 'entry', 'clusterName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDasRestartPriorityForFtVm;
our @ISA = qw(InvalidArgument);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidDasRestartPriorityForFtVm', 'vm', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDatastore;
our @ISA = qw(VimFault);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 0],
   ['name', undef, undef, 0],
);


VIMRuntime::make_get_set('InvalidDatastore', 'datastore', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDatastorePath;
our @ISA = qw(InvalidDatastore);

our @property_list = (
   ['datastorePath', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidDatastorePath', 'datastorePath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDatastoreState;
our @ISA = qw(InvalidState);

our @property_list = (
   ['datastoreName', undef, undef, 0],
);


VIMRuntime::make_get_set('InvalidDatastoreState', 'datastoreName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDeviceBacking;
our @ISA = qw(InvalidDeviceSpec);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidDeviceBacking');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDeviceOperation;
our @ISA = qw(InvalidDeviceSpec);

our @property_list = (
   ['badOp', 'VirtualDeviceConfigSpecOperation', undef, 0],
   ['badFileOp', 'VirtualDeviceConfigSpecFileOperation', undef, 0],
);


VIMRuntime::make_get_set('InvalidDeviceOperation', 'badOp', 'badFileOp');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDeviceSpec;
our @ISA = qw(InvalidVmConfig);

our @property_list = (
   ['deviceIndex', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidDeviceSpec', 'deviceIndex');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDiskFormat;
our @ISA = qw(InvalidFormat);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidDiskFormat');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidDrsBehaviorForFtVm;
our @ISA = qw(InvalidArgument);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidDrsBehaviorForFtVm', 'vm', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidEditionLicense;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['feature', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidEditionLicense', 'feature');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidEvent;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidEvent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidFolder;
our @ISA = qw(VimFault);

our @property_list = (
   ['target', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('InvalidFolder', 'target');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidFormat;
our @ISA = qw(VmConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidFormat');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidGuestLogin;
our @ISA = qw(GuestOperationsFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidGuestLogin');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidHostConnectionState;
our @ISA = qw(InvalidHostState);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidHostConnectionState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidHostName;
our @ISA = qw(HostConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidHostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidHostState;
our @ISA = qw(InvalidState);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('InvalidHostState', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidIndexArgument;
our @ISA = qw(InvalidArgument);

our @property_list = (
   ['key', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidIndexArgument', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidIpfixConfig;
our @ISA = qw(DvsFault);

our @property_list = (
   ['property', undef, undef, 0],
);


VIMRuntime::make_get_set('InvalidIpfixConfig', 'property');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidIpmiLoginInfo;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidIpmiLoginInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidIpmiMacAddress;
our @ISA = qw(VimFault);

our @property_list = (
   ['userProvidedMacAddress', undef, undef, 1],
   ['observedMacAddress', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidIpmiMacAddress', 'userProvidedMacAddress', 'observedMacAddress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidLicense;
our @ISA = qw(VimFault);

our @property_list = (
   ['licenseContent', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidLicense', 'licenseContent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidLocale;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidLocale');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidLogin;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidLogin');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidName;
our @ISA = qw(VimFault);

our @property_list = (
   ['name', undef, undef, 1],
   ['entity', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('InvalidName', 'name', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidNasCredentials;
our @ISA = qw(NasConfigFault);

our @property_list = (
   ['userName', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidNasCredentials', 'userName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidNetworkInType;
our @ISA = qw(VAppPropertyFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidNetworkInType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidNetworkResource;
our @ISA = qw(NasConfigFault);

our @property_list = (
   ['remoteHost', undef, undef, 1],
   ['remotePath', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidNetworkResource', 'remoteHost', 'remotePath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidOperationOnSecondaryVm;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['instanceUuid', undef, undef, 0],
);


VIMRuntime::make_get_set('InvalidOperationOnSecondaryVm', 'instanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidPowerState;
our @ISA = qw(InvalidState);

our @property_list = (
   ['requestedState', 'VirtualMachinePowerState', undef, 0],
   ['existingState', 'VirtualMachinePowerState', undef, 1],
);


VIMRuntime::make_get_set('InvalidPowerState', 'requestedState', 'existingState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidPrivilege;
our @ISA = qw(VimFault);

our @property_list = (
   ['privilege', undef, undef, 1],
);


VIMRuntime::make_get_set('InvalidPrivilege', 'privilege');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidProfileReferenceHost;
our @ISA = qw(RuntimeFault);

our @property_list = (
   ['reason', undef, undef, 0],
   ['host', 'ManagedObjectReference', undef, 0],
   ['profile', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('InvalidProfileReferenceHost', 'reason', 'host', 'profile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidPropertyType;
our @ISA = qw(VAppPropertyFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidPropertyType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidPropertyValue;
our @ISA = qw(VAppPropertyFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidPropertyValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidResourcePoolStructureFault;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidResourcePoolStructureFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidSnapshotFormat;
our @ISA = qw(InvalidFormat);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidSnapshotFormat');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidState;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('InvalidState');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InvalidVmConfig;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['property', undef, undef, 0],
);


VIMRuntime::make_get_set('InvalidVmConfig', 'property');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package InventoryHasStandardAloneHosts;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['hosts', undef, 1, 1],
);


VIMRuntime::make_get_set('InventoryHasStandardAloneHosts', 'hosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IpHostnameGeneratorError;
our @ISA = qw(CustomizationFault);

our @property_list = (
);


VIMRuntime::make_get_set('IpHostnameGeneratorError');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('IscsiFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultInvalidVnic;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultInvalidVnic', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultPnicInUse;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['pnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultPnicInUse', 'pnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultVnicAlreadyBound;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultVnicAlreadyBound', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultVnicHasActivePaths;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultVnicHasActivePaths', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultVnicHasMultipleUplinks;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultVnicHasMultipleUplinks', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultVnicHasNoUplinks;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultVnicHasNoUplinks', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultVnicHasWrongUplink;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultVnicHasWrongUplink', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultVnicInUse;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultVnicInUse', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultVnicIsLastPath;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultVnicIsLastPath', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultVnicNotBound;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultVnicNotBound', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IscsiFaultVnicNotFound;
our @ISA = qw(IscsiFault);

our @property_list = (
   ['vnicDevice', undef, undef, 1],
);


VIMRuntime::make_get_set('IscsiFaultVnicNotFound', 'vnicDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LargeRDMConversionNotSupported;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['device', undef, undef, 1],
);


VIMRuntime::make_get_set('LargeRDMConversionNotSupported', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LargeRDMNotSupportedOnDatastore;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['device', undef, undef, 1],
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['datastoreName', undef, undef, 1],
);


VIMRuntime::make_get_set('LargeRDMNotSupportedOnDatastore', 'device', 'datastore', 'datastoreName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LegacyNetworkInterfaceInUse;
our @ISA = qw(CannotAccessNetwork);

our @property_list = (
);


VIMRuntime::make_get_set('LegacyNetworkInterfaceInUse');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseAssignmentFailed;
our @ISA = qw(RuntimeFault);

our @property_list = (
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('LicenseAssignmentFailed', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseDowngradeDisallowed;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['edition', undef, undef, 1],
   ['entityId', undef, undef, 1],
   ['features', 'KeyAnyValue', 1, 1],
);


VIMRuntime::make_get_set('LicenseDowngradeDisallowed', 'edition', 'entityId', 'features');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseEntityNotFound;
our @ISA = qw(VimFault);

our @property_list = (
   ['entityId', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseEntityNotFound', 'entityId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseExpired;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['licenseKey', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseExpired', 'licenseKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseKeyEntityMismatch;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
);


VIMRuntime::make_get_set('LicenseKeyEntityMismatch');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseRestricted;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
);


VIMRuntime::make_get_set('LicenseRestricted');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseServerUnavailable;
our @ISA = qw(VimFault);

our @property_list = (
   ['licenseServer', undef, undef, 1],
);


VIMRuntime::make_get_set('LicenseServerUnavailable', 'licenseServer');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LicenseSourceUnavailable;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['licenseSource', 'LicenseSource', undef, 1],
);


VIMRuntime::make_get_set('LicenseSourceUnavailable', 'licenseSource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LimitExceeded;
our @ISA = qw(VimFault);

our @property_list = (
   ['property', undef, undef, 0],
   ['limit', undef, undef, 0],
);


VIMRuntime::make_get_set('LimitExceeded', 'property', 'limit');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LinuxVolumeNotClean;
our @ISA = qw(CustomizationFault);

our @property_list = (
);


VIMRuntime::make_get_set('LinuxVolumeNotClean');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LogBundlingFailed;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('LogBundlingFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MaintenanceModeFileMove;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('MaintenanceModeFileMove');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MemoryHotPlugNotSupported;
our @ISA = qw(VmConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('MemoryHotPlugNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MemorySizeNotRecommended;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['memorySizeMB', undef, undef, 1],
   ['minMemorySizeMB', undef, undef, 1],
   ['maxMemorySizeMB', undef, undef, 1],
);


VIMRuntime::make_get_set('MemorySizeNotRecommended', 'memorySizeMB', 'minMemorySizeMB', 'maxMemorySizeMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MemorySizeNotSupported;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['memorySizeMB', undef, undef, 1],
   ['minMemorySizeMB', undef, undef, 1],
   ['maxMemorySizeMB', undef, undef, 1],
);


VIMRuntime::make_get_set('MemorySizeNotSupported', 'memorySizeMB', 'minMemorySizeMB', 'maxMemorySizeMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MemorySizeNotSupportedByDatastore;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['memorySizeMB', undef, undef, 1],
   ['maxMemorySizeMB', undef, undef, 1],
);


VIMRuntime::make_get_set('MemorySizeNotSupportedByDatastore', 'datastore', 'memorySizeMB', 'maxMemorySizeMB');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MemorySnapshotOnIndependentDisk;
our @ISA = qw(SnapshotFault);

our @property_list = (
);


VIMRuntime::make_get_set('MemorySnapshotOnIndependentDisk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MethodAlreadyDisabledFault;
our @ISA = qw(RuntimeFault);

our @property_list = (
   ['sourceId', undef, undef, 1],
);


VIMRuntime::make_get_set('MethodAlreadyDisabledFault', 'sourceId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MethodDisabled;
our @ISA = qw(RuntimeFault);

our @property_list = (
   ['source', undef, undef, 0],
);


VIMRuntime::make_get_set('MethodDisabled', 'source');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationDisabled;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('MigrationDisabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('MigrationFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationFeatureNotSupported;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['atSourceHost', 'boolean', undef, 1],
   ['failedHostName', undef, undef, 1],
   ['failedHost', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('MigrationFeatureNotSupported', 'atSourceHost', 'failedHostName', 'failedHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MigrationNotReady;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['reason', undef, undef, 1],
);


VIMRuntime::make_get_set('MigrationNotReady', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MismatchedBundle;
our @ISA = qw(VimFault);

our @property_list = (
   ['bundleUuid', undef, undef, 1],
   ['hostUuid', undef, undef, 1],
   ['bundleBuildNumber', undef, undef, 1],
   ['hostBuildNumber', undef, undef, 1],
);


VIMRuntime::make_get_set('MismatchedBundle', 'bundleUuid', 'hostUuid', 'bundleBuildNumber', 'hostBuildNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MismatchedNetworkPolicies;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['device', undef, undef, 1],
   ['backing', undef, undef, 1],
   ['connected', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('MismatchedNetworkPolicies', 'device', 'backing', 'connected');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MismatchedVMotionNetworkNames;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['sourceNetwork', undef, undef, 1],
   ['destNetwork', undef, undef, 1],
);


VIMRuntime::make_get_set('MismatchedVMotionNetworkNames', 'sourceNetwork', 'destNetwork');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MissingBmcSupport;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('MissingBmcSupport');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MissingController;
our @ISA = qw(InvalidDeviceSpec);

our @property_list = (
);


VIMRuntime::make_get_set('MissingController');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MissingIpPool;
our @ISA = qw(VAppPropertyFault);

our @property_list = (
);


VIMRuntime::make_get_set('MissingIpPool');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MissingLinuxCustResources;
our @ISA = qw(CustomizationFault);

our @property_list = (
);


VIMRuntime::make_get_set('MissingLinuxCustResources');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MissingNetworkIpConfig;
our @ISA = qw(VAppPropertyFault);

our @property_list = (
);


VIMRuntime::make_get_set('MissingNetworkIpConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MissingPowerOffConfiguration;
our @ISA = qw(VAppConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('MissingPowerOffConfiguration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MissingPowerOnConfiguration;
our @ISA = qw(VAppConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('MissingPowerOnConfiguration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MissingWindowsCustResources;
our @ISA = qw(CustomizationFault);

our @property_list = (
);


VIMRuntime::make_get_set('MissingWindowsCustResources');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MksConnectionLimitReached;
our @ISA = qw(InvalidState);

our @property_list = (
   ['connectionLimit', undef, undef, 1],
);


VIMRuntime::make_get_set('MksConnectionLimitReached', 'connectionLimit');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MountError;
our @ISA = qw(CustomizationFault);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['diskIndex', undef, undef, 1],
);


VIMRuntime::make_get_set('MountError', 'vm', 'diskIndex');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MultipleCertificatesVerifyFaultThumbprintData;
our @ISA = qw(DynamicData);

our @property_list = (
   ['port', undef, undef, 1],
   ['thumbprint', undef, undef, 1],
);


VIMRuntime::make_get_set('MultipleCertificatesVerifyFaultThumbprintData', 'port', 'thumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfMultipleCertificatesVerifyFaultThumbprintData;
our @ISA = qw(ComplexType);

our @property_list = (
   ['MultipleCertificatesVerifyFaultThumbprintData', 'MultipleCertificatesVerifyFaultThumbprintData', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfMultipleCertificatesVerifyFaultThumbprintData', 'MultipleCertificatesVerifyFaultThumbprintData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MultipleCertificatesVerifyFault;
our @ISA = qw(HostConnectFault);

our @property_list = (
   ['thumbprintData', 'MultipleCertificatesVerifyFaultThumbprintData', 1, 1],
);


VIMRuntime::make_get_set('MultipleCertificatesVerifyFault', 'thumbprintData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package MultipleSnapshotsNotSupported;
our @ISA = qw(SnapshotFault);

our @property_list = (
);


VIMRuntime::make_get_set('MultipleSnapshotsNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NamespaceFull;
our @ISA = qw(VimFault);

our @property_list = (
   ['name', undef, undef, 1],
   ['currentMaxSize', undef, undef, 1],
   ['requiredSize', undef, undef, 0],
);


VIMRuntime::make_get_set('NamespaceFull', 'name', 'currentMaxSize', 'requiredSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NamespaceLimitReached;
our @ISA = qw(VimFault);

our @property_list = (
   ['limit', undef, undef, 0],
);


VIMRuntime::make_get_set('NamespaceLimitReached', 'limit');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NamespaceWriteProtected;
our @ISA = qw(VimFault);

our @property_list = (
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('NamespaceWriteProtected', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NasConfigFault;
our @ISA = qw(HostConfigFault);

our @property_list = (
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('NasConfigFault', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NasConnectionLimitReached;
our @ISA = qw(NasConfigFault);

our @property_list = (
   ['remoteHost', undef, undef, 1],
   ['remotePath', undef, undef, 1],
);


VIMRuntime::make_get_set('NasConnectionLimitReached', 'remoteHost', 'remotePath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NasSessionCredentialConflict;
our @ISA = qw(NasConfigFault);

our @property_list = (
   ['remoteHost', undef, undef, 1],
   ['remotePath', undef, undef, 1],
   ['userName', undef, undef, 1],
);


VIMRuntime::make_get_set('NasSessionCredentialConflict', 'remoteHost', 'remotePath', 'userName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NasVolumeNotMounted;
our @ISA = qw(NasConfigFault);

our @property_list = (
   ['remoteHost', undef, undef, 1],
   ['remotePath', undef, undef, 1],
);


VIMRuntime::make_get_set('NasVolumeNotMounted', 'remoteHost', 'remotePath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NetworkCopyFault;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('NetworkCopyFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NetworkDisruptedAndConfigRolledBack;
our @ISA = qw(VimFault);

our @property_list = (
   ['host', undef, undef, 1],
);


VIMRuntime::make_get_set('NetworkDisruptedAndConfigRolledBack', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NetworkInaccessible;
our @ISA = qw(NasConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('NetworkInaccessible');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NetworksMayNotBeTheSame;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['name', undef, undef, 0],
);


VIMRuntime::make_get_set('NetworksMayNotBeTheSame', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NicSettingMismatch;
our @ISA = qw(CustomizationFault);

our @property_list = (
   ['numberOfNicsInSpec', undef, undef, 1],
   ['numberOfNicsInVM', undef, undef, 1],
);


VIMRuntime::make_get_set('NicSettingMismatch', 'numberOfNicsInSpec', 'numberOfNicsInVM');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoActiveHostInCluster;
our @ISA = qw(InvalidState);

our @property_list = (
   ['computeResource', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('NoActiveHostInCluster', 'computeResource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoAvailableIp;
our @ISA = qw(VAppPropertyFault);

our @property_list = (
   ['network', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('NoAvailableIp', 'network');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoClientCertificate;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoClientCertificate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoCompatibleDatastore;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoCompatibleDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoCompatibleHardAffinityHost;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('NoCompatibleHardAffinityHost', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoCompatibleHost;
our @ISA = qw(VimFault);

our @property_list = (
   ['host', 'ManagedObjectReference', 1, 0],
   ['error', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('NoCompatibleHost', 'host', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoCompatibleHostWithAccessToDevice;
our @ISA = qw(NoCompatibleHost);

our @property_list = (
);


VIMRuntime::make_get_set('NoCompatibleHostWithAccessToDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoCompatibleSoftAffinityHost;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('NoCompatibleSoftAffinityHost', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoConnectedDatastore;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoConnectedDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoDiskFound;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoDiskFound');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoDiskSpace;
our @ISA = qw(FileFault);

our @property_list = (
   ['datastore', undef, undef, 1],
);


VIMRuntime::make_get_set('NoDiskSpace', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoDisksToCustomize;
our @ISA = qw(CustomizationFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoDisksToCustomize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoGateway;
our @ISA = qw(HostConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoGateway');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoGuestHeartbeat;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoGuestHeartbeat');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoHost;
our @ISA = qw(HostConnectFault);

our @property_list = (
   ['name', undef, undef, 0],
);


VIMRuntime::make_get_set('NoHost', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoHostSuitableForFtSecondary;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('NoHostSuitableForFtSecondary', 'vm', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoLicenseServerConfigured;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
);


VIMRuntime::make_get_set('NoLicenseServerConfigured');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoPeerHostFound;
our @ISA = qw(HostPowerOpFailed);

our @property_list = (
);


VIMRuntime::make_get_set('NoPeerHostFound');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoPermission;
our @ISA = qw(SecurityError);

our @property_list = (
   ['object', 'ManagedObjectReference', undef, 1],
   ['privilegeId', undef, undef, 1],
);


VIMRuntime::make_get_set('NoPermission', 'object', 'privilegeId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoPermissionOnAD;
our @ISA = qw(ActiveDirectoryFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoPermissionOnAD');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoPermissionOnHost;
our @ISA = qw(HostConnectFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoPermissionOnHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoPermissionOnNasVolume;
our @ISA = qw(NasConfigFault);

our @property_list = (
   ['userName', undef, undef, 0],
);


VIMRuntime::make_get_set('NoPermissionOnNasVolume', 'userName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoSubjectName;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoSubjectName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoVcManagedIpConfigured;
our @ISA = qw(VAppPropertyFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoVcManagedIpConfigured');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoVirtualNic;
our @ISA = qw(HostConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoVirtualNic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NoVmInVApp;
our @ISA = qw(VAppConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('NoVmInVApp');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NonADUserRequired;
our @ISA = qw(ActiveDirectoryFault);

our @property_list = (
);


VIMRuntime::make_get_set('NonADUserRequired');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NonHomeRDMVMotionNotSupported;
our @ISA = qw(MigrationFeatureNotSupported);

our @property_list = (
   ['device', undef, undef, 1],
);


VIMRuntime::make_get_set('NonHomeRDMVMotionNotSupported', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NonPersistentDisksNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('NonPersistentDisksNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NonVmwareOuiMacNotSupportedHost;
our @ISA = qw(NotSupportedHost);

our @property_list = (
   ['hostName', undef, undef, 1],
);


VIMRuntime::make_get_set('NonVmwareOuiMacNotSupportedHost', 'hostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotADirectory;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('NotADirectory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotAFile;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('NotAFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotAuthenticated;
our @ISA = qw(NoPermission);

our @property_list = (
);


VIMRuntime::make_get_set('NotAuthenticated');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotEnoughCpus;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['numCpuDest', undef, undef, 1],
   ['numCpuVm', undef, undef, 1],
);


VIMRuntime::make_get_set('NotEnoughCpus', 'numCpuDest', 'numCpuVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotEnoughLogicalCpus;
our @ISA = qw(NotEnoughCpus);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('NotEnoughLogicalCpus', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotFound;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('NotFound');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotSupportedDeviceForFT;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['hostName', undef, undef, 0],
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 0],
   ['deviceType', undef, undef, 1],
   ['deviceLabel', undef, undef, 0],
);


VIMRuntime::make_get_set('NotSupportedDeviceForFT', 'host', 'hostName', 'vm', 'vmName', 'deviceType', 'deviceLabel');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotSupportedHost;
our @ISA = qw(HostConnectFault);

our @property_list = (
   ['productName', undef, undef, 0],
   ['productVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('NotSupportedHost', 'productName', 'productVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotSupportedHostForVFlash;
our @ISA = qw(NotSupportedHost);

our @property_list = (
   ['hostName', undef, undef, 1],
);


VIMRuntime::make_get_set('NotSupportedHostForVFlash', 'hostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotSupportedHostForVsan;
our @ISA = qw(NotSupportedHost);

our @property_list = (
   ['hostName', undef, undef, 1],
);


VIMRuntime::make_get_set('NotSupportedHostForVsan', 'hostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotSupportedHostInCluster;
our @ISA = qw(NotSupportedHost);

our @property_list = (
);


VIMRuntime::make_get_set('NotSupportedHostInCluster');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotSupportedHostInDvs;
our @ISA = qw(NotSupportedHost);

our @property_list = (
   ['switchProductSpec', 'DistributedVirtualSwitchProductSpec', undef, 1],
);


VIMRuntime::make_get_set('NotSupportedHostInDvs', 'switchProductSpec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotSupportedHostInHACluster;
our @ISA = qw(NotSupportedHost);

our @property_list = (
   ['hostName', undef, undef, 1],
   ['build', undef, undef, 1],
);


VIMRuntime::make_get_set('NotSupportedHostInHACluster', 'hostName', 'build');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NotUserConfigurableProperty;
our @ISA = qw(VAppPropertyFault);

our @property_list = (
);


VIMRuntime::make_get_set('NotUserConfigurableProperty');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NumVirtualCoresPerSocketNotSupported;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['maxSupportedCoresPerSocketDest', undef, undef, 1],
   ['numCoresPerSocketVm', undef, undef, 1],
);


VIMRuntime::make_get_set('NumVirtualCoresPerSocketNotSupported', 'maxSupportedCoresPerSocketDest', 'numCoresPerSocketVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NumVirtualCpusExceedsLimit;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
   ['maxSupportedVcpus', undef, undef, 1],
);


VIMRuntime::make_get_set('NumVirtualCpusExceedsLimit', 'maxSupportedVcpus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NumVirtualCpusIncompatible;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['reason', undef, undef, 1],
   ['numCpu', undef, undef, 1],
);


VIMRuntime::make_get_set('NumVirtualCpusIncompatible', 'reason', 'numCpu');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NumVirtualCpusNotSupported;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['maxSupportedVcpusDest', undef, undef, 1],
   ['numCpuVm', undef, undef, 1],
);


VIMRuntime::make_get_set('NumVirtualCpusNotSupported', 'maxSupportedVcpusDest', 'numCpuVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OperationDisabledByGuest;
our @ISA = qw(GuestOperationsFault);

our @property_list = (
);


VIMRuntime::make_get_set('OperationDisabledByGuest');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OperationDisallowedOnHost;
our @ISA = qw(RuntimeFault);

our @property_list = (
);


VIMRuntime::make_get_set('OperationDisallowedOnHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OperationNotSupportedByGuest;
our @ISA = qw(GuestOperationsFault);

our @property_list = (
);


VIMRuntime::make_get_set('OperationNotSupportedByGuest');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OutOfBounds;
our @ISA = qw(VimFault);

our @property_list = (
   ['argumentName', undef, undef, 1],
);


VIMRuntime::make_get_set('OutOfBounds', 'argumentName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfAttribute;
our @ISA = qw(OvfInvalidPackage);

our @property_list = (
   ['elementName', undef, undef, 1],
   ['attributeName', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfAttribute', 'elementName', 'attributeName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConnectedDevice;
our @ISA = qw(OvfHardwareExport);

our @property_list = (
);


VIMRuntime::make_get_set('OvfConnectedDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConnectedDeviceFloppy;
our @ISA = qw(OvfConnectedDevice);

our @property_list = (
   ['filename', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConnectedDeviceFloppy', 'filename');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConnectedDeviceIso;
our @ISA = qw(OvfConnectedDevice);

our @property_list = (
   ['filename', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConnectedDeviceIso', 'filename');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConstraint;
our @ISA = qw(OvfInvalidPackage);

our @property_list = (
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConstraint', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerCallbackFault;
our @ISA = qw(OvfFault);

our @property_list = (
   ['extensionKey', undef, undef, 1],
   ['extensionName', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConsumerCallbackFault', 'extensionKey', 'extensionName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerCommunicationError;
our @ISA = qw(OvfConsumerCallbackFault);

our @property_list = (
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConsumerCommunicationError', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerFault;
our @ISA = qw(OvfConsumerCallbackFault);

our @property_list = (
   ['errorKey', undef, undef, 1],
   ['message', undef, undef, 1],
   ['params', 'KeyValue', 1, 0],
);


VIMRuntime::make_get_set('OvfConsumerFault', 'errorKey', 'message', 'params');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerInvalidSection;
our @ISA = qw(OvfConsumerCallbackFault);

our @property_list = (
   ['lineNumber', undef, undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConsumerInvalidSection', 'lineNumber', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerPowerOnFault;
our @ISA = qw(InvalidState);

our @property_list = (
   ['extensionKey', undef, undef, 1],
   ['extensionName', undef, undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConsumerPowerOnFault', 'extensionKey', 'extensionName', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerUndeclaredSection;
our @ISA = qw(OvfConsumerCallbackFault);

our @property_list = (
   ['qualifiedSectionType', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConsumerUndeclaredSection', 'qualifiedSectionType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerUndefinedPrefix;
our @ISA = qw(OvfConsumerCallbackFault);

our @property_list = (
   ['prefix', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConsumerUndefinedPrefix', 'prefix');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfConsumerValidationFault;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['extensionKey', undef, undef, 1],
   ['extensionName', undef, undef, 1],
   ['message', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfConsumerValidationFault', 'extensionKey', 'extensionName', 'message');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCpuCompatibility;
our @ISA = qw(OvfImport);

our @property_list = (
   ['registerName', undef, undef, 1],
   ['level', undef, undef, 1],
   ['registerValue', undef, undef, 1],
   ['desiredRegisterValue', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfCpuCompatibility', 'registerName', 'level', 'registerValue', 'desiredRegisterValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfCpuCompatibilityCheckNotSupported;
our @ISA = qw(OvfImport);

our @property_list = (
);


VIMRuntime::make_get_set('OvfCpuCompatibilityCheckNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfDiskMappingNotFound;
our @ISA = qw(OvfSystemFault);

our @property_list = (
   ['diskName', undef, undef, 1],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfDiskMappingNotFound', 'diskName', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfDiskOrderConstraint;
our @ISA = qw(OvfConstraint);

our @property_list = (
);


VIMRuntime::make_get_set('OvfDiskOrderConstraint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfDuplicateElement;
our @ISA = qw(OvfElement);

our @property_list = (
);


VIMRuntime::make_get_set('OvfDuplicateElement');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfDuplicatedElementBoundary;
our @ISA = qw(OvfElement);

our @property_list = (
   ['boundary', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfDuplicatedElementBoundary', 'boundary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfDuplicatedPropertyIdExport;
our @ISA = qw(OvfExport);

our @property_list = (
   ['fqid', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfDuplicatedPropertyIdExport', 'fqid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfDuplicatedPropertyIdImport;
our @ISA = qw(OvfExport);

our @property_list = (
);


VIMRuntime::make_get_set('OvfDuplicatedPropertyIdImport');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfElement;
our @ISA = qw(OvfInvalidPackage);

our @property_list = (
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfElement', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfElementInvalidValue;
our @ISA = qw(OvfElement);

our @property_list = (
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfElementInvalidValue', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfExport;
our @ISA = qw(OvfFault);

our @property_list = (
);


VIMRuntime::make_get_set('OvfExport');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfExportFailed;
our @ISA = qw(OvfExport);

our @property_list = (
);


VIMRuntime::make_get_set('OvfExportFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('OvfFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfHardwareCheck;
our @ISA = qw(OvfImport);

our @property_list = (
);


VIMRuntime::make_get_set('OvfHardwareCheck');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfHardwareExport;
our @ISA = qw(OvfExport);

our @property_list = (
   ['device', 'VirtualDevice', undef, 0],
   ['vmPath', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfHardwareExport', 'device', 'vmPath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfHostResourceConstraint;
our @ISA = qw(OvfConstraint);

our @property_list = (
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfHostResourceConstraint', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfHostValueNotParsed;
our @ISA = qw(OvfSystemFault);

our @property_list = (
   ['property', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfHostValueNotParsed', 'property', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfImport;
our @ISA = qw(OvfFault);

our @property_list = (
);


VIMRuntime::make_get_set('OvfImport');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfImportFailed;
our @ISA = qw(OvfImport);

our @property_list = (
);


VIMRuntime::make_get_set('OvfImportFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfInternalError;
our @ISA = qw(OvfSystemFault);

our @property_list = (
);


VIMRuntime::make_get_set('OvfInternalError');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfInvalidPackage;
our @ISA = qw(OvfFault);

our @property_list = (
   ['lineNumber', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfInvalidPackage', 'lineNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfInvalidValue;
our @ISA = qw(OvfAttribute);

our @property_list = (
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfInvalidValue', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfInvalidValueConfiguration;
our @ISA = qw(OvfInvalidValue);

our @property_list = (
);


VIMRuntime::make_get_set('OvfInvalidValueConfiguration');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfInvalidValueEmpty;
our @ISA = qw(OvfInvalidValue);

our @property_list = (
);


VIMRuntime::make_get_set('OvfInvalidValueEmpty');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfInvalidValueFormatMalformed;
our @ISA = qw(OvfInvalidValue);

our @property_list = (
);


VIMRuntime::make_get_set('OvfInvalidValueFormatMalformed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfInvalidValueReference;
our @ISA = qw(OvfInvalidValue);

our @property_list = (
);


VIMRuntime::make_get_set('OvfInvalidValueReference');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfInvalidVmName;
our @ISA = qw(OvfUnsupportedPackage);

our @property_list = (
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfInvalidVmName', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfMappedOsId;
our @ISA = qw(OvfImport);

our @property_list = (
   ['ovfId', undef, undef, 1],
   ['ovfDescription', undef, undef, 1],
   ['targetDescription', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfMappedOsId', 'ovfId', 'ovfDescription', 'targetDescription');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfMissingAttribute;
our @ISA = qw(OvfAttribute);

our @property_list = (
);


VIMRuntime::make_get_set('OvfMissingAttribute');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfMissingElement;
our @ISA = qw(OvfElement);

our @property_list = (
);


VIMRuntime::make_get_set('OvfMissingElement');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfMissingElementNormalBoundary;
our @ISA = qw(OvfMissingElement);

our @property_list = (
   ['boundary', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfMissingElementNormalBoundary', 'boundary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfMissingHardware;
our @ISA = qw(OvfImport);

our @property_list = (
   ['name', undef, undef, 1],
   ['resourceType', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfMissingHardware', 'name', 'resourceType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfNetworkMappingNotSupported;
our @ISA = qw(OvfImport);

our @property_list = (
);


VIMRuntime::make_get_set('OvfNetworkMappingNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfNoHostNic;
our @ISA = qw(OvfUnsupportedPackage);

our @property_list = (
);


VIMRuntime::make_get_set('OvfNoHostNic');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfNoSpaceOnController;
our @ISA = qw(OvfUnsupportedElement);

our @property_list = (
   ['parent', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfNoSpaceOnController', 'parent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfNoSupportedHardwareFamily;
our @ISA = qw(OvfUnsupportedPackage);

our @property_list = (
   ['version', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfNoSupportedHardwareFamily', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfProperty;
our @ISA = qw(OvfInvalidPackage);

our @property_list = (
   ['type', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfProperty', 'type', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfPropertyExport;
our @ISA = qw(OvfExport);

our @property_list = (
   ['type', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfPropertyExport', 'type', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfPropertyNetwork;
our @ISA = qw(OvfProperty);

our @property_list = (
);


VIMRuntime::make_get_set('OvfPropertyNetwork');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfPropertyNetworkExport;
our @ISA = qw(OvfExport);

our @property_list = (
   ['network', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfPropertyNetworkExport', 'network');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfPropertyQualifier;
our @ISA = qw(OvfProperty);

our @property_list = (
   ['qualifier', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfPropertyQualifier', 'qualifier');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfPropertyQualifierDuplicate;
our @ISA = qw(OvfProperty);

our @property_list = (
   ['qualifier', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfPropertyQualifierDuplicate', 'qualifier');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfPropertyQualifierIgnored;
our @ISA = qw(OvfProperty);

our @property_list = (
   ['qualifier', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfPropertyQualifierIgnored', 'qualifier');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfPropertyType;
our @ISA = qw(OvfProperty);

our @property_list = (
);


VIMRuntime::make_get_set('OvfPropertyType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfPropertyValue;
our @ISA = qw(OvfProperty);

our @property_list = (
);


VIMRuntime::make_get_set('OvfPropertyValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfSystemFault;
our @ISA = qw(OvfFault);

our @property_list = (
);


VIMRuntime::make_get_set('OvfSystemFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfToXmlUnsupportedElement;
our @ISA = qw(OvfSystemFault);

our @property_list = (
   ['name', undef, undef, 0],
);


VIMRuntime::make_get_set('OvfToXmlUnsupportedElement', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnableToExportDisk;
our @ISA = qw(OvfHardwareExport);

our @property_list = (
   ['diskName', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnableToExportDisk', 'diskName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnexpectedElement;
our @ISA = qw(OvfElement);

our @property_list = (
);


VIMRuntime::make_get_set('OvfUnexpectedElement');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnknownDevice;
our @ISA = qw(OvfSystemFault);

our @property_list = (
   ['device', 'VirtualDevice', undef, 0],
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnknownDevice', 'device', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnknownDeviceBacking;
our @ISA = qw(OvfHardwareExport);

our @property_list = (
   ['backing', 'VirtualDeviceBackingInfo', undef, 1],
);


VIMRuntime::make_get_set('OvfUnknownDeviceBacking', 'backing');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnknownEntity;
our @ISA = qw(OvfSystemFault);

our @property_list = (
   ['lineNumber', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnknownEntity', 'lineNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedAttribute;
our @ISA = qw(OvfUnsupportedPackage);

our @property_list = (
   ['elementName', undef, undef, 1],
   ['attributeName', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnsupportedAttribute', 'elementName', 'attributeName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedAttributeValue;
our @ISA = qw(OvfUnsupportedAttribute);

our @property_list = (
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnsupportedAttributeValue', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedDeviceBackingInfo;
our @ISA = qw(OvfSystemFault);

our @property_list = (
   ['elementName', undef, undef, 0],
   ['instanceId', undef, undef, 0],
   ['deviceName', undef, undef, 1],
   ['backingName', undef, undef, 0],
);


VIMRuntime::make_get_set('OvfUnsupportedDeviceBackingInfo', 'elementName', 'instanceId', 'deviceName', 'backingName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedDeviceBackingOption;
our @ISA = qw(OvfSystemFault);

our @property_list = (
   ['elementName', undef, undef, 0],
   ['instanceId', undef, undef, 0],
   ['deviceName', undef, undef, 1],
   ['backingName', undef, undef, 0],
);


VIMRuntime::make_get_set('OvfUnsupportedDeviceBackingOption', 'elementName', 'instanceId', 'deviceName', 'backingName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedDeviceExport;
our @ISA = qw(OvfHardwareExport);

our @property_list = (
);


VIMRuntime::make_get_set('OvfUnsupportedDeviceExport');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedDiskProvisioning;
our @ISA = qw(OvfImport);

our @property_list = (
   ['diskProvisioning', undef, undef, 1],
   ['supportedDiskProvisioning', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnsupportedDiskProvisioning', 'diskProvisioning', 'supportedDiskProvisioning');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedElement;
our @ISA = qw(OvfUnsupportedPackage);

our @property_list = (
   ['name', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnsupportedElement', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedElementValue;
our @ISA = qw(OvfUnsupportedElement);

our @property_list = (
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnsupportedElementValue', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedPackage;
our @ISA = qw(OvfFault);

our @property_list = (
   ['lineNumber', undef, undef, 0],
);


VIMRuntime::make_get_set('OvfUnsupportedPackage', 'lineNumber');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedSection;
our @ISA = qw(OvfUnsupportedElement);

our @property_list = (
   ['info', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnsupportedSection', 'info');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedSubType;
our @ISA = qw(OvfUnsupportedPackage);

our @property_list = (
   ['elementName', undef, undef, 1],
   ['instanceId', undef, undef, 1],
   ['deviceType', undef, undef, 1],
   ['deviceSubType', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnsupportedSubType', 'elementName', 'instanceId', 'deviceType', 'deviceSubType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfUnsupportedType;
our @ISA = qw(OvfUnsupportedPackage);

our @property_list = (
   ['name', undef, undef, 1],
   ['instanceId', undef, undef, 1],
   ['deviceType', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfUnsupportedType', 'name', 'instanceId', 'deviceType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfWrongElement;
our @ISA = qw(OvfElement);

our @property_list = (
);


VIMRuntime::make_get_set('OvfWrongElement');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfWrongNamespace;
our @ISA = qw(OvfInvalidPackage);

our @property_list = (
   ['namespaceName', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfWrongNamespace', 'namespaceName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package OvfXmlFormat;
our @ISA = qw(OvfInvalidPackage);

our @property_list = (
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('OvfXmlFormat', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchAlreadyInstalled;
our @ISA = qw(PatchNotApplicable);

our @property_list = (
);


VIMRuntime::make_get_set('PatchAlreadyInstalled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchBinariesNotFound;
our @ISA = qw(VimFault);

our @property_list = (
   ['patchID', undef, undef, 1],
   ['binary', undef, 1, 0],
);


VIMRuntime::make_get_set('PatchBinariesNotFound', 'patchID', 'binary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchInstallFailed;
our @ISA = qw(PlatformConfigFault);

our @property_list = (
   ['rolledBack', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('PatchInstallFailed', 'rolledBack');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchIntegrityError;
our @ISA = qw(PlatformConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('PatchIntegrityError');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchMetadataCorrupted;
our @ISA = qw(PatchMetadataInvalid);

our @property_list = (
);


VIMRuntime::make_get_set('PatchMetadataCorrupted');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchMetadataInvalid;
our @ISA = qw(VimFault);

our @property_list = (
   ['patchID', undef, undef, 1],
   ['metaData', undef, 1, 0],
);


VIMRuntime::make_get_set('PatchMetadataInvalid', 'patchID', 'metaData');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchMetadataNotFound;
our @ISA = qw(PatchMetadataInvalid);

our @property_list = (
);


VIMRuntime::make_get_set('PatchMetadataNotFound');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchMissingDependencies;
our @ISA = qw(PatchNotApplicable);

our @property_list = (
   ['prerequisitePatch', undef, 1, 0],
   ['prerequisiteLib', undef, 1, 0],
);


VIMRuntime::make_get_set('PatchMissingDependencies', 'prerequisitePatch', 'prerequisiteLib');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchNotApplicable;
our @ISA = qw(VimFault);

our @property_list = (
   ['patchID', undef, undef, 1],
);


VIMRuntime::make_get_set('PatchNotApplicable', 'patchID');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PatchSuperseded;
our @ISA = qw(PatchNotApplicable);

our @property_list = (
   ['supersede', undef, 1, 0],
);


VIMRuntime::make_get_set('PatchSuperseded', 'supersede');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PhysCompatRDMNotSupported;
our @ISA = qw(RDMNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('PhysCompatRDMNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PlatformConfigFault;
our @ISA = qw(HostConfigFault);

our @property_list = (
   ['text', undef, undef, 1],
);


VIMRuntime::make_get_set('PlatformConfigFault', 'text');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PowerOnFtSecondaryFailed;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 1],
   ['hostSelectionBy', 'FtIssuesOnHostHostSelectionType', undef, 1],
   ['hostErrors', 'LocalizedMethodFault', 1, 0],
   ['rootCause', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('PowerOnFtSecondaryFailed', 'vm', 'vmName', 'hostSelectionBy', 'hostErrors', 'rootCause');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package PowerOnFtSecondaryTimedout;
our @ISA = qw(Timedout);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 1],
   ['vmName', undef, undef, 1],
   ['timeout', undef, undef, 1],
);


VIMRuntime::make_get_set('PowerOnFtSecondaryTimedout', 'vm', 'vmName', 'timeout');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileUpdateFailedUpdateFailure;
our @ISA = qw(DynamicData);

our @property_list = (
   ['profilePath', 'ProfilePropertyPath', undef, 1],
   ['errMsg', 'LocalizableMessage', undef, 1],
);


VIMRuntime::make_get_set('ProfileUpdateFailedUpdateFailure', 'profilePath', 'errMsg');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfProfileUpdateFailedUpdateFailure;
our @ISA = qw(ComplexType);

our @property_list = (
   ['ProfileUpdateFailedUpdateFailure', 'ProfileUpdateFailedUpdateFailure', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfProfileUpdateFailedUpdateFailure', 'ProfileUpdateFailedUpdateFailure');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ProfileUpdateFailed;
our @ISA = qw(VimFault);

our @property_list = (
   ['failure', 'ProfileUpdateFailedUpdateFailure', 1, 1],
);


VIMRuntime::make_get_set('ProfileUpdateFailed', 'failure');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package QuestionPending;
our @ISA = qw(InvalidState);

our @property_list = (
   ['text', undef, undef, 1],
);


VIMRuntime::make_get_set('QuestionPending', 'text');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package QuiesceDatastoreIOForHAFailed;
our @ISA = qw(ResourceInUse);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['hostName', undef, undef, 1],
   ['ds', 'ManagedObjectReference', undef, 1],
   ['dsName', undef, undef, 1],
);


VIMRuntime::make_get_set('QuiesceDatastoreIOForHAFailed', 'host', 'hostName', 'ds', 'dsName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RDMConversionNotSupported;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['device', undef, undef, 1],
);


VIMRuntime::make_get_set('RDMConversionNotSupported', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RDMNotPreserved;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['device', undef, undef, 1],
);


VIMRuntime::make_get_set('RDMNotPreserved', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RDMNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('RDMNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RDMNotSupportedOnDatastore;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['device', undef, undef, 1],
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['datastoreName', undef, undef, 1],
);


VIMRuntime::make_get_set('RDMNotSupportedOnDatastore', 'device', 'datastore', 'datastoreName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RDMPointsToInaccessibleDisk;
our @ISA = qw(CannotAccessVmDisk);

our @property_list = (
);


VIMRuntime::make_get_set('RDMPointsToInaccessibleDisk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RawDiskNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('RawDiskNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReadHostResourcePoolTreeFailed;
our @ISA = qw(HostConnectFault);

our @property_list = (
);


VIMRuntime::make_get_set('ReadHostResourcePoolTreeFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReadOnlyDisksWithLegacyDestination;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['roDiskCount', undef, undef, 1],
   ['timeoutDanger', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('ReadOnlyDisksWithLegacyDestination', 'roDiskCount', 'timeoutDanger');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RebootRequired;
our @ISA = qw(VimFault);

our @property_list = (
   ['patch', undef, undef, 0],
);


VIMRuntime::make_get_set('RebootRequired', 'patch');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RecordReplayDisabled;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('RecordReplayDisabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RemoteDeviceNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('RemoteDeviceNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RemoveFailed;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('RemoveFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationConfigFault;
our @ISA = qw(ReplicationFault);

our @property_list = (
);


VIMRuntime::make_get_set('ReplicationConfigFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationDiskConfigFault;
our @ISA = qw(ReplicationConfigFault);

our @property_list = (
   ['reason', undef, undef, 0],
   ['vmRef', 'ManagedObjectReference', undef, 0],
   ['key', undef, undef, 0],
);


VIMRuntime::make_get_set('ReplicationDiskConfigFault', 'reason', 'vmRef', 'key');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('ReplicationFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationIncompatibleWithFT;
our @ISA = qw(ReplicationFault);

our @property_list = (
);


VIMRuntime::make_get_set('ReplicationIncompatibleWithFT');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationInvalidOptions;
our @ISA = qw(ReplicationFault);

our @property_list = (
   ['options', undef, undef, 1],
   ['entity', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ReplicationInvalidOptions', 'options', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationNotSupportedOnHost;
our @ISA = qw(ReplicationFault);

our @property_list = (
);


VIMRuntime::make_get_set('ReplicationNotSupportedOnHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationVmConfigFault;
our @ISA = qw(ReplicationConfigFault);

our @property_list = (
   ['reason', undef, undef, 0],
   ['vmRef', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ReplicationVmConfigFault', 'reason', 'vmRef');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ReplicationVmFault;
our @ISA = qw(ReplicationFault);

our @property_list = (
   ['reason', undef, undef, 0],
   ['state', undef, undef, 0],
   ['instanceId', undef, undef, 0],
   ['vm', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('ReplicationVmFault', 'reason', 'state', 'instanceId', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceInUse;
our @ISA = qw(VimFault);

our @property_list = (
   ['type', undef, undef, 0],
   ['name', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourceInUse', 'type', 'name');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ResourceNotAvailable;
our @ISA = qw(VimFault);

our @property_list = (
   ['containerType', undef, undef, 0],
   ['containerName', undef, undef, 0],
   ['type', undef, undef, 0],
);


VIMRuntime::make_get_set('ResourceNotAvailable', 'containerType', 'containerName', 'type');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RestrictedVersion;
our @ISA = qw(SecurityError);

our @property_list = (
);


VIMRuntime::make_get_set('RestrictedVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RollbackFailure;
our @ISA = qw(DvsFault);

our @property_list = (
   ['entityName', undef, undef, 1],
   ['entityType', undef, undef, 1],
);


VIMRuntime::make_get_set('RollbackFailure', 'entityName', 'entityType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package RuleViolation;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 0],
   ['rule', 'ClusterRuleInfo', undef, 0],
);


VIMRuntime::make_get_set('RuleViolation', 'host', 'rule');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SSLDisabledFault;
our @ISA = qw(HostConnectFault);

our @property_list = (
);


VIMRuntime::make_get_set('SSLDisabledFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SSLVerifyFault;
our @ISA = qw(HostConnectFault);

our @property_list = (
   ['selfSigned', 'boolean', undef, 1],
   ['thumbprint', undef, undef, 1],
);


VIMRuntime::make_get_set('SSLVerifyFault', 'selfSigned', 'thumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SSPIChallenge;
our @ISA = qw(VimFault);

our @property_list = (
   ['base64Token', undef, undef, 1],
);


VIMRuntime::make_get_set('SSPIChallenge', 'base64Token');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SecondaryVmAlreadyDisabled;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['instanceUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('SecondaryVmAlreadyDisabled', 'instanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SecondaryVmAlreadyEnabled;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['instanceUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('SecondaryVmAlreadyEnabled', 'instanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SecondaryVmAlreadyRegistered;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['instanceUuid', undef, undef, 0],
);


VIMRuntime::make_get_set('SecondaryVmAlreadyRegistered', 'instanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SecondaryVmNotRegistered;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['instanceUuid', undef, undef, 0],
);


VIMRuntime::make_get_set('SecondaryVmNotRegistered', 'instanceUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SharedBusControllerNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('SharedBusControllerNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ShrinkDiskFault;
our @ISA = qw(VimFault);

our @property_list = (
   ['diskId', undef, undef, 0],
);


VIMRuntime::make_get_set('ShrinkDiskFault', 'diskId');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotCloneNotSupported;
our @ISA = qw(SnapshotCopyNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('SnapshotCloneNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotCopyNotSupported;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('SnapshotCopyNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotDisabled;
our @ISA = qw(SnapshotFault);

our @property_list = (
);


VIMRuntime::make_get_set('SnapshotDisabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('SnapshotFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotIncompatibleDeviceInVm;
our @ISA = qw(SnapshotFault);

our @property_list = (
   ['fault', 'LocalizedMethodFault', undef, 1],
);


VIMRuntime::make_get_set('SnapshotIncompatibleDeviceInVm', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotLocked;
our @ISA = qw(SnapshotFault);

our @property_list = (
);


VIMRuntime::make_get_set('SnapshotLocked');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotMoveFromNonHomeNotSupported;
our @ISA = qw(SnapshotCopyNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('SnapshotMoveFromNonHomeNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotMoveNotSupported;
our @ISA = qw(SnapshotCopyNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('SnapshotMoveNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotMoveToNonHomeNotSupported;
our @ISA = qw(SnapshotCopyNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('SnapshotMoveToNonHomeNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotNoChange;
our @ISA = qw(SnapshotFault);

our @property_list = (
);


VIMRuntime::make_get_set('SnapshotNoChange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SnapshotRevertIssue;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['snapshotName', undef, undef, 0],
   ['event', 'Event', 1, 0],
   ['errors', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('SnapshotRevertIssue', 'snapshotName', 'event', 'errors');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SoftRuleVioCorrectionDisallowed;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('SoftRuleVioCorrectionDisallowed', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SoftRuleVioCorrectionImpact;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['vmName', undef, undef, 1],
);


VIMRuntime::make_get_set('SoftRuleVioCorrectionImpact', 'vmName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SsdDiskNotAvailable;
our @ISA = qw(VimFault);

our @property_list = (
   ['devicePath', undef, undef, 1],
);


VIMRuntime::make_get_set('SsdDiskNotAvailable', 'devicePath');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveDiskInMultiWriterMode;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveDiskInMultiWriterMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveFTVm;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveFTVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveIndependentDisk;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveIndependentDisk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveManuallyPlacedSwapFile;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveManuallyPlacedSwapFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveManuallyPlacedVm;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveManuallyPlacedVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveSharedDisk;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveSharedDisk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveTemplate;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveTemplate');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveVmInUserFolder;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveVmInUserFolder');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveVmWithMountedCDROM;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveVmWithMountedCDROM');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsCannotMoveVmWithNoFilesInLayout;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsCannotMoveVmWithNoFilesInLayout');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsDatacentersCannotShareDatastore;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsDatacentersCannotShareDatastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsDisabledOnVm;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsDisabledOnVm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsIolbDisabledInternally;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsIolbDisabledInternally');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageDrsUnableToMoveFiles;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('StorageDrsUnableToMoveFiles');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageVMotionNotSupported;
our @ISA = qw(MigrationFeatureNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('StorageVMotionNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package StorageVmotionIncompatible;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('StorageVmotionIncompatible', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SuspendedRelocateNotSupported;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('SuspendedRelocateNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SwapDatastoreNotWritableOnHost;
our @ISA = qw(DatastoreNotWritableOnHost);

our @property_list = (
);


VIMRuntime::make_get_set('SwapDatastoreNotWritableOnHost');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SwapDatastoreUnset;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('SwapDatastoreUnset');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SwapPlacementOverrideNotSupported;
our @ISA = qw(InvalidVmConfig);

our @property_list = (
);


VIMRuntime::make_get_set('SwapPlacementOverrideNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SwitchIpUnset;
our @ISA = qw(DvsFault);

our @property_list = (
);


VIMRuntime::make_get_set('SwitchIpUnset');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package SwitchNotInUpgradeMode;
our @ISA = qw(DvsFault);

our @property_list = (
);


VIMRuntime::make_get_set('SwitchNotInUpgradeMode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TaskInProgress;
our @ISA = qw(VimFault);

our @property_list = (
   ['task', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('TaskInProgress', 'task');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ThirdPartyLicenseAssignmentFailed;
our @ISA = qw(RuntimeFault);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['module', undef, undef, 1],
   ['reason', undef, undef, 0],
);


VIMRuntime::make_get_set('ThirdPartyLicenseAssignmentFailed', 'host', 'module', 'reason');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package Timedout;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('Timedout');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TooManyConcurrentNativeClones;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('TooManyConcurrentNativeClones');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TooManyConsecutiveOverrides;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('TooManyConsecutiveOverrides');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TooManyDevices;
our @ISA = qw(InvalidVmConfig);

our @property_list = (
);


VIMRuntime::make_get_set('TooManyDevices');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TooManyDisksOnLegacyHost;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['diskCount', undef, undef, 1],
   ['timeoutDanger', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('TooManyDisksOnLegacyHost', 'diskCount', 'timeoutDanger');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TooManyGuestLogons;
our @ISA = qw(GuestOperationsFault);

our @property_list = (
);


VIMRuntime::make_get_set('TooManyGuestLogons');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TooManyHosts;
our @ISA = qw(HostConnectFault);

our @property_list = (
);


VIMRuntime::make_get_set('TooManyHosts');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TooManyNativeCloneLevels;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('TooManyNativeCloneLevels');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TooManyNativeClonesOnFile;
our @ISA = qw(FileFault);

our @property_list = (
);


VIMRuntime::make_get_set('TooManyNativeClonesOnFile');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TooManySnapshotLevels;
our @ISA = qw(SnapshotFault);

our @property_list = (
);


VIMRuntime::make_get_set('TooManySnapshotLevels');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ToolsAlreadyUpgraded;
our @ISA = qw(VmToolsUpgradeFault);

our @property_list = (
);


VIMRuntime::make_get_set('ToolsAlreadyUpgraded');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ToolsAutoUpgradeNotSupported;
our @ISA = qw(VmToolsUpgradeFault);

our @property_list = (
);


VIMRuntime::make_get_set('ToolsAutoUpgradeNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ToolsImageCopyFailed;
our @ISA = qw(VmToolsUpgradeFault);

our @property_list = (
);


VIMRuntime::make_get_set('ToolsImageCopyFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ToolsImageNotAvailable;
our @ISA = qw(VmToolsUpgradeFault);

our @property_list = (
);


VIMRuntime::make_get_set('ToolsImageNotAvailable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ToolsImageSignatureCheckFailed;
our @ISA = qw(VmToolsUpgradeFault);

our @property_list = (
);


VIMRuntime::make_get_set('ToolsImageSignatureCheckFailed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ToolsInstallationInProgress;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('ToolsInstallationInProgress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ToolsUnavailable;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('ToolsUnavailable');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ToolsUpgradeCancelled;
our @ISA = qw(VmToolsUpgradeFault);

our @property_list = (
);


VIMRuntime::make_get_set('ToolsUpgradeCancelled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnSupportedDatastoreForVFlash;
our @ISA = qw(UnsupportedDatastore);

our @property_list = (
   ['datastoreName', undef, undef, 1],
   ['type', undef, undef, 1],
);


VIMRuntime::make_get_set('UnSupportedDatastoreForVFlash', 'datastoreName', 'type');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UncommittedUndoableDisk;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('UncommittedUndoableDisk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnconfiguredPropertyValue;
our @ISA = qw(InvalidPropertyValue);

our @property_list = (
);


VIMRuntime::make_get_set('UnconfiguredPropertyValue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UncustomizableGuest;
our @ISA = qw(CustomizationFault);

our @property_list = (
   ['uncustomizableGuestOS', undef, undef, 1],
);


VIMRuntime::make_get_set('UncustomizableGuest', 'uncustomizableGuestOS');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnexpectedCustomizationFault;
our @ISA = qw(CustomizationFault);

our @property_list = (
);


VIMRuntime::make_get_set('UnexpectedCustomizationFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnrecognizedHost;
our @ISA = qw(VimFault);

our @property_list = (
   ['hostName', undef, undef, 1],
);


VIMRuntime::make_get_set('UnrecognizedHost', 'hostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnsharedSwapVMotionNotSupported;
our @ISA = qw(MigrationFeatureNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('UnsharedSwapVMotionNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnsupportedDatastore;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('UnsupportedDatastore', 'datastore');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnsupportedGuest;
our @ISA = qw(InvalidVmConfig);

our @property_list = (
   ['unsupportedGuestOS', undef, undef, 1],
);


VIMRuntime::make_get_set('UnsupportedGuest', 'unsupportedGuestOS');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnsupportedVimApiVersion;
our @ISA = qw(VimFault);

our @property_list = (
   ['version', undef, undef, 0],
);


VIMRuntime::make_get_set('UnsupportedVimApiVersion', 'version');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnsupportedVmxLocation;
our @ISA = qw(VmConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('UnsupportedVmxLocation');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UnusedVirtualDiskBlocksNotScrubbed;
our @ISA = qw(DeviceBackingNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('UnusedVirtualDiskBlocksNotScrubbed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package UserNotFound;
our @ISA = qw(VimFault);

our @property_list = (
   ['principal', undef, undef, 1],
   ['unresolved', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('UserNotFound', 'principal', 'unresolved');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VAppConfigFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('VAppConfigFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VAppNotRunning;
our @ISA = qw(VmConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('VAppNotRunning');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VAppOperationInProgress;
our @ISA = qw(RuntimeFault);

our @property_list = (
);


VIMRuntime::make_get_set('VAppOperationInProgress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VAppPropertyFault;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['id', undef, undef, 1],
   ['category', undef, undef, 1],
   ['label', undef, undef, 1],
   ['type', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('VAppPropertyFault', 'id', 'category', 'label', 'type', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VAppTaskInProgress;
our @ISA = qw(TaskInProgress);

our @property_list = (
);


VIMRuntime::make_get_set('VAppTaskInProgress');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VFlashModuleNotSupported;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['vmName', undef, undef, 1],
   ['moduleName', undef, undef, 1],
   ['reason', undef, undef, 1],
   ['hostName', undef, undef, 1],
);


VIMRuntime::make_get_set('VFlashModuleNotSupported', 'vmName', 'moduleName', 'reason', 'hostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VFlashModuleVersionIncompatible;
our @ISA = qw(VimFault);

our @property_list = (
   ['moduleName', undef, undef, 1],
   ['vmRequestModuleVersion', undef, undef, 1],
   ['hostMinSupportedVerson', undef, undef, 1],
   ['hostModuleVersion', undef, undef, 1],
);


VIMRuntime::make_get_set('VFlashModuleVersionIncompatible', 'moduleName', 'vmRequestModuleVersion', 'hostMinSupportedVerson', 'hostModuleVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMINotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('VMINotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMOnConflictDVPort;
our @ISA = qw(CannotAccessNetwork);

our @property_list = (
);


VIMRuntime::make_get_set('VMOnConflictDVPort');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMOnVirtualIntranet;
our @ISA = qw(CannotAccessNetwork);

our @property_list = (
);


VIMRuntime::make_get_set('VMOnVirtualIntranet');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMotionAcrossNetworkNotSupported;
our @ISA = qw(MigrationFeatureNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('VMotionAcrossNetworkNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMotionInterfaceIssue;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['atSourceHost', 'boolean', undef, 1],
   ['failedHost', undef, undef, 1],
   ['failedHostEntity', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('VMotionInterfaceIssue', 'atSourceHost', 'failedHost', 'failedHostEntity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMotionLinkCapacityLow;
our @ISA = qw(VMotionInterfaceIssue);

our @property_list = (
   ['network', undef, undef, 1],
);


VIMRuntime::make_get_set('VMotionLinkCapacityLow', 'network');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMotionLinkDown;
our @ISA = qw(VMotionInterfaceIssue);

our @property_list = (
   ['network', undef, undef, 1],
);


VIMRuntime::make_get_set('VMotionLinkDown', 'network');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMotionNotConfigured;
our @ISA = qw(VMotionInterfaceIssue);

our @property_list = (
);


VIMRuntime::make_get_set('VMotionNotConfigured');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMotionNotLicensed;
our @ISA = qw(VMotionInterfaceIssue);

our @property_list = (
);


VIMRuntime::make_get_set('VMotionNotLicensed');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMotionNotSupported;
our @ISA = qw(VMotionInterfaceIssue);

our @property_list = (
);


VIMRuntime::make_get_set('VMotionNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VMotionProtocolIncompatible;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('VMotionProtocolIncompatible');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VimFault;
our @ISA = qw(MethodFault);

our @property_list = (
);


VIMRuntime::make_get_set('VimFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualDiskBlocksNotFullyProvisioned;
our @ISA = qw(DeviceBackingNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('VirtualDiskBlocksNotFullyProvisioned');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualDiskModeNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
   ['mode', undef, undef, 1],
);


VIMRuntime::make_get_set('VirtualDiskModeNotSupported', 'mode');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualEthernetCardNotSupported;
our @ISA = qw(DeviceNotSupported);

our @property_list = (
);


VIMRuntime::make_get_set('VirtualEthernetCardNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualHardwareCompatibilityIssue;
our @ISA = qw(VmConfigFault);

our @property_list = (
);


VIMRuntime::make_get_set('VirtualHardwareCompatibilityIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VirtualHardwareVersionNotSupported;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
   ['hostName', undef, undef, 1],
   ['host', 'ManagedObjectReference', undef, 1],
);


VIMRuntime::make_get_set('VirtualHardwareVersionNotSupported', 'hostName', 'host');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmAlreadyExistsInDatacenter;
our @ISA = qw(InvalidFolder);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['hostname', undef, undef, 1],
   ['vm', 'ManagedObjectReference', 1, 1],
);


VIMRuntime::make_get_set('VmAlreadyExistsInDatacenter', 'host', 'hostname', 'vm');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmConfigFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('VmConfigFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmConfigIncompatibleForFaultTolerance;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['fault', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VmConfigIncompatibleForFaultTolerance', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmConfigIncompatibleForRecordReplay;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['fault', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VmConfigIncompatibleForRecordReplay', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFaultToleranceConfigIssue;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['reason', undef, undef, 0],
   ['entityName', undef, undef, 0],
   ['entity', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('VmFaultToleranceConfigIssue', 'reason', 'entityName', 'entity');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFaultToleranceConfigIssueWrapper;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['entityName', undef, undef, 0],
   ['entity', 'ManagedObjectReference', undef, 0],
   ['error', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('VmFaultToleranceConfigIssueWrapper', 'entityName', 'entity', 'error');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFaultToleranceInvalidFileBacking;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['backingType', undef, undef, 0],
   ['backingFilename', undef, undef, 0],
);


VIMRuntime::make_get_set('VmFaultToleranceInvalidFileBacking', 'backingType', 'backingFilename');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFaultToleranceIssue;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('VmFaultToleranceIssue');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFaultToleranceOpIssuesList;
our @ISA = qw(VmFaultToleranceIssue);

our @property_list = (
   ['errors', 'LocalizedMethodFault', 1, 0],
   ['warnings', 'LocalizedMethodFault', 1, 0],
);


VIMRuntime::make_get_set('VmFaultToleranceOpIssuesList', 'errors', 'warnings');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmFaultToleranceTooManyVMsOnHost;
our @ISA = qw(InsufficientResourcesFault);

our @property_list = (
   ['hostName', undef, undef, 0],
   ['maxNumFtVms', undef, undef, 1],
);


VIMRuntime::make_get_set('VmFaultToleranceTooManyVMsOnHost', 'hostName', 'maxNumFtVms');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmHostAffinityRuleViolation;
our @ISA = qw(VmConfigFault);

our @property_list = (
   ['vmName', undef, undef, 1],
   ['hostName', undef, undef, 1],
);


VIMRuntime::make_get_set('VmHostAffinityRuleViolation', 'vmName', 'hostName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmLimitLicense;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['limit', undef, undef, 1],
);


VIMRuntime::make_get_set('VmLimitLicense', 'limit');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMetadataManagerFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('VmMetadataManagerFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmMonitorIncompatibleForFaultTolerance;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('VmMonitorIncompatibleForFaultTolerance');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmPowerOnDisabled;
our @ISA = qw(InvalidState);

our @property_list = (
);


VIMRuntime::make_get_set('VmPowerOnDisabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmToolsUpgradeFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('VmToolsUpgradeFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmValidateMaxDevice;
our @ISA = qw(VimFault);

our @property_list = (
   ['device', undef, undef, 1],
   ['max', undef, undef, 1],
   ['count', undef, undef, 1],
);


VIMRuntime::make_get_set('VmValidateMaxDevice', 'device', 'max', 'count');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmWwnConflict;
our @ISA = qw(InvalidVmConfig);

our @property_list = (
   ['vm', 'ManagedObjectReference', undef, 0],
   ['host', 'ManagedObjectReference', undef, 0],
   ['name', undef, undef, 0],
   ['wwn', undef, undef, 0],
);


VIMRuntime::make_get_set('VmWwnConflict', 'vm', 'host', 'name', 'wwn');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsAlreadyMounted;
our @ISA = qw(VmfsMountFault);

our @property_list = (
);


VIMRuntime::make_get_set('VmfsAlreadyMounted');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsAmbiguousMount;
our @ISA = qw(VmfsMountFault);

our @property_list = (
);


VIMRuntime::make_get_set('VmfsAmbiguousMount');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsMountFault;
our @ISA = qw(HostConfigFault);

our @property_list = (
   ['uuid', undef, undef, 1],
);


VIMRuntime::make_get_set('VmfsMountFault', 'uuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmotionInterfaceNotEnabled;
our @ISA = qw(HostPowerOpFailed);

our @property_list = (
);


VIMRuntime::make_get_set('VmotionInterfaceNotEnabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VolumeEditorError;
our @ISA = qw(CustomizationFault);

our @property_list = (
);


VIMRuntime::make_get_set('VolumeEditorError');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VramLimitLicense;
our @ISA = qw(NotEnoughLicenses);

our @property_list = (
   ['limit', undef, undef, 1],
);


VIMRuntime::make_get_set('VramLimitLicense', 'limit');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanClusterUuidMismatch;
our @ISA = qw(CannotMoveVsanEnabledHost);

our @property_list = (
   ['hostClusterUuid', undef, undef, 1],
   ['destinationClusterUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('VsanClusterUuidMismatch', 'hostClusterUuid', 'destinationClusterUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanDiskFault;
our @ISA = qw(VsanFault);

our @property_list = (
   ['device', undef, undef, 0],
);


VIMRuntime::make_get_set('VsanDiskFault', 'device');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VsanFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('VsanFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VspanDestPortConflict;
our @ISA = qw(DvsFault);

our @property_list = (
   ['vspanSessionKey1', undef, undef, 1],
   ['vspanSessionKey2', undef, undef, 1],
   ['portKey', undef, undef, 1],
);


VIMRuntime::make_get_set('VspanDestPortConflict', 'vspanSessionKey1', 'vspanSessionKey2', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VspanPortConflict;
our @ISA = qw(DvsFault);

our @property_list = (
   ['vspanSessionKey1', undef, undef, 1],
   ['vspanSessionKey2', undef, undef, 1],
   ['portKey', undef, undef, 1],
);


VIMRuntime::make_get_set('VspanPortConflict', 'vspanSessionKey1', 'vspanSessionKey2', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VspanPortMoveFault;
our @ISA = qw(DvsFault);

our @property_list = (
   ['srcPortgroupName', undef, undef, 1],
   ['destPortgroupName', undef, undef, 1],
   ['portKey', undef, undef, 1],
);


VIMRuntime::make_get_set('VspanPortMoveFault', 'srcPortgroupName', 'destPortgroupName', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VspanPortPromiscChangeFault;
our @ISA = qw(DvsFault);

our @property_list = (
   ['portKey', undef, undef, 1],
);


VIMRuntime::make_get_set('VspanPortPromiscChangeFault', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VspanPortgroupPromiscChangeFault;
our @ISA = qw(DvsFault);

our @property_list = (
   ['portgroupName', undef, undef, 1],
);


VIMRuntime::make_get_set('VspanPortgroupPromiscChangeFault', 'portgroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VspanPortgroupTypeChangeFault;
our @ISA = qw(DvsFault);

our @property_list = (
   ['portgroupName', undef, undef, 1],
);


VIMRuntime::make_get_set('VspanPortgroupTypeChangeFault', 'portgroupName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VspanPromiscuousPortNotSupported;
our @ISA = qw(DvsFault);

our @property_list = (
   ['vspanSessionKey', undef, undef, 1],
   ['portKey', undef, undef, 1],
);


VIMRuntime::make_get_set('VspanPromiscuousPortNotSupported', 'vspanSessionKey', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VspanSameSessionPortConflict;
our @ISA = qw(DvsFault);

our @property_list = (
   ['vspanSessionKey', undef, undef, 1],
   ['portKey', undef, undef, 1],
);


VIMRuntime::make_get_set('VspanSameSessionPortConflict', 'vspanSessionKey', 'portKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package WakeOnLanNotSupported;
our @ISA = qw(VirtualHardwareCompatibilityIssue);

our @property_list = (
);


VIMRuntime::make_get_set('WakeOnLanNotSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package WakeOnLanNotSupportedByVmotionNIC;
our @ISA = qw(HostPowerOpFailed);

our @property_list = (
);


VIMRuntime::make_get_set('WakeOnLanNotSupportedByVmotionNIC');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package WillLoseHAProtection;
our @ISA = qw(MigrationFault);

our @property_list = (
   ['resolution', undef, undef, 1],
);


VIMRuntime::make_get_set('WillLoseHAProtection', 'resolution');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package WillModifyConfigCpuRequirements;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('WillModifyConfigCpuRequirements');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package WillResetSnapshotDirectory;
our @ISA = qw(MigrationFault);

our @property_list = (
);


VIMRuntime::make_get_set('WillResetSnapshotDirectory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package WipeDiskFault;
our @ISA = qw(VimFault);

our @property_list = (
);


VIMRuntime::make_get_set('WipeDiskFault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostActiveDirectoryInfo;
our @ISA = qw(HostDirectoryStoreInfo);

our @property_list = (
   ['joinedDomain', undef, undef, 0],
   ['trustedDomain', undef, 1, 0],
   ['domainMembershipStatus', undef, undef, 0],
);


VIMRuntime::make_get_set('HostActiveDirectoryInfo', 'joinedDomain', 'trustedDomain', 'domainMembershipStatus');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostActiveDirectorySpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['domainName', undef, undef, 0],
   ['userName', undef, undef, 0],
   ['password', undef, undef, 0],
   ['camServer', undef, undef, 0],
   ['thumbprint', undef, undef, 0],
);


VIMRuntime::make_get_set('HostActiveDirectorySpec', 'domainName', 'userName', 'password', 'camServer', 'thumbprint');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostActiveDirectory;
our @ISA = qw(DynamicData);

our @property_list = (
   ['changeOperation', undef, undef, 1],
   ['spec', 'HostActiveDirectorySpec', undef, 0],
);


VIMRuntime::make_get_set('HostActiveDirectory', 'changeOperation', 'spec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostActiveDirectory;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostActiveDirectory', 'HostActiveDirectory', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostActiveDirectory', 'HostActiveDirectory');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAuthenticationManagerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['authConfig', 'HostAuthenticationStoreInfo', 1, 1],
);


VIMRuntime::make_get_set('HostAuthenticationManagerInfo', 'authConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAuthenticationStoreInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('HostAuthenticationStoreInfo', 'enabled');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostAuthenticationStoreInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostAuthenticationStoreInfo', 'HostAuthenticationStoreInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostAuthenticationStoreInfo', 'HostAuthenticationStoreInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AutoStartDefaults;
our @ISA = qw(DynamicData);

our @property_list = (
   ['enabled', 'boolean', undef, 0],
   ['startDelay', undef, undef, 0],
   ['stopDelay', undef, undef, 0],
   ['waitForHeartbeat', 'boolean', undef, 0],
   ['stopAction', undef, undef, 0],
);


VIMRuntime::make_get_set('AutoStartDefaults', 'enabled', 'startDelay', 'stopDelay', 'waitForHeartbeat', 'stopAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package AutoStartPowerInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['startOrder', undef, undef, 1],
   ['startDelay', undef, undef, 1],
   ['waitForHeartbeat', 'AutoStartWaitHeartbeatSetting', undef, 1],
   ['startAction', undef, undef, 1],
   ['stopDelay', undef, undef, 1],
   ['stopAction', undef, undef, 1],
);


VIMRuntime::make_get_set('AutoStartPowerInfo', 'key', 'startOrder', 'startDelay', 'waitForHeartbeat', 'startAction', 'stopDelay', 'stopAction');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfAutoStartPowerInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['AutoStartPowerInfo', 'AutoStartPowerInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfAutoStartPowerInfo', 'AutoStartPowerInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostAutoStartManagerConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['defaults', 'AutoStartDefaults', undef, 0],
   ['powerInfo', 'AutoStartPowerInfo', 1, 0],
);


VIMRuntime::make_get_set('HostAutoStartManagerConfig', 'defaults', 'powerInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostBootDeviceInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['bootDevices', 'HostBootDevice', 1, 0],
   ['currentBootDeviceKey', undef, undef, 0],
);


VIMRuntime::make_get_set('HostBootDeviceInfo', 'bootDevices', 'currentBootDeviceKey');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostBootDevice;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['description', undef, undef, 1],
);


VIMRuntime::make_get_set('HostBootDevice', 'key', 'description');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostBootDevice;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostBootDevice', 'HostBootDevice', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostBootDevice', 'HostBootDevice');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCacheConfigurationSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 1],
   ['swapSize', undef, undef, 1],
);


VIMRuntime::make_get_set('HostCacheConfigurationSpec', 'datastore', 'swapSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCacheConfigurationInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', 'ManagedObjectReference', undef, 1],
   ['swapSize', undef, undef, 1],
);


VIMRuntime::make_get_set('HostCacheConfigurationInfo', 'key', 'swapSize');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostCacheConfigurationInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostCacheConfigurationInfo', 'HostCacheConfigurationInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostCacheConfigurationInfo', 'HostCacheConfigurationInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['recursiveResourcePoolsSupported', 'boolean', undef, 1],
   ['cpuMemoryResourceConfigurationSupported', 'boolean', undef, 1],
   ['rebootSupported', 'boolean', undef, 1],
   ['shutdownSupported', 'boolean', undef, 1],
   ['vmotionSupported', 'boolean', undef, 1],
   ['standbySupported', 'boolean', undef, 1],
   ['ipmiSupported', 'boolean', undef, 0],
   ['maxSupportedVMs', undef, undef, 0],
   ['maxRunningVMs', undef, undef, 0],
   ['maxSupportedVcpus', undef, undef, 0],
   ['maxRegisteredVMs', undef, undef, 0],
   ['datastorePrincipalSupported', 'boolean', undef, 1],
   ['sanSupported', 'boolean', undef, 1],
   ['nfsSupported', 'boolean', undef, 1],
   ['iscsiSupported', 'boolean', undef, 1],
   ['vlanTaggingSupported', 'boolean', undef, 1],
   ['nicTeamingSupported', 'boolean', undef, 1],
   ['highGuestMemSupported', 'boolean', undef, 1],
   ['maintenanceModeSupported', 'boolean', undef, 1],
   ['suspendedRelocateSupported', 'boolean', undef, 1],
   ['restrictedSnapshotRelocateSupported', 'boolean', undef, 1],
   ['perVmSwapFiles', 'boolean', undef, 1],
   ['localSwapDatastoreSupported', 'boolean', undef, 1],
   ['unsharedSwapVMotionSupported', 'boolean', undef, 1],
   ['backgroundSnapshotsSupported', 'boolean', undef, 1],
   ['preAssignedPCIUnitNumbersSupported', 'boolean', undef, 1],
   ['screenshotSupported', 'boolean', undef, 1],
   ['scaledScreenshotSupported', 'boolean', undef, 1],
   ['storageVMotionSupported', 'boolean', undef, 0],
   ['vmotionWithStorageVMotionSupported', 'boolean', undef, 0],
   ['vmotionAcrossNetworkSupported', 'boolean', undef, 0],
   ['hbrNicSelectionSupported', 'boolean', undef, 0],
   ['recordReplaySupported', 'boolean', undef, 0],
   ['ftSupported', 'boolean', undef, 0],
   ['replayUnsupportedReason', undef, undef, 0],
   ['replayCompatibilityIssues', undef, 1, 0],
   ['ftCompatibilityIssues', undef, 1, 0],
   ['loginBySSLThumbprintSupported', 'boolean', undef, 0],
   ['cloneFromSnapshotSupported', 'boolean', undef, 0],
   ['deltaDiskBackingsSupported', 'boolean', undef, 0],
   ['perVMNetworkTrafficShapingSupported', 'boolean', undef, 0],
   ['tpmSupported', 'boolean', undef, 0],
   ['supportedCpuFeature', 'HostCpuIdInfo', 1, 0],
   ['virtualExecUsageSupported', 'boolean', undef, 0],
   ['storageIORMSupported', 'boolean', undef, 0],
   ['vmDirectPathGen2Supported', 'boolean', undef, 0],
   ['vmDirectPathGen2UnsupportedReason', undef, 1, 0],
   ['vmDirectPathGen2UnsupportedReasonExtended', undef, undef, 0],
   ['supportedVmfsMajorVersion', undef, 1, 0],
   ['vStorageCapable', 'boolean', undef, 0],
   ['snapshotRelayoutSupported', 'boolean', undef, 0],
   ['firewallIpRulesSupported', 'boolean', undef, 0],
   ['servicePackageInfoSupported', 'boolean', undef, 0],
   ['maxHostRunningVms', undef, undef, 0],
   ['maxHostSupportedVcpus', undef, undef, 0],
   ['vmfsDatastoreMountCapable', 'boolean', undef, 0],
   ['eightPlusHostVmfsSharedAccessSupported', 'boolean', undef, 0],
   ['nestedHVSupported', 'boolean', undef, 0],
   ['vPMCSupported', 'boolean', undef, 0],
   ['interVMCommunicationThroughVMCISupported', 'boolean', undef, 0],
   ['scheduledHardwareUpgradeSupported', 'boolean', undef, 0],
   ['featureCapabilitiesSupported', 'boolean', undef, 0],
   ['latencySensitivitySupported', 'boolean', undef, 0],
   ['storagePolicySupported', 'boolean', undef, 0],
   ['accel3dSupported', 'boolean', undef, 0],
   ['reliableMemoryAware', 'boolean', undef, 0],
   ['multipleNetworkStackInstanceSupported', 'boolean', undef, 0],
   ['vsanSupported', 'boolean', undef, 0],
   ['vFlashSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('HostCapability', 'recursiveResourcePoolsSupported', 'cpuMemoryResourceConfigurationSupported', 'rebootSupported', 'shutdownSupported', 'vmotionSupported', 'standbySupported', 'ipmiSupported', 'maxSupportedVMs', 'maxRunningVMs', 'maxSupportedVcpus', 'maxRegisteredVMs', 'datastorePrincipalSupported', 'sanSupported', 'nfsSupported', 'iscsiSupported', 'vlanTaggingSupported', 'nicTeamingSupported', 'highGuestMemSupported', 'maintenanceModeSupported', 'suspendedRelocateSupported', 'restrictedSnapshotRelocateSupported', 'perVmSwapFiles', 'localSwapDatastoreSupported', 'unsharedSwapVMotionSupported', 'backgroundSnapshotsSupported', 'preAssignedPCIUnitNumbersSupported', 'screenshotSupported', 'scaledScreenshotSupported', 'storageVMotionSupported', 'vmotionWithStorageVMotionSupported', 'vmotionAcrossNetworkSupported', 'hbrNicSelectionSupported', 'recordReplaySupported', 'ftSupported', 'replayUnsupportedReason', 'replayCompatibilityIssues', 'ftCompatibilityIssues', 'loginBySSLThumbprintSupported', 'cloneFromSnapshotSupported', 'deltaDiskBackingsSupported', 'perVMNetworkTrafficShapingSupported', 'tpmSupported', 'supportedCpuFeature', 'virtualExecUsageSupported', 'storageIORMSupported', 'vmDirectPathGen2Supported', 'vmDirectPathGen2UnsupportedReason', 'vmDirectPathGen2UnsupportedReasonExtended', 'supportedVmfsMajorVersion', 'vStorageCapable', 'snapshotRelayoutSupported', 'firewallIpRulesSupported', 'servicePackageInfoSupported', 'maxHostRunningVms', 'maxHostSupportedVcpus', 'vmfsDatastoreMountCapable', 'eightPlusHostVmfsSharedAccessSupported', 'nestedHVSupported', 'vPMCSupported', 'interVMCommunicationThroughVMCISupported', 'scheduledHardwareUpgradeSupported', 'featureCapabilitiesSupported', 'latencySensitivitySupported', 'storagePolicySupported', 'accel3dSupported', 'reliableMemoryAware', 'multipleNetworkStackInstanceSupported', 'vsanSupported', 'vFlashSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConfigChange;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('HostConfigChange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['host', 'ManagedObjectReference', undef, 1],
   ['product', 'AboutInfo', undef, 1],
   ['hyperThread', 'HostHyperThreadScheduleInfo', undef, 0],
   ['consoleReservation', 'ServiceConsoleReservationInfo', undef, 0],
   ['virtualMachineReservation', 'VirtualMachineMemoryReservationInfo', undef, 0],
   ['storageDevice', 'HostStorageDeviceInfo', undef, 0],
   ['multipathState', 'HostMultipathStateInfo', undef, 0],
   ['fileSystemVolume', 'HostFileSystemVolumeInfo', undef, 0],
   ['systemFile', undef, 1, 0],
   ['network', 'HostNetworkInfo', undef, 0],
   ['vmotion', 'HostVMotionInfo', undef, 0],
   ['virtualNicManagerInfo', 'HostVirtualNicManagerInfo', undef, 0],
   ['capabilities', 'HostNetCapabilities', undef, 0],
   ['datastoreCapabilities', 'HostDatastoreSystemCapabilities', undef, 0],
   ['offloadCapabilities', 'HostNetOffloadCapabilities', undef, 0],
   ['service', 'HostServiceInfo', undef, 0],
   ['firewall', 'HostFirewallInfo', undef, 0],
   ['autoStart', 'HostAutoStartManagerConfig', undef, 0],
   ['activeDiagnosticPartition', 'HostDiagnosticPartition', undef, 0],
   ['option', 'OptionValue', 1, 0],
   ['optionDef', 'OptionDef', 1, 0],
   ['datastorePrincipal', undef, undef, 0],
   ['localSwapDatastore', 'ManagedObjectReference', undef, 0],
   ['systemSwapConfiguration', 'HostSystemSwapConfiguration', undef, 0],
   ['systemResources', 'HostSystemResourceInfo', undef, 0],
   ['dateTimeInfo', 'HostDateTimeInfo', undef, 0],
   ['flags', 'HostFlagInfo', undef, 0],
   ['adminDisabled', 'boolean', undef, 0],
   ['ipmi', 'HostIpmiInfo', undef, 0],
   ['sslThumbprintInfo', 'HostSslThumbprintInfo', undef, 0],
   ['sslThumbprintData', 'HostSslThumbprintInfo', 1, 0],
   ['certificate', undef, 1, 0],
   ['pciPassthruInfo', 'HostPciPassthruInfo', 1, 0],
   ['authenticationManagerInfo', 'HostAuthenticationManagerInfo', undef, 0],
   ['featureVersion', 'HostFeatureVersionInfo', 1, 0],
   ['powerSystemCapability', 'PowerSystemCapability', undef, 0],
   ['powerSystemInfo', 'PowerSystemInfo', undef, 0],
   ['cacheConfigurationInfo', 'HostCacheConfigurationInfo', 1, 0],
   ['wakeOnLanCapable', 'boolean', undef, 0],
   ['featureCapability', 'HostFeatureCapability', 1, 0],
   ['maskedFeatureCapability', 'HostFeatureCapability', 1, 0],
   ['vFlashConfigInfo', 'HostVFlashManagerVFlashConfigInfo', undef, 0],
   ['vsanHostConfig', 'VsanHostConfigInfo', undef, 0],
   ['graphicsInfo', 'HostGraphicsInfo', 1, 0],
);


VIMRuntime::make_get_set('HostConfigInfo', 'host', 'product', 'hyperThread', 'consoleReservation', 'virtualMachineReservation', 'storageDevice', 'multipathState', 'fileSystemVolume', 'systemFile', 'network', 'vmotion', 'virtualNicManagerInfo', 'capabilities', 'datastoreCapabilities', 'offloadCapabilities', 'service', 'firewall', 'autoStart', 'activeDiagnosticPartition', 'option', 'optionDef', 'datastorePrincipal', 'localSwapDatastore', 'systemSwapConfiguration', 'systemResources', 'dateTimeInfo', 'flags', 'adminDisabled', 'ipmi', 'sslThumbprintInfo', 'sslThumbprintData', 'certificate', 'pciPassthruInfo', 'authenticationManagerInfo', 'featureVersion', 'powerSystemCapability', 'powerSystemInfo', 'cacheConfigurationInfo', 'wakeOnLanCapable', 'featureCapability', 'maskedFeatureCapability', 'vFlashConfigInfo', 'vsanHostConfig', 'graphicsInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConfigManager;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cpuScheduler', 'ManagedObjectReference', undef, 0],
   ['datastoreSystem', 'ManagedObjectReference', undef, 0],
   ['memoryManager', 'ManagedObjectReference', undef, 0],
   ['storageSystem', 'ManagedObjectReference', undef, 0],
   ['networkSystem', 'ManagedObjectReference', undef, 0],
   ['vmotionSystem', 'ManagedObjectReference', undef, 0],
   ['virtualNicManager', 'ManagedObjectReference', undef, 0],
   ['serviceSystem', 'ManagedObjectReference', undef, 0],
   ['firewallSystem', 'ManagedObjectReference', undef, 0],
   ['advancedOption', 'ManagedObjectReference', undef, 0],
   ['diagnosticSystem', 'ManagedObjectReference', undef, 0],
   ['autoStartManager', 'ManagedObjectReference', undef, 0],
   ['snmpSystem', 'ManagedObjectReference', undef, 0],
   ['dateTimeSystem', 'ManagedObjectReference', undef, 0],
   ['patchManager', 'ManagedObjectReference', undef, 0],
   ['imageConfigManager', 'ManagedObjectReference', undef, 0],
   ['bootDeviceSystem', 'ManagedObjectReference', undef, 0],
   ['firmwareSystem', 'ManagedObjectReference', undef, 0],
   ['healthStatusSystem', 'ManagedObjectReference', undef, 0],
   ['pciPassthruSystem', 'ManagedObjectReference', undef, 0],
   ['licenseManager', 'ManagedObjectReference', undef, 0],
   ['kernelModuleSystem', 'ManagedObjectReference', undef, 0],
   ['authenticationManager', 'ManagedObjectReference', undef, 0],
   ['powerSystem', 'ManagedObjectReference', undef, 0],
   ['cacheConfigurationManager', 'ManagedObjectReference', undef, 0],
   ['esxAgentHostManager', 'ManagedObjectReference', undef, 0],
   ['iscsiManager', 'ManagedObjectReference', undef, 0],
   ['vFlashManager', 'ManagedObjectReference', undef, 0],
   ['vsanSystem', 'ManagedObjectReference', undef, 0],
   ['graphicsManager', 'ManagedObjectReference', undef, 0],
   ['vsanInternalSystem', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('HostConfigManager', 'cpuScheduler', 'datastoreSystem', 'memoryManager', 'storageSystem', 'networkSystem', 'vmotionSystem', 'virtualNicManager', 'serviceSystem', 'firewallSystem', 'advancedOption', 'diagnosticSystem', 'autoStartManager', 'snmpSystem', 'dateTimeSystem', 'patchManager', 'imageConfigManager', 'bootDeviceSystem', 'firmwareSystem', 'healthStatusSystem', 'pciPassthruSystem', 'licenseManager', 'kernelModuleSystem', 'authenticationManager', 'powerSystem', 'cacheConfigurationManager', 'esxAgentHostManager', 'iscsiManager', 'vFlashManager', 'vsanSystem', 'graphicsManager', 'vsanInternalSystem');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConfigSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['nasDatastore', 'HostNasVolumeConfig', 1, 0],
   ['network', 'HostNetworkConfig', undef, 0],
   ['nicTypeSelection', 'HostVirtualNicManagerNicTypeSelection', 1, 0],
   ['service', 'HostServiceConfig', 1, 0],
   ['firewall', 'HostFirewallConfig', undef, 0],
   ['option', 'OptionValue', 1, 0],
   ['datastorePrincipal', undef, undef, 0],
   ['datastorePrincipalPasswd', undef, undef, 0],
   ['datetime', 'HostDateTimeConfig', undef, 0],
   ['storageDevice', 'HostStorageDeviceInfo', undef, 0],
   ['license', 'HostLicenseSpec', undef, 0],
   ['security', 'HostSecuritySpec', undef, 0],
   ['userAccount', 'HostAccountSpec', 1, 0],
   ['usergroupAccount', 'HostAccountSpec', 1, 0],
   ['memory', 'HostMemorySpec', undef, 0],
   ['activeDirectory', 'HostActiveDirectory', 1, 0],
   ['genericConfig', 'KeyAnyValue', 1, 0],
);


VIMRuntime::make_get_set('HostConfigSpec', 'nasDatastore', 'network', 'nicTypeSelection', 'service', 'firewall', 'option', 'datastorePrincipal', 'datastorePrincipalPasswd', 'datetime', 'storageDevice', 'license', 'security', 'userAccount', 'usergroupAccount', 'memory', 'activeDirectory', 'genericConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConnectInfoNetworkInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['summary', 'NetworkSummary', undef, 1],
);


VIMRuntime::make_get_set('HostConnectInfoNetworkInfo', 'summary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostConnectInfoNetworkInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostConnectInfoNetworkInfo', 'HostConnectInfoNetworkInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostConnectInfoNetworkInfo', 'HostConnectInfoNetworkInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostNewNetworkConnectInfo;
our @ISA = qw(HostConnectInfoNetworkInfo);

our @property_list = (
);


VIMRuntime::make_get_set('HostNewNetworkConnectInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDatastoreConnectInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['summary', 'DatastoreSummary', undef, 1],
);


VIMRuntime::make_get_set('HostDatastoreConnectInfo', 'summary');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDatastoreConnectInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDatastoreConnectInfo', 'HostDatastoreConnectInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDatastoreConnectInfo', 'HostDatastoreConnectInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDatastoreExistsConnectInfo;
our @ISA = qw(HostDatastoreConnectInfo);

our @property_list = (
   ['newDatastoreName', undef, undef, 1],
);


VIMRuntime::make_get_set('HostDatastoreExistsConnectInfo', 'newDatastoreName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDatastoreNameConflictConnectInfo;
our @ISA = qw(HostDatastoreConnectInfo);

our @property_list = (
   ['newDatastoreName', undef, undef, 1],
);


VIMRuntime::make_get_set('HostDatastoreNameConflictConnectInfo', 'newDatastoreName');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostLicenseConnectInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['license', 'LicenseManagerLicenseInfo', undef, 1],
   ['evaluation', 'LicenseManagerEvaluationInfo', undef, 1],
   ['resource', 'HostLicensableResourceInfo', undef, 0],
);


VIMRuntime::make_get_set('HostLicenseConnectInfo', 'license', 'evaluation', 'resource');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConnectInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['serverIp', undef, undef, 0],
   ['inDasCluster', 'boolean', undef, 0],
   ['host', 'HostListSummary', undef, 1],
   ['vm', 'VirtualMachineSummary', 1, 0],
   ['vimAccountNameRequired', 'boolean', undef, 0],
   ['clusterSupported', 'boolean', undef, 0],
   ['network', 'HostConnectInfoNetworkInfo', 1, 0],
   ['datastore', 'HostDatastoreConnectInfo', 1, 0],
   ['license', 'HostLicenseConnectInfo', undef, 0],
);


VIMRuntime::make_get_set('HostConnectInfo', 'serverIp', 'inDasCluster', 'host', 'vm', 'vimAccountNameRequired', 'clusterSupported', 'network', 'datastore', 'license');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostConnectSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['hostName', undef, undef, 0],
   ['port', undef, undef, 0],
   ['sslThumbprint', undef, undef, 0],
   ['userName', undef, undef, 0],
   ['password', undef, undef, 0],
   ['vmFolder', 'ManagedObjectReference', undef, 0],
   ['force', 'boolean', undef, 1],
   ['vimAccountName', undef, undef, 0],
   ['vimAccountPassword', undef, undef, 0],
   ['managementIp', undef, undef, 0],
);


VIMRuntime::make_get_set('HostConnectSpec', 'hostName', 'port', 'sslThumbprint', 'userName', 'password', 'vmFolder', 'force', 'vimAccountName', 'vimAccountPassword', 'managementIp');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostCpuIdInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['level', undef, undef, 1],
   ['vendor', undef, undef, 0],
   ['eax', undef, undef, 0],
   ['ebx', undef, undef, 0],
   ['ecx', undef, undef, 0],
   ['edx', undef, undef, 0],
);


VIMRuntime::make_get_set('HostCpuIdInfo', 'level', 'vendor', 'eax', 'ebx', 'ecx', 'edx');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostCpuIdInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostCpuIdInfo', 'HostCpuIdInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostCpuIdInfo', 'HostCpuIdInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostHyperThreadScheduleInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['available', 'boolean', undef, 1],
   ['active', 'boolean', undef, 1],
   ['config', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('HostHyperThreadScheduleInfo', 'available', 'active', 'config');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileQueryFlags;
our @ISA = qw(DynamicData);

our @property_list = (
   ['fileType', 'boolean', undef, 1],
   ['fileSize', 'boolean', undef, 1],
   ['modification', 'boolean', undef, 1],
   ['fileOwner', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('FileQueryFlags', 'fileType', 'fileSize', 'modification', 'fileOwner');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['path', undef, undef, 1],
   ['fileSize', undef, undef, 0],
   ['modification', undef, undef, 0],
   ['owner', undef, undef, 0],
);


VIMRuntime::make_get_set('FileInfo', 'path', 'fileSize', 'modification', 'owner');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfFileInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['FileInfo', 'FileInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfFileInfo', 'FileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FileQuery;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('FileQuery');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfFileQuery;
our @ISA = qw(ComplexType);

our @property_list = (
   ['FileQuery', 'FileQuery', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfFileQuery', 'FileQuery');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmConfigFileQueryFilter;
our @ISA = qw(DynamicData);

our @property_list = (
   ['matchConfigVersion', undef, 1, 0],
);


VIMRuntime::make_get_set('VmConfigFileQueryFilter', 'matchConfigVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmConfigFileQueryFlags;
our @ISA = qw(DynamicData);

our @property_list = (
   ['configVersion', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('VmConfigFileQueryFlags', 'configVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmConfigFileQuery;
our @ISA = qw(FileQuery);

our @property_list = (
   ['filter', 'VmConfigFileQueryFilter', undef, 0],
   ['details', 'VmConfigFileQueryFlags', undef, 0],
);


VIMRuntime::make_get_set('VmConfigFileQuery', 'filter', 'details');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TemplateConfigFileQuery;
our @ISA = qw(VmConfigFileQuery);

our @property_list = (
);


VIMRuntime::make_get_set('TemplateConfigFileQuery');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDiskFileQueryFilter;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskType', undef, 1, 0],
   ['matchHardwareVersion', undef, 1, 0],
   ['controllerType', undef, 1, 0],
   ['thin', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VmDiskFileQueryFilter', 'diskType', 'matchHardwareVersion', 'controllerType', 'thin');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDiskFileQueryFlags;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskType', 'boolean', undef, 1],
   ['capacityKb', 'boolean', undef, 1],
   ['hardwareVersion', 'boolean', undef, 1],
   ['controllerType', 'boolean', undef, 0],
   ['diskExtents', 'boolean', undef, 0],
   ['thin', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VmDiskFileQueryFlags', 'diskType', 'capacityKb', 'hardwareVersion', 'controllerType', 'diskExtents', 'thin');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDiskFileQuery;
our @ISA = qw(FileQuery);

our @property_list = (
   ['filter', 'VmDiskFileQueryFilter', undef, 0],
   ['details', 'VmDiskFileQueryFlags', undef, 0],
);


VIMRuntime::make_get_set('VmDiskFileQuery', 'filter', 'details');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FolderFileQuery;
our @ISA = qw(FileQuery);

our @property_list = (
);


VIMRuntime::make_get_set('FolderFileQuery');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmSnapshotFileQuery;
our @ISA = qw(FileQuery);

our @property_list = (
);


VIMRuntime::make_get_set('VmSnapshotFileQuery');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IsoImageFileQuery;
our @ISA = qw(FileQuery);

our @property_list = (
);


VIMRuntime::make_get_set('IsoImageFileQuery');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FloppyImageFileQuery;
our @ISA = qw(FileQuery);

our @property_list = (
);


VIMRuntime::make_get_set('FloppyImageFileQuery');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmNvramFileQuery;
our @ISA = qw(FileQuery);

our @property_list = (
);


VIMRuntime::make_get_set('VmNvramFileQuery');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmLogFileQuery;
our @ISA = qw(FileQuery);

our @property_list = (
);


VIMRuntime::make_get_set('VmLogFileQuery');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmConfigFileInfo;
our @ISA = qw(FileInfo);

our @property_list = (
   ['configVersion', undef, undef, 0],
);


VIMRuntime::make_get_set('VmConfigFileInfo', 'configVersion');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package TemplateConfigFileInfo;
our @ISA = qw(VmConfigFileInfo);

our @property_list = (
);


VIMRuntime::make_get_set('TemplateConfigFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmDiskFileInfo;
our @ISA = qw(FileInfo);

our @property_list = (
   ['diskType', undef, undef, 0],
   ['capacityKb', undef, undef, 0],
   ['hardwareVersion', undef, undef, 0],
   ['controllerType', undef, undef, 0],
   ['diskExtents', undef, 1, 0],
   ['thin', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VmDiskFileInfo', 'diskType', 'capacityKb', 'hardwareVersion', 'controllerType', 'diskExtents', 'thin');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FolderFileInfo;
our @ISA = qw(FileInfo);

our @property_list = (
);


VIMRuntime::make_get_set('FolderFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmSnapshotFileInfo;
our @ISA = qw(FileInfo);

our @property_list = (
);


VIMRuntime::make_get_set('VmSnapshotFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package IsoImageFileInfo;
our @ISA = qw(FileInfo);

our @property_list = (
);


VIMRuntime::make_get_set('IsoImageFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FloppyImageFileInfo;
our @ISA = qw(FileInfo);

our @property_list = (
);


VIMRuntime::make_get_set('FloppyImageFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmNvramFileInfo;
our @ISA = qw(FileInfo);

our @property_list = (
);


VIMRuntime::make_get_set('VmNvramFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmLogFileInfo;
our @ISA = qw(FileInfo);

our @property_list = (
);


VIMRuntime::make_get_set('VmLogFileInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDatastoreBrowserSearchSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['query', 'FileQuery', 1, 0],
   ['details', 'FileQueryFlags', undef, 0],
   ['searchCaseInsensitive', 'boolean', undef, 0],
   ['matchPattern', undef, 1, 0],
   ['sortFoldersFirst', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('HostDatastoreBrowserSearchSpec', 'query', 'details', 'searchCaseInsensitive', 'matchPattern', 'sortFoldersFirst');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDatastoreBrowserSearchResults;
our @ISA = qw(DynamicData);

our @property_list = (
   ['datastore', 'ManagedObjectReference', undef, 0],
   ['folderPath', undef, undef, 0],
   ['file', 'FileInfo', 1, 0],
);


VIMRuntime::make_get_set('HostDatastoreBrowserSearchResults', 'datastore', 'folderPath', 'file');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDatastoreBrowserSearchResults;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDatastoreBrowserSearchResults', 'HostDatastoreBrowserSearchResults', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDatastoreBrowserSearchResults', 'HostDatastoreBrowserSearchResults');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDatastoreSystemCapabilities;
our @ISA = qw(DynamicData);

our @property_list = (
   ['nfsMountCreationRequired', 'boolean', undef, 1],
   ['nfsMountCreationSupported', 'boolean', undef, 1],
   ['localDatastoreSupported', 'boolean', undef, 1],
   ['vmfsExtentExpansionSupported', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('HostDatastoreSystemCapabilities', 'nfsMountCreationRequired', 'nfsMountCreationSupported', 'localDatastoreSupported', 'vmfsExtentExpansionSupported');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreInfo;
our @ISA = qw(DatastoreInfo);

our @property_list = (
   ['maxPhysicalRDMFileSize', undef, undef, 0],
   ['maxVirtualRDMFileSize', undef, undef, 0],
   ['vmfs', 'HostVmfsVolume', undef, 0],
);


VIMRuntime::make_get_set('VmfsDatastoreInfo', 'maxPhysicalRDMFileSize', 'maxVirtualRDMFileSize', 'vmfs');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package NasDatastoreInfo;
our @ISA = qw(DatastoreInfo);

our @property_list = (
   ['nas', 'HostNasVolume', undef, 0],
);


VIMRuntime::make_get_set('NasDatastoreInfo', 'nas');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package LocalDatastoreInfo;
our @ISA = qw(DatastoreInfo);

our @property_list = (
   ['path', undef, undef, 0],
);


VIMRuntime::make_get_set('LocalDatastoreInfo', 'path');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['diskUuid', undef, undef, 1],
);


VIMRuntime::make_get_set('VmfsDatastoreSpec', 'diskUuid');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreCreateSpec;
our @ISA = qw(VmfsDatastoreSpec);

our @property_list = (
   ['partition', 'HostDiskPartitionSpec', undef, 1],
   ['vmfs', 'HostVmfsSpec', undef, 1],
   ['extent', 'HostScsiDiskPartition', 1, 0],
);


VIMRuntime::make_get_set('VmfsDatastoreCreateSpec', 'partition', 'vmfs', 'extent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreExtendSpec;
our @ISA = qw(VmfsDatastoreSpec);

our @property_list = (
   ['partition', 'HostDiskPartitionSpec', undef, 1],
   ['extent', 'HostScsiDiskPartition', 1, 1],
);


VIMRuntime::make_get_set('VmfsDatastoreExtendSpec', 'partition', 'extent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreExpandSpec;
our @ISA = qw(VmfsDatastoreSpec);

our @property_list = (
   ['partition', 'HostDiskPartitionSpec', undef, 1],
   ['extent', 'HostScsiDiskPartition', undef, 1],
);


VIMRuntime::make_get_set('VmfsDatastoreExpandSpec', 'partition', 'extent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreBaseOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['layout', 'HostDiskPartitionLayout', undef, 1],
   ['partitionFormatChange', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('VmfsDatastoreBaseOption', 'layout', 'partitionFormatChange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreSingleExtentOption;
our @ISA = qw(VmfsDatastoreBaseOption);

our @property_list = (
   ['vmfsExtent', 'HostDiskPartitionBlockRange', undef, 1],
);


VIMRuntime::make_get_set('VmfsDatastoreSingleExtentOption', 'vmfsExtent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreAllExtentOption;
our @ISA = qw(VmfsDatastoreSingleExtentOption);

our @property_list = (
);


VIMRuntime::make_get_set('VmfsDatastoreAllExtentOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreMultipleExtentOption;
our @ISA = qw(VmfsDatastoreBaseOption);

our @property_list = (
   ['vmfsExtent', 'HostDiskPartitionBlockRange', 1, 1],
);


VIMRuntime::make_get_set('VmfsDatastoreMultipleExtentOption', 'vmfsExtent');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package VmfsDatastoreOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['info', 'VmfsDatastoreBaseOption', undef, 1],
   ['spec', 'VmfsDatastoreSpec', undef, 1],
);


VIMRuntime::make_get_set('VmfsDatastoreOption', 'info', 'spec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfVmfsDatastoreOption;
our @ISA = qw(ComplexType);

our @property_list = (
   ['VmfsDatastoreOption', 'VmfsDatastoreOption', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfVmfsDatastoreOption', 'VmfsDatastoreOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDateTimeConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['timeZone', undef, undef, 0],
   ['ntpConfig', 'HostNtpConfig', undef, 0],
);


VIMRuntime::make_get_set('HostDateTimeConfig', 'timeZone', 'ntpConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDateTimeInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['timeZone', 'HostDateTimeSystemTimeZone', undef, 1],
   ['ntpConfig', 'HostNtpConfig', undef, 0],
);


VIMRuntime::make_get_set('HostDateTimeInfo', 'timeZone', 'ntpConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDateTimeSystemTimeZone;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['name', undef, undef, 1],
   ['description', undef, undef, 1],
   ['gmtOffset', undef, undef, 1],
);


VIMRuntime::make_get_set('HostDateTimeSystemTimeZone', 'key', 'name', 'description', 'gmtOffset');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDateTimeSystemTimeZone;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDateTimeSystemTimeZone', 'HostDateTimeSystemTimeZone', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDateTimeSystemTimeZone', 'HostDateTimeSystemTimeZone');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDevice;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceName', undef, undef, 1],
   ['deviceType', undef, undef, 1],
);


VIMRuntime::make_get_set('HostDevice', 'deviceName', 'deviceType');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDhcpServiceSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['virtualSwitch', undef, undef, 1],
   ['defaultLeaseDuration', undef, undef, 1],
   ['leaseBeginIp', undef, undef, 1],
   ['leaseEndIp', undef, undef, 1],
   ['maxLeaseDuration', undef, undef, 1],
   ['unlimitedLease', 'boolean', undef, 1],
   ['ipSubnetAddr', undef, undef, 1],
   ['ipSubnetMask', undef, undef, 1],
);


VIMRuntime::make_get_set('HostDhcpServiceSpec', 'virtualSwitch', 'defaultLeaseDuration', 'leaseBeginIp', 'leaseEndIp', 'maxLeaseDuration', 'unlimitedLease', 'ipSubnetAddr', 'ipSubnetMask');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDhcpServiceConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['changeOperation', undef, undef, 0],
   ['key', undef, undef, 1],
   ['spec', 'HostDhcpServiceSpec', undef, 1],
);


VIMRuntime::make_get_set('HostDhcpServiceConfig', 'changeOperation', 'key', 'spec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDhcpServiceConfig;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDhcpServiceConfig', 'HostDhcpServiceConfig', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDhcpServiceConfig', 'HostDhcpServiceConfig');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDhcpService;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['spec', 'HostDhcpServiceSpec', undef, 1],
);


VIMRuntime::make_get_set('HostDhcpService', 'key', 'spec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDhcpService;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDhcpService', 'HostDhcpService', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDhcpService', 'HostDhcpService');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiagnosticPartitionCreateOption;
our @ISA = qw(DynamicData);

our @property_list = (
   ['storageType', undef, undef, 1],
   ['diagnosticType', undef, undef, 1],
   ['disk', 'HostScsiDisk', undef, 1],
);


VIMRuntime::make_get_set('HostDiagnosticPartitionCreateOption', 'storageType', 'diagnosticType', 'disk');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDiagnosticPartitionCreateOption;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDiagnosticPartitionCreateOption', 'HostDiagnosticPartitionCreateOption', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDiagnosticPartitionCreateOption', 'HostDiagnosticPartitionCreateOption');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiagnosticPartitionCreateSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['storageType', undef, undef, 1],
   ['diagnosticType', undef, undef, 1],
   ['id', 'HostScsiDiskPartition', undef, 1],
   ['partition', 'HostDiskPartitionSpec', undef, 1],
   ['active', 'boolean', undef, 0],
);


VIMRuntime::make_get_set('HostDiagnosticPartitionCreateSpec', 'storageType', 'diagnosticType', 'id', 'partition', 'active');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiagnosticPartitionCreateDescription;
our @ISA = qw(DynamicData);

our @property_list = (
   ['layout', 'HostDiskPartitionLayout', undef, 1],
   ['diskUuid', undef, undef, 1],
   ['spec', 'HostDiagnosticPartitionCreateSpec', undef, 1],
);


VIMRuntime::make_get_set('HostDiagnosticPartitionCreateDescription', 'layout', 'diskUuid', 'spec');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiagnosticPartition;
our @ISA = qw(DynamicData);

our @property_list = (
   ['storageType', undef, undef, 1],
   ['diagnosticType', undef, undef, 1],
   ['slots', undef, undef, 1],
   ['id', 'HostScsiDiskPartition', undef, 1],
);


VIMRuntime::make_get_set('HostDiagnosticPartition', 'storageType', 'diagnosticType', 'slots', 'id');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDiagnosticPartition;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDiagnosticPartition', 'HostDiagnosticPartition', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDiagnosticPartition', 'HostDiagnosticPartition');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDirectoryStoreInfo;
our @ISA = qw(HostAuthenticationStoreInfo);

our @property_list = (
);


VIMRuntime::make_get_set('HostDirectoryStoreInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiskConfigurationResult;
our @ISA = qw(DynamicData);

our @property_list = (
   ['devicePath', undef, undef, 0],
   ['success', 'boolean', undef, 0],
   ['fault', 'LocalizedMethodFault', undef, 0],
);


VIMRuntime::make_get_set('HostDiskConfigurationResult', 'devicePath', 'success', 'fault');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDiskConfigurationResult;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDiskConfigurationResult', 'HostDiskConfigurationResult', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDiskConfigurationResult', 'HostDiskConfigurationResult');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiskDimensionsChs;
our @ISA = qw(DynamicData);

our @property_list = (
   ['cylinder', undef, undef, 1],
   ['head', undef, undef, 1],
   ['sector', undef, undef, 1],
);


VIMRuntime::make_get_set('HostDiskDimensionsChs', 'cylinder', 'head', 'sector');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiskDimensionsLba;
our @ISA = qw(DynamicData);

our @property_list = (
   ['blockSize', undef, undef, 1],
   ['block', undef, undef, 1],
);


VIMRuntime::make_get_set('HostDiskDimensionsLba', 'blockSize', 'block');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiskDimensions;
our @ISA = qw(DynamicData);

our @property_list = (
);


VIMRuntime::make_get_set('HostDiskDimensions');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiskPartitionAttributes;
our @ISA = qw(DynamicData);

our @property_list = (
   ['partition', undef, undef, 1],
   ['startSector', undef, undef, 1],
   ['endSector', undef, undef, 1],
   ['type', undef, undef, 1],
   ['guid', undef, undef, 0],
   ['logical', 'boolean', undef, 1],
   ['attributes', undef, undef, 1],
   ['partitionAlignment', undef, undef, 0],
);


VIMRuntime::make_get_set('HostDiskPartitionAttributes', 'partition', 'startSector', 'endSector', 'type', 'guid', 'logical', 'attributes', 'partitionAlignment');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDiskPartitionAttributes;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDiskPartitionAttributes', 'HostDiskPartitionAttributes', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDiskPartitionAttributes', 'HostDiskPartitionAttributes');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiskPartitionBlockRange;
our @ISA = qw(DynamicData);

our @property_list = (
   ['partition', undef, undef, 0],
   ['type', undef, undef, 1],
   ['start', 'HostDiskDimensionsLba', undef, 1],
   ['end', 'HostDiskDimensionsLba', undef, 1],
);


VIMRuntime::make_get_set('HostDiskPartitionBlockRange', 'partition', 'type', 'start', 'end');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDiskPartitionBlockRange;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDiskPartitionBlockRange', 'HostDiskPartitionBlockRange', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDiskPartitionBlockRange', 'HostDiskPartitionBlockRange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiskPartitionSpec;
our @ISA = qw(DynamicData);

our @property_list = (
   ['partitionFormat', undef, undef, 0],
   ['chs', 'HostDiskDimensionsChs', undef, 0],
   ['totalSectors', undef, undef, 0],
   ['partition', 'HostDiskPartitionAttributes', 1, 0],
);


VIMRuntime::make_get_set('HostDiskPartitionSpec', 'partitionFormat', 'chs', 'totalSectors', 'partition');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiskPartitionLayout;
our @ISA = qw(DynamicData);

our @property_list = (
   ['total', 'HostDiskDimensionsLba', undef, 0],
   ['partition', 'HostDiskPartitionBlockRange', 1, 1],
);


VIMRuntime::make_get_set('HostDiskPartitionLayout', 'total', 'partition');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDiskPartitionInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['deviceName', undef, undef, 1],
   ['spec', 'HostDiskPartitionSpec', undef, 1],
   ['layout', 'HostDiskPartitionLayout', undef, 1],
);


VIMRuntime::make_get_set('HostDiskPartitionInfo', 'deviceName', 'spec', 'layout');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostDiskPartitionInfo;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostDiskPartitionInfo', 'HostDiskPartitionInfo', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostDiskPartitionInfo', 'HostDiskPartitionInfo');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDnsConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['dhcp', 'boolean', undef, 1],
   ['virtualNicDevice', undef, undef, 0],
   ['hostName', undef, undef, 1],
   ['domainName', undef, undef, 1],
   ['address', undef, 1, 0],
   ['searchDomain', undef, 1, 0],
);


VIMRuntime::make_get_set('HostDnsConfig', 'dhcp', 'virtualNicDevice', 'hostName', 'domainName', 'address', 'searchDomain');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostDnsConfigSpec;
our @ISA = qw(HostDnsConfig);

our @property_list = (
   ['virtualNicConnection', 'HostVirtualNicConnection', undef, 0],
);


VIMRuntime::make_get_set('HostDnsConfigSpec', 'virtualNicConnection');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostEsxAgentHostManagerConfigInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['agentVmDatastore', 'ManagedObjectReference', undef, 0],
   ['agentVmNetwork', 'ManagedObjectReference', undef, 0],
);


VIMRuntime::make_get_set('HostEsxAgentHostManagerConfigInfo', 'agentVmDatastore', 'agentVmNetwork');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FcoeConfigVlanRange;
our @ISA = qw(DynamicData);

our @property_list = (
   ['vlanLow', undef, undef, 1],
   ['vlanHigh', undef, undef, 1],
);


VIMRuntime::make_get_set('FcoeConfigVlanRange', 'vlanLow', 'vlanHigh');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfFcoeConfigVlanRange;
our @ISA = qw(ComplexType);

our @property_list = (
   ['FcoeConfigVlanRange', 'FcoeConfigVlanRange', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfFcoeConfigVlanRange', 'FcoeConfigVlanRange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FcoeConfigFcoeCapabilities;
our @ISA = qw(DynamicData);

our @property_list = (
   ['priorityClass', 'boolean', undef, 1],
   ['sourceMacAddress', 'boolean', undef, 1],
   ['vlanRange', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('FcoeConfigFcoeCapabilities', 'priorityClass', 'sourceMacAddress', 'vlanRange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FcoeConfigFcoeSpecification;
our @ISA = qw(DynamicData);

our @property_list = (
   ['underlyingPnic', undef, undef, 1],
   ['priorityClass', undef, undef, 0],
   ['sourceMac', undef, undef, 0],
   ['vlanRange', 'FcoeConfigVlanRange', 1, 0],
);


VIMRuntime::make_get_set('FcoeConfigFcoeSpecification', 'underlyingPnic', 'priorityClass', 'sourceMac', 'vlanRange');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package FcoeConfig;
our @ISA = qw(DynamicData);

our @property_list = (
   ['priorityClass', undef, undef, 1],
   ['sourceMac', undef, undef, 1],
   ['vlanRange', 'FcoeConfigVlanRange', 1, 1],
   ['capabilities', 'FcoeConfigFcoeCapabilities', undef, 1],
   ['fcoeActive', 'boolean', undef, 1],
);


VIMRuntime::make_get_set('FcoeConfig', 'priorityClass', 'sourceMac', 'vlanRange', 'capabilities', 'fcoeActive');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostFeatureCapability;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['featureName', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('HostFeatureCapability', 'key', 'featureName', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostFeatureCapability;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostFeatureCapability', 'HostFeatureCapability', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostFeatureCapability', 'HostFeatureCapability');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostFeatureMask;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['featureName', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('HostFeatureMask', 'key', 'featureName', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostFeatureMask;
our @ISA = qw(ComplexType);

our @property_list = (
   ['HostFeatureMask', 'HostFeatureMask', 1, 0],
);


VIMRuntime::make_get_set('ArrayOfHostFeatureMask', 'HostFeatureMask');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package HostFeatureVersionInfo;
our @ISA = qw(DynamicData);

our @property_list = (
   ['key', undef, undef, 1],
   ['value', undef, undef, 1],
);


VIMRuntime::make_get_set('HostFeatureVersionInfo', 'key', 'value');


sub get_property_list {
   my $class = shift;
   my @super_list = $class->SUPER::get_property_list();
   return (@super_list, @property_list);   
}

1;
##################################################################################




##################################################################################
package ArrayOfHostFeatureVersionInfo;
our @ISA = qw(ComplexType