#!/bin/bash
# Copyright (C) 2020 McAfee, LLC. All Rights Reserved.
# Script to set the SELinux context for ENSL files
# Applicable for Runtime, ESP, File Access, AAC, TP, and FW.
# This script always exits with a return code of 0

# Unset all the language locale and set LANG to C to disable localization
unset LC_ALL
unset LANG
export LANG=C
export LC_ALL=C

# Use only bash for executing the script
ps -o args= -p "$$" | grep bash > /dev/null
if [ $? -ne 0 ]
then
    echo "Error: This script can be run by bash shell only"
    exit 0
fi

# Set the environment variable where commands will be commonly present
PATH=${PATH}:/sbin:/usr/sbin:/bin:/usr/bin

#Check if Run By root or not
if [ $EUID -ne 0 ]
then
    echo "This script can be run by root or a user with sudo privileges"
    exit 0
fi

usage()
{
    echo "Usage: $0"
    echo "Run this script to set the SELinux context for files belonging to McAfeeRt, McAfeeESP, McAfeeESPFileAccess, McAfeeESPAac, McAfeeTP, and McAfeeFW"
    echo "Applicable only for RHEL 7 and above when McAfeeENS-selinux is installed, policies are loaded and SELinux is in targeted mode"
    exit 0
}

updateSELinuxContext()
{
    restoreconBinPath="/sbin/restorecon"
    if [ -f ${restoreconBinPath} ]
    then
        [ -d /opt/McAfee/ens ] && ${restoreconBinPath} -R /opt/McAfee/ens > /dev/null || :
        [ -d /var/McAfee/ens ] && ${restoreconBinPath} -R /var/McAfee/ens > /dev/null || :
        [ -f /etc/ld-mfeensrt-3.0.so.conf ] && ${restoreconBinPath} /etc/ld-mfeensrt-3.0.so.conf > /dev/null || :
        [ -f /etc/ld-mfeensrt-3.0.so.cache ] && ${restoreconBinPath} /etc/ld-mfeensrt-3.0.so.cache > /dev/null || :
    fi
}

if [ $# -gt 0 ]
then
    usage
else
    updateSELinuxContext
fi

exit 0
