# McAfee ENSL SELinux policy RPM
Copyright (C) 2020 McAfee, LLC. All Rights Reserved.
<br />
README for 10.7.12-2

## About the ENSL SELinux policies
* ENSL SELinux policies are compatible only with ENSL 10.7.x
* ENSL SELinux policy RPM are available in two flavors - RHEL 7 and RHEL 8
* Each RPM ships with different SELinux policies which can support different selinux-policy version
* When the RPM is installed, in the %post section of the RPM, it will determine the current selinux-policy installed and accordingly load the correct SELinux policy module.
* The RPM ships the following SELinux policies only for targeted mode
  * mfe_ens_rt.pp
  * mfe_ens_esp.pp
  * mfe_ens_tp.pp
  * mfe_ens_fw.pp
* The RPM loads the policies in the following sequence
  1. mfe_ens_rt.pp
  1. mfe_ens_esp.pp
  1. mfe_ens_tp.pp
  1. mfe_ens_fw.pp
* Policies should be unloaded in the reverse sequence

### ENSL SELinux policy support details
No | Version    | Compiled On           | Min supported | Maximum supported
-- | ---------- | --------------------- | ------------- | -----------------
1  | 3.13.1-60  | 3.13.1-60 (RHEL 7.2)  | 3.13.1-23     | < 3.13.1-192
2  | 3.13.1-229 | 3.13.1-229 (RHEL 7.6) | 3.13.1-229    | < 3.14
3  | 3.14.1-61  | 3.14.1-61 (RHEL 8.0)  | 3.14.1-61     | < 3.14.3-20
4  | 3.14.3-20  | 3.14.3-20 (RHEL 8.1)  | 3.14.3-20     | Not set

## Customising ENSL SELinux policy
### Prepare the environment
Ensure the following packages are installed
- make
- m4
- gcc
- policycoreutils-devel
- selinux-policy-devel

### Modify the SELinux policies.
Source is available in - /opt/McAfee/ens/selinux/src

### Compile the SELinux policies.
```shell
pushd ${HOME}/rpmbuild/SOURCES
make
```
### Reloading the updated SELinux policies manually
* First stop all ENSL Processes
* Unload the older policies
* Load the new policies
* Update the context using a script
* Start all ENSL Processes

```shell
# Stop ENSL TP if present
[ -f /opt/McAfee/ens/tp/init/mfetpd-control.sh ]  && /opt/McAfee/ens/tp/init/mfetpd-control.sh stop > /dev/null || :
# Stop ENSL FW if present
[ -f /opt/McAfee/ens/fw/init/mfefwd-control.sh ]  && /opt/McAfee/ens/fw/init/mfefwd-control.sh stop > /dev/null || :
# Stop ENSL ESP if present
[ -f /opt/McAfee/ens/esp/init/mfeespd-control.sh ]  && /opt/McAfee/ens/esp/init/mfeespd-control.sh stop > /dev/null || :
# Unload the policies
semodule -s targeted -r mfe_ens_tp
semodule -s targeted -r mfe_ens_fw
semodule -s targeted -r mfe_ens_esp
semodule -s targeted -r mfe_ens_rt
# Load the new policies
pushd /opt/McAfee/ens/selinux/src
semodule -s targeted -i mfe_ens_rt.pp
semodule -s targeted -i mfe_ens_esp.pp
semodule -s targeted -i mfe_ens_fw.pp
semodule -s targeted -i mfe_ens_tp.pp
# Update the context
[ -f /opt/McAfee/ens/selinux/scripts/update-selinux-context.sh ] && /opt/McAfee/ens/selinux/scripts/update-selinux-context.sh > /dev/null || :
# Start ENSL ESP if present
[ -f /opt/McAfee/ens/esp/init/mfeespd-control.sh ]  && /opt/McAfee/ens/esp/init/mfeespd-control.sh start > /dev/null || :
# Start ENSL FW if present
[ -f /opt/McAfee/ens/fw/init/mfefwd-control.sh ]  && /opt/McAfee/ens/fw/init/mfefwd-control.sh start > /dev/null || :
# Start ENSL TP if present
[ -f /opt/McAfee/ens/tp/init/mfetpd-control.sh ]  && /opt/McAfee/ens/tp/init/mfetpd-control.sh start > /dev/null || :
```

## Creating a new SELinux policy RPM which installs modified policies
Instead of loading the policies directly, a new RPM can be created and installed on the system
* Install the ENSL SELinux policy SRPM for that platform
* Install the package - rpm-build
* Compile the SELinux policies
* Create the environment
```shell
mkdir -p ${HOME}/rpmbuild/SOURCES/McAfeeENS-selinux/
```
* Copy the SELinux policies
```shell
pushd ${HOME}/rpmbuild/SOURCES
pushd selinux-*
cp -f mfe_ens_*targeted ${HOME}/rpmbuild/SOURCES/McAfeeENS-selinux/
```
* Create the RPM using rpmbuild
```shell
pushd ${HOME}/rpmbuild/SPECS
rpmbuild --define 'pkg_version 99' -ba McAfeeENS-selinux.spec
```
This creates a RPM with version 10.7.0-99 inside ${HOME}/rpmbuild/RPMS/x86_64/

# Reference
Packaging was done based on [SELinux Policy Modules Packaging Draft by Fedora](https://fedoraproject.org/wiki/SELinux_Policy_Modules_Packaging_Draft)
