# Copyright (C) 2016-2021 McAfee, LLC. All Rights Reserved.
# bash auto completion script for Intel Security Threat Prevention CLI
# 

# Ref - http://bashcookbook.com/bashinfo/source/bash-3.1/examples/complete/complete-examples
# Return 1 if $1 appears to contain a redirection operator.  Handles backslash
# quoting (barely).
#
_redir_op()
{
    case "$1" in
    *\\'[\<\>]'*)   return 1;;
    *[\<\>]*)   return 0;;
    *)      return 1;;
    esac
}

# _redir_test tests the current word ($1) and the previous word ($2) for
# redirection operators and does filename completion on the current word
# if either one contains a redirection operator
_redir_test()
{
    if _redir_op "$1" ; then
        COMPREPLY=( $( compgen -f "$1" ) )
        return 0
    elif _redir_op "$2" ; then
        COMPREPLY=( $( compgen -f "$1" ) )
        return 0
    fi
    return 1
}

_mfetpcli() 
{
    local cur prev opts
    COMPREPLY=()
    cur="${COMP_WORDS[COMP_CWORD]}"
    prev="${COMP_WORDS[COMP_CWORD-1]}"
    COMPREPLY=()
    # Check for presence of redirection operator
    _redir_test "$cur" "$prev" && return 0;
    # Primary options
    opts="--help --version --setoasglobalconfig --addprocess --setprocess --delprocess --setoasprofileconfig --getoasconfig --getoasprofileconfig --setquarantinefolder --listquarantineitems --restorequarantineitems --addodstask --listtasks --deltask --runtask --stoptask --showtask --setmaxproductlogsize --productlog --debuglog --usesyslog --addupdatetask --scheduletask --flushscancache --showscancachestatus --showlogsettings --showrepositories  --disablerepository --enablerepository --removeproxy --setrepositorypriority --addrepository --addproxy --getapstatus   --getallaprules --getapruleconfig --getapexclusions --setapexclusions --deleteapexclusions --setapstatus --createaprule --deleteaprule --editaprule --gtitelemetry --proxyserverconfig --odsactivitylog --getepstatus --setepstatus --getallepsignatures --getepexclusions --flushgticache --setoascpulimit --setdeferredscan --getdeferredscan --getoascpulimit"
    local helpOpt="--help"
    local onOffOpt="on off"
    local enabledDisabledOpt="enable disable"
    local allowDenyOpt="allow deny"
    local setOasGlobalConfigSubOpt="--oas --maxscantime --procsettings --gti"
    local gtiSubopt="--state --sensitivity"
    local gtiSensitivityParam="verylow low medium high veryhigh" 
    local standardRiskBasedSubOpt="standard riskbased"
    local standardHighLowRiskSubOpt="standard highrisk lowrisk"
    local addSetProcessSubOpt="--highrisk --lowrisk"
    local indexOpt="--index"
    local typeOpt="--type"
    local profileOpt="--profile"
    local nameOpt="--name"
    local runtaskOpt="--index --name"
    local setOasProfileConfigSubOpt="--setmode --filetypestoscan --onscanerror --onscantimeout --networkscan --scanarchive --scanmime --scanpups --scanunknownprograms --scanunknownmacros --primaryaction --secondaryaction --primaryactionpup --secondaryactionpup --addexclusionread --addexclusionwrite --addexclusionrw --delexclusion"
    local addODSTaskSubOpt="--scanarchive --scanmime --scanpups --scanunknownprograms --scanunknownmacros --scansubfolders --scanlocaldrives --scanpaths --scantmpfolders --scannetworkdrives --filetypestoscan --excludepaths --excludefiletype --excludepathwithsubfolder --usescancache --primaryaction --secondaryaction --primaryactionpup --secondaryactionpup --odsthreads --maxscantime --gti --setmaxcpulimit"
    local getOasConfigSubOpt="--summary --processlist --exclusionlist --listfiletypestoscan"
    local exclusionSubOpt="--excludepaths --excludefiletype --excludesubfolder"
    local restoreQuarantineItemsSubOpt="--detectionname --detectionalias"
    local createApRuleSubOpt="--rulename --block --report --includeprocess --excludeprocess --includeusers --excludeusers --subrulename --subruletype --operations --includetargetfile --excludetargetfile"
    local editApSubRuleSubOpt="--subrulename --subruletype --operations --includetargetfile  --includetargetdstfile --includetargetprocess  --excludetargetfile --excludetargetdstfile --excludetargetprocess"
    local gtiTelemetrySubopt="--setstatus --getstatus"
    local proxyServerConfigSubopt="--type"
    local typeSubopt="noproxy systemproxy customproxy"

    if [ $COMP_CWORD -eq 1 ]
    then
        # Display primary parameters
        COMPREPLY=( $(compgen -W "${opts}" -- ${cur}) )
    elif [ $COMP_CWORD -eq 2 ]
    then
        # Primary option has been displayed, now display its relevant sub option
        case "${prev}" in
            --setoasglobalconfig)
                local setOasGlobalConfigOpts="${helpOpt} ${setOasGlobalConfigSubOpt}"
                COMPREPLY=( $(compgen -W "${setOasGlobalConfigOpts}" -- ${cur}) )
                return 0
                ;;
            --addprocess)
                local addProcessOpts="${helpOpt} ${addSetProcessSubOpt}"
                COMPREPLY=( $(compgen -W "${addProcessOpts}" -- ${cur}) )
                return 0
                ;;
            --setprocess)
                local setProcessOpts="${helpOpt} ${addSetProcessSubOpt}"
                COMPREPLY=( $(compgen -W "${setProcessOpts}" -- ${cur}) )
                return 0
                ;;
            --delprocess)
                local delProcessOpts="${helpOpt} ${indexOpt}"
                COMPREPLY=( $(compgen -W "${delProcessOpts}" -- ${cur}) )
                return 0
                ;;
            --deltask)
                local deltaskOpts="${helpOpt} ${indexOpt}"
                COMPREPLY=( $(compgen -W "${deltaskOpts}" -- ${cur}) )
                return 0
                ;;
            --stoptask)
                local stoptaskOpts="${helpOpt} ${indexOpt}"
                COMPREPLY=( $(compgen -W "${stoptaskOpts}" -- ${cur}) )
                return 0
                ;;
            --showtask)
                local showtaskOpts="${helpOpt} ${indexOpt}"
                COMPREPLY=( $(compgen -W "${showtaskOpts}" -- ${cur}) )
                return 0
                ;;
            --runtask)
                local runtaskOpts="${helpOpt} ${runtaskOpt}"
                COMPREPLY=( $(compgen -W "${runtaskOpts}" -- ${cur}) )
                return 0
                ;;
            --productlog)
                local productLogOpts="${helpOpt} ${enabledDisabledOpt}"
                COMPREPLY=( $(compgen -W "${productLogOpts}" -- ${cur}) )
                return 0
                ;;
            --debuglog)
                local debugLogOpts="${helpOpt} ${enabledDisabledOpt}"
                COMPREPLY=( $(compgen -W "${debugLogOpts}" -- ${cur}) )
                return 0
                ;;
            --usesyslog)
                local useSysLogOpts="${helpOpt} ${enabledDisabledOpt}"
                COMPREPLY=( $(compgen -W "${useSysLogOpts}" -- ${cur}) )
                return 0
                ;;
            --odsactivitylog)
                local odsActivityLogOpts="${helpOpt} ${enabledDisabledOpt}"
                COMPREPLY=( $(compgen -W "${odsActivityLogOpts}" -- ${cur}) )
                return 0
                ;;
            --listquarantineitems)
                local listQuarantineItemsOpts="${helpOpt} --verbose"
                COMPREPLY=( $(compgen -W "${listQuarantineItemsOpts}" -- ${cur}) )
                return 0
                ;;
            --restorequarantineitems)
                local restoreQuarantineItemsOpts="${helpOpt} ${restoreQuarantineItemsSubOpt}"
                COMPREPLY=( $(compgen -W "${restoreQuarantineItemsOpts}" -- ${cur}) )
                return 0
                ;;
            --addupdatetask)
                local addUpdateTaskOpts="${helpOpt} ${nameOpt}"
                COMPREPLY=( $(compgen -W "${addUpdateTaskOpts}" -- ${cur}) )
                return 0
                ;;
            --setoasprofileconfig)
                local setOasProfileConfigOpts="${helpOpt} ${profileOpt}"
                COMPREPLY=( $(compgen -W "${setOasProfileConfigOpts}" -- ${cur}) )
                return 0
                ;;
            --getoasconfig)
                local getOasConfigOpts="${helpOpt} ${getOasConfigSubOpt}"
                COMPREPLY=( $(compgen -W "${getOasConfigOpts}" -- ${cur}) )
                return 0
                ;;
            --getoasprofileconfig)
                COMPREPLY=( $(compgen -W "${standardHighLowRiskSubOpt}" -- ${cur}) )
                return 0
                ;;
            --addodstask)
                local addODSTaskOpts="${helpOpt} ${nameOpt}"
                COMPREPLY=( $(compgen -W "${addODSTaskOpts}" -- ${cur}) )
                return 0
                ;;
            --scheduletask)
                local scheduleTaskOpts="${helpOpt} ${indexOpt}"
                COMPREPLY=( $(compgen -W "${scheduleTaskOpts}" -- ${cur}) )
                return 0
                ;;
            --disablerepository)
                local disableRepositoryOpts="${helpOpt} ${nameOpt}"
                COMPREPLY=( $(compgen -W "${disableRepositoryOpts}" -- ${cur}) )
                return 0
                ;;
            --enablerepository)
                local enableRepositoryOpts="${helpOpt} ${nameOpt}"
                COMPREPLY=( $(compgen -W "${enableRepositoryOpts}" -- ${cur}) )
                return 0
                ;;
            --setrepositorypriority)
                local setRepositoryPriorityOpts="${helpOpt} ${nameOpt}"
                COMPREPLY=( $(compgen -W "${setRepositoryPriorityOpts}" -- ${cur}) )
                return 0
                ;;
            --addrepository)
                local addRepositoryOpts="${helpOpt} ${nameOpt}"
                COMPREPLY=( $(compgen -W "${addRepositoryOpts}" -- ${cur}) )
                return 0
                ;;
            
            --addproxy)
                local addProxyOpts="${helpOpt} ${typeOpt}"
                COMPREPLY=( $(compgen -W "${addProxyOpts}" -- ${cur}) )
                return 0
                ;;
            --removeproxy)
                local removeProxyOpts="${helpOpt} ${typeOpt}"
                COMPREPLY=( $(compgen -W "${removeProxyOpts}" -- ${cur}) )
                return 0
                ;;
            --setapstatus)
                local setapstatusOpts="${enabledDisabledOpt}"
                COMPREPLY=( $(compgen -W "${setapstatusOpts}" -- ${cur}) )
                return 0
                ;;
            --createaprule)
                COMPREPLY=( $(compgen -W "${createApRuleSubOpt}" -- ${cur}) )
                return 0
                ;;
            --gtitelemetry)
                COMPREPLY=( $(compgen -W "${gtiTelemetrySubopt}" -- ${cur}) )
                return 0
                ;;
            --proxyserverconfig)
                COMPREPLY=( $(compgen -W "${proxyServerConfigSubopt}" -- ${cur}) )
                return 0
                ;;
            --setepstatus)
                local setepstatusOpts="${enabledDisabledOpt}"
                COMPREPLY=( $(compgen -W "${setepstatusOpts}" -- ${cur}) )
                return 0
                ;;
            *)
                ;;
        esac
    # Process upto 3 level argument parameters
    elif [ $COMP_CWORD -ge 3 ]
    then
        firstarg="${COMP_WORDS[1]}"
        case "${firstarg}" in
            # Specific option for setting oas global configuration
            --setoasglobalconfig)
                case "$prev" in
                    # Specific option for setting oas status
                    --oas)
                        COMPREPLY=( $(compgen -W "${onOffOpt}" -- ${cur}) )
                        ;;
                    --procsettings)
                        COMPREPLY=( $(compgen -W "${standardRiskBasedSubOpt}" -- ${cur}) )
                        ;;
                     --gti)
                        COMPREPLY=( $(compgen -W "${gtiSubopt}" -- ${cur}) )
                        ;;
                    --state)
                        COMPREPLY=( $(compgen -W "${enabledDisabledOpt}" -- ${cur}) )
                        ;;
                    --sensitivity)
                        COMPREPLY=( $(compgen -W "${gtiSensitivityParam}" -- ${cur}) )
                        ;;
                    *)
                        ;;
                esac
                ;;
            --setrepositorypriority)
                prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                if [ "$prePrev" == --name ]
                then
                    COMPREPLY=( $(compgen -W "--priority" -- ${cur}) )
                fi
                ;;
            --addupdatetask)
                case "$prev" in
                    --updatetype)
                        COMPREPLY=( $(compgen -W "dat engine dat,engine" -- ${cur}) )
                        ;;
                    dat|\
                    engine|\
                    dat,engine|\
                    --name)
                        ;;
                    *)
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --name ]
                        then
                            COMPREPLY=( $(compgen -W "--updatetype" -- ${cur}) )
                        fi
                esac
                ;;
            --addproxy)
                case "$prev" in
                    --type)
                        COMPREPLY=( $(compgen -W "http ftp" -- ${cur}) )
                        ;;
                    http|\
                    ftp)
                        COMPREPLY=( $(compgen -W "--address" -- ${cur}) )
                        ;;
                    *)
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --address ]
                        then
                            COMPREPLY=( $(compgen -W "--port" -- ${cur}) )
                        fi
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --port ]
                        then
                            COMPREPLY=( $(compgen -W "--username" -- ${cur}) )
                        fi
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --username ]
                        then
                            COMPREPLY=( $(compgen -W "--password" -- ${cur}) )
                        fi
                esac
                ;;    
            --addrepository)
                case "$prev" in
                    --type)
                        COMPREPLY=( $(compgen -W "http ftp local" -- ${cur}) )
                        ;;
                    http|\
                    ftp|\
                    local)
                        COMPREPLY=( $(compgen -W "--url" -- ${cur}) )
                        ;;
                    *)
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --name ]
                        then
                            COMPREPLY=( $(compgen -W "--type" -- ${cur}) )
                        fi
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --url ]
                        then
                            COMPREPLY=( $(compgen -W "--port" -- ${cur}) )
                        fi
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --port ]
                        then
                            COMPREPLY=( $(compgen -W "--priority" -- ${cur}) )
                        fi
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --priority ]
                        then
                            COMPREPLY=( $(compgen -W "--username" -- ${cur}) )
                        fi
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --username ]
                        then
                            COMPREPLY=( $(compgen -W "--password" -- ${cur}) )
                        fi
                esac
                ;;    
             --scheduletask)
                case "$prev" in
                    --weekly)
                        COMPREPLY=( $(compgen -W "--dayofweek" -- ${cur}) )
                        ;;
                    --monthly)
                        COMPREPLY=( $(compgen -W "--dayofmonth" -- ${cur}) )
                        ;;
                    --daily|\
                    --index|\
                    --dayofweek|\
                    --dayofmonth|\
                    --starttime)
                        ;;
                    *)
                        prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prePrev" == --index ]
                        then
                            COMPREPLY=( $(compgen -W "--starttime" -- ${cur}) )
                        elif [ "$prePrev" == --dayofweek ]
                        then
                            :
                            # do nothing as this should be the last level of valid option, no more options should be allowed after them.
                        elif [ "$prePrev" == --dayofmonth ]
                        then
                            :
                            # do nothing as this should be the last level of valid option, no more options should be allowed after them.
                        else
                            COMPREPLY=( $(compgen -W "--daily --weekly --monthly --unspecified" -- ${cur}) )
                        fi
                        ;;
                esac
                ;;
            # Specific option for getting oas configuration
            --getoasconfig)
                case "$prev" in
                    # These parameters specifically require a value after it.
                    # Do not show any parameter after these
                    --summary|\
                    --processlist)
                        ;;
                    # Specific option for setting oas status
                    --exclusionlist)
                        COMPREPLY=( $(compgen -W "--profile" -- ${cur}) )
                        ;;
                    --listfiletypestoscan)
                        COMPREPLY=( $(compgen -W "defaultandspecified onlyspecified" -- ${cur}) )
                        ;;
                    defaultandspecified|\
                    onlyspecified)
                        COMPREPLY=( $(compgen -W "--profile" -- ${cur}) )
                        ;;
                    --profile)
                        COMPREPLY=( $(compgen -W "${standardHighLowRiskSubOpt}" -- ${cur}) )
                        ;;
                    *)
                        ;;
                esac
                ;;
            # Specific option for setting gti telemetry
            --gtitelemetry)
                case "$prev" in
                    # These parameters specifically require a value after it.
                    # Do not show any parameter after these
                    --getstatus)
                        ;;
                    # Specific option for setting oas status
                    --setstatus)
                        COMPREPLY=( $(compgen -W "${enabledDisabledOpt}" -- ${cur}) )
                        ;;
                    *)
                        ;;
                esac
                ;;
            --proxyserverconfig)
                prePrev="${COMP_WORDS[COMP_CWORD-2]}"
                if [ "$prePrev" == --username ]
                then
                    COMPREPLY=( $(compgen -W "--password" -- ${cur}) )
                fi
                if [ "$prePrev" == --url ]
                then
                    COMPREPLY=( $(compgen -W "--port" -- ${cur}) )
                fi
                if [ "$prePrev" == --port ]
                then
                    COMPREPLY=( $(compgen -W "--httpauth" -- ${cur}) )
                fi
                case "$prev" in
                    # These parameters specifically require a value after it.
                    # Do not show any parameter after these
                    --type)
                        COMPREPLY=( $(compgen -W "${typeSubopt}" -- ${cur}) )
                        ;;
                    systemproxy)
                        COMPREPLY=( $(compgen -W "--httpauth" -- ${cur}) ) 
                        ;;
                    customproxy)
                        COMPREPLY=( $(compgen -W "--url" -- ${cur}) ) 
                        ;;
                    # Specific option for setting oas status
                    --httpauth)
                        COMPREPLY=( $(compgen -W "${enabledDisabledOpt}" -- ${cur}) )
                        ;;
                    enable)
                        COMPREPLY=( $(compgen -W "--username" -- ${cur}) )
                        ;;
                    *)
                        ;;
                esac
                ;;
            # Specific option for setting oas profile configuration
            --setoasprofileconfig)
                case "$prev" in
                    # These parameters specifically require a value after it.
                    # Do not show any parameter after these
                    --delexclusion)
                        COMPREPLY=( $(compgen -W "${indexOpt}" -- ${cur}) )
                        ;;
                    --profile)
                        COMPREPLY=( $(compgen -W "${standardHighLowRiskSubOpt}" -- ${cur}) )
                        ;;
                    --setmode)
                        COMPREPLY=( $(compgen -W "sor sow mcafee noscan" -- ${cur}) )
                        ;;
                    --onscanerror|\
                    --onscantimeout)
                        COMPREPLY=( $(compgen -W "${allowDenyOpt}" -- ${cur}) )
                        ;;
                    --networkscan|\
                    --scanarchive|\
                    --scanunknownprograms|\
                    --scanunknownmacros|\
                    --scanpups|\
                    --scanmime)
                        COMPREPLY=( $(compgen -W "${enabledDisabledOpt}" -- ${cur}) )
                        ;;
                    --primaryaction)
                        COMPREPLY=( $(compgen -W "deny clean delete" -- ${cur}) )
                        ;;
                    --secondaryaction)
                        COMPREPLY=( $(compgen -W "deny delete" -- ${cur}) )
                        ;;
                    --primaryactionpup)
                        COMPREPLY=( $(compgen -W "allow deny clean delete" -- ${cur}) )
                        ;;
                    --secondaryactionpup)
                        COMPREPLY=( $(compgen -W "allow deny delete" -- ${cur}) )
                        ;;
                    --addexclusionread|\
                    --addexclusionwrite|\
                    --addexclusionrw)
                        COMPREPLY=( $(compgen -W "${exclusionSubOpt}" -- ${cur}) )
                        ;;
                    --filetypestoscan)
                        COMPREPLY=( $(compgen -W "all defaultandspecified onlyspecified" -- ${cur}) )
                        ;;
                    --addfiletype|\
                    --delfiletype|\
                    --excludepaths|\
                    --excludefiletype|\
                    all)
                        ;;
                    defaultandspecified)
                        COMPREPLY=( $(compgen -W "--scanmacros --addfiletype --delfiletype" -- ${cur}) )
                        ;;
                    onlyspecified)
                        COMPREPLY=( $(compgen -W "--noextension --addfiletype --delfiletype" -- ${cur}) )
                        ;;
                    --scanmacros|\
                    --noextension)
                        COMPREPLY=( $(compgen -W "${enabledDisabledOpt}" -- ${cur}) )
                        ;;
                    # For any thing else, show the complete list of available parameters
                    *)
                        COMPREPLY=( $(compgen -W "${setOasProfileConfigSubOpt}" -- ${cur}) )
                        ;;
                esac
                ;;
            # Specific option for adding ODS task
            --addodstask)
                case "$prev" in
                    --scanarchive|\
                    --scanmime|\
                    --scanpups|\
                    --scanunknownprograms|\
                    --scanunknownmacros|\
                    --scansubfolders|\
                    --scanlocaldrives|\
                    --scantmpfolders|\
                    --scannetworkdrives|\
                    --usescancache)
                        COMPREPLY=( $(compgen -W "${enabledDisabledOpt}" -- ${cur}) )
                        ;;
                    --primaryaction)
                        COMPREPLY=( $(compgen -W "continue clean delete" -- ${cur}) )
                        ;;
                    --secondaryaction)
                        COMPREPLY=( $(compgen -W "continue delete" -- ${cur}) )
                        ;;
                    --setmaxcpulimit)
                        COMPREPLY=( $(compgen -W "80" -- ${cur}) )
                        ;;
                    --primaryactionpup)
                        COMPREPLY=( $(compgen -W "continue clean delete" -- ${cur}) )
                        ;;
                    --secondaryactionpup)
                        COMPREPLY=( $(compgen -W "continue delete" -- ${cur}) )
                        ;;
                    --excludepaths|\
                    --excludefiletype|\
                    --excludepathwithsubfolder|\
                    --name|\
                    --odsthreads|\
                    --maxscantime|\
                    --scanpaths|\
                    --addfiletype|\
                    --delfiletype)
                        ;;
                    --filetypestoscan)
                        COMPREPLY=( $(compgen -W "all defaultandspecified onlyspecified" -- ${cur}) )
                        ;;
                    all)
                        ;;
                    defaultandspecified)
                        COMPREPLY=( $(compgen -W "--scanmacros --addfiletype --delfiletype" -- ${cur}) )
                        ;;
                    onlyspecified)
                        COMPREPLY=( $(compgen -W "--noextension --addfiletype --delfiletype" -- ${cur}) )
                        ;;
                    --scanmacros|\
                    --noextension)
                        COMPREPLY=( $(compgen -W "${enabledDisabledOpt}" -- ${cur}) )
                        ;;
                    --gti)
                        COMPREPLY=( $(compgen -W "${gtiSubopt}" -- ${cur}) )
                        ;;
                    --state)
                        COMPREPLY=( $(compgen -W "${enabledDisabledOpt}" -- ${cur}) )
                        ;;
                    --sensitivity)
                        COMPREPLY=( $(compgen -W "${gtiSensitivityParam}" -- ${cur}) )
                        ;;    
                    
                    # For any thing else, show the complete list of available parameters
                    *)
                        COMPREPLY=( $(compgen -W "${addODSTaskSubOpt}" -- ${cur}) )
                        ;;
                esac
                ;;
            --createaprule)
                case "$prev" in
                    --rulename)
                        ;;
                    --block|\
                    --report)
                        COMPREPLY=( $(compgen -W "${enabledDisabledOpt}" -- ${cur}) )
                        ;;
                    --includeprocess|\
                    --excludeprocess|\
                    --includeusers|\
                    --excludeusers|\
                    --subrulename|\
                    --includetargetfile|\
                    --excludetargetfile)
                        ;;
                    --subruletype)
                        COMPREPLY=( $(compgen -W "file process" -- ${cur}) )
                        ;;
                    --operations)
                        ;;
                    *)
                        COMPREPLY=( $(compgen -W "${createApRuleSubOpt}" -- ${cur}) )
                        ;;
                esac
                ;;
            --editaprule)
                case "$prev" in
                    --addsubrule)
                        COMPREPLY=( $(compgen -W "${editApSubRuleSubOpt}" -- ${cur}) )
                        ;;
                    --subrulename|\
                    --includetargetfile|\
                    --includetargetdstfile|\
                    --includetargetprocess|\
                    --excludetargetfile|\
                    --excludetargetdstfile|\
                    --excludetargetprocess|\
                    --operations)
                        ;;
                    --subruletype)
                        COMPREPLY=( $(compgen -W "file process" -- ${cur})  )
                        ;;
                    *)
                        prevCmd="${COMP_WORDS[COMP_CWORD-2]}"
                        if [ "$prevCmd" == --editaprule ]
                        then
                            COMPREPLY=( $(compgen -W "--addsubrule" -- ${cur}) )
                        else
                            COMPREPLY=( $(compgen -W "${editApSubRuleSubOpt}" -- ${cur}) )
                        fi
                ;;
                esac
                ;;

        esac
    fi
    return 0
}
complete -F _mfetpcli mfetpcli
